<?php
defined('PP_PATH') or exit;
class comment_control extends admin_control {
	// 评论管理
	public function index() {
		$status = intval(R('status'));

		$mid = max(2, (int)R('mid'));
		$table = $this->models->get_table($mid);

		// 模型名称
		$mod_name = $this->models->get_name();
		if(isset($mod_name[1])) unset($mod_name[1]);
		$this->assign('mid', $mid);
		$this->assign('mod_name', $mod_name);

		if(!empty($status)){
			$where['status'] = $status;
			$urlstr = '-status-'.$status;
		}else{
			$where['mid'] = $mid;
		}
		// 初始分页
		$pagenum = 20;
		$total = $this->cms_comment->find_count($where);
		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pp_pages($page, $maxpage, 'index.php?u=comment-index-mid-'.$mid.'-page-{page}');
		$this->assign('pages', $pages);
		$this->assign('total', $total);

		// 获取评论列表
		$id_arr = array();
		$comment_arr = $this->cms_comment->list_arr($where, -1, ($page-1)*$pagenum, $pagenum, $total);
		foreach($comment_arr as &$v) {
			$this->cms_comment->format($v, 'Y-m-d H:i:s', 0);
			$id_arr[] = $v['id'];
		}

		$id_arr = array_unique($id_arr);
		$this->cms_content->table = 'cms_'.$table;
		$key_pre = 'cms_'.$table.'-id-';
		$tmp = $this->cms_content->mget($id_arr);
		foreach($comment_arr as &$v) {
			$row = $tmp[$key_pre.$v['id']];
			$v['title'] = $row['title'];
			$v['url'] = $this->cms_content->content_url($row['cid'], $row['id'], $row['alias'], $row['dateline']);
		}
		$this->assign('comment_arr', $comment_arr);
		$this->display();
	}

	// 单条内容评论管理
	public function content() {
		
		$id = (int) R('id');
		$mid = max(2, (int)R('mid'));
		$table = $this->models->get_table($mid);

		// 模型名称
		$mod_name = $this->models->get_name();
		if(isset($mod_name[1])) unset($mod_name[1]);
		$this->assign('mid', $mid);
		$this->assign('mod_name', $mod_name);

		// 读取内容
		$this->cms_content->table = 'cms_'.$table;
		$row = $this->cms_content->read($id);

		// 初始化标题、位置
		$this->_pkey = 'content';
		$this->_title = '评论管理';
		$this->_place = '内容 &#187; 评论管理 &#187; '.$row['title'];

		// 初始分页
		$pagenum = 20;
		$total = $row['comments'];
		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pp_pages($page, $maxpage, 'index.php?u=comment-content-mid-'.$mid.'-id-'.$id.'-page-{page}');
		$this->assign('pages', $pages);
		$this->assign('total', $total);

		// 获取评论列表
		$this->cms_comment->table = 'cms_'.$table.'_comment';
		$comment_arr = $this->cms_content_comment->list_arr(array('id' => $id,'mid'=>$mid), -1, ($page-1)*$pagenum, $pagenum, $total);
		foreach($comment_arr as &$v) {
			$this->cms_content_comment->format($v, 'Y-m-d H:i:s', 0);
			$v['title'] = $row['title'];
			$v['url'] = $this->cms_content->content_url($row['cid'], $row['id'], $row['alias'], $row['dateline']);
		}
		$this->assign('comment_arr', $comment_arr);

		
		$this->display('comment_index.htm');
	}

	// 读取一条评论
	public function get_json() {

		$commentid = (int) R('commentid', 'P');

		$data = $this->cms_comment->read($commentid);
		
		echo json_encode($data);
		exit;
	}

	// 编辑评论
	public function edit() {
		
		$commentid = (int) R('commentid', 'P');
		$author = htmlspecialchars(trim(R('author', 'P')));
		$content = htmlspecialchars(trim(R('content', 'P')));

		empty($commentid) && E(1, '评论ID不能为空！');
		empty($author) && E(1, '昵称不能为空！');
		strlen($author)>20 && E(1, '昵称太长了！');
		empty($content) && E(1, '评论内容不能为空！');
		strlen($content)>3000 && E(1, '评论内容太长了！');

		$data = $this->cms_comment->read($commentid);

		$data['author'] = $author;
		$data['content'] = $content;

		
		if($this->cms_comment->update($data)) {
			E(0, '编辑成功！');
		}else{
			E(1, '编辑失败！');
		}
	}
	
	// 审核评论
	public function status() {
		$commentid = (int) R('commentid', 'P');
		$status = (int) R('status', 'P');
		$mid = max(2, (int)R('mid', 'P'));
		$id = (int) R('id', 'P');

		$commdata = $this->cms_comment->read($commentid);
		$commdata['status'] = $status;

		if(!$this->cms_comment->update($commdata)) {
			E(1, '审核失败！');
		}

		$_cfg = $this->runtime->xget();
		if($_cfg['comment_status']>0){//前台需要审核　同时增加评论数量，如不需要审核，前台处理增加
			$table = $this->models->get_table($mid);
			$this->cms_content->table = 'cms_'.$table;
			$data = $this->cms_content->read($id);
			$data['comments']++;
			if(!$this->cms_content->update($data)) {
				E(1, '更新内容评论数量出错！');
			}
		}
		E(0, '审核通过！');
	}

	// 删除评论
	//需减少用户评论数量，对应文章评论数量

	public function del() {

		$id = (int) R('id', 'P');
		$commentid = (int) R('commentid', 'P');
		$mid = max(2, (int)R('mid', 'P'));
		$table = $this->models->get_table($mid);

		empty($id) && E(1, '内容ID不能为空！');
		empty($commentid) && E(1, '评论ID不能为空！');
		
		$commdata = $this->cms_comment->read($commentid);

		$err = $this->cms_comment->xdelete($table, $id, $commentid,$commdata['status'],$commdata['uid']);
		if($err) {
			E(1, $err);
		}else{
			E(0, '删除成功！');
		}
	}

	// 批量删除评论
	public function batch_del() {
		
		$mid = max(2, (int)R('mid', 'P'));
		$table = $this->models->get_table($mid);

		$id_arr = R('id_arr', 'P');

		if(!empty($id_arr) && is_array($id_arr)) {
			$err_num = 0;
			foreach($id_arr as $arr) {
				$id = $arr[0];
				$commentid = $arr[1];
				$tmp = $this->cms_comment->read($commentid);
				$err = $this->cms_comment->xdelete($table, $id, $commentid,$tmp['status'],$tmp['uid']);
				if($err) $err_num++;
			}

			if($err_num) {
				E(1, $err_num.' 条评论删除失败！');
			}else{
				E(0, '删除成功！');
			}
		}else{
			E(1, '参数不能为空！');
		}
	}

	}
