<?php
defined('PP_PATH') or exit;

class faq_control extends admin_control {
	// faq管理
	public function index() {
		
		$pid = intval(R('pid'));

		$this->_pkey = 'content';
		$this->_ukey = 'faq-index-pid-'.$pid;
		$this->_title = 'faq管理';
		$this->_place = '内容 &#187; 资源管理 &#187 faq管理';

		// 初始模型表名
		$this->cms_content->table = 'cms_faq';

		// 初始分页
		$pagenum = 20;
		if($pid) {
			$where = array('pid' => $pid);
			$total = $this->cms_content->find_count($where);
			$urlstr = '-pid-'.$pid;
		}else{
			$where = array();
			$total = $this->cms_content->count();
			$urlstr = '';
		}
		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pages($page, $maxpage, 'index.php?u=faq-index'.$urlstr.'-page-{page}');
		$this->assign('total', $total);
		$this->assign('pages', $pages);

		$cms_article_arr = $this->cms_content->list_arr($where, 'id', -1, ($page-1)*$pagenum, $pagenum, $total);
		
		$this->assign('cms_article_arr', $cms_article_arr);
		$this->display();
	}

	// 发布faq
	public function add() {

		$uid = $this->_user['uid'];
		if(empty($_POST)) {
			$pid = intval(R('pid'));
			
			$this->_pkey = 'content';
			$this->_ukey = 'products-faqadd-pid-'.$pid;
			$this->_title = '添加faq';
			$this->_place = '内容 &#187; 资源管理 &#187 添加faq';

			$this->assign('pid', $pid);

			$this->display('products_faq_set.htm');
		}else{
			$pid = intval(R('pid', 'P'));
			$title = trim(strip_tags(R('title', 'P')));
			$contentstr = trim(R('content', 'P'));
			$dateline = trim(R('dateline', 'P'));

			empty($title) && E(1, '亲，您的标题忘了填哦！');
			if(strlen($contentstr) < 5) E(1, '亲，您的内容字数太少了哦！');

			// 写入内容表
			$data = array(
				'pid' => $pid,
				'title' => $title,
				'uid' => $uid,
				'author' => trim(R('author', 'P')),	// 可以不等于发布用户
				'dateline' => $dateline ? strtotime($dateline) : $_ENV['_time'],
				'lasttime' => $_ENV['_time'],
			);
			$this->cms_content->table = 'cms_faq';
			$id = $this->cms_content->create($data);
			if(!$id) {
				E(1, '写入内容表出错');
			}

			// 写入内容数据表
			$this->cms_content_data->table = 'cms_faq_data';
			if(!$this->cms_content_data->set($id, array('content' => $contentstr))) {
				E(1, '写入内容数据表出错');
			}

			E(0, '发布完成');
		}
	}
	// 编辑
	public function faq_edit() {
		if(empty($_POST)) {
			$id = intval(R('id'));
			$pid = intval(R('pid'));

			$this->_pkey = 'content';
			$this->_ukey = 'products-edit-pid-'.$pid.'-id-'.$id;
			$this->_title = '编辑faq';
			$this->_place = '内容 &#187; faq管理 &#187 编辑faq';

			$table = 'faq';

			// 读取内容
			$this->cms_content->table = 'cms_'.$table;
			$this->cms_content_data->table = 'cms_'.$table.'_data';
			$data = $this->cms_content->get($id);
			if(empty($data)) $this->message(0, '内容不存在！', -1);

			$data2 = $this->cms_content_data->get($id);
			$data = array_merge($data, $data2);
			$data['content'] = htmlspecialchars($data['content']);

			$this->assign('data', $data);

			$this->display('products_faq_set.htm');
		}else{
			$id = intval(R('id', 'P'));
			$pid = intval(R('pid', 'P'));
			
			$title = trim(strip_tags(R('title', 'P')));

			$contentstr = trim(R('content', 'P'));

			$uid = $this->_user['uid'];

			empty($id) && E(1, 'ID不能为空！');
			empty($pid) && E(1, '哪个资源的faq？');
			empty($title) && E(1, '亲，您的标题忘了填哦！');
			if(strlen($contentstr) < 5) E(1, '亲，您的内容字数太少了哦！');

			$this->cms_content->table = 'cms_faq';
			$data = $this->cms_content->get($id);
			if(empty($data)) E(1, '内容不存在！');

			$endstr = '';

			// 写入内容表
			$data['pid'] = $pid;
			$data['id'] = $id;
			$data['title'] = $title;

			$data['uid'] = $uid;

			$data['dateline'] = strtotime(trim(R('dateline', 'P')));
			$data['lasttime'] = $_ENV['_time'];

			if(!$this->cms_content->update($data)) {
				E(1, '更新内容表出错');
			}

			// 写入内容数据表
			$this->cms_content_data->table = 'cms_faq_data';
			if(!$this->cms_content_data->set($id, array('content' => $contentstr))) {
				E(1, '写入内容数据表出错');
			}

			E(0, '编辑完成');
		}
	}

	// 删除文章
	public function del() {
		

		$id = (int) R('id', 'P');
		$cid = (int) R('cid', 'P');

		empty($id) && E(1, '内容ID不能为空！');
		empty($cid) && E(1, '分类ID不能为空！');

		

		$err = $this->cms_content->xdelete('article', $id, $cid);
		if($err) {
			E(1, $err);
		}else{
			E(0, '删除成功！');
		}
	}

	// 批量删除文章
	public function batch_del() {
		

		$id_arr = R('id_arr', 'P');
		if(!empty($id_arr) && is_array($id_arr)) {
			$err_num = 0;
			foreach($id_arr as $v) {
				$err = $this->cms_content->xdelete('article', $v[0], $v[1]);
				if($err) $err_num++;
			}

			if($err_num) {
				E(1, $err_num.' 篇文章删除失败！');
			}else{
				E(0, '删除成功！');
			}
		}else{
			E(1, '参数不能为空！');
		}
	}

	// 自动保存文章
	public function auto_save() {
		$this->kv->set('auto_save_article_uid_'.$this->_user['uid'], $_POST) ? E(0, '自动保存成功！') : E(1, '自动保存失败！');
	}

	// 自动生成摘要
	private function auto_intro($intro, &$content) {
		if(empty($intro)) {
			$intro = preg_replace('/\s{2,}/', ' ', strip_tags($content));
			return trim(utf8::cutstr_cn($intro, 255, ''));
		}else{
			return str_replace(array("\r\n", "\r", "\n"), '<br />', strip_tags($intro));
		}
	}

	// 自动生成缩略图
	private function auto_pic($table, $uid, $id = 0) {
		$pic_arr = $this->cms_attach->find_fetch(array('id'=>$id, 'uid'=>$uid, 'isimage'=>1), array(), 0, 1);
		$pic_arr = current($pic_arr);
		$cfg = $this->runtime->xget();
		$path = 'upload/'.$table.'/'.$pic_arr['filepath'];
		$pic = image::thumb_name($path);
		$src_file = PP_PATH.$path;
		$dst_file = PP_PATH.$pic;
		if(!is_file($dst_file)) {
			image::thumb($src_file, $dst_file, $cfg['thumb_'.$table.'_w'], $cfg['thumb_'.$table.'_h'], $cfg['thumb_type'], $cfg['thumb_quality']);
		}
		return $pic;
	}

	// 获取远程图片
	private function get_remote_img($table, &$content, $uid, $cid = 0, $id = 0) {
		function_exists('set_time_limit') && set_time_limit(0);
		$cfg = $this->runtime->xget();
		$updir = 'upload/'.$table.'/';
		$_ENV['_prc_err'] = 0;
		$_ENV['_prc_arg'] = array(
			'hosts'=>array('127.0.0.1', 'localhost', $_SERVER['HTTP_HOST'], $cfg['webdomain']),
			'uid'=>$uid,
			'cid'=>$cid,
			'id'=>$id,
			'maxSize'=>10000,
			'upDir'=>PP_PATH.$updir,
			'preUri'=>$cfg['weburl'].$updir,
			'cfg'=>$cfg,
		);
		$content = preg_replace_callback('#\<img [^\>]*src=["\']((?:http|ftp)\://[^"\']+)["\'][^\>]*\>#iU', array($this, 'img_replace'), $content);
		unset($_ENV['_prc_arg']);
		return $_ENV['_prc_err'] ? '，但远程抓取图片失败 '.$_ENV['_prc_err'].' 张！' : '';
	}

	// 远程图片处理 (如果抓取失败则不替换)
	// $conf 用到4个参数 hosts preUri cfg upDir
	private function img_replace($mat) {
		static $uris = array();
		$uri = $mat[1];
		$conf = &$_ENV['_prc_arg'];

		// 排除重复保存相同URL图片
		if(isset($uris[$uri])) return str_replace($uri, $uris[$uri], $mat[0]);

		// 根据域名排除本站图片
		$urls = parse_url($uri);
		if(in_array($urls['host'], $conf['hosts'])) return $mat[0];

		$file = $this->cms_attach->remote_down($uri, $conf);
		if($file) {
			$uris[$uri] = $conf['preUri'].$file;
			$cfg = $conf['cfg'];

			// 是否添加水印
			if(!empty($cfg['watermark_pos'])) {
				image::watermark($conf['upDir'].$file, PP_PATH.'static/img/watermark.png', null, $cfg['watermark_pos'], $cfg['watermark_pct']);
			}

			return str_replace($uri, $uris[$uri], $mat[0]);
		}else{
			$_ENV['_prc_err']++;
			return $mat[0];
		}
	}

	
}
