<?php
defined('PP_PATH') or exit;
class guestbook_control extends admin_control {
	public $_group_arr = array();
	
	public function __construct(){
		parent::__construct();
		$user_group = &$this->user_group;
		$this->_group_arr = $user_group->get_groups();
	}
	//留言列表
	public function index(){
		$model = &$this->guestbook;
		
		$pagenum = 15;
		$urlstr = '';
		$where = array();
		
		$total = $model->count();
		
		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pages($page, $maxpage, 'index.php?u=guestbook-index'.$urlstr.'-page-{page}');
		$this->assign('total', $total);
		$this->assign('pages', $pages);
		
		$list = $model->find_fetch($where,array('id'=>'-1'),($page-1)*$pagenum, $pagenum, $total);
		$user = &$this->user;
		foreach ($list as &$v){
			if($v['uid']){
				$tmp = $user->get($v['uid']);
				$v['username'] = $tmp['username'];
				$v['groupname'] = $this->_group_arr['user_group-groupid-'.$tmp['groupid']]['groupname'];
				switch ($tmp['status']){
					case 1:
						$v['memstatus'] = '正常';break;
					case 2:
						$v['memstatus'] = '待审核';break;
					case 3:
						$v['memstatus'] = '禁止登录';break;
					case 4:
						$v['memstatus'] = '禁止评论';break;
					default:
						$v['memstatus'] = '未知';
				}
			}
		}
		
		$this->assign('list', $list);
		
		$this->display();
	}
	
	//留言详情
	public function view(){
		$model = &$this->guestbook;
		$id = intval( R('id','G') );
		$data = $model->get($id);

		$userModel = &$this->user;
		$userData = $userModel->get($data['uid']);
		$userData['groupname'] = $this->_group_arr['user_group-groupid-'.$userData['groupid']]['groupname'];
		
		if( empty($_POST) ){
			$this->_pkey = 'home';
			$this->_ukey = 'guestbook-view-id-'.$id;
			$this->_title = '查看留言';
			$this->_place = '留言管理 &#187; 查看留言';
			
			if( empty($data) )	E(1, '查看留言失败'.$id.'不存在！');

			$this->assign('user', $userData);
			$this->assign('data', $data);
			$this->display();
		}else{
			$model = &$this->guestbook;
			$id = intval( R('id','P') );
			$admin_content = R('admin_content','P');
			
			$data = $model->get($id);
			if( empty($data) )	E(1, '编辑留言失败'.$id.'不存在！');

			$data['status'] = 1;
			$data['admin_content'] = $admin_content;
			
			$model->update($data);

			E(0, '回复成功');
		}
	}
	
	public function edit(){

	}
	
	//删除
	public function del(){
		$model = &$this->guestbook;
		$id = intval( R('id','P') );
	
		$status = $model->delete($id);
		if( $status ){
			$this->message(1, '删除留言成功,留言ID:'.$id,'index.php?u=guestbook-index');
		}else{
			$this->message(0, '删除留言失败,留言ID:'.$id);
		}
	}
	
	//删除一个月前的留言
	public function delbatch(){
		$model = &$this->guestbook;
		$where['dateline'] = array('<='=>time() - (86400 * 30));
		$model->find_delete($where);
		$this->message(1, '删除一个月前的留言成功！');
	}
}
