<?php
defined('PP_PATH') or exit;
class record_control extends admin_control {
	//交易清单
	public function index(){
		$cfg = $this->kv->xget('cfg');

		$pagenum = 10;
		$where	= array();
		
		$username 	= R('username','R');
		$order_id 	= R('order_id','R');
		$type 		= intval(R('type','R'));// 1 充值 2消费 3提现　4提成
		$status 	= intval(R('status','R'));// 1 充值失败/提现申请 0 充值成功/提现成功

		$urlstr = '';
		if($username){
			$where['username'] = $username;			
			$urlstr = '-username-'.$username;
		}
		if($order_id){
			$where['order_id'] = $order_id;			
			$urlstr = '-order_id-'.$order_id;
		}
		if($type) {
			$where['type'] = $type;			
			$urlstr = '-type-'.$type;
		}else{
			$where['type'] = array('IN'=>array(1,2));//默认充值消费
		}
		if($type==1 && !empty($status)){
			$where['status'] = $status;			
			$urlstr = '-status-'.$status;
		}
		$total = $this->record->find_count($where);
		
		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pp_pages($page, $maxpage, 'index.php?u=record-index'.$urlstr.'-page-{page}');
		$this->assign('total', $total);
		$this->assign('pages', $pages);
		
		$cms_arr = $this->record->list_arr($where, 'id', -1, ($page-1)*$pagenum, $pagenum, $total);
		foreach($cms_arr as &$v) {
			switch ($v['type']){
				case 0:
					$v['typename'] = '系统';break;
				case 1:
					$v['typename'] = '充值';break;
				case 2:
					$v['typename'] = '消费';break;
				case 3:
					$v['typename'] = '提现';break;
				case 4:
					$v['typename'] = '提成';break;
				default:
					$v['typename'] = '';
			}
		}
		$this->assign('lists', $cms_arr);
		$this->assign('pp', $cfg);
		$this->assign('username', $username);
		$this->assign('order_id', $order_id);
		$this->display();
	}
	// 充值手工确认
	public function confirm(){
		$id = intval( R('id','P') );
		$cfg = $this->runtime->xget('cfg');
		
		$data = $this->record->get($id);
		$update['id'] 		= $id;
		$update['status'] 	= 0;

		$user 		= $this->user->get($data['uid']);
		$user['money']	= $user['money'] + $data['money'] ;

		if(!$this->user->update($user)){
			$err_msg1 = '用户金额更新失败';
		}
		if(!$this->record->update($update)){
			$err_msg2 = '订单状态更新失败';
		}
		if(!empty($err_msg1) || !empty($err_msg2)){
			E(1, $err_msg1.$err_msg2);
		}else{
			//给用户发送短信
			if($user['mobile_staus']){
				$sms_cfg = $this->kv->xget('sms_cfg');
				if(!empty($sms_cfg['payok_off'])){
					//发送短信
					try{
						other::send_sms($sms_cfg,$user['mobile'],str_replace(array("{username}","{money}"),array($user['username'],$data['money']),$sms_cfg['payok']));
					}catch(Exception $e){}
				}
			}
		}
		E(0, '确认成功');
	}
	// 删除
	public function del(){
		$model = &$this->record;
		$id = intval( R('id','P') );
		$where['id'] = $id;
		$status = $model->find_delete($where);
		if($status){
			E(0, '删除成功');
		}else{
			E(1, '删除失败！');
		}
	}
	// 批量删除
	public function batch_del() {
		$id_arr = R('id_arr', 'P');
		if(!empty($id_arr) && is_array($id_arr)) {
			$err_num = 0;
			foreach($id_arr as $v) {
				$where['id'] = $v;
				$status = $this->record->find_delete($where);
				if(empty($status)) $err_num++;
			}
			if($err_num) {
				E(1, $err_num.' 条记录删除失败！');
			}else{
				E(0, '删除成功！');
			}
		}else{
			E(1, '参数不能为空！');
		}
	}
}
