<?php
defined('PP_PATH') or exit;
class setting_control extends admin_control {
	public function index() {
		if(empty($_POST)) {
			$cfg = $this->kv->xget('cfg');
			$templates		= array();
			$dirs = $this->get_theme_all();
			foreach($dirs as $file) {
				if (strpos($file,'.')===0 || $file=='index.html'){
					continue;
				}
				$templates[]	= $file;
			}
			$input = array();
			$input['webname'] 	= form::get_text('webname', $cfg['webname'], 'form-control');
			$input['webdomain'] = form::get_text('webdomain', $cfg['webdomain'], 'form-control');
			$input['webdir'] 	= form::get_text('webdir', $cfg['webdir'], 'form-control');
			$input['webmail'] 	= form::get_text('webmail', $cfg['webmail'], 'form-control');
			$input['qq'] 		= form::get_text('qq', $cfg['qq'], 'form-control');
			$input['tongji'] 	= form::get_textarea('tongji', $cfg['tongji'], 'form-control');
			$input['beian'] 	= form::get_text('beian', $cfg['beian'], 'form-control');
			$input['dis_comment'] 		= empty($cfg['dis_comment']) ? 0 : 1;
			$input['user_comment'] 		= empty($cfg['user_comment']) ? 0 : 1;
			$input['comment_status'] 	= empty($cfg['comment_status']) ? 0 : 1;
			$input['comment_filter'] 	= form::get_textarea('comment_filter', $cfg['comment_filter'], 'form-control');
			$input['gzip'] 				= empty($cfg['gzip']) ? 0 : 1;
			$input['bdts'] 				= form::get_text('bdts', $cfg['bdts'], 'form-control');
			
			// $input['chinabank']['off'] 		= empty($cfg['chinabank']['off']) ? 0 : 1;
			// $input['chinabank']['v_mid'] 	= form::get_text('chinabank[v_mid]', $cfg['chinabank']['v_mid']);
			// $input['chinabank']['key'] 		= form::get_text('chinabank[key]', $cfg['chinabank']['key']);

			$input['lifealipay']['off'] 	= empty($cfg['lifealipay']['off']) ? 0 : 1;
			$input['lifealipay']['id'] 		= form::get_text('lifealipay[id]', $cfg['lifealipay']['id'], 'form-control');
			$input['lifealipay']['notice'] 	= form::get_textarea('lifealipay[notice]', $cfg['lifealipay']['notice'], 'form-control');
			
			$input['alipay']['off'] 	= empty($cfg['alipay']['off']) ? 0 : 1;
			$input['alipay']['id'] 		= form::get_text('alipay[id]', $cfg['alipay']['id'], 'form-control');
			$input['alipay']['partner'] = form::get_text('alipay[partner]', $cfg['alipay']['partner'], 'form-control');
			$input['alipay']['key'] 	= form::get_text('alipay[key]', $cfg['alipay']['key'], 'form-control');
			
			$input['passpay']['off'] 	= empty($cfg['passpay']['off']) ? 0 : 1;
			$input['passpay']['user_seller'] 	= form::get_text('passpay[user_seller]', $cfg['passpay']['user_seller'], 'form-control');
			$input['passpay']['partner'] 		= form::get_text('passpay[partner]', $cfg['passpay']['partner'], 'form-control');
			$input['passpay']['key'] 			= form::get_text('passpay[key]', $cfg['passpay']['key'], 'form-control');

			$input['weixin']['off'] 		= empty($cfg['weixin']['off']) ? 0 : 1;
			$input['weixin']['APPID'] 		= form::get_text('weixin[APPID]', $cfg['weixin']['APPID'], 'form-control');
			$input['weixin']['MCHID'] 		= form::get_text('weixin[MCHID]', $cfg['weixin']['MCHID'], 'form-control');
			$input['weixin']['KEY'] 		= form::get_text('weixin[KEY]', $cfg['weixin']['KEY'], 'form-control');
			$input['weixin']['APPSECRET'] 	= form::get_text('weixin[APPSECRET]', $cfg['weixin']['APPSECRET'], 'form-control');
			//$input['weixin']['NOTIFY_URL'] 	= empty($cfg['weixin']['NOTIFY_URL']) ? '' : $cfg['weixin']['NOTIFY_URL'];
			//{$pp['weburl']}index.php?u=pay-weixinnotify
			//
			$input['cft']['off'] 	= empty($cfg['cft']['off']) ? 0 : 1;
			$input['cft']['partner'] 	= form::get_text('cft[partner]', $cfg['cft']['partner'], 'form-control');
			$input['cft']['key'] 	= form::get_text('cft[key]', $cfg['cft']['key'], 'form-control');

			$input['mingyi']['off'] 			= empty($cfg['mingyi']['off']) ? 0 : 1;
			$input['mingyi']['id'] 				= form::get_text('mingyi[id]', $cfg['mingyi']['id'], 'form-control');
			$input['mingyi']['key'] 			= form::get_text('mingyi[key]', $cfg['mingyi']['key'], 'form-control');

			$input['offbank'] 			= $cfg['offbank'];
			
			$input['qq_login']['off'] 		= empty($cfg['qq_login']['off']) ? 0 : 1;
			$input['qq_login']['appid'] 	= form::get_text('qq_login[appid]', $cfg['qq_login']['appid'], 'form-control');
			$input['qq_login']['appkey'] 	= form::get_text('qq_login[appkey]', $cfg['qq_login']['appkey'], 'form-control');
			
			$input['user']['open_user_model'] 	= empty($cfg['user']['open_user_model']) ? 0 : 1;
			$input['user']['open_user_reg'] 	= empty($cfg['user']['open_user_reg']) ? 0 : 1;
			$input['user']['gift_mobi_off'] 	= empty($cfg['user']['gift_mobi_off']) ? 0 : 1;
			$input['user']['gift_email_off'] 	= empty($cfg['user']['gift_email_off']) ? 0 : 1;
			// $input['user']['gift_mobi_off'] 	= form::loop('radio', 'gift_mobi_off', array('1'=>'是','0'=>'否'), $cfg['user']['gift_mobi_off'], '&nbsp; &nbsp;');
			// $input['user']['gift_email_off'] 	= form::loop('radio', 'gift_email_off', array('1'=>'是','0'=>'否'), $cfg['user']['gift_email_off'], '&nbsp; &nbsp;');

			$input['user']['gift'] 				= form::get_text('user[gift]', $cfg['user']['gift'], 'form-control');
			$input['user']['charge'] 			= form::get_text('user[charge]', $cfg['user']['charge'], 'form-control');
			$input['user']['mintx'] 			= form::get_text('user[mintx]', $cfg['user']['mintx'], 'form-control');
			$input['user']['open_sem'] 			= empty($cfg['user']['open_sem']) ? 0 : 1;

			$do = (int) R('do');
			$this->assign('do', $do);
			
			$this->assign('templates', $templates);
			$this->assign('theme', $cfg['theme']);
			$this->assign('input', $input);
			$this->display();
		}else{
			_trim($_POST);

			$gzip = (int)R('gzip', 'P');

			$theme = R('theme', 'P');
			$this->check_theme($theme);

			$this->kv->xset('webname', R('webname', 'P'), 'cfg');
			$this->kv->xset('webdomain', R('webdomain', 'P'), 'cfg');
			$this->kv->xset('webdir', R('webdir', 'P'), 'cfg');
			$this->kv->xset('webmail', R('webmail', 'P'), 'cfg');
			$this->kv->xset('qq', R('qq', 'P'), 'cfg');
			$this->kv->xset('bdts', R('bdts', 'P'), 'cfg');
			$this->kv->xset('tongji', R('tongji', 'P'), 'cfg');
			$this->kv->xset('beian', R('beian', 'P'), 'cfg');
			$this->kv->xset('theme', $theme, 'cfg');
			$this->kv->xset('gzip', $gzip, 'cfg');
			
			$this->kv->xset('dis_comment', (int)R('dis_comment', 'P'), 'cfg');
			$this->kv->xset('user_comment', (int)R('user_comment', 'P'), 'cfg');
			$this->kv->xset('comment_status', (int)R('comment_status', 'P'), 'cfg');
			$this->kv->xset('comment_filter', R('comment_filter', 'P'), 'cfg');
			
			$weixin = R('weixin', 'P') ;
			
			// $this->kv->xset('chinabank', R('chinabank', 'P'), 'cfg');
			$this->kv->xset('lifealipay', R('lifealipay', 'P'), 'cfg');
			$this->kv->xset('alipay', R('alipay', 'P'), 'cfg');
			$this->kv->xset('passpay', R('passpay', 'P'), 'cfg');
			$this->kv->xset('weixin', $weixin, 'cfg');
			$this->kv->xset('cft', R('cft', 'P'), 'cfg');
			$this->kv->xset('mingyi', R('mingyi', 'P'), 'cfg');
			$this->kv->xset('qq_login', R('qq_login', 'P'), 'cfg');
			$this->kv->xset('offbank', R('offbank', 'P'), 'cfg');
			
			//存储wx
			$wx_notice = '';
			if(!empty($weixin)){
				$wxFile		= APP_PATH.'config/wx.php';
				$s = file_get_contents($wxFile);
				$s = preg_replace("#const APPID = '\w*';#", "const APPID = '".addslashes($weixin['APPID'])."';", $s);
				$s = preg_replace("#const MCHID = '\w*';#", "const MCHID = '".addslashes($weixin['MCHID'])."';", $s);
				$s = preg_replace("#const KEY = '\w*';#", "const KEY = '".addslashes($weixin['KEY'])."';", $s);
				$s = preg_replace("#const COMPANY = '\w*';#", "const COMPANY = '".R('webname', 'P')."';", $s);
				if(!FW($wxFile, $s)){
					$wx_notice = '！但微信配置写入失败，如果您使用微信支付，需手动修改config/wx.php';
				}
			}

			$user = R('user', 'P') ;
			if(empty($user['gift_mobi_off'])){
				$user['gift_mobi_off'] = 0 ;
			}
			if(empty($user['gift_email_off'])){
				$user['gift_email_off'] = 0 ;
			}
			if(empty($user['open_sem'])){
				$user['open_sem'] = 0 ;
			}
			$this->kv->xset('user', $user, 'cfg');

			$this->kv->save_changed();
			$this->runtime->delete('cfg');
			
			$file = APP_PATH.'config/config.php';
			if(!_is_writable($file)) exit('{"err":1, "msg":"配置文件 config/config.php 不可写"}');
			$s = file_get_contents($file);
			$s = preg_replace("#'gzip'\s*=>\s*\d,#", "'gzip' => {$gzip},", $s);
			if(!file_put_contents($file, $s)) exit('{"err":1, "msg":"写入 config.php 失败"}');
			
			exit('{"err":0, "msg":"修改成功'.$wx_notice.'"}');
		}
	}
	
	//短信邮箱配置
	public function sms() {
		if(empty($_POST)) {
			$cfg 		= $this->kv->xget('cfg');
			$mailconf 	= $this->kv->xget('mail_cfg');
			$smscfg 	= $this->kv->xget('sms_cfg');
			//短信
			$sms = array();
			$type = array('1'=>'<a href="http://www.winic.org" target="_blank">吉信通</a>','2'=>'<a href="http://www.dxton.com/13185" target="_blank">106短信接口</a>');
			//$sms['type'] = form::loop('radio', 'type', $type, $smscfg['type'], ' &nbsp;&nbsp;', 'form-control');
			$sms['type'] = $smscfg['type'];
			
			$sms['sms_off'] 		= empty($smscfg['sms_off']) ? 0 : 1; 
			$sms['sms_user'] 		= form::get_text('sms_user', $smscfg['sms_user'], 'form-control');
			$sms['sms_password'] 	= form::get_password('sms_password', $smscfg['sms_password'], 'form-control');
			
			$sms['lo6']['sms_user'] 	= form::get_text('lo6[sms_user]', $smscfg['lo6']['sms_user'], 'form-control');
			$sms['lo6']['sms_password'] = form::get_password('lo6[sms_password]', $smscfg['lo6']['sms_password'], 'form-control');
			
			if( empty($smscfg['sms_pwd_content']) ){
				$smscfg['sms_pwd_content'] = '你好，密码找回，新的登录密码为：{password}';
			}			
			if( empty($smscfg['update']) ){
				$smscfg['update'] = '你购买的“{name}”有更新了，请到本站下载更新。';
			}

			$sms['payok'] 			= form::get_textarea('payok', $smscfg['payok'], 'form-control');
			$sms['payok_off'] 		= empty($smscfg['payok_off']) ? 0 : 1;
			$sms['phonecode'] 		= form::get_textarea('phonecode', $smscfg['phonecode'], 'form-control');
			$sms['sms_pwd_content'] = form::get_textarea('sms_pwd_content', $smscfg['sms_pwd_content'], 'form-control');
			$sms['sms_pwd_off'] 	= empty($smscfg['sms_pwd_off']) ? 0 : 1;
			$sms['phonecode_off'] 	= empty($smscfg['phonecode_off']) ? 0 : 1;
			
			
			$sms['payok_off'] 		= empty($smscfg['payok_off']) ? 0 : 1;
			$sms['update'] 			= form::get_textarea('update', $smscfg['update'], 'form-control');
			$sms['update_off'] 		= empty($smscfg['update_off']) ? 0 : 1;
			
			//邮箱
			$email = array();
			$email['sendtype'] 				= empty($mailconf['sendtype']) ? 0 : 1;
			
			$email['smtplist']['email'] 	= form::get_text('smtplist[email]', $mailconf['smtplist']['email'], 'form-control');
			$email['smtplist']['host'] 		= form::get_text('smtplist[host]', $mailconf['smtplist']['host'], 'form-control');
			$email['smtplist']['port'] 		= form::get_text('smtplist[port]', $mailconf['smtplist']['port'], 'form-control');
			$email['smtplist']['user'] 		= form::get_text('smtplist[user]', $mailconf['smtplist']['user'], 'form-control');
			$email['smtplist']['pass'] 		= form::get_text('smtplist[pass]', $mailconf['smtplist']['pass'], 'form-control');
			
			if(empty($mailconf['moban']['email_active_content']) ){
				$mailconf['moban']['email_active_content'] = '欢迎您注册成为'.$cfg['webname'].'用户，点击下面链接进行邮箱绑定：{click}
或者将网址复制到浏览器：{url}';
			}
			if(empty($mailconf['moban']['email_pwd_content']) ){
				$mailconf['moban']['email_pwd_content'] = $cfg['webname'].'密码找回，新的登录密码为：{password}';
			}
			if(empty($mailconf['moban']['email_update']) ){
				$mailconf['moban']['email_update'] = '你购买的“{name}”有更新了，请到本站下载更新。';
			}
			
			$email['moban']['email_active_content'] = form::get_textarea('moban[email_active_content]', $mailconf['moban']['email_active_content'], 'form-control');
			$email['moban']['email_pwd_content'] 	= form::get_textarea('moban[email_pwd_content]', $mailconf['moban']['email_pwd_content'], 'form-control');
			$email['moban']['email_update'] 		= form::get_textarea('moban[email_update]', $mailconf['moban']['email_update'], 'form-control');
			$email['moban']['email_active_off'] 	= empty($mailconf['moban']['email_active_off']) ? 0 : 1;
			$email['moban']['email_pwd_off'] 		= empty($mailconf['moban']['email_pwd_off']) ? 0 : 1;
			$email['moban']['email_update_off'] 	= empty($mailconf['moban']['email_update_off']) ? 0 : 1;

			$do = (int) R('do');
			$this->assign('do', $do);
		
			$this->assign('sms', $sms);
			$this->assign('email', $email);
			$this->display();

		}else{
			_trim($_POST);
			$this->kv->xset('type', (int)R('type', 'P'), 'sms_cfg');

			$this->kv->xset('sms_off', (int)R('sms_off', 'P'), 'sms_cfg');
			$this->kv->xset('sms_user', R('sms_user', 'P'), 'sms_cfg');
			$this->kv->xset('sms_password', R('sms_password', 'P'), 'sms_cfg');
			
			$this->kv->xset('lo6', R('lo6', 'P'), 'sms_cfg');
			
			$this->kv->xset('update', R('update', 'P'), 'sms_cfg');
			$this->kv->xset('update_off', (int)R('update_off', 'P'), 'sms_cfg');

			$this->kv->xset('payok', R('payok', 'P'), 'sms_cfg');
			$this->kv->xset('payok_off', (int)R('payok_off', 'P'), 'sms_cfg');
			
			$this->kv->xset('phonecode', R('phonecode', 'P'), 'sms_cfg');
			$this->kv->xset('sms_pwd_content', R('sms_pwd_content', 'P'), 'sms_cfg');
			$this->kv->xset('sms_pwd_off', (int)R('sms_pwd_off', 'P'), 'sms_cfg');
			$this->kv->xset('phonecode_off', (int)R('phonecode_off', 'P'), 'sms_cfg');
			
			$this->kv->xset('sendtype', (int)R('sendtype', 'P'), 'mail_cfg');
			$this->kv->xset('smtplist', R('smtplist', 'P'), 'mail_cfg');
			$this->kv->xset('moban', R('moban', 'P'), 'mail_cfg');
			
			$this->kv->save_changed();
			$this->runtime->delete('sms_cfg');
			$this->runtime->delete('mail_cfg');
			exit('{"err":0, "msg":"修改成功"}');
		}
	}
	
	public function seo() {
		if(empty($_POST)) {
			$cfg = $this->kv->xget('cfg');
			$input = array();
			$input['seo_title'] = form::get_text('seo_title', $cfg['seo_title'], 'form-control');
			$input['seo_keywords'] = form::get_text('seo_keywords', $cfg['seo_keywords'], 'form-control');
			$input['seo_description'] = form::get_textarea('seo_description', $cfg['seo_description'], 'form-control');
			$this->assign('input', $input);
			$this->display();
		}else{
			_trim($_POST);
			$this->kv->xset('seo_title', R('seo_title', 'P'), 'cfg');
			$this->kv->xset('seo_keywords', R('seo_keywords', 'P'), 'cfg');
			$this->kv->xset('seo_description', R('seo_description', 'P'), 'cfg');
			
			$this->kv->save_changed();
			$this->runtime->delete('cfg');
			exit('{"err":0, "msg":"修改成功"}');
		}
	}
	// 链接设置
	public function link() {
		if(empty($_POST)) {
			$software = R('SERVER_SOFTWARE', 'S');
			$this->assign('software', $software);
			$parseurl = $_ENV['_config']['nzcms_parseurl'];
			$cfg = $this->kv->xget('cfg');
			$this->assign('cfg', $cfg);
			$mk = R('mk');
			$del = R('del');
			$do = (int) R('do');
			$this->assign('do', $do);
			// 伪静态规则
			$nginx = 'if (!-e $request_filename) {'."\n";
			$nginx .= "\t".'rewrite ^'.$cfg['webdir'].'(.+) '.$cfg['webdir'].'index.php?rewrite=$1 last;'."\n";
			$nginx .= '}';
			$this->assign('nginx', $nginx);
			$apache = '<IfModule mod_rewrite.c>'."\r\n";
			$apache .= 'RewriteEngine On'."\r\n";
			$apache .= 'RewriteBase '.$cfg['webdir']."\r\n";
			$apache .= 'RewriteCond %{REQUEST_FILENAME} !-f'."\r\n";
			$apache .= 'RewriteCond %{REQUEST_FILENAME} !-d'."\r\n";
			$apache .= 'RewriteRule (.+) index.php?rewrite=$1 [L]'."\r\n";
			$apache .= '</IfModule>';
			$this->assign('apache', $apache);
			// 创建.htaccess
			$file_apache = PP_PATH.'.htaccess';
			$is_file_apache = is_file($file_apache);
			$this->assign('is_file_apache', $is_file_apache);
			if($mk == 'htaccess') {
				$f = @fopen($file_apache, 'w');
				if (!$f) {
					exit('{"err":1, "msg":"无写入权限"}');
				} else {
					$bytes = fwrite($f, $apache);
					fclose($f);
					if($bytes > 0) {
						exit('{"err":0, "msg":"创建 .htaccess 成功"}');
					}else{
						exit('{"err":1, "msg":"创建 .htaccess 失败"}');
					}
				}
			}
			// 删除.htaccess
			if($del == 'htaccess') {
				$ret = FALSE;
				try{ $is_file_apache && $ret = unlink($file_apache); }catch(Exception $e) {}
				if($ret) {
					exit('{"err":0, "msg":"删除 .htaccess 成功"}');
				}else{
					exit('{"err":1, "msg":"删除 .htaccess 失败"}');
				}
			}
			$iis = '<?xml version="1.0" encoding="UTF-8"?>'."\r\n";
			$iis .= '<configuration>'."\r\n";
			$iis .= "\t".'<system.webServer>'."\r\n";
			$iis .= "\t\t".'<rewrite>'."\r\n";
			$iis .= "\t\t\t".'<rules>'."\r\n";
			$iis .= "\t\t\t\t".'<rule name="nzcms Rule '.$cfg['webdir'].'" stopProcessing="true">'."\r\n";
			$iis .= "\t\t\t\t\t".'<match url="(.+)" ignoreCase="false" />'."\r\n";
			$iis .= "\t\t\t\t\t".'<conditions logicalGrouping="MatchAll">'."\r\n";
			$iis .= "\t\t\t\t\t\t".'<add input="{REQUEST_FILENAME}" matchType="IsFile" negate="true" />'."\r\n";
			$iis .= "\t\t\t\t\t\t".'<add input="{REQUEST_FILENAME}" matchType="IsDirectory" negate="true" />'."\r\n";
			$iis .= "\t\t\t\t\t".'</conditions>'."\r\n";
			$iis .= "\t\t\t\t\t".'<action type="Rewrite" url="index.php?rewrite={R:1}" />'."\r\n";
			$iis .= "\t\t\t\t".'</rule>'."\r\n";
			$iis .= "\t\t\t".'</rules>'."\r\n";
			$iis .= "\t\t".'</rewrite>'."\r\n";
			$iis .= "\t".'</system.webServer>'."\r\n";
			$iis .= '</configuration>';
			$this->assign('iis', $iis);
			// 创建web.config
			$file_iis = PP_PATH.'web.config';
			$is_file_iis = is_file($file_iis);
			$this->assign('is_file_iis', $is_file_iis);
			if($mk == 'web_config') {
				$f = @fopen($file_iis, 'w');
				if (!$f) {
					exit('{"err":1, "msg":"无写入权限"}');
				} else {
					$bytes = fwrite($f, $iis);
					fclose($f);
					if($bytes > 0) {
						exit('{"err":0, "msg":"创建 web.config 成功"}');
					}else{
						exit('{"err":1, "msg":"创建 web.config 失败"}');
					}
				}
			}
			// 删除web.config
			if($del == 'web_config') {
				$ret = FALSE;
				try{ $is_file_iis && $ret = unlink($file_iis); }catch(Exception $e) {}
				if($ret) {
					exit('{"err":0, "msg":"删除 web.config 成功"}');
				}else{
					exit('{"err":1, "msg":"删除 web.config 失败"}');
				}
			}
			// IIS6
			$path_file = $path_dir = '';
			$dh = opendir(PP_PATH);
			while($file = readdir($dh)) {
				if(preg_match('#^[\w]+$#', $file) && is_dir(PP_PATH.$file)) {
					$path_dir .= $file.'|';
				}elseif(preg_match('#^\w[\w\.]+$#', $file) && is_file(PP_PATH.$file)) {
					$path_file .= preg_quote($file).'|';
				}
			}
			$webdir = preg_quote($cfg['webdir']);
			$iis6 = '[ISAPI_Rewrite]'."\r\n\r\n";
			$iis6 .= 'RewriteRule '.$webdir.'('.trim($path_file, '|').') '.$webdir.'$1 [L]'."\r\n";
			$iis6 .= 'RewriteRule '.$webdir.'('.trim($path_dir, '|').')/(.*) '.$webdir.'$1/$2 [L]'."\r\n";
			$iis6 .= 'RewriteRule '.$webdir.'(.+) '.$webdir.'index\.php\?rewrite=$1 [L]';
			$this->assign('iis6', $iis6);
			// 创建httpd.ini
			$file_iis6 = $_SERVER["DOCUMENT_ROOT"].'/httpd.ini';
			$is_file_iis6 = is_file($file_iis6);
			$this->assign('is_file_iis6', $is_file_iis6);
			if($mk == 'httpd_ini') {
				$f = @fopen($file_iis6, 'w');
				if (!$f) {
					exit('{"err":1, "msg":"无写入权限"}');
				} else {
					$bytes = fwrite($f, $iis6);
					fclose($f);
					if($bytes > 0) {
						exit('{"err":0, "msg":"创建 httpd.ini 成功"}');
					}else{
						exit('{"err":1, "msg":"创建 httpd.ini 失败"}');
					}
				}
			}
			// 删除httpd.ini
			if($del == 'httpd_ini') {
				$ret = FALSE;
				try{ $is_file_iis6 && $ret = unlink($file_iis6); }catch(Exception $e) {}
				if($ret) {
					exit('{"err":0, "msg":"删除 httpd.ini 成功"}');
				}else{
					exit('{"err":1, "msg":"删除 httpd.ini 失败"}');
				}
			}
			$input = array();
			$input['parseurl'] = form::loop('radio', 'parseurl', array('0'=>'动态', '1'=>'伪静态'), $parseurl, ' &nbsp; &nbsp;');
			$input['link_show'] = form::get_text('link_show', $cfg['link_show'], 'form-control');
			$input['link_cate_end'] = form::get_text('link_cate_end', $cfg['link_cate_end'], 'form-control');
			$input['link_cate_page_pre'] = form::get_text('link_cate_page_pre', $cfg['link_cate_page_pre'], 'form-control');
			$input['link_cate_page_end'] = form::get_text('link_cate_page_end', $cfg['link_cate_page_end'], 'form-control');
			$input['link_tag_pre'] = form::get_text('link_tag_pre', $cfg['link_tag_pre'], 'form-control');
			$input['link_tag_end'] = form::get_text('link_tag_end', $cfg['link_tag_end'], 'form-control');
			$input['link_comment_pre'] = form::get_text('link_comment_pre', $cfg['link_comment_pre'], 'form-control');
			$input['link_comment_end'] = form::get_text('link_comment_end', $cfg['link_comment_end'], 'form-control');
			$input['link_index_end'] = form::get_text('link_index_end', $cfg['link_index_end'], 'form-control');
			$this->assign('input', $input);
			
			$this->display();
		}else{
			_trim($_POST);
			// 伪静态开关
			$parseurl = (int)R('parseurl', 'P');
			$file = APP_PATH.'config/config.php';
			if(!_is_writable($file)) exit('{"err":1, "msg":"配置文件 config/config.php 不可写"}');
			$s = file_get_contents($file);
			$s = preg_replace("#'nzcms_parseurl'\s*=>\s*\d,#", "'nzcms_parseurl' => {$parseurl},", $s);
			if(!file_put_contents($file, $s)) exit('{"err":1, "msg":"写入 config.php 失败"}');
			// 关闭伪静态时，不需要更改伪静态参数
			if($parseurl == 0) {
				$this->runtime->truncate();
				exit('{"err":0, "msg":"修改成功"}');
			}
			// 智能生成内容链接参数 (四种情况，性能方面依次排列)
			$link_show = R('link_show', 'P');
			if(substr($link_show, 0, 10) == '{cid}/{id}' && strpos($link_show, '{', 10) === FALSE) {
				$link_show_type = 1;
				$link_show_end = (string)substr($link_show, 10);
			}elseif(substr($link_show, 0, 17) == '{cate_alias}/{id}' && strpos($link_show, '{', 17) === FALSE) {
				$link_show_type = 2;
				$link_show_end = (string)substr($link_show, 17);
			}elseif(substr($link_show, 0, 7) == '{alias}' && strpos($link_show, '{', 7) === FALSE) {
				$link_show_type = 3;
				$link_show_end = (string)substr($link_show, 7);
			}else{
				$link_show_type = 4;
				$link_show_end = '';
			}
			$this->kv->xset('link_show', $link_show, 'cfg');
			$this->kv->xset('link_show_type', $link_show_type, 'cfg');
			$this->kv->xset('link_show_end', $link_show_end, 'cfg');
			$link_cate_page_pre = R('link_cate_page_pre', 'P');
			$link_cate_page_end = R('link_cate_page_end', 'P');
			$link_cate_end = R('link_cate_end', 'P');
			$link_tag_pre = R('link_tag_pre', 'P');
			$link_tag_end = R('link_tag_end', 'P');
			$link_comment_pre = R('link_comment_pre', 'P');
			$link_comment_end = R('link_comment_end', 'P');
			$link_index_end = R('link_index_end', 'P');
			// 暂时不考虑过滤 标签URL前缀 和 评论URL后缀 重复问题
			if(empty($link_cate_page_pre)) exit('{"err":1, "msg":"分类URL前缀不能为空"}');
			if(empty($link_cate_page_end)) exit('{"err":1, "msg":"分类URL后缀不能为空"}');
			if(empty($link_cate_end)) exit('{"err":1, "msg":"分类URL首页后缀不能为空"}');
			if(empty($link_tag_pre)) exit('{"err":1, "msg":"标签URL前缀不能为空"}');
			if(empty($link_tag_end)) exit('{"err":1, "msg":"标签URL后缀不能为空"}');
			if(empty($link_comment_pre)) exit('{"err":1, "msg":"评论URL前缀不能为空"}');
			if(empty($link_comment_end)) exit('{"err":1, "msg":"评论URL后缀不能为空"}');
			if(empty($link_index_end)) exit('{"err":1, "msg":"首页分页URL后缀不能为空"}');
			$this->kv->xset('link_index_end', $link_index_end, 'cfg');
			$this->kv->xset('link_cate_page_pre', $link_cate_page_pre, 'cfg');
			$this->kv->xset('link_cate_page_end', $link_cate_page_end, 'cfg');
			$this->kv->xset('link_cate_end', $link_cate_end, 'cfg');
			$this->kv->xset('link_tag_pre', $link_tag_pre, 'cfg');
			$this->kv->xset('link_tag_end', $link_tag_end, 'cfg');
			$this->kv->xset('link_comment_pre', $link_comment_pre, 'cfg');
			$this->kv->xset('link_comment_end', $link_comment_end, 'cfg');
			
			$this->kv->save_changed();
			$this->runtime->truncate();
			exit('{"err":0, "msg":"修改成功"}');
		}
	}
	// 上传设置
	public function attach() {
		if(empty($_POST)) {
			$cfg = $this->kv->xget('cfg');
			$input = array();
			$input['up_img_ext'] = form::get_text('up_img_ext', $cfg['up_img_ext'], 'form-control');
			$input['up_img_max_size'] = form::get_number('up_img_max_size', $cfg['up_img_max_size'], 'form-control');
			$input['up_file_ext'] = form::get_text('up_file_ext', $cfg['up_file_ext'], 'form-control');
			$input['up_file_max_size'] = form::get_number('up_file_max_size', $cfg['up_file_max_size'], 'form-control');
			
			$this->assign('input', $input);
			$this->display();
		}else{
			_trim($_POST);
			$this->kv->xset('up_img_ext', R('up_img_ext', 'P'), 'cfg');
			$this->kv->xset('up_img_max_size', R('up_img_max_size', 'P'), 'cfg');
			$this->kv->xset('up_file_ext', R('up_file_ext', 'P'), 'cfg');
			$this->kv->xset('up_file_max_size', R('up_file_max_size', 'P'), 'cfg');
			
			$this->kv->save_changed();
			$this->runtime->delete('cfg');
			exit('{"err":0, "msg":"修改成功"}');
		}
	}
	// 图片设置
	public function image() {
		if(empty($_POST)) {
			$cfg = $this->kv->xget('cfg');
			$input = array();
			$input['thumb_products_w'] = form::get_number('thumb_products_w', $cfg['thumb_products_w'], 'form-control');
			$input['thumb_products_h'] = form::get_number('thumb_products_h', $cfg['thumb_products_h'], 'form-control');
			$input['thumb_article_w'] = form::get_number('thumb_article_w', $cfg['thumb_article_w'], 'form-control');
			$input['thumb_article_h'] = form::get_number('thumb_article_h', $cfg['thumb_article_h'], 'form-control');
			$input['thumb_type'] = form::loop('radio', 'thumb_type', array('1'=>'补白', '2'=>'居中', '3'=>'上左'), $cfg['thumb_type'], ' &nbsp; &nbsp;');
			$input['thumb_quality'] = form::get_number('thumb_quality', $cfg['thumb_quality'], 'form-control');
			$cfg['watermark_pos'] = isset($cfg['watermark_pos']) ? (int)$cfg['watermark_pos'] : 0;
			$input['watermark_pct'] = form::get_number('watermark_pct', $cfg['watermark_pct'], 'form-control');
			
			$this->assign('input', $input);
			$this->assign('cfg', $cfg);
			$this->display();
		}else{
			$this->kv->xset('thumb_products_w', (int) R('thumb_products_w', 'P'), 'cfg');
			$this->kv->xset('thumb_products_h', (int) R('thumb_products_h', 'P'), 'cfg');
			$this->kv->xset('thumb_article_w', (int) R('thumb_article_w', 'P'), 'cfg');
			$this->kv->xset('thumb_article_h', (int) R('thumb_article_h', 'P'), 'cfg');
			$this->kv->xset('thumb_type', (int) R('thumb_type', 'P'), 'cfg');
			$this->kv->xset('thumb_quality', (int) R('thumb_quality', 'P'), 'cfg');
			$this->kv->xset('watermark_pos', (int) R('watermark_pos', 'P'), 'cfg');
			$this->kv->xset('watermark_pct', (int) R('watermark_pct', 'P'), 'cfg');
			
			$this->kv->save_changed();
			$this->runtime->delete('cfg');
			exit('{"err":0, "msg":"修改成功"}');
		}
	}

	// 检查是否为合法的主题名
	private function check_theme($dir) {
		if(empty($dir)) {
			E(1, '主题目录名不能为空！');
		}elseif(preg_match('/\W/', $dir)) {
			E(1, '主题目录名不正确！');
		}elseif(!is_dir(APP_PATH.'view/'.$dir)) {
			E(1, '主题目录名不存在！');
		}
	}
	private function get_theme_all() {
		$dir = APP_PATH.'view/';
		$files = _scandir($dir);
		return $files;
	}

	public function vip() {
		_trim($_POST);
		$key = trim(R('key', 'P'));
		$_key = trim(R('_key', 'P'));
		$this->kv->xset('key', $key,'vip');
		$this->kv->xset('_key', $_key,'vip');
		$this->kv->save_changed();
		E(0, '保存成功');
	}
	//邮件测试
	public function testemail(){
		$cfg = $this->kv->xget('cfg');
		$email = R('email','P');
		if( empty($email) || !check::is_email($email) )	$this->message(0,'邮箱格式不正确！');
		$mmiscModel = &$this->mmisc;
		$code	= other::rand_string(6,1);
		$content = '您的验证码为'.$code ;
		$errMsg = $mmiscModel->sendmail('',$email,$content,$content.'请勿回复！');
		if( empty($errMsg) ){
			E(0, '邮件发送成功！');
		}else{
			E(1, '邮件发送失败！');
		}
	}
}
