<?php
defined('PP_PATH') or exit;
class user_control extends admin_control {
	public $_group_arr = array();
	
	public function __construct(){
		parent::__construct();
		$user_group = &$this->user_group;
		$this->_group_arr = $user_group->get_groups();
	}
	
	// 用户管理
	public function index() {
		$urlstr = '';
		
		$user = &$this->user;
		
		$where = $order = array();
		$condition['username'] = '';
		$condition['groupid'] = '*';
		
		$username = empty($_POST) ? R('username') : R('username', 'P');
		$groupid = empty($_POST) ? R('groupid') : R('groupid', 'P');
		

		
		$_order = intval(R('order'));
		if(!empty($_order)){
			$order['logindate'] = '-1' ;
			$urlstr .= '-order-'.$_order;
		}else{
			$order['uid'] = '-1' ;
		}
		if($username){
			$condition['username'] = $where['username'] = $username;
			$urlstr .= '-username-'.urlencode($username);
		}
		if($groupid && $groupid != '*'){
			$condition['groupid'] = $where['groupid'] = $groupid;
			$urlstr .= '-groupid-'.$groupid;
		}
		
		//所有用户组
		$this->assign('user_group_list', $this->_group_arr);
		
		// 初始分页
		$pagenum = 20;
		
		$total = $user->find_count($where);
		
		$this->assign('condition',$condition);
		
		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pp_pages($page, $maxpage, 'index.php?u=user-index'.$urlstr.'-page-{page}');
		$this->assign('total', $total);
		$this->assign('pages', $pages);
		
		$list = $user->find_fetch($where,$order,($page-1)*$pagenum, $pagenum, $total);
		$this->cms_content_book->table = 'cms_book';
		foreach ($list as &$v){
			$user->format($v);
			$v['groupname'] = $this->_group_arr['user_group-groupid-'.$v['groupid']]['groupname'];
			$v['status_num'] = $v['status'] ;
			$v['ordernum'] = $this->cms_content_book->find_count(array('uid'=>$v['uid']));
			
			switch ($v['status']){
				case 1:
					$v['status'] = '√';break;
				case 2:
					$v['status'] = '<span style="color:red">禁止</span>';break;
				default:
					$v['status'] = '<a class="but3" href="javascript:;" onclick="set_status('.$v['uid'].',1);">激活</a>';
			}
		}
		$this->assign('_order', $_order);
		$this->assign('list', $list);
		$this->display();
	}
	
	//添加用户
	public function add(){
		if( empty($_POST) ){
			$this->_pkey = 'user';
			$this->_ukey = 'user-add';
			$this->_title = '添加用户';
			$this->_place = '用户 &#187; 用户管理 &#187 添加用户';
			
			$this->assign('user_group', $this->_group_arr);
			
			$this->display();
		}else{
			$user = &$this->user;
			$info = R('info','P');
			if( empty($info) ){
				E(1, '添加用户失败，传递参数为空！', 'name');
			}elseif ( $info['email'] && !check::is_email($info['email']) ){
				E(1, '添加用户失败，邮箱格式不正确！', 'name');
			}else{
				$usermsg = $user->check_username($info['username']);
				if( $usermsg != '' ) E(1, '用户名不能为空！');
				
				$passwordmsg = $user->check_password($info['password']);
				if( $passwordmsg != '' ) E(1, '密码不能为空！', 'password');
				
				if( $info['password'] != $info['repassword'] )	E(1, '添加用户失败:两次输入的密码不一致！', 'repassword');
				
				$has = $user->get_user_by_username($info['username']);
				if( $has ) E(1, '用户名已经存在！');
				
				unset($info['repassword']);
				
				//后台添加用户不需要增加审核机制
				
				$ip = &$_ENV['_ip'];
				$time = time();
				$info['salt'] = $salt = random(16, 3, '0123456789abcdefghijklmnopqrstuvwxyz~!@#$%^&*()_+<>,.');
				$info['password'] = get_password($info['password'],$salt);
				$info['regip'] = ip2long($ip);
				$info['regdate'] = $time;
				$info['author'] = empty($info['author']) ? $info['username']:$info['author'];
				$info['status'] = 1;
				$info['groupid'] = max(1, (int)$info['groupid']);
				
				$info['isadmin'] = intval($this->_group_arr['user_group-groupid-'.$info['groupid']]['isadmin']);

				$uid = $user->create($info);
				if( $uid ){
					E(0, '添加成功！');
				}else{
					E(1, '添加用户失败，写入数据库失败！');
				}
			}
			
		}
	}
	
	
	//编辑用户
	public function edit(){
		if( empty($_POST) ){
			$uid = intval( R('uid','G') );
			
			$this->_pkey = 'user';
			$this->_ukey = 'user-edit-uid-'.$uid;
			$this->_title = '编辑用户';
			$this->_place = '用户 &#187; 用户管理 &#187 编辑用户';
			
			$user = &$this->user;
			$data = $user->get($uid);
			
			$this->assign('user_group',$this->_group_arr);
			
			$this->assign('data',$data);
			
			$this->display();
		}else{
			$user = &$this->user;
			$info = R('info','P');
			$uid = intval( R('uid','P') );
			if( empty($info) || empty($uid) ){
				E(1, '添加用户失败，传递参数为空！', 'name');
			}elseif ( $info['email'] && !check::is_email($info['email']) ){
				E(1, '添加用户失败，邮箱格式不正确！', 'name');
			}elseif( $info['mobile'] && !check::is_mobile($info['mobile']) ){
					E(1, '编辑用户失败，手机号格式不正确！');
			}else{
				$usermsg = $user->check_username($info['username']);
				if( $usermsg != '' ) E(1, '用户名不能为空！');
			
				$has = $user->get_user_by_username($info['username']);
				if( $has && $has['uid'] != $uid ) E(1, '编辑用户失败，用户名已经存在！');
				
								
				$info['groupid'] 	= max(1, (int)$info['groupid']);			
				$info['isadmin'] 	= intval($this->_group_arr['user_group-groupid-'.$info['groupid']]['isadmin']);
				$info['author'] 	= empty($info['author']) ? $info['username']:$info['author'];
				$info['uid'] 		= $uid;
				$info['mobile_staus'] 		= empty($info['mobile_staus']) ? 0:$info['mobile_staus'];
				$info['email_staus'] 		= empty($info['email_staus']) ? 0:$info['email_staus'];

				if( $user->update($info) ){
					E(0, '编辑用户成功！');
				}else{
					E(1, '编辑用户失败，写入数据库失败！');
				}
			}
		}
	}
	
	//调整余额 ajax
	public function change_money(){
		if(empty($_POST) ){
			$res = array('err'=>1,'msg'=>'来源错误');
		}else{
			$uid 		= intval(R('uid','P'));
			//$_money 	= intval(R('money','P'));
			$_money 	= sprintf("%.2f", R('money','P')); 
			
			$user = &$this->user;
			$data = $user->get($uid);
			
			$info = array(
				'uid'	=> $uid,
				'money'	=> $data['money'] + $_money ,
			);

			if($user->update($info)){
				$res = array('err' => 0,'msg'=>'成功');
				//添加交易记录
				$record 	= &$this->record;
				$recordata 	= array(
					'uid'		=> $data['uid'],
					'username'	=> $data['username'],
					'money'		=> $_money,
					'gold'		=> 0,
					'type'		=> 0,
					'created'	=> $_ENV['_time'],
					'status'	=> 0,
					'comment'	=> '系统',
				);
				$record->create($recordata);
			}else{
				$res = array('err' => 1,'msg'=>'更新用户金额失败');
			}
			exit(json_encode($res));
		}
	}
	
	//删除用户
	public function del(){
		$uid = intval( R('uid','P') );
		$user = &$this->user;
		$msg = $user->xdelete($uid);
		if( $msg ){
			E(1, $msg);
		}else{
			E(0, '删除成功！');
		}
	}
	
	//禁止　解禁
	public function set_status(){
		$uid 	= intval( R('uid','P') );
		$status = intval( R('status','P') );
		
		$user = &$this->user;
		$data = $user->get($uid);
		
		$data['status'] = $status ;
		
		if(!$user->update($data)){
			E(1, '出错了');
		}
		E(0, '操作成功！');
	}
}