<?php
defined('PP_PATH') or exit;
class withdraw_control extends admin_control {
	//提现管理
	public function index(){
		$cfg = $this->kv->xget('cfg');
		// 初始模型表名
		$this->cms_content->table = 'record';
		$pagenum = 10;

		$where	= array();
		
		$username 	= R('username','R');
		$order_id 	= R('order_id','R');
		$status 	= R('status','R');
		
		$this->_pkey = 'audit';
		$this->_ukey = 'withdraw-index-status-'.$status;
		$this->_title = '提现列表';
		$this->_place = '提现管理 &#187; 提现列表';

		$urlstr = '';
		if($username){
			$where['username'] = $username;			
			$urlstr .= '-username-'.$username;
		}
		if($order_id){
			$where['order_id'] = $order_id;			
			$urlstr .= '-order_id-'.$order_id;
		}

		$where['status'] = $status;
		$urlstr .= '-status-'.$status;

		$where['type'] 		= 3;
		$total = $this->record->find_count($where);
		
		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pp_pages($page, $maxpage, 'index.php?u=record-index'.$urlstr.'-page-{page}');
		$this->assign('total', $total);
		$this->assign('pages', $pages);
		
		$cms_arr = $this->record->list_arr($where, 'id', -1, ($page-1)*$pagenum, $pagenum, $total);
		foreach($cms_arr as &$v) {
			switch ($v['paybank']){
				case 'chinabank':
					$v['paybank'] = '网银在线';break;
				case 'alipay':
					$v['paybank'] = '支付宝';break;
				case 'lifealipay':
					$v['paybank'] = '支付宝转帐';break;
				default:
					$v['paybank'] = '';
			}
			$v['user'] = $this->user->get($v['uid']);
		}
		$this->assign('lists', $cms_arr);
		$this->assign('pp', $cfg);
		$this->assign('username', $username);
		$this->assign('order_id', $order_id);
		$this->display();
	}
	// 付款跳转支付宝
	public function lifealipay(){
		$id = intval(R('id','G') );
		header('Location:index.php?u=pay-lifealipay-id-'.$id);
	}
	// 付款完毕
	public function confirm(){
		$id = intval( R('id','P') );
		$cfg = $this->runtime->xget('cfg');
		
		$data = $this->record->get($id);
		$update['id'] 		= $id;
		$update['status'] 	= 0;

		$user 		= $this->user->get($data['uid']);
		$user['dmoney']	= $user['dmoney'] - $data['money'] ; //冻结金额扣除


		if(!$this->user->update($user)){
			$err_msg1 = '用户金额更新失败';
		}
		if(!$this->record->update($update)){
			$err_msg2 = '订单状态更新失败';
		}
		if(!empty($err_msg1) || !empty($err_msg2)){
			E(1, $err_msg1.$err_msg2);
		}
		E(0, '处理成功');
	}
	// 删除
	public function del(){
		$id = intval( R('id','P') );
		$uid = intval( R('uid','P') );
	
		$where['id'] = $id;
		$where['uid'] = $uid;
		
		//返回用户金额
		$user 	= $this->user->get($uid);
		$data	= $this->record->get($id);
		$user['dmoney']	= $user['dmoney'] - $data['money'] ; //冻结金额扣除
		$user['money']	= $user['money'] + $data['money'] ; //可用金额增加

		$status = $this->record->find_delete($where);
		if($status){
			$this->user->update($user);
			E(0, '删除成功');
		}else{
			E(1, '删除失败！');
		}
	}
}
