<?php
defined('PP_PATH') or exit;
class comment_control extends user_control{
	public $_navgroup = 'home';
	//我的评论
	public function index(){
		$this->assign_value('navkey', 'comment-index');
		$mid = max(2, (int)R('mid'));
		$table = $this->models->get_table($mid);
		
		// 模型名称
		$mod_name = $this->models->get_name();
		if(isset($mod_name[1])) unset($mod_name[1]);
		$this->assign('mid', $mid);
		$this->assign('mod_name', $mod_name);
		
		$where['mid'] = $mid;
		$where['uid'] = $this->_uid;
		
		// 初始分页
		$pagenum = 20;
		$total = $this->cms_comment->find_count($where);
		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pages($page, $maxpage, 'index.php?u=my-comment-mid-'.$mid.'-page-{page}');
		$this->assign('pages', $pages);
		$this->assign('total', $total);
		
		// 获取评论列表
		$id_arr = array();
		$comment_arr = $this->cms_comment->list_arr($where, -1, ($page-1)*$pagenum, $pagenum, $total);
		foreach($comment_arr as &$v) {
			$this->cms_comment->format($v, 'Y-m-d H:i:s', 0);
			$id_arr[] = $v['id'];
		}
		
		$id_arr = array_unique($id_arr);
		$this->cms_content->table = 'cms_'.$table;
		$key_pre = 'cms_'.$table.'-id-';
		$tmp = $this->cms_content->mget($id_arr);
		foreach($comment_arr as &$v) {
			$row = $tmp[$key_pre.$v['id']];
			$v['title'] = $row['title'];
			$v['url'] = $this->cms_content->content_url($row['cid'], $row['id'], $row['alias'], $row['dateline']);
		}
		$this->assign('lists', $comment_arr);
		
		$this->display('comment.htm');
	}
	
	//删除评论
	public function commentdel(){
		$commentid = intval( R('commentid','G') );
		$model = $this->cms_comment;
		$comment_data = $model->get($commentid);
		if( $comment_data['uid'] != $this->_uid ){
			$this->message(0, '该评论部属于你！');
		}
		$table = $this->models->get_table($comment_data['mid']);
		$err = $model->xdelete($table, $comment_data['id'], $commentid);
		if($err) {
			$this->message(0, $err);
		}else{
			$this->message(1, '删除成功！','index.php?u=my-comment');
		}
	}
}
