<?php
defined('PP_PATH') or exit;
class record_control extends user_control{
	public $_navgroup = 'record';

	//交易清单
	public function index(){
		$this->assign_value('navkey', 'record-index');

		// 初始分页
		$where['uid'] = $this->_uid;
		$pagenum = 20;
		
		$type = intval(R('type')); // 1 充值 2消费
		
		$urlstr = '';
		if($type) {
			$where['type'] = $type;			
			$urlstr = '-type-'.$type;
		}
		$total = $this->record->find_count($where);
		
		$maxpage 	= max(1, ceil($total/$pagenum));
		$page 		= min($maxpage, max(1, intval(R('page'))));
		$pages 		= user_pages($page, $maxpage, 'index.php?u=record-index'.$urlstr.'-page-{page}');
		$this->assign('total', $total);
		$this->assign('pages', $pages);
		
		$cms_arr = $this->record->list_arr($where, 'id', -1, ($page-1)*$pagenum, $pagenum, $total);
		foreach($cms_arr as &$v) {

			switch ($v['type']){
				case 0:
					$v['typename'] = '系统';break;
				case 1:
					$v['typename'] = '充值';break;
				case 2:
					$v['typename'] = '消费';break;
				case 3:
					$v['typename'] = '提现';break;
				case 4:
					$v['typename'] = '提成';break;
				default:
					$v['typename'] = '';
			}
		}
		$this->assign('lists', $cms_arr);
		$this->assign('type', $type);
		$this->assign('type1', $type1);
		$this->display('record.htm');
	}
	
	//充值
	public function order(){
		$this->assign_value('navkey', 'record-order');
		if(empty($_POST)) {
			$price 		= (int)R('price');
			$this->assign('price', $price);
			$this->display('order.htm');
		}else{
			$price 		= R('price','P');
			$paybank 	= R('paybank','P');
			$teegon_channel 	= R('teegon_channel','P');	//天工选择

			$order_id = order_number();

			if($price<=0){
				//$this->message(0, '金额必须大于0');
				E(1, '金额必须大于0');
			}
			
			//写入交易记录库
			//成功后更新充值状态，更新订单状态，并增加消费记录
			$record = &$this->record;
			$recordata = array(
				'uid'		=> $this->_user['uid'],
				'username'	=> $this->_user['username'],
				'money'		=> $price,
				'gold'		=> 0,
				'type'		=> 1,
				'paybank'	=> $paybank,
				'order_id'	=> $order_id,
				'created'	=> $_ENV['_time'],
				'status'	=> 1,
			);
			$id = $record->create($recordata);
			if($id>0){
				if($paybank == 'teegon'){
					header('Location:'.$this->_cfg['weburl'].'index.php?u=pay-'.$paybank.'-id-'.$id.'-channel-'.$teegon_channel);
				}else{
					header('Location:'.$this->_cfg['weburl'].'index.php?u=pay-'.$paybank.'-id-'.$id);
				}
			}else{
				$this->message(0, '订单写入失败');
			}
		}
	}

	//删除
	public function del(){
		$order_id = trim(strip_tags((R('oid','P'))));
		
		$model = &$this->record;
	
		$where['order_id'] 		= $order_id;
		$where['uid'] 			= $this->_uid;
		$where['status'] 		= 1;

		$status = $model->find_delete($where);
		if($status){
			E(0, '删除成功');
		}else{
			E(1, '删除失败！');
		}
	}
}
