<?php
defined('FINE_PATH') || exit;
/**
 * 列表页模块 (不推荐频道分类使用此模块，影响性能)
 * @param int pagenum 每页显示条数
 * @param int titlenum 标题长度
 * @param int intronum 简介长度
 * @param string dateformat 时间格式
 * @param string orderby 排序方式
 * @param int orderway 降序(-1),升序(1)
 * @return array
 */
function kp_block_global_cate($conf) {
	global $run;

	$order = intval(R('order','C'));//将orderby从cookie中获取 只限列表页排序
	$cid = &$run->_var['cid'];
	$mid = &$run->_var['mid'];

	if($mid==2){
		if($order==2){
			$orderby = 'sells'; //热度
			$orderway = -1;
		}elseif($order==3){	//价格
			$orderby = 'price';
			$orderway = 1;
		}elseif($order==1){
			$orderby = 'lasttime'; //更新时间
			$orderway = -1;
		}else{
			$orderby = 'id';
			$orderway = -1;
		}
	}else{
		$orderby = 'id';
		$orderway = -1;
	}

	$pagenum = empty($conf['pagenum']) ? 20 : max(1, (int)$conf['pagenum']);
	$titlenum = isset($conf['titlenum']) ? (int)$conf['titlenum'] : 0;
	$intronum = isset($conf['intronum']) ? (int)$conf['intronum'] : 0;
	$dateformat = empty($conf['dateformat']) ? 'Y-m-d H:i:s' : $conf['dateformat'];
	$orderby = isset($conf['orderby']) && in_array($conf['orderby'], array('id', 'dateline')) ? $conf['orderby'] : $orderby;
	$orderway = isset($conf['orderway']) && $conf['orderway'] == 1 ? 1 : $orderway;
	$ext = _int($conf, 'ext');

	// 排除单页模型
	if($mid == 1) return FALSE;
	
	$where = array();

	if(!empty($run->_var['son_cids']) && is_array($run->_var['son_cids'])) {
		// 影响数据库性能
		$where['cid'] = array("IN" => $run->_var['son_cids']);
		$total = 0;
		$cate_arr = array();
		foreach($run->_var['son_cids'] as $v) {
			$cate_arr[$v] = $run->category->get_cache($v);
			//$total += $cate_arr[$v]['count'];
			$total += $cate_arr[$v]['count_0'];
		}
	}else{
		$where['cid'] = $cid;
		$total = &$run->_var['count_0'];
	}
	$where['status'] = 0;
	// 分页相关
	$maxpage = max(1, ceil($total/$pagenum));
	$page = min($maxpage, max(1, intval(R('page'))));
	$pages = pp_pages($page, $maxpage, $run->category->category_url($cid, $run->_var['alias'], TRUE));

	// 初始模型表名
	$run->cms_content->table = 'cms_'.$run->_var['table'];

	// 获取内容列表
	$list_arr = $run->cms_content->list_arr($where, $orderby, $orderway, ($page-1)*$pagenum, $pagenum, $total);
	foreach($list_arr as &$v) {
		$run->cms_content->format($v, $mid, $dateformat, $titlenum, $intronum ,$ext);
		if(isset($cate_arr)) {
			$v['cate_name'] = $cate_arr[$v['cid']]['name'];
			$v['cate_url'] = $run->category->category_url($cate_arr[$v['cid']]['cid'], $cate_arr[$v['cid']]['alias']);
		}
	}
	return array('total'=> $total, 'pages'=> $pages, 'list'=> $list_arr);
}