<?php
defined('FINE_PATH') || die('Error Accessing');
version_compare(PHP_VERSION, '5.2.0', '>') || die('require PHP > 5.2.0 !');
$_ENV['_start_time'] = microtime(1);
define('MEMORY_LIMIT_ON', function_exists('memory_get_usage'));
if(MEMORY_LIMIT_ON) $_ENV['_start_memory'] = memory_get_usage();
define('FINE_VERSION', '1.0.0');
defined('DEVMODE') || define('DEVMODE', true);
defined('CONFIG_PATH') || define('CONFIG_PATH', APP_PATH.'config/');
defined('CONTROL_PATH') || define('CONTROL_PATH', APP_PATH.'control/');
defined('BLOCK_PATH') || define('BLOCK_PATH', APP_PATH.'block/');
defined('MODEL_PATH') || define('MODEL_PATH', APP_PATH.'model/');
defined('VIEW_PATH') || define('VIEW_PATH', APP_PATH.'view/');
defined('LOG_PATH') || define('LOG_PATH', APP_PATH.'log/');
defined('RUNTIME_PATH') || define('RUNTIME_PATH', APP_PATH.'runtime/');
defined('RUNTIME_MODEL') || define('RUNTIME_MODEL', RUNTIME_PATH.APP_NAME.'_model/');
defined('RUNTIME_CONTROL') || define('RUNTIME_CONTROL', RUNTIME_PATH.APP_NAME.'_control/');
include CONFIG_PATH.'config.php';
if(DEVMODE){
	include FINE_PATH.'base/base.func.php';
	include FINE_PATH.'base/core.class.php';
	include FINE_PATH.'base/devmode.class.php';
	include FINE_PATH.'base/log.class.php';
	include FINE_PATH.'base/model.class.php';
	include FINE_PATH.'base/view.class.php';
	include FINE_PATH.'base/control.class.php';
	include FINE_PATH.'db/db.interface.php';
	include FINE_PATH.'db/db_mysql.class.php';
	include FINE_PATH.'cache/cache.interface.php';
	include FINE_PATH.'cache/cache_memcache.class.php';
}else{
	$runfile = RUNTIME_PATH.'_runtime.php';
	if(!is_file($runfile)) {
		$s  = trim(php_strip_whitespace(FINE_PATH.'base/base.func.php'), "<?ph>\r\n");
		$s .= trim(php_strip_whitespace(FINE_PATH.'base/core.class.php'), "<?ph>\r\n");
		$s .= trim(php_strip_whitespace(FINE_PATH.'base/devmode.class.php'), "<?ph>\r\n");
		$s .= trim(php_strip_whitespace(FINE_PATH.'base/log.class.php'), "<?ph>\r\n");
		$s .= trim(php_strip_whitespace(FINE_PATH.'base/model.class.php'), "<?ph>\r\n");
		$s .= trim(php_strip_whitespace(FINE_PATH.'base/view.class.php'), "<?ph>\r\n");
		$s .= trim(php_strip_whitespace(FINE_PATH.'base/control.class.php'), "<?ph>\r\n");
		$s .= trim(php_strip_whitespace(FINE_PATH.'db/db.interface.php'), "<?ph>\r\n");
		$s .= trim(php_strip_whitespace(FINE_PATH.'db/db_mysql.class.php'), "<?ph>\r\n");
		$s .= trim(php_strip_whitespace(FINE_PATH.'cache/cache.interface.php'), "<?ph>\r\n");
		$s .= trim(php_strip_whitespace(FINE_PATH.'cache/cache_memcache.class.php'), "<?ph>\r\n");
		$s = str_replace('defined(\'FINE_PATH\') || exit;', '', $s);
		file_put_contents($runfile, '<?php '.$s);
		unset($s);
	}
	include $runfile;
}
core::start();