DROP TABLE IF EXISTS pre_category;
CREATE TABLE pre_category (
  cid smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  mid tinyint(1) unsigned NOT NULL DEFAULT '0',
  type tinyint(1) unsigned NOT NULL DEFAULT '0',
  upid int(10) NOT NULL DEFAULT '0',
  name char(30) NOT NULL DEFAULT '',
  alias char(50) NOT NULL DEFAULT '',
  intro char(255) NOT NULL DEFAULT '',
  cate_tpl char(80) NOT NULL DEFAULT '',
  show_tpl char(80) NOT NULL DEFAULT '',
  count int(10) unsigned NOT NULL DEFAULT '0',
  count_0 int(10) unsigned NOT NULL DEFAULT '0',
  count_1 int(10) unsigned NOT NULL DEFAULT '0',
  orderby smallint(5) NOT NULL DEFAULT '0',
  seo_title char(80) NOT NULL DEFAULT '',
  seo_keywords char(80) NOT NULL DEFAULT '',
  seo_description char(150) NOT NULL DEFAULT '',
  PRIMARY KEY (cid),
  UNIQUE KEY alias (alias)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_article;
CREATE TABLE pre_cms_article (
  cid smallint(5) unsigned NOT NULL DEFAULT '0',
  id int(10) unsigned NOT NULL AUTO_INCREMENT,
  title char(80) NOT NULL DEFAULT '',
  color char(6) NOT NULL DEFAULT '',
  alias char(50) NOT NULL DEFAULT '',
  tags varchar(255) NOT NULL DEFAULT '',
  intro varchar(255) NOT NULL DEFAULT '',
  pic varchar(255) NOT NULL DEFAULT '',
  uid int(10) unsigned NOT NULL DEFAULT '0',
  author varchar(20) NOT NULL DEFAULT '',
  source varchar(150) NOT NULL DEFAULT '',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  lasttime int(10) unsigned NOT NULL DEFAULT '0',
  ip int(10) NOT NULL DEFAULT '0',
  iscomment tinyint(1) unsigned NOT NULL DEFAULT '0',
  comments int(10) unsigned NOT NULL DEFAULT '0',
  views int(10) unsigned NOT NULL DEFAULT '0',
  imagenum int(10) unsigned NOT NULL DEFAULT '0',
  filenum int(10) unsigned NOT NULL DEFAULT '0',
  flags varchar(20) NOT NULL DEFAULT '',
  seo_title varchar(80) NOT NULL DEFAULT '',
  seo_keywords varchar(80) NOT NULL DEFAULT '',
  seo_description varchar(255) NOT NULL DEFAULT '',
  baidu tinyint(1) unsigned NOT NULL DEFAULT '0',
  status tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
  KEY cid_id (cid,id),
  KEY cid_dateline (cid,dateline)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_article_data;
CREATE TABLE pre_cms_article_data (
  id int(10) unsigned NOT NULL DEFAULT '0',
  images mediumtext NOT NULL,
  content mediumtext NOT NULL,
  PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_article_flag;
CREATE TABLE pre_cms_article_flag (
  flag tinyint(1) unsigned NOT NULL DEFAULT '0',
  cid int(10) unsigned NOT NULL DEFAULT '0',
  id int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (flag,id),
  KEY flag_cid (flag,cid,id),
  KEY id (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_article_tag;
CREATE TABLE pre_cms_article_tag (
  tagid int(10) unsigned NOT NULL AUTO_INCREMENT,
  name char(10) NOT NULL DEFAULT '',
  count int(10) unsigned NOT NULL DEFAULT '0',
  content text NOT NULL,
  PRIMARY KEY (tagid),
  UNIQUE KEY name (name),
  KEY count (count)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_article_tag_data;
CREATE TABLE pre_cms_article_tag_data (
  tagid int(10) unsigned NOT NULL,
  id int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (tagid,id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_attach;
CREATE TABLE pre_cms_attach (
  aid int(10) unsigned NOT NULL AUTO_INCREMENT,
  cid smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  uid int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  id int(10) unsigned NOT NULL DEFAULT '0' COMMENT '内容ID',
  mid tinyint(1) unsigned NOT NULL DEFAULT '2' COMMENT '模型ID(默认文章模型)',
  filename char(80) NOT NULL DEFAULT '' COMMENT '文件原名',
  filetype char(10) NOT NULL DEFAULT '' COMMENT '后缀',
  filesize int(10) unsigned NOT NULL DEFAULT '0' COMMENT '大小',
  filepath char(150) NOT NULL DEFAULT '' COMMENT '路径',
  dateline int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上传时间',
  downloads int(10) unsigned NOT NULL DEFAULT '0' COMMENT '下载次数',
  isimage tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否是图片 (1为图片，0为文件)',
  PRIMARY KEY (aid),
  KEY id (id,aid,mid),
  KEY uid (uid,aid)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

DROP TABLE IF EXISTS pre_cms_block;
CREATE TABLE pre_cms_block (
  id int(10) unsigned NOT NULL AUTO_INCREMENT,
  pos char(30) NOT NULL DEFAULT '',
  isjs tinyint(1) unsigned NOT NULL DEFAULT '0',
  title varchar(30) NOT NULL DEFAULT '',
  content text,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
  KEY pos (pos)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_book;
CREATE TABLE pre_cms_book (
  cid smallint(5) unsigned NOT NULL DEFAULT '0',
  id int(10) unsigned NOT NULL AUTO_INCREMENT,
  order_id char(20) NOT NULL,
  pid int(10) unsigned NOT NULL DEFAULT '0',
  uid int(10) unsigned NOT NULL DEFAULT '0',
  price decimal(11,2) unsigned NOT NULL DEFAULT '0.00',
  totalprice decimal(11,2) unsigned NOT NULL DEFAULT '0.00',
  ordernum smallint(3) unsigned NOT NULL DEFAULT '0',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  edittime int(10) unsigned NOT NULL DEFAULT '0',
  is_tuan tinyint(1) unsigned NOT NULL DEFAULT '0',
  is_comments tinyint(1) unsigned NOT NULL DEFAULT '0',
  staus tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
  KEY cid_id (cid,id),
  KEY cid_dateline (cid,dateline)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_comment;
CREATE TABLE pre_cms_comment (
  id int(10) unsigned NOT NULL DEFAULT '0' COMMENT '内容ID',
  mid tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '模型ID(默认文章模型)',
  commentid int(10) unsigned NOT NULL AUTO_INCREMENT,
  uid int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  author char(30) NOT NULL DEFAULT '' COMMENT '称呼',
  content text NOT NULL COMMENT '评论内容',
  ip int(10) NOT NULL DEFAULT '0' COMMENT 'IP',
  dateline int(10) unsigned NOT NULL DEFAULT '0' COMMENT '发表时间',
  status tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (commentid),
  KEY id (id,commentid,mid),
  KEY ip (ip,commentid)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_page;
CREATE TABLE pre_cms_page (
  cid smallint(5) unsigned NOT NULL,
  content mediumtext NOT NULL,
  PRIMARY KEY (cid)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_products;
CREATE TABLE pre_cms_products (
  cid smallint(5) unsigned NOT NULL DEFAULT '0',
  id int(10) unsigned NOT NULL AUTO_INCREMENT,
  uid int(10) unsigned NOT NULL DEFAULT '0',
  author varchar(20) NOT NULL DEFAULT '',
  title char(80) NOT NULL DEFAULT '',
  color char(6) NOT NULL DEFAULT '',
  pic varchar(255) NOT NULL,
  pid int(10) unsigned NOT NULL DEFAULT '0',
  down_pan varchar(255) NOT NULL,
  pan_code varchar(255) NOT NULL,
  demo_url varchar(255) NOT NULL,
  alias char(50) NOT NULL DEFAULT '',
  tags varchar(255) NOT NULL DEFAULT '',
  intro varchar(255) NOT NULL DEFAULT '',  
  price decimal(11,2) unsigned NOT NULL DEFAULT '0.00',
  sells int(10) unsigned NOT NULL DEFAULT '0',
  zk_price decimal(11,2) unsigned NOT NULL DEFAULT '0.00',
  zk_start int(10) unsigned NOT NULL DEFAULT '0',
  zk_end int(10) unsigned NOT NULL DEFAULT '0',
  lan tinyint(1) unsigned NOT NULL DEFAULT '0',
  sqls tinyint(1) unsigned NOT NULL DEFAULT '0',
  license tinyint(1) unsigned NOT NULL DEFAULT '0',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  lasttime int(10) unsigned NOT NULL DEFAULT '0',
  iscomment tinyint(1) unsigned NOT NULL DEFAULT '0',
  comments int(10) unsigned NOT NULL DEFAULT '0',
  faqs int(10) unsigned NOT NULL DEFAULT '0',
  views int(10) unsigned NOT NULL DEFAULT '0',
  seo_title varchar(80) NOT NULL DEFAULT '',
  seo_keywords varchar(80) NOT NULL DEFAULT '',
  seo_description varchar(255) NOT NULL DEFAULT '',
  status tinyint(1) unsigned NOT NULL DEFAULT '0',
  imagenum int(10) unsigned NOT NULL DEFAULT '0',
  filenum int(10) unsigned NOT NULL DEFAULT '0',
  flags varchar(20) NOT NULL DEFAULT '',
  baidu tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
  KEY cid_id (cid,id),
  KEY cid_dateline (cid,dateline)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_products_data;
CREATE TABLE pre_cms_products_data (
  id int(10) unsigned NOT NULL DEFAULT '0',
  images mediumtext NOT NULL,
  downs mediumtext NOT NULL,
  content mediumtext NOT NULL,
  PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_products_flag;
CREATE TABLE pre_cms_products_flag (
  flag tinyint(1) unsigned NOT NULL DEFAULT '0',
  cid int(10) unsigned NOT NULL DEFAULT '0',
  id int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (flag,id),
  KEY flag_cid (flag,cid,id),
  KEY id (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_products_golds;
CREATE TABLE pre_cms_products_golds (
  id int(10) unsigned NOT NULL DEFAULT '0',
  cid smallint(5) unsigned NOT NULL DEFAULT '0',
  gold decimal(3,1) unsigned NOT NULL DEFAULT '0.0',
  golder smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
  KEY cid (cid,gold),
  KEY gold (gold)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_products_tag;
CREATE TABLE pre_cms_products_tag (
  tagid int(10) unsigned NOT NULL AUTO_INCREMENT,
  name varchar(20) NOT NULL,
  count int(10) unsigned NOT NULL DEFAULT '0',
  content text NOT NULL,
  PRIMARY KEY (tagid),
  UNIQUE KEY name (name),
  KEY count (count)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_cms_products_tag_data;
CREATE TABLE pre_cms_products_tag_data (
  tagid int(10) unsigned NOT NULL,
  id int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (tagid,id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_framework_count;
CREATE TABLE pre_framework_count (
  name char(32) NOT NULL DEFAULT '',
  count int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (name)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_framework_maxid;
CREATE TABLE pre_framework_maxid (
  name char(32) NOT NULL DEFAULT '',
  maxid int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (name)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_kv;
CREATE TABLE pre_kv (
  k char(32) NOT NULL DEFAULT '',
  v text NOT NULL,
  expiry int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (k)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_models;
CREATE TABLE pre_models (
  mid tinyint(1) unsigned NOT NULL AUTO_INCREMENT,
  name char(10) NOT NULL DEFAULT '',
  tablename char(20) NOT NULL DEFAULT '',
  index_tpl char(80) NOT NULL DEFAULT '',
  cate_tpl char(80) NOT NULL DEFAULT '',
  show_tpl char(80) NOT NULL DEFAULT '',
  system tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (mid),
  UNIQUE KEY tablename (tablename)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_only_alias;
CREATE TABLE pre_only_alias (
  alias char(50) NOT NULL,
  mid tinyint(1) unsigned NOT NULL DEFAULT '0',
  cid smallint(5) unsigned NOT NULL DEFAULT '0',
  id int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (alias),
  KEY mid_id (mid,id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_record;
CREATE TABLE pre_record (
  id int(10) unsigned NOT NULL AUTO_INCREMENT,
  uid int(10) unsigned NOT NULL DEFAULT '0',
  username varchar(50) NOT NULL,
  type smallint(3) unsigned NOT NULL DEFAULT '0',
  type1 tinyint(3) unsigned NOT NULL DEFAULT '0',
  paybank varchar(20) NOT NULL,
  money decimal(11,2) NOT NULL DEFAULT '0.00',
  charge decimal(13,2) unsigned NOT NULL DEFAULT '0.00',
  gold int(10) NOT NULL DEFAULT '0',
  comment varchar(200) DEFAULT NULL,
  order_id char(20) NOT NULL,
  created int(10) unsigned NOT NULL DEFAULT '0',
  status tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
  KEY uid (uid)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_runtime;
CREATE TABLE pre_runtime (
  k char(32) NOT NULL DEFAULT '',
  v text NOT NULL,
  expiry int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (k)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_user;
CREATE TABLE pre_user (
  uid int(10) unsigned NOT NULL AUTO_INCREMENT,
  upid int(10) unsigned NOT NULL DEFAULT '0',
  username char(16) NOT NULL DEFAULT '',
  password char(32) NOT NULL DEFAULT '',
  salt char(16) NOT NULL DEFAULT '',
  groupid smallint(5) unsigned NOT NULL DEFAULT '0',
  email char(40) NOT NULL DEFAULT '',
  mobile char(11) NOT NULL,
  regip int(10) NOT NULL DEFAULT '0',
  regdate int(10) unsigned NOT NULL DEFAULT '0',
  loginip int(10) NOT NULL DEFAULT '0',
  logindate int(10) unsigned NOT NULL DEFAULT '0',
  lastip int(10) NOT NULL DEFAULT '0',
  lastdate int(10) unsigned NOT NULL DEFAULT '0',
  contents int(10) unsigned NOT NULL DEFAULT '0',
  comments int(10) unsigned NOT NULL DEFAULT '0',
  logins int(10) unsigned NOT NULL DEFAULT '0',
  author varchar(20) NOT NULL DEFAULT '',
  status tinyint(1) unsigned NOT NULL DEFAULT '0',
  isadmin tinyint(1) unsigned NOT NULL DEFAULT '0',
  avatar varchar(255) NOT NULL DEFAULT '',
  recordtime int(10) unsigned NOT NULL DEFAULT '0',
  recordays int(10) unsigned NOT NULL DEFAULT '0',
  setoptime int(10) unsigned NOT NULL DEFAULT '0',
  money decimal(13,2) unsigned NOT NULL DEFAULT '0.00',
  dmoney decimal(13,2) unsigned NOT NULL DEFAULT '0.00',
  gold int(10) unsigned NOT NULL DEFAULT '0',
  alipay char(40) NOT NULL DEFAULT '',
  alipay_name varchar(20) NOT NULL DEFAULT '',
  qq char(11) NOT NULL DEFAULT '',
  email_staus tinyint(1) unsigned NOT NULL DEFAULT '0',
  mobile_staus tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (uid),
  UNIQUE KEY username (username)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_user_group;
CREATE TABLE pre_user_group (
  groupid smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  groupname char(20) NOT NULL DEFAULT '',
  system tinyint(1) unsigned NOT NULL DEFAULT '0',
  isadmin tinyint(1) unsigned NOT NULL DEFAULT '0',
  purviews text NOT NULL,
  ishidden tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (groupid)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS pre_withdraw;
CREATE TABLE pre_withdraw (
  id int(10) unsigned NOT NULL AUTO_INCREMENT,
  uid int(10) unsigned NOT NULL DEFAULT '0',
  username varchar(50) NOT NULL,
  paybank varchar(20) NOT NULL,
  money decimal(11,2) NOT NULL DEFAULT '0.00',
  comment varchar(200) DEFAULT NULL,
  order_id char(20) NOT NULL,
  created int(10) unsigned NOT NULL DEFAULT '0',
  status tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
  KEY uid (uid)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

DROP TABLE IF EXISTS pre_cms_faq;
CREATE TABLE IF NOT EXISTS pre_cms_faq (
  id int(10) unsigned NOT NULL AUTO_INCREMENT,
  pid int(10) unsigned NOT NULL DEFAULT '0',
  title char(80) NOT NULL DEFAULT '',
  uid int(10) unsigned NOT NULL DEFAULT '0',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  lasttime int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
  KEY cid_id (id),
  KEY cid_dateline (dateline)
) ENGINE=MyISAM DEFAULT CHARSET=utf8  COLLATE=utf8_general_ci ;

DROP TABLE IF EXISTS pre_cms_faq_data;
CREATE TABLE IF NOT EXISTS pre_cms_faq_data (
  id int(10) unsigned NOT NULL DEFAULT '0',
  pid int(10) unsigned NOT NULL DEFAULT '0',
  content mediumtext NOT NULL,
  PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ;

DROP TABLE IF EXISTS pre_user_qqlogin;
CREATE TABLE pre_user_qqlogin (
  uid int(10) unsigned NOT NULL DEFAULT '0',
  openid char(32) NOT NULL DEFAULT '',
  PRIMARY KEY(uid),
  UNIQUE KEY(openid)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;