<?php
defined('PP_PATH') or exit;
class cms_content extends model {
	function __construct() {
		$this->table = '';	
		$this->pri = array('id');	// 主键
		$this->maxid = 'id';		// 自增字段
	}
	function __get($var) {
		if($var == 'cfg') {
			return $this->cfg = $this->runtime->xget();
		}else{
			return parent::__get($var);
		}
	}
	public function format(&$v, $mid, $dateformat = 'Y-m-d H:i:s', $titlenum = 0, $intronum = 0, $ext = 0) {
		if(empty($v)) return FALSE;
		//$v['date'] = date($dateformat, $v['dateline']);
		//$v['last'] = date($dateformat, $v['lasttime']);
		$v['date'] = humandate($v['dateline'],$dateformat);
		$v['last'] = humandate($v['lasttime'],$dateformat);
		if($mid==2){
			$v['iszk'] = 0 ;
			$v['lan'] 		= empty($v['lan']) ? $_ENV['_config']['lan'][0] : $_ENV['_config']['lan'][$v['lan']] ;
			$v['sqls'] 		= empty($v['sqls']) ? $_ENV['_config']['sqls'][0] : $_ENV['_config']['sqls'][$v['sqls']] ;
			$v['license'] 	= empty($v['license']) ? $_ENV['_config']['license'][0] : $_ENV['_config']['license'][$v['license']] ;
			if(!empty($v['size_mb'])){
				$v['size_mb'] = $v['size_mb']-0;
			}
			if($ext>0){
				$v['goldarr'] 		= $this->get_golds($v['cid'],$v['id']);
				$v['isBuyed'] 		= $this->cms_content_book->isBuyed($v['id']);
			}
			
			$v['old_price'] = 0 ;
			$v['zhe'] = 0 ;
			$zk_end	= !empty($v['zk_end']) ? $v['zk_end'] : 0 ;
			$zk_start	= !empty($v['zk_start']) ? $v['zk_start'] : 0 ;
			$v['vipprice'] 	= $v['price'] ;	//定义VIP

			if($zk_end > time() && $zk_start < time()){
				$v['old_price'] = $v['price'] ;
				$v['price'] 	= $v['zk_price'] ;
				$v['zhe'] 		= number_format($v['price'] / $v['old_price'] * 10, 1, ".", "") ;
				$v['iszk'] 		= 1 ;
			}
		}

		$v['subject'] = $titlenum ? utf8::cutstr_cn($v['title'], $titlenum) : $v['title'];
		$v['url'] = $this->content_url($v['cid'], $v['id'], $v['alias'], $v['dateline']);

		$v['tags'] = _json_decode($v['tags']);
		if($v['tags']) {
			$v['tag_arr'] = array();
			foreach($v['tags'] as $name) {
				$v['tag_arr'][] = array('name'=>$name, 'url'=> $this->tag_url($mid, $name));
			}
		}
		$v['intro'] = preg_replace('/( |　)/i','',$v['intro']);
		$intronum && $v['intro'] = strip_tags(utf8::cutstr_cn($v['intro'], $intronum));
		
		$v['thumb']		= $v['pic'] ;
		$v['bigpic'] 	= empty($v['pic']) ? 'static/img/nopic.jpg' : str_replace(array('_thumb'),'',$v['pic']);
		$v['pic'] 		= empty($v['pic']) ? $this->cfg['webdir'].'static/img/nopic.jpg' : $this->cfg['webdir'].$v['pic'];

		$v['comment_url'] = $this->comment_url($v['cid'], $v['id']);
	}
	public function get_golds(&$cid, &$id) {
		$mgolds = &$this->models->cms_content_golds;
		$mgolds->table = 'cms_products_golds';
		$data = $mgolds->get($id);
		if(!$data) $data = array('id'=>$id, 'cid'=>$cid, 'gold'=>0, 'golder'=>0);
		return array('gold'=>$data['gold'],'golder'=>$data['golder']);
	}

	public function list_arr($where, $orderby, $orderway, $start, $limit, $total) {
		if($start > 1000 && $total > 2000 && $start > $total/2) {
			$orderway = -$orderway;
			$newstart = $total-$start-$limit;
			if($newstart < 0) {
				$limit += $newstart;
				$newstart = 0;
			}
			$list_arr = $this->find_fetch($where, array($orderby => $orderway), $newstart, $limit);
			return array_reverse($list_arr, TRUE);
		}else{
			return $this->find_fetch($where, array($orderby => $orderway), $start, $limit);
		}
	}
	public function xdelete($table, $id, $cid) {
		$this->table = 'cms_'.$table;
		$this->cms_content_data->table = 'cms_'.$table.'_data';
		$this->cms_content_flag->table = 'cms_'.$table.'_flag';
		$this->cms_content_tag->table = 'cms_'.$table.'_tag';
		$this->cms_content_tag_data->table = 'cms_'.$table.'_tag_data';
		if($table=='products'){
			$this->cms_content_golds->table = 'cms_'.$table.'_golds';
		}
		// 内容读取
		$data = $this->read($id);
		if(empty($data)) return '内容不存在！';
		// 删除评论
		$this->cms_comment->find_delete(array('id'=>$id));
		if($table=='products'){
			// 删除faq
			$this->cms_faq->find_delete(array('pid'=>$id));
			// 删除faq_data
			$this->cms_faq_data->find_delete(array('pid'=>$id));
		}

		// 删除附件
		$attach_arr = $this->cms_attach->find_fetch(array('id'=>$id));
		$updir = PP_PATH.'upload/'.$table.'/';
		foreach($attach_arr as $v){
			$file = $updir.$v['filepath'];
			$thumb = image::thumb_name($file);
			try{
				is_file($file) && unlink($file);
				is_file($thumb) && unlink($thumb);
			}catch(Exception $e) {}
			$this->cms_attach->delete($v['aid']);
		}
		
		// 更新标签表
		if(!empty($data['tags'])) {
			$tags_arr = _json_decode($data['tags']);
			foreach($tags_arr as $tagid => $name) {
				$this->cms_content_tag_data->delete($tagid, $id);
				$tagdata = $this->cms_content_tag->read($tagid);
				$tagdata['count']--;
				if($tagdata['count'] > 0) $this->cms_content_tag->update($tagdata);
			}
		}
		// 更新分类表
		$catedata = $this->category->read($cid);
		if(empty($catedata)) return '读取分类表出错！';
		if($catedata['count'] > 0) {
			$catedata['count']--;
			$catedata['count_'.$data['status']]--;
			if(!$this->category->update($catedata)) return '写入内容表出错！';
			$this->category->update_cache($cid);
		}
		// 删除内容
		$this->cms_content_data->delete($id);
		// 删除评分
		if($table=='products'){
			$this->cms_content_golds->delete($id);
		}
		$this->cms_content_flag->find_delete(array('id'=>$id));
		$this->only_alias->delete($data['alias']);
		$ret = $this->delete($id);
		return $ret ? '' : '删除失败！';
	}
	public function tag_url(&$mid, &$name, $page = FALSE) {
		if(empty($_ENV['_config']['nzcms_parseurl'])) {
			$s = $page ? '-page-{page}' : '';
			return $this->cfg['webdir'].'index.php?tag--mid-'.$mid.'-name-'.urlencode($name).$s.$_ENV['_config']['url_suffix'];
		}else{
			return $this->cfg['webdir'].$this->cfg['link_tag_pre'].$mid.'_'.urlencode($name).($page ? '_{page}' : '').$this->cfg['link_tag_end'];
		}
	}
	public function comment_url(&$cid, &$id, $page = FALSE) {
		if(empty($_ENV['_config']['nzcms_parseurl'])) {
			$s = $page ? '-page-{page}' : '';
			return $this->cfg['webdir'].'index.php?comment--cid-'.$cid.'-id-'.$id.$s.$_ENV['_config']['url_suffix'];
		}else{
			return $this->cfg['webdir'].$this->cfg['link_comment_pre'].$cid.'_'.$id.($page ? '_{page}' : '').$this->cfg['link_comment_end'];
		}
	}
	public function index_url(&$mid) {
		if(empty($_ENV['_config']['nzcms_parseurl'])) {
			return $this->cfg['webdir'].'index.php?index-index-mid-'.$mid.'-page-{page}'.$_ENV['_config']['url_suffix'];
		}else{
			return $this->cfg['webdir'].'index_'.$mid.'_{page}'.$this->cfg['link_index_end'];
		}
	}
	public function content_url(&$cid, &$id, &$alias, &$dateline) {
		if(empty($_ENV['_config']['nzcms_parseurl'])) {
			return $this->cfg['webdir'].'index.php?show--cid-'.$cid.'-id-'.$id.$_ENV['_config']['url_suffix'];
		}else{
			switch($this->cfg['link_show_type']) {
				case 1:
					return $this->cfg['webdir'].$cid.'/'.$id.$this->cfg['link_show_end'];
				case 2:
					return $this->cfg['webdir'].$this->cfg['cate_arr'][$cid].'/'.$id.$this->cfg['link_show_end'];
				case 3:
					return $this->cfg['webdir'].($alias ? $alias : $cid.'_'.$id).$this->cfg['link_show_end'];
				default:
					return $this->cfg['webdir'].strtr($this->cfg['link_show'], array(
						'{cid}' => $cid,
						'{id}' => $id,
						'{alias}' => $alias ? $alias : $cid.'_'.$id,
						'{cate_alias}' => $this->cfg['cate_arr'][$cid],
						'{y}' => date('Y', $dateline),
						'{m}' => date('m', $dateline),
						'{d}' => date('d', $dateline)
					));
			}
		}
	}
}
