<?php
defined('PP_PATH') or exit;
class cms_content_tag extends model {
	function __construct() {
		$this->table = '';	
		$this->pri = array('tagid');	// 主键
		$this->maxid = 'tagid';			// 自增字段
	}
	// 获取标签列表
	public function list_arr($orderway, $start, $limit, $total) {
		if($start > 1000 && $total > 2000 && $start > $total/2) {
			$orderway = -$orderway;
			$newstart = $total-$start-$limit;
			if($newstart < 0) {
				$limit += $newstart;
				$newstart = 0;
			}
			$list_arr = $this->find_fetch(array(), array('count' => $orderway), $newstart, $limit);
			return array_reverse($list_arr, TRUE);
		}else{
			return $this->find_fetch(array(), array('count' => $orderway), $start, $limit);
		}
	}
	public function xdelete($table, $tagid) {
		$this->table = 'cms_'.$table.'_tag';
		$this->cms_content->table = 'cms_'.$table;
		$this->cms_content_tag_data->table = 'cms_'.$table.'_tag_data';
		try{
			$list_arr = $this->cms_content_tag_data->find_fetch(array('tagid'=>$tagid));
			foreach($list_arr as $v) {
				$data = $this->cms_content->read($v['id']);
				if(empty($data)) return '读取内容表出错！';
				$row = _json_decode($data['tags']);
				unset($row[$tagid]);
				$data['tags'] = _json_encode($row);
				if(!$this->cms_content->update($data)) return '写入内容表出错！';
			}
		}catch(Exception $e) {
			return '修改内容表出错！';
		}
		try{
			$this->cms_content_tag_data->find_delete(array('tagid'=>$tagid));
		}catch(Exception $e) {
			return '删除标签数据表出错！';
		}
		return $this->delete($tagid) ? '' : '删除失败！';
	}
}
