<?php
defined('PP_PATH') or exit;
class category extends model {
	private $data = array();
	function __construct() {
		$this->table = 'category';	// 表名
		$this->pri = array('cid');	// 主键
		$this->maxid = 'cid';		// 自增字段
	}
	// 暂时用些方法解决获取 cfg 值
	function __get($var) {
		if($var == 'cfg') {
			return $this->cfg = $this->runtime->xget();
		}else{
			return parent::__get($var);
		}
	}
	// 检查基本参数是否填写
	public function check_base(&$post) {
		if(empty($post['mid'])) {
			$name = 'mid';
			$msg = '请选择分类模型';
		}elseif(!isset($post['type'])) {
			$name = 'type';
			$msg = '请选择分类属性';
		}elseif(!isset($post['upid'])) {
			$name = 'upid';
			$msg = '请选择所属频道';
		}elseif(strlen($post['name']) < 1) {
			$name = 'name';
			$msg = '请填写分类名称';
		}elseif(strlen($post['alias']) < 1) {
			$name = 'alias';
			$msg = '请填写分类别名';
		}elseif(strlen($post['alias']) > 50) {
			$name = 'alias';
			$msg = '分类别名不能超过50个字符';
		}elseif(empty($post['cate_tpl'])) {
			$name = 'cate_tpl';
			$msg = '请填写分类页模板';
		}elseif($post['mid'] > 1 && empty($post['show_tpl'])) {
			$name = 'show_tpl';
			$msg = '请填写内容页模板';
		}
		return empty($msg) ? FALSE : array('name' => $name, 'msg' => $msg);
	}
	public function check_alias($alias) {
		$msg = $this->only_alias->check_alias($alias);
		return empty($msg) ? FALSE : array('name' => 'alias', 'msg' => $msg);
	}
	public function check_is_edit($post, $data) {
		if($post['cid'] == $post['upid']) {
			$name = 'upid';
			$msg = '所属频道不能修改为自己';
		}elseif($data['count'] > 0 && $post['mid'] != $data['mid']) {
			$name = 'mid';
			$msg = '分类中有内容，不允许修改分类模型，请先清空分类内容';
		}elseif($data['count'] > 0 && $post['type'] != $data['type']) {
			$name = 'type';
			$msg = '分类中有内容，不允许修改分类属性，请先清空分类内容';
		}elseif($data['type'] == 1 && $post['mid'] != $data['mid'] && $this->check_is_son($data['cid'])) {
			$name = 'mid';
			$msg = '分类有下级分类，不允许修改分类模型';
		}elseif($data['type'] == 1 && $post['type'] != $data['type'] && $this->check_is_son($data['cid'])) {
			$name = 'type';
			$msg = '分类有下级分类，不允许修改分类类型';
		}
		return empty($msg) ? FALSE : array('name' => $name, 'msg' => $msg);
	}
	public function check_is_del($data) {
		if($data['type'] == 1 && $this->check_is_son($data['cid'])) {
			return '分类有下级分类，请先删除下级分类';
		}elseif($data['count'] > 0) {
			return '分类中有内容，请先删除内容';
		}
		return FALSE;
	}
	public function check_is_son($upid) {
		return $this->find_fetch_key(array('upid' => $upid), array(), 0, 1) ? TRUE : FALSE;
	}
	public function get_category_db() {
		if(isset($this->data['category_db'])) {
			return $this->data['category_db'];
		}
		$arr = array();
		$tmp = $this->find_fetch(array(), array('orderby'=>-1,'cid'=>-1));
		foreach($tmp as $v) {
			$arr[$v['cid']] = $v;
		}
		return $this->data['category_db'] = $arr;
	}
	public function get_category_tree() {
		if(isset($this->data['category_tree'])) {
			return $this->data['category_tree'];
		}
		$this->data['category_tree'] = array();
		$tmp = $this->get_category_db();
		foreach($tmp as $v) {
			$tmp[$v['upid']]['son'][$v['cid']] = &$tmp[$v['cid']];
		}
		$this->data['category_tree'] = isset($tmp['0']['son']) ? $tmp['0']['son'] : array();
		return $this->data['category_tree'];
	}
	public function get_category() {
		if(isset($this->data['category_array'])) {
			return $this->data['category_array'];
		}
		$arr = $this->get_category_tree();
		return $this->data['category_array'] = $this->to_array($arr);
	}
	public function to_array($data, $pre = 1) {
		static $arr = array();
		foreach($data as $k => $v) {
			$v['pre'] = $pre;
			if(isset($v['son'])) {
				$arr[$v['mid']][] = $v;
				self::to_array($v['son'], $pre+1);
			}else{
				$arr[$v['mid']][] = $v;
			}
		}
		return $arr;
	}
	public function get_cids_by_mid($mid) {
		$k = 'cate_by_mid_'.$mid;
		if(isset($this->data[$k])) return $this->data[$k];
		$arr = $this->runtime->xget($k);
		if(empty($arr)) {
			$arr = $this->get_cids_by_upid(0, $mid);
			$this->runtime->set($k, $arr);
		}
		$this->data[$k] = $arr;
		return $arr;
	}
	public function get_cids_by_upid($upid, $mid) {
		$arr = array();
		$tmp = $this->get_category_db();
		if($upid != 0 && !isset($tmp[$upid])) return FALSE;
		foreach($tmp as $k => $v) {
			if($v['mid'] == $mid) {
				$tmp[$v['upid']]['son'][$v['cid']] = &$tmp[$v['cid']];
			}else{
				unset($tmp[$k]);
			}
		}
		if(isset($tmp[$upid]['son'])) {
			foreach($tmp[$upid]['son'] as $k => $v) {
				if($v['type'] == 1) {
					$arr[$k] = isset($v['son']) ? self::recursion_cid($v['son']) : array();
				}elseif($v['type'] == 0) {
					$arr[$k] = 1;
				}
			}
		}
		return $arr;
	}
	public function get_smallcats($upid, $mid) {//
		$arr = array();
		$tmp = $this->get_category_db();
		if($upid != 0 && !isset($tmp[$upid])) return FALSE;
		foreach($tmp as $k => $v) {
			if($v['mid'] == $mid) {
				$tmp[$v['upid']]['son'][$v['cid']] = &$tmp[$v['cid']];
			}else{
				unset($tmp[$k]);
			}
		}
		if(isset($tmp[$upid]['son'])) {
			foreach($tmp[$upid]['son'] as $k => $v) {
				if($v['type'] == 1) {
					$arr[$k] = isset($v['son']) ? self::recursion_cid($v['son']) : array();
				}elseif($v['type'] == 0) {
					$arr[$k] = 1;
				}
			}
		}
		return $arr;
	}
	public function recursion_cid(&$data) {
		$arr = array();
		foreach($data as $k => $v) {
			if(isset($v['son'])) {
				$arr2 = self::recursion_cid($v['son']);
				$arr = array_merge($arr, $arr2);
			}else{
				if($v['type'] == 0) {
					$arr[] = intval($v['cid']);
				}
			}
		}
		return $arr;
	}
	public function get_cidhtml_by_mid($_mid, $cid, $tips = '选择分类') {
		$category_arr = $this->get_category();
		$s = '<select name="cid" id="cid" class="form-control">';
		if(empty($category_arr)) {
			$s .= '<option value="">没有分类</option>';
		}else{
			$s .= '<option value="">'.$tips.'</option>';
			foreach($category_arr as $mid => $arr) {
				if($mid != $_mid) continue;
				foreach($arr as $v) {
					$disabled = $v['type'] == 1 ? ' disabled="disabled"' : '';
					$s .= '<option value="'.$v['cid'].'"'.($v['type'] == 0 && $v['cid'] == $cid ? ' selected="selected"' : '').$disabled.'>';
					$s .= str_repeat("　", $v['pre']-1);
					$s .= '|─'.$v['name'].($v['type'] == 1 ? '[频道]' : '').'</option>';
				}
			}
		}
		$s .= '</select>';
		return $s;
	}
	public function get_category_upid($mid, $upid = 0, $noid = 0) {
		$category_arr = $this->get_category();
		$s = '<option value="0">无</option>';
		if(isset($category_arr[$mid])) {
			foreach($category_arr[$mid] as $v) {
				if($mid> 1 && $v['type'] == 0) continue;
				if($noid) {
					if(isset($pre)) {
						if($v['pre'] > $pre) continue;
						else unset($pre);
					}
					if($v['cid'] == $noid) {
						$pre = $v['pre'];
						continue;
					}
				}
				$s .= '<option value="'.$v['cid'].'"'.($v['cid'] == $upid ? ' selected="selected"' : '').'>';
				$s .= str_repeat("　", $v['pre']-1);
				$s .= '|─'.$v['name'].'</option>';
			}
		}
		return $s;
	}
	public function get_smallid_upid($mid, $upid = 0) {//子分类
		$category_arr = $this->get_category();
		$s = array();
		if(isset($category_arr[$mid])) {
			foreach($category_arr[$mid] as $c => $v) {
				if($v['type'] != 0 || $v['cid'] == $upid) continue;
				$s[$c]['cid'] = $v['cid'];
				$s[$c]['name'] = $v['name'];
			}
		}
		return $s;
	}
	public function get_mid_by_cid($cid) {
		if($cid) {
			$arr = $this->read($cid);
		}else{
			$arr = $this->get_category();
			if(empty($arr)) return 2;
			$arr = current($arr);
			$arr = current($arr);
		}
		return $arr['mid'];
	}
	public function get_place($cid) {
		$p = array();
		$tmp = $this->get_category_db();
		while(isset($tmp[$cid]) && $v = &$tmp[$cid]) {
			array_unshift($p, array(
				'cid'=> $v['cid'],
				'name'=> $v['name'],
				'url'=> $this->category_url($v['cid'], $v['alias'])
			));
			$cid = $v['upid'];
		}
		return $p;
	}
	public function get_cache($cid) {
		$k = 'cate_'.$cid;
		if(isset($this->data[$k])) return $this->data[$k];
		$arr = $this->runtime->xget($k);
		if(empty($arr)) {
			$arr = $this->update_cache($cid);
		}
		$this->data[$k] = $arr;
		return $arr;
	}
	public function update_cache($cid) {
		$k = 'cate_'.$cid;
		$arr = $this->read($cid);
		if(empty($arr)) return FALSE;
		$arr['place'] = $this->get_place($cid);	// 分类当前位置
		$arr['topcid'] = $arr['place'][0]['cid'];	// 顶级分类CID
		$arr['table'] = $this->cfg['table_arr'][$arr['mid']];	// 分类模型表名
		if($arr['type'] == 1) {
			$arr['son_list'] = $this->get_cids_by_upid($cid, $arr['mid']);
			$arr['son_cids'] = array();
			if(!empty($arr['son_list'])) {
				foreach($arr['son_list'] as $c => $v) {
					if(is_array($v)) {
						$v && $arr['son_cids'] = array_merge($arr['son_cids'], $v);
					}else{
						$arr['son_cids'][] = $c;
					}
				}
			}
		}
		$this->runtime->set($k, $arr);
		return $arr;
	}
	public function delete_cache() {
		$key_arr = $this->runtime->find_fetch_key(array(), array(), 0, 2000);
		foreach ($key_arr as $v) {
			if(substr($v, 10, 5) == 'cate_') {
				$this->runtime->delete(substr($v, 10));
			}
		}
		return TRUE;
	}
	public function category_url(&$cid, &$alias, $page = FALSE) {
		if(empty($_ENV['_config']['nzcms_parseurl'])) {
			return $this->cfg['webdir'].'index.php?cate--cid-'.$cid.($page ? '-page-{page}' : '').$_ENV['_config']['url_suffix'];
		}else{
			if($page) {
				return $this->cfg['webdir'].$alias.$this->cfg['link_cate_page_pre'].'{page}'.$this->cfg['link_cate_page_end'];
			}else{
				return $this->cfg['webdir'].$alias.$this->cfg['link_cate_end'];
			}
		}
	}
}