<?php

namespace app\admin\controller;

use app\common\controller\Admin;
use app\common\model\Groups;
use app\common\model\Setting as SettingModel;
use think\facade\Cache;

class Setting extends Admin
{


    public function basic(){
        $this->saveOptions();
        $this->assign('option',$this->getOptions());
        return $this->fetch();
    }


    public function register(){
        $this->saveOptions();
        $group = Groups::field('id,group_name')->select()->toArray();
        $this->assign('group',$group);
        $this->assign('option',$this->getOptions());
        return $this->fetch();
    }

    public function pay(){
        $this->saveOptions();
        $this->assign('option',$this->getOptions());
        return $this->fetch();
    }

    public function vip(){
        $this->saveOptions();
        $group = Groups::field('id,group_name')->select()->toArray();
        $this->assign('group',$group);
        $this->assign('option',$this->getOptions());
        return $this->fetch();
    }

    public function email(){
        $this->saveOptions();
        $this->assign('option',$this->getOptions());
        return $this->fetch();
    }

    protected function saveOptions(){
        if($this->request->isPost()){
            $type = $this->request->action();
            $post = input('post.');

            try {
                // 更新数据库
                foreach ($post as $key => $item){
                    if(SettingModel::where('set_name',$key)->where('set_type',$type)->count() > 0){
                        SettingModel::where('set_name',$key)->where('set_type',$type)->update(['set_value' => $item]);
                    }else{
                        throw new Exception('当前安全邮箱已被绑定');
                       // SettingModel::where('set_name',$key)->where('set_type',$type)->update(['set_value' => $item]);
                    }
                }
            }catch (\Throwable $e){
                $this->returnError($e->getMessage());
            }

            // 更新缓存
            $setting = SettingModel::select()->toArray();
            Cache::set('_setting_config',$setting);

            $this->returnSuccess('保存成功');
        }
    }

    protected function getOptions(): array
    {
        $type = $this->request->action();
        $settings = SettingModel::where('set_type',$type)->select();
        $options = [];
        foreach ($settings as $item){
            $options[$item['set_name']] = $item['set_value'];
        }
        return $options;
    }

}