<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2016 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 流年 <liu21st@gmail.com>
// +----------------------------------------------------------------------

use app\common\model\driver\AliyunOss;
use app\common\model\driver\Local;
use app\common\model\driver\TxyunOss;
 
// 应用公共文件
	function ismobile() {
        if (isset ($_SERVER['HTTP_X_WAP_PROFILE'])) {
            // 如果有HTTP_X_WAP_PROFILE则一定是移动设备
            return true;
        } elseif (isset ($_SERVER['HTTP_USER_AGENT'])) {
            // 判断手机发送的客户端标志,兼容性有待提高
            $clientkeywords = array('nokia','sony','ericsson','mot','samsung','htc','sgh','lg','sharp','sie-','philips','panasonic','alcatel','lenovo','iphone','ipod','blackberry','meizu','android','netfront','symbian','ucweb','windowsce','palm','operamini','operamobi','openwave','nexusone','cldc','midp','wap','mobile');
            // 从HTTP_USER_AGENT中查找手机浏览器的关键字
            if (preg_match("/(" . implode('|', $clientkeywords) . ")/i", strtolower($_SERVER['HTTP_USER_AGENT']))){
                return true;
            }
        }
        // 协议法，因为有可能不准确，放到最后判断
        if (isset ($_SERVER['HTTP_ACCEPT'])) {
            // 如果只支持wml并且不支持html那一定是移动设备
            // 如果支持wml和html但是wml在html之前则是移动设备
            if ((strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') !== false) && (strpos($_SERVER['HTTP_ACCEPT'], 'text/html') === false || (strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') < strpos($_SERVER['HTTP_ACCEPT'], 'text/html')))){
                return true;
            }
        }
		return false;
    }





function getNotNullTime($time, $default = '', $format = 'Y-m-d H:i:s'){
    if($time > 0){
        return date($format,$time);
    }else{
        return $default;
    }
}

function countSize($bit,$array=false){
    $type = ['B','KB','MB','GB','TB'];
    $box = ['1','1024','1048576','1073741824','TB'];
    for($i = 0; $bit >= 1024; $i++) {
        $bit/=1024;
    }
    if($array){
        return [(floor($bit*100)/100),$box[$i]];
    }
    return (floor($bit*100)/100).$type[$i];
}

function PolicyType($d): string
{
    $type = [
        'local' => '本地',
        'remote' => '远程',
        'aliyunoss' => '阿里云OSS',
        'txyunoss' => '腾讯云COS'
    ];

    return $type[$d] ?? '未知';
}

function getphotoRemote($file_path,$origin_name,$hosts,$speed,$token){
    if($speed === ""){
        $speed = 'full';
    }
    if($speed === 0){
        $speed = 'none';
    }
    $params = [
        'file' => $file_path,
        'origin' => $origin_name,
        'speed' => $speed,
        'time' => time()
    ];
    $post = [
        'md' => 'photo',
        'tk' => urlsafe_b64encode(implode(',',$params))
    ];
    $post['sign'] = getRemoteSign($post,$token);
    return $hosts .'?' . urldecode(http_build_query($post));
}


function getFilepic($files,$type = 'admin'): string{
	$stores = \app\common\model\Stores::get($files);
	$policy = $stores->getPolicy();
 
 
            // 远程文件下载
            if($policy->type == 'remote'){
				$filename = 'remote_'.$stores['id'].pathinfo($stores['file_name'], PATHINFO_BASENAME);
				
				$save_to=env('root_path').'public/thumb/'.$filename; 
			//	if(!file_exists($save_to)){
					if(isset($policy->config['download_uri']) && !empty($policy->config['download_uri'])){
						$down_url = getphotoRemote($stores['file_name'],$stores['origin_name'],$policy->config['download_uri'],'',$policy->config['access_token']);
					}else{
						$down_url = getphotoRemote($stores['file_name'],$stores['origin_name'],$policy->config['server_uri'],'',$policy->config['access_token']);
					}
					#return 'http://'.dr_catcher_data($down_url);
					return downloads('http://'.dr_catcher_data($down_url), $filename);
			//	}else{
					return '/thumb/'.$filename; 
			//	}
            }


            // 存储驱动下载

            switch ($policy->type){
                case 'aliyunoss':
                    $driver = new AliyunOss(0,0,0);break;
                case 'txyunoss':
                    $driver = new TxyunOss(0,0,0);break;
                default:
                    $driver = new Local(0,0,0);break;
            }
	return $driver->photo($stores,'',$policy);
	#return  $policy->type;
}	
	
function getFileIcon($file_ext,$type = 'admin'): string
{
    $file_types = [
        'video' => ['mp4','avi','mov','rmvb','rm','asf','divx','mpg','mpeg','mpe','wmv','mp4','mkv','vob','swf','flv'],
        'music' => ['cd','mp3','flac','ape','wma','mid','midi','mmf','ncm','wav','dts','dsf'],
        'code' => ['c','php','py','py3','cpp','h','jar','html','hta','chm','css','js','htm','asp','aspx','jsp','dll','cs','go','sql','xml','vb','java','lib','e','ec','db','bat','vbs','cmd','json','vbe','ocx','conf','sh','dat'],
        'zip' => ['zip','tar','gz','rar','7z','arj','z','iso','gho'],
        'ps' => ['ps','psd','pdd','eps','iff','tdi','pcx','raw'],
        'img' => ['png','bmp','rle','dib','gif','ico','jpeg','jpe','jff','jps','jpg','psb','svg','pbm','mp0'],
        'fonts' => ['ttf','eot','woff','otf','woff2'],
        'text' => ['txt','md','rtf','ini'],
        'word' => ['doc','docx','docm'],
        'excel' => ['xls','xlsx','xlsm'],
        'ppt' => ['ppt','pptx','pdf','pdp'],
        'links' => ['url','lnk'],
        'exe' => ['exe','msi'],
        'ipa' => ['ipa'],
        'apk' => ['apk']
    ];

    $file_mime = 'unknown';

    if($file_ext == 'dir'){
        $file_mime = 'folder';
    }else{
        foreach ($file_types as $mime_name => $item){
            foreach ($item as $ext){
                if($ext == $file_ext){
                    $file_mime = $mime_name;
                    break;
                }
            }
        }
    }

    if($type == 'admin'){
        return '/static/admin/images/file_ext/'.$file_mime.'.png';
    }else{
        return '/assets/files_ext/'.$file_mime.'.png';
    }
}

function getUserHead($user_head): string
{
    if(empty($user_head)){
        return '/assets/image/userhead.png';
    }

    return $user_head;
}

function getVipRule(){
    $vip_rule = config('vip.vip_rule');

    $rule_list = explode('<br />',nl2br($vip_rule));

    foreach ($rule_list as $key => $item){
        $keys = ['name', 'money', 'day','day_name', 'discount', 'discount_msg', 'desc','is_top'];
        $rule = array_combine($keys,explode('|',trim($item)));
        $rule['id'] = $key;
        $rule_list[$key] = $rule;
    }

    return $rule_list;
}

function shortUrl($url){

    $hex = md5($url);
    $base32 = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $hexLen = strlen($hex);
    $subHexLen = $hexLen / 8;
    $output = [];
    for( $i = 0; $i < $subHexLen; $i++ ) {
        $subHex = substr($hex, $i*8, 8);
        $idx = 0x3FFFFFFF & (1 * hexdec('0x' . $subHex));
        $out = '';
        for( $j = 0; $j < 6; $j++ )
        {
            $out .= $base32[0x0000003D & $idx];
            $idx = $idx >> 5;
        }
        $output[$i] = $out;
    }

    $code = array_shift($output);

    $suc = substr(microtime(),2,4);

    foreach (str_split($suc,1) as $k){
        $code .= substr(str_shuffle($base32),$k,1);
    }

    return $code;
}

function getRndSharePwd($len = 4){
    $string = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $result = '';
    for ($i = 0;$i < $len;$i++){
        $result .= substr(str_shuffle($string),rand(0,strlen($string) - 1),1);
    }
    return $result;
}

function getShareUrl($code): string
{
    return url('index/share',['code' => $code],true,true);
}

function friendDate($time, $format='Y-m-d'){
    if (!$time)
        return '';

    $nowtime = time();
    if ($time > $nowtime){
        return date($format, $time);
    }

    $Y = date('Y', $time);//年份
    $z = date('z', $time);//当前的第几天
    $nowY = date('Y', $nowtime);
    $nowz = date('z', $nowtime);

    if ($z > $nowz){
        $nowz += 365;
    }
    $diffz = $nowz - $z;//获取差异天
    $diffs = $nowtime - $time;//获取差异秒

    if ($diffz >= 365){
        return ($nowY-$Y).'年前';
    } elseif ($diffz >= 30){
        return floor($diffz / 30).'个月前';
    } elseif ($diffz >= 7){
        return floor($diffz / 7).'个星期前';
    } elseif ($diffz >= 1){
        return $diffz.'天前';
    } elseif ($diffs >= 3600) {
        return floor($diffs / 3600).'小时前';
    } elseif ($diffs >= 300) {
        return floor($diffs / 60).'分钟前';
    } else {//五分钟内
        return '刚刚';
    }
}

function getSafeNickname($name): string
{
    if(mb_strlen($name) <= 2){
        $name = mb_substr($name,0,1) . '*';
    }else{
        $len = mb_strlen($name);
        $sub_len = $len - 2;
        $name = mb_substr($name,0,1) . '*' . str_repeat('*',$sub_len) .  mb_substr($name,$len - 1,1);
    }
    return $name;
}

function getSafeDirSeparator($dir){
    return str_replace(['/','\\','//','\\\\'],DIRECTORY_SEPARATOR,$dir);
}

function getDiyDirSeparator($spr,$dir){
    return str_replace(['/','\\','//','\\\\'],$spr,$dir);
}

 
	
function sendEmail($username,$email,$url){
    // 邮件配置
    $config = config('email.');

    // 获取模板变量
    $temp_var = [
        '{username}' => $username,
        '{site_title}' => config('basic.site_title'),
        '{url}' => $url
    ];

    // 邮件正文
    $email_body = str_replace(array_keys($temp_var),array_values($temp_var),$config['template_forget']);

    // php mail客户端
    $mail = new PHPMailer\PHPMailer\PHPMailer();
    // debug调试
    $mail->SMTPDebug = 0;
    //  使用smtp鉴权方式
    $mail->isSMTP();
    // SMTP鉴权
    $mail->SMTPAuth = true;
    // 邮箱服务器地址
    $mail->Host = $config['smtp_host'];
    // SSL加密
    $mail->SMTPSecure = 'ssl';
    // 端口
    $mail->Port = $config['smtp_port'];
    // 邮件的编码
    $mail->CharSet = 'UTF-8';
    // smtp账号
    $mail->Username = $config['username'];
    // smtp密码
    $mail->Password = $config['password'];
    // 设置发件人昵称
    $mail->FromName = $config['nickname'];
    // 设置发件人邮箱
    $mail->From = $config['username'];
    // 邮件正文为html编码
    $mail->isHTML(true);
    // 收件人邮箱
    $mail->addAddress($email);
    // 邮件标题
    $mail->Subject = '【'.config('basic.site_title').'】找回密码邮件';

    // 邮件正文
    $mail->Body = $email_body;

    // 发送邮件 返回状态
    return $mail->send();
}

function getFileDownloadUrl($shares_id,$file_id,$is_count = 1){

    $params = [
        'file' => $file_id,
        'shares' => $shares_id,
        'timestamp' => time(),
    ];

    $sign = md5(urldecode(http_build_query($params)) . config('app.pass_salt'));

    $params['sign'] = $sign;
    $params['is_count'] = $is_count;

    return url('Index/download','',false,true).'?'.urldecode(http_build_query($params));
}

function getDownloadFileSignVerify($param,$sign): bool
{
    $sign_key = md5(urldecode(http_build_query($param)) . config('app.pass_salt'));
    return $sign_key == $sign;
}

function getFileName($field_id){
    return \app\common\model\Stores::withTrashed()->where('id',$field_id)->value('origin_name');
}

function getWeekDay($time){
    $week = ["日","一","二","三","四","五","六"];
    return '星期'.$week[date('w',$time)];
}

function getTimeLastDay($time){
    $now_time = strtotime(date('Y-m-d'));
    $the_time = strtotime(date('Y-m-d',$time));
    $day_lazy = $now_time - $the_time;
    return floor($day_lazy / 86400);
}

function getDownloadRemote($file_path,$origin_name,$hosts,$speed,$token){
    if($speed === ""){
        $speed = 'full';
    }
    if($speed === 0){
        $speed = 'none';
    }
    $params = [
        'file' => $file_path,
        'origin' => $origin_name,
        'speed' => $speed,
        'time' => time()
    ];
    $post = [
        'md' => 'download',
        'tk' => urlsafe_b64encode(implode(',',$params))
    ];
    $post['sign'] = getRemoteSign($post,$token);
    return $hosts .'?' . urldecode(http_build_query($post));
}

function urlsafe_b64encode($string) {
    $data = base64_encode($string);
    $data = str_replace(['+','/','='],['-','_',''],$data);
    return $data;
}

function getRemoteSign($params,$key): string
{
    // 过滤参数
    $params = array_filter($params,function($key) use ($params){
        if(empty($params[$key]) || $key == 'sign'){
            return false;
        }
        return true;
    },ARRAY_FILTER_USE_KEY);
    // ascii排序
    ksort($params);
    reset($params);

    // 签名
    return md5(urldecode(http_build_query($params)) . $key);
}

function Recursion($data, $pid = 0)
{
    static $child = [];

    foreach ($data as $key => $value) {
        if ($value['pid'] == $pid) {
            $child[] = $value;
            unset($data[$key]);
            Recursion($data, $value['id']);
        }
    }

    return $child;
}

function getFolderChildFiles($uid,$folder_id){
    // 获取目录列表
    $folder_list = db('folders')
        ->where('uid',$uid)
        ->field('id,parent_folder as pid')
        ->select();

    $folder = Recursion($folder_list,$folder_id);

    $folder_ids = array_column($folder,'id');

    $files = db('stores')->where('uid',$uid)
        ->where('parent_folder','in',$folder_ids)
        ->field('id')
        ->select();

    $files_ids = array_column($files,'id');

    return [
        'folder' => $folder_ids,
        'file' => $files_ids
    ];
}


/**
 * 调用远程数据
 *
 * @param	string	$url
 * @return	string
 */
function dr_catcher_data($url) {

	// fopen模式
	if ( ini_get( 'allow_url_fopen' ) ) {
		$data = @file_get_contents( $url );
		if ( $data !== FALSE ) {
			if ( preg_match( '/^\xEF\xBB\xBF/', $data ) ) {
				$data = substr( $data, 3 );
			}
			return $data;
		}
	}
	// curl模式
	if ( function_exists( 'curl_init' ) && function_exists( 'curl_exec' ) ) {
		$ch = curl_init( $url );
		$data = '';
		curl_setopt( $ch, CURLOPT_HEADER, 0 );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
		$data = curl_exec( $ch );
		curl_close( $ch );
		if ( preg_match( '/^\xEF\xBB\xBF/', $data ) ) {
			$data = substr( $data, 3 );
		}
		return $data;
	}

	return NULL;
}
// 从url获取json数据
function wx_get_https_json_data($url) {
    $response = @file_get_contents($url);
    if (!$response) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // 跳过证书检查
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, true); // 从证书中检查SSL加密算法是否存在
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $response = curl_exec($ch);
        if ($error=curl_error($ch)){
            return dr_return_data(0, $error);
        }
        curl_close($ch);
    }

    return $response;
}
/**
 * 将对象转换为数组
 *
 * @param	object	$obj	数组对象
 * @return	array
 */
function dr_object2array($obj) {
    $_arr = is_object($obj) ? get_object_vars($obj) : $obj;
    if ($_arr && is_array($_arr)) {
        foreach ($_arr as $key => $val) {
            $val = (is_array($val) || is_object($val)) ? dr_object2array($val) : $val;
            $arr[$key] = $val;
        }
    }
    return $arr;
}
function dr_xml2array($xml){      
   //将XML转为array       
   $array_data = json_decode(json_encode(simplexml_load_string($xml, 'SimpleXMLElement', LIBXML_NOCDATA)), true);      
    return $array_data;
}
 
/**
     * 发送HTTP请求方法
     * @param  string $url    请求URL
     * @param  array  $params 请求参数
     * @param  string $method 请求方法GET/POST
     * @return array  $data   响应数据
     */
    function drhttp($url, $params=""){
        
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);  //curl可以直接
        //curl_setopt($curl, CURLOPT_HEADER, 1);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl,CURLOPT_HTTPHEADER,array("Content-type: application/json;charset='utf-8'")); //设置响应头
        if ($params) {
            curl_setopt($curl,CURLOPT_POST,1);
            $data = json_encode($params);
            curl_setopt($curl,CURLOPT_POSTFIELDS,$data);
        }
        $data = curl_exec($curl);
        curl_close($curl);
		$data = json_decode($data, true);
        //if($error) throw new Exception('请求发生错误：' . $error);
        return  $data;
    }







		/**
		* @param    string      $string 加密内容
		* @param    string      $operation 加密动作
		* @param    string      $key 私钥
		* @param    int         $expiry 有效时间秒
		* @return   string      加密串
		*/
		function uc_authcode($string, $operation = 'DECODE', $key = '', $expiry = 0){
			$ckey_length = 4;
			$key = md5($key);
			$keya = md5(substr($key, 0, 16));
			$keyb = md5(substr($key, 16, 16));
			if ($operation == 'DECODE'){
				$string = str_replace(array('-', '_'), array('+', '/'), $string);
			}else{
				$string = urlencode($string);
			}
			
			$keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : '';
			$cryptkey = $keya.md5($keya.$keyc);
			$key_length = strlen($cryptkey);
			$string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0).substr(md5($string.$keyb), 0, 16).$string;
			$string_length = strlen($string);
			$result = '';
			$box = range(0, 255);
			$rndkey = array();
			for($i = 0; $i <= 255; $i++)
			{
				$rndkey[$i] = ord($cryptkey[$i % $key_length]);
			}
			for($j = $i = 0; $i < 256; $i++)
			{
				$j = ($j + $box[$i] + $rndkey[$i]) % 256;
				$tmp = $box[$i];
				$box[$i] = $box[$j];
				$box[$j] = $tmp;
			}
			for($a = $j = $i = 0; $i < $string_length; $i++)
			{
				$a = ($a + 1) % 256;
				$j = ($j + $box[$a]) % 256;
				$tmp = $box[$a];
				$box[$a] = $box[$j];
				$box[$j] = $tmp;
				$result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
			}
			if($operation == 'DECODE')
			{
				if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)){
					return urldecode(substr($result, 26));
				}else{
					return '';
				}
			}else{
				#return $keyc.str_replace('=', '', base64_encode($result));
				$data = $keyc . str_replace('=', '', base64_encode($result));
				return str_replace(array('+', '/', '='), array('-', '_', ''), $data);
			}
		}
















/*==================================================================
** 支付宝函数
**==================================================================
*/


/**
 * 生成签名结果
 * @param $sort_para 要签名的数组
 * @param $key 支付宝交易安全校验码
 * @param $sign_type 签名类型 默认值：MD5
 * return 签名结果字符串
 */
function buildMysign($sort_para,$key,$sign_type = "MD5") {
	//把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
	$prestr = createLinkstring($sort_para);
	//把拼接后的字符串再与安全校验码直接连接起来
	$prestr = $prestr.$key;
	//把最终的字符串签名，获得签名结果
	$mysgin = sign($prestr,$sign_type);
	return $mysgin;
}





/**
 * 把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
 * @param $para 需要拼接的数组
 * return 拼接完成以后的字符串
 */
function createLinkstring($para) {
	$arg  = "";
	while (list ($key, $val) = each ($para)) {
		$arg.=$key."=".$val."&";
	}
	//去掉最后一个&字符
	$arg = substr($arg,0,count($arg)-2);
	
	//如果存在转义字符，那么去掉转义
	if(get_magic_quotes_gpc()){$arg = stripslashes($arg);}
	
	return $arg;
}
/**
 * 把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串，并对字符串做urlencode编码
 * @param $para 需要拼接的数组
 * return 拼接完成以后的字符串
 */
function createLinkstringUrlencode($para) {
	$arg  = "";
	while (list ($key, $val) = each ($para)) {
		$arg.=$key."=".urlencode($val)."&";
	}
	//去掉最后一个&字符
	$arg = substr($arg,0,count($arg)-2);
	
	//如果存在转义字符，那么去掉转义
	if(get_magic_quotes_gpc()){$arg = stripslashes($arg);}
	
	return $arg;
}
/**
 * 除去数组中的空值和签名参数
 * @param $para 签名参数组
 * return 去掉空值与签名参数后的新签名参数组
 */
function paraFilter($para) {
	$para_filter = array();
 
	while (list ($key, $val) = each ($para)) {
		if($key == "sign" || $key == "sign_type" || $val == "")continue;
		else	$para_filter[$key] = $para[$key];
	}
	return $para_filter;
}
/**
 * 对数组排序
 * @param $para 排序前的数组
 * return 排序后的数组
 */
function argSort($para) {
	ksort($para);
	reset($para);
	return $para;
}
/**
 * 签名字符串
 * @param $prestr 需要签名的字符串
 * @param $sign_type 签名类型 默认值：MD5
 * return 签名结果
 */
function sign($prestr,$sign_type='MD5') {
	$sign='';
	if($sign_type == 'MD5') {
		$sign = md5($prestr);
	}elseif($sign_type =='DSA') {
		//DSA 签名方法待后续开发
		die("DSA 签名方法待后续开发，请先使用MD5签名方式");
	}else {
		die("支付宝暂不支持".$sign_type."类型的签名方式");
	}
	return $sign;
}
/**
 * 写日志，方便测试（看网站需求，也可以改成把记录存入数据库）
 * 注意：服务器需要开通fopen配置
 * @param $word 要写入日志里的文本内容 默认值：空值
 */
function logResult($word='') {
	$fp = fopen("log.txt","a");
	flock($fp, LOCK_EX) ;
	fwrite($fp,"执行日期：".strftime("%Y%m%d%H%M%S",time())."\n".$word."\n");
	flock($fp, LOCK_UN);
	fclose($fp);
}

/**
 * 远程获取数据，POST模式
 * 注意：
 * 1.使用Crul需要修改服务器中php.ini文件的设置，找到php_curl.dll去掉前面的";"就行了
 * 2.文件夹中cacert.pem是SSL证书请保证其路径有效，目前默认路径是：getcwd().'\\cacert.pem'
 * @param $url 指定URL完整路径地址
 * @param $cacert_url 指定当前工作目录绝对路径
 * @param $para 请求的数据
 * @param $input_charset 编码格式。默认值：空值
 * return 远程输出的数据
 */
function getHttpResponsePOST($url, $cacert_url, $para, $input_charset = '') {

	if (trim($input_charset) != '') {
		$url = $url."_input_charset=".$input_charset;
	}
	$curl = curl_init($url);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);//SSL证书认证
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);//严格认证
	curl_setopt($curl, CURLOPT_CAINFO,$cacert_url);//证书地址
	curl_setopt($curl, CURLOPT_HEADER, 0 ); // 过滤HTTP头
	curl_setopt($curl,CURLOPT_RETURNTRANSFER, 1);// 显示输出结果
	curl_setopt($curl,CURLOPT_POST,true); // post传输数据
	curl_setopt($curl,CURLOPT_POSTFIELDS,$para);// post传输数据
	$responseText = curl_exec($curl);
	//var_dump( curl_error($curl) );//如果执行curl过程中出现异常，可打开此开关，以便查看异常内容
	curl_close($curl);
	
	return $responseText;
}

/**
 * 远程获取数据，GET模式
 * 注意：
 * 1.使用Crul需要修改服务器中php.ini文件的设置，找到php_curl.dll去掉前面的";"就行了
 * 2.文件夹中cacert.pem是SSL证书请保证其路径有效，目前默认路径是：getcwd().'\\cacert.pem'
 * @param $url 指定URL完整路径地址
 * @param $cacert_url 指定当前工作目录绝对路径
 * return 远程输出的数据
 */
function getHttpResponseGET($url,$cacert_url) {
	$curl = curl_init($url);
	curl_setopt($curl, CURLOPT_HEADER, 0 ); // 过滤HTTP头
	curl_setopt($curl,CURLOPT_RETURNTRANSFER, 1);// 显示输出结果
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);//SSL证书认证
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);//严格认证
	curl_setopt($curl, CURLOPT_CAINFO,$cacert_url);//证书地址
	$responseText = curl_exec($curl);
	//var_dump( curl_error($curl) );//如果执行curl过程中出现异常，可打开此开关，以便查看异常内容
	curl_close($curl);
	
	return $responseText;
}

/**
 * 实现多种字符编码方式
 * @param $input 需要编码的字符串
 * @param $_output_charset 输出的编码格式
 * @param $_input_charset 输入的编码格式
 * return 编码后的字符串
 */
function charsetEncode($input,$_output_charset ,$_input_charset) {
	$output = "";
	if(!isset($_output_charset) )$_output_charset  = $_input_charset;
	if($_input_charset == $_output_charset || $input ==null ) {
		$output = $input;
	} elseif (function_exists("mb_convert_encoding")) {
		$output = mb_convert_encoding($input,$_output_charset,$_input_charset);
	} elseif(function_exists("iconv")) {
		$output = iconv($_input_charset,$_output_charset,$input);
	} else die("sorry, you have no libs support for charset change.");
	return $output;
}
/**
 * 实现多种字符解码方式
 * @param $input 需要解码的字符串
 * @param $_output_charset 输出的解码格式
 * @param $_input_charset 输入的解码格式
 * return 解码后的字符串
 */
function charsetDecode($input,$_input_charset ,$_output_charset) {
	$output = "";
	if(!isset($_input_charset) )$_input_charset  = $_input_charset ;
	if($_input_charset == $_output_charset || $input ==null ) {
		$output = $input;
	} elseif (function_exists("mb_convert_encoding")) {
		$output = mb_convert_encoding($input,$_output_charset,$_input_charset);
	} elseif(function_exists("iconv")) {
		$output = iconv($_input_charset,$_output_charset,$input);
	} else die("sorry, you have no libs support for charset changes.");
	return $output;
}
/* *
 * MD5
 * 详细：MD5加密
 * 版本：3.3
 * 日期：2012-07-19
 * 说明：
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 * 该代码仅供学习和研究支付宝接口使用，只是提供一个参考。
 */

/**
 * 签名字符串
 * @param $prestr 需要签名的字符串
 * @param $key 私钥
 * return 签名结果
 */
function md5Sign($prestr, $key) {
	$prestr = $prestr . $key;
	return md5($prestr);
}

/**
 * 验证签名
 * @param $prestr 需要签名的字符串
 * @param $sign 签名结果
 * @param $key 私钥
 * return 签名结果
 */
function md5Verify($prestr, $sign, $key) {
	$prestr = $prestr . $key;
	$mysgin = md5($prestr);

	if($mysgin == $sign) {
		return true;
	}
	else {
		return false;
	}
}
/**
 * 远程获取数据
 * 注意：该函数的功能可以用curl来实现和代替。curl需自行编写。
 * $url 指定URL完整路径地址
 * @param $input_charset 编码格式。默认值：空值
 * @param $time_out 超时时间。默认值：60
 * return 远程输出的数据
 */
function getHttpResponse($url, $input_charset = '', $time_out = "60") {
	$urlarr     = parse_url($url);
	$errno      = "";
	$errstr     = "";
	$transports = "";
	$responseText = "";
	if($urlarr["scheme"] == "https") {
		$transports = "ssl://";
		$urlarr["port"] = "443";
	} else {
		$transports = "tcp://";
		$urlarr["port"] = "80";
	}
	$fp=@fsockopen($transports . $urlarr['host'],$urlarr['port'],$errno,$errstr,$time_out);
	if(!$fp) {
		die("ERROR: $errno - $errstr<br />\n");
	} else {
		if (trim($input_charset) == '') {
			fputs($fp, "POST ".$urlarr["path"]." HTTP/1.1\r\n");
		}
		else {
			fputs($fp, "POST ".$urlarr["path"].'?_input_charset='.$input_charset." HTTP/1.1\r\n");
		}
		fputs($fp, "Host: ".$urlarr["host"]."\r\n");
		fputs($fp, "Content-type: application/x-www-form-urlencoded\r\n");
		fputs($fp, "Content-length: ".strlen($urlarr["query"])."\r\n");
		fputs($fp, "Connection: close\r\n\r\n");
		fputs($fp, $urlarr["query"] . "\r\n\r\n");
		while(!feof($fp)) {
			$responseText .= @fgets($fp, 1024);
		}
		fclose($fp);
		$responseText = trim(stristr($responseText,"\r\n\r\n"),"\r\n");
		
		return $responseText;
	}
}



/**
 * 调用远程数据
 *
 * @param	string	$url
 * @return	string
 */
 
function downloads($url, $filename){
	
	$file_url=$url;
	$save_to=env('root_path').'public/thumb/'.$filename; 
		
	if(file_exists($save_to)){
		return '/thumb/'.$filename;	
	}
 	file_put_contents($save_to, dr_catcher_data($file_url));	
return '/thumb/'.$filename;
}
 
	 
