<?php
namespace app\common\model;
use think\Model;
use think\facade\Env;
use think\model\concern\SoftDelete;
class Stores extends Model {
	use SoftDelete;
	protected $deleteTime = 'delete_time';
	protected $autoWriteTimestamp = true;
	public function getPolicy() {
		$policy = Policys::get($this->policy_id);
		if(empty($policy)) {
			return false;
		}
		return $policy;
	}
	
	public function getLocalSaveFilePath($save_dir,$filename): string {
		return env('root_path').'public'.getSafeDirSeparator($save_dir . $filename);
	}
	public function getLocalSaveFile($save_dir,$filename) {
		return str_replace(['/','\\','//','\\\\'],'/',($save_dir.$filename));
	}
	
	/*  文件ID  用户UID  保存到目录ID */
	public function to_save_file($ids,$uid,$folder_id) {
		$WEBPATH = Env::get('root_path');
		if(!empty($ids)) {
			
 
 			
			foreach ($ids as $id) {
				#$file[$id] = self::where('id',$id)->field('origin_name,file_name,size,ext,policy_id')->find();
				$file[$id] = self::where('id',$id)->field('origin_name,file_name,size,ext,policy_id')->find()->toArray();

				if(!empty($file[$id])) {
					$file[$id]['uid']=$uid;
					$file[$id]['parent_folder']=$folder_id;
					$file[$id]['create_time']=time();
					$file[$id]['update_time']=time();
					
            		$file_id = self::insertGetId($file[$id]);
					$share_id = Shares::addShare($uid,$file_id,0);
					self::where('id',$file_id)->update(['shares_id' => $share_id]);
 
					$success[] = $file_id;
				}
 				
				
			}
 			#file_put_contents($WEBPATH."file.txt", var_export($file, true));
			
			//echo "<pre>";print_r($file);exit;
			
		 return $success;
		}
		
	}
	
	
}