<?php
namespace app\http\middleware;
use app\common\model\Users;

class UserLoginCheck{
    protected $except = [
        'User/login',
		'Weixin/wxlogin','Weixin/index','Weixin/wx_code',
        'User/register',
        'User/forget',
        'User/reset',
        'Index/index',
        'Weixin/index','Index/terms','Index/about',
        'Index/share',
        'Index/report',
        'Index/share_pass',
        'Index/qrcode',
        'Index/download',
        'Index/return_callback',
        'Index/return_notify',
        'Upload/notify',
		'Payment/index','Payment/wxpay','Payment/alipay',
		'Payment/alipay_call','Payment/alipay_notify',
		'Payment/weixin_call','Payment/weixin_notify',
    ];

    public function handle($request, \Closure $next){

        $request_uri = $request->controller() . '/' . $request->action();

        if(!in_array($request_uri,$this->except) && !(new Users)->login_auth('default')){
            (new Users)->logout('default');
            return redirect('user/login');
        }

        return $next($request);
    }

}