<?php /*a:1:{s:67:"/www/wwwroot/127.0.0.1/application/admin/view/group/edit.html";i:1658883146;}*/ ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <link rel="stylesheet" href="/static/component/pear/css/pear.css" />
</head>
<body>
<form class="layui-form">
  <div class="mainBox">
    <div class="main-container">
      <div class="layui-form-item">
        <label class="layui-form-label">用户组名</label>
        <div class="layui-input-block">
          <input type="text" name="group_name" value="<?php echo htmlentities($info['group_name']); ?>" required  lay-verify="required" autocomplete="off" class="layui-input">
          <div class="layui-form-mid layui-word-aux">用户组的名称</div>
        </div>
      </div>

      <div class="layui-form-item">
        <label class="layui-form-label">存储策略</label>
        <div class="layui-input-block">
          <select name="policy_id" lay-verify="required">
            <?php if(is_array($policy) || $policy instanceof \think\Collection || $policy instanceof \think\Paginator): $i = 0; $__LIST__ = $policy;if( count($__LIST__)==0 ) : echo "" ;else: foreach($__LIST__ as $key=>$vo): $mod = ($i % 2 );++$i;?>
            <option value="<?php echo htmlentities($vo['id']); ?>" <?php if($vo['id'] == $info['policy_id']): ?>selected<?php endif; ?>><?php echo htmlentities($vo['name']); ?></option>
            <?php endforeach; endif; else: echo "" ;endif; ?>
          </select>
          <div class="layui-form-mid layui-word-aux">为该用户组绑定一个上传策略</div>
        </div>
      </div>

      <div class="layui-form-item">
        <label class="layui-form-label">上传大小</label>
        <div class="layui-input-block">
          <div class="layui-input-inline">
            <input type="number" name="max_storage" required value="<?php echo countSize($info['max_storage'],true)[0]; ?>"  lay-verify="required" autocomplete="off" class="layui-input">
          </div>
          <div class="layui-form-mid">单位：</div>
          <div class="layui-input-inline">
            <select name="storage_size" lay-verify="required">
              <?php 
                $storage_size = countSize($info['max_storage'],true)[1];
               ?>
              <option value="1" <?php if($storage_size == '1'): ?>selected<?php endif; ?>>B</option>
              <option value="1024" <?php if($storage_size == '1024'): ?>selected<?php endif; ?>>KB</option>
              <option value="1048576" <?php if($storage_size == '1048576'): ?>selected<?php endif; ?>>MB</option>
              <option value="1073741824" <?php if($storage_size == '1073741824'): ?>selected<?php endif; ?>>GB</option>
            </select>
          </div>
          <div class="layui-form-mid layui-word-aux">限制用户组单文件上传大小</div>
        </div>

      </div>

      <div class="layui-form-item">
        <label class="layui-form-label">下载限速</label>
        <div class="layui-input-inline">
          <input type="text" name="speed" min="0" value="<?php echo htmlentities($info['speed']); ?>" placeholder="留空表示不限速" autocomplete="off" class="layui-input">
        </div>
        <div class="layui-form-mid layui-word-aux"><b>KB/s</b>  填写0表示禁止下载</div>
      </div>

      <div class="layui-form-item">
        <label class="layui-form-label">分享文件</label>
        <div class="layui-input-inline">
          <input type="radio" name="allow_share" value="1" title="允许" <?php if($info['allow_share'] == '1'): ?>checked<?php endif; ?>>
          <input type="radio" name="allow_share" value="0" title="禁止" <?php if($info['allow_share'] == '0'): ?>checked<?php endif; ?>>
        </div>
        <div class="layui-form-mid layui-word-aux">是否允许文件链接分享他人下载</div>
      </div>

    </div>
  </div>
  <div class="bottom">
    <div class="button-container">
      <button type="submit" class="layui-btn layui-btn-normal layui-btn-sm" lay-submit="" lay-filter="save">
        <i class="layui-icon layui-icon-ok"></i>
        提交
      </button>
    </div>
  </div>
</form>
<script src="/static/component/layui/layui.js"></script>
<script src="/static/component/pear/pear.js"></script>
<script>
  layui.use(['form','jquery'],function(){
    let form = layui.form;
    let $ = layui.jquery;

    form.on('submit(save)', function(data){
      $.ajax({
        data:JSON.stringify(data.field),
        dataType:'json',
        contentType:'application/json',
        type:'post',
        success:function(res){
          //判断有没有权限
          if(res && res.code == 999){
            layer.msg(res.msg, {
              icon: 5,
              time: 2000,
            })
            return false;
          }else if(res.code == 200){
            layer.msg(res.msg,{icon:1,time:1000},function(){
              parent.layer.close(parent.layer.getFrameIndex(window.name));//关闭当前页
              parent.layui.table.reload("user-table");
            });
          }else{
            layer.msg(res.msg,{icon:2,time:1000});
          }
        }
      })
      return false;
    });
  })
</script>
</body>
</html>