<?php /*a:1:{s:67:"/www/wwwroot/127.0.0.1/application/admin/view/policy/index.html";i:1659252642;}*/ ?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title></title>
    <link rel="stylesheet" href="/static/component/pear/css/pear.css" />
</head>
<body class="pear-container">

<div class="layui-card">
    <div class="layui-card-body">
        <table id="user-table" lay-filter="user-table"></table>
    </div>
</div>

<script type="text/html" id="user-toolbar">
    <button class="pear-btn pear-btn-primary pear-btn-md" lay-event="add">
        <i class="layui-icon layui-icon-add-1"></i>
        添加策略
    </button>
</script>

<script type="text/html" id="user-bar">
    <button class="pear-btn pear-btn-primary pear-btn-sm" lay-event="edit"><i class="layui-icon layui-icon-edit"></i></button>
    <button class="pear-btn pear-btn-danger pear-btn-sm" lay-event="remove"><i class="layui-icon layui-icon-delete"></i></button>
</script>


<script src="/static/component/layui/layui.js"></script>
<script src="/static/component/pear/pear.js"></script>
<script>
    layui.use(['table', 'form', 'jquery','common'], function() {
        let table = layui.table;
        let form = layui.form;
        let $ = layui.jquery;
        let common = layui.common;

        let cols = [
            [{type: 'checkbox'},
                {title: '策略名称', field: 'name', align: 'center'},
                {title: '类型', field: 'type', align: 'center'},
                {title: '文件数量', field: 'file_num', align: 'center'},
                {title: '存储数据量', field: 'store_num', align: 'center'},
                {title: '操作', toolbar: '#user-bar', align: 'center', width: 130}
            ]
        ]

        table.render({
            elem: '#user-table',
            url: "<?php echo url('policy/index'); ?>",
            page: true,
            cols: cols,
            skin: 'line',
            toolbar: '#user-toolbar',
            defaultToolbar: [{
                title: '刷新',
                layEvent: 'refresh',
                icon: 'layui-icon-refresh',
            }, 'filter', 'print', 'exports']
        });

        table.on('tool(user-table)', function(obj) {
            if (obj.event === 'remove') {
                window.remove(obj);
            } else if (obj.event === 'edit') {
                window.edit(obj);
            }
        });

        table.on('toolbar(user-table)', function(obj) {
            if (obj.event === 'add') {
                window.add();
            } else if (obj.event === 'refresh') {
                window.refresh();
            }
        });


        window.add = function() {
            layer.open({
                type: 2,
                title: '添加策略',
                shade: 0.1,
                area: [common.isModile()?'100%':'600px', common.isModile()?'100%':'600px'],
                content: "<?php echo url('Policy/add'); ?>"
            });
        }

        window.edit = function(obj) {
            layer.open({
                type: 2,
                title: '修改策略',
                shade: 0.1,
                area: [common.isModile()?'100%':'600px', common.isModile()?'100%':'600px'],
                content: "<?php echo url('policy/edit'); ?>?id=" + obj.data['id']
            });
        }

        window.remove = function(obj) {
            layer.confirm('确定要删除该储存设置吗？<b style="color: red">删除后会导致上传文件不能下载，且不可恢复</b>', {
                icon: 3,
                title: '提示'
            }, function(index) {
                layer.close(index);
                let loading = layer.load();
                $.ajax({
                    url: "<?php echo url('policy/delete'); ?>?id=" + obj.data['id'],
                    dataType: 'json',
                    type: 'get',
                    success: function(result) {
                        layer.close(loading);
                        if (result.code == 200) {
                            layer.msg(result.msg, {
                                icon: 1,
                                time: 1000
                            }, function() {
                                obj.del();
                            });
                        } else {
                            layer.msg(result.msg, {
                                icon: 2,
                                time: 1000
                            });
                        }
                    }
                })
            });
        }

        window.refresh = function(param) {
            table.reload('user-table');
        }
    })
</script>
</body>
</html>
