<?php
namespace app\index\controller;
use think\facade\Env;
use think\session\driver\Redis;
use app\common\controller\Home;
use app\common\model\Users;
use Qrcode\Qrcode;
use think\Exception;
use think\facade\Cookie;
use think\response\Download;
use app\common\model\Auth;
use think\facade\Session;
use app\common\model\Shares;
use app\common\model\Profit;

use app\common\model\Wxpay;
use app\common\model\Alipay;
use app\common\model\Order;


class Payment extends Home {
 
 
    //进行微信支付
	//	127.0.0.1/payment/wxpay
	
	//	域名：request()->domain()
    public function wxpay(){
		$site_url = request()->domain(); 
		$trade_no=input('get.trade_no');
		$money=input('get.money');
		$order = Order::where('trade_no',$trade_no)->where('type','wxpay')->where('status',0)->field('uid,trade_no,money,pay_time')->find();
		if(!$order){
			$this->error('['.$trade_no.']订单不存在');exit;
		}
		$order['subject']='在线付款';
 		$order['body']='Vip描述';
		if (ismobile() && !strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger')){
		// 手机浏览器调用H5
			$order['trade_type']='MWEB';//H5支付的交易类型为MWEB
		}else{
			$order['trade_type']='JSAPI';// 微信浏览器内支付的交易类型为JSAPI ,还有NATIVE，APP等模式
		}
		$result = ( new Wxpay )->wxpay($order);
		if($order['trade_type']=='MWEB'){	
			$retur['url']=$order['mweb_url'];
		}elseif($result['html']){
			echo $result['html'];exit;
		}else{
			echo '交易发起失败';exit;
		}
		return $retur;exit;
    }

 
	/*
	**
	*********************************** 
	支付宝下单接口
	***********************************
	**   
	*/
	 public function alipay(){ 
		$trade_no=input('get.trade_no');
		$money=input('get.money');
		$order = Order::where('trade_no',$trade_no)->where('type','alipay')->where('status',0)->field('uid,trade_no,money,pay_time')->find();
		if(!$order){
			$this->error('['.$trade_no.']订单不存在');exit;
		}
		$order['subject']='在线付款';
 		$order['body']='Vip描述';
		$alipaySubmit =( new Alipay );
		$parameter =$alipaySubmit->Int($order);
//echo '$alipaySubmit1:';print_r($alipaySubmit1);exit;
         $html_text = $alipaySubmit->buildRequestForm($parameter,"post","OK");
		 echo $html_text;exit;
	 }
	
	
 
 

	/**  支付宝同步通知  **/
    public function alipay_call(){
		$WEBPATH = Env::get('root_path');
		#file_put_contents($WEBPATH."api/aliPay_call_content1.txt", var_export($content, true));
 	
		$a_config=[];
		$alipayreturn =( new Alipay );
		$parameter =$alipayreturn->Int_return($a_config);
		
 		$verify_result = $alipayreturn->verifyReturn();
		if ($verify_result) {//验证成功
			$trade_no = $_GET['trade_no']; //获取支付宝交易号
			$total_fee = $_GET['total_fee']; //获取总价格
			$out_trade_no = $_GET['out_trade_no'];	//获取订单号
			if ($_GET['trade_status'] == 'TRADE_FINISHED' || $_GET['trade_status'] == 'TRADE_SUCCESS') {
				#$money = number_format($total_fee, 2, '.', '');
				$this->return_callback('alipay');
			} else {
				$this->error('trade_status='.$_GET['trade_status']);
			}
		} else {//验证失败
		 	$this->error('验证失败');
		}
 
	}
	
	
	
	
	
	
	
	
	
	
	
	
	/**  支付宝异步通知  **/
    public function alipay_notify(){
/*		
		$WEBPATH = Env::get('root_path');
 		file_put_contents($WEBPATH."api/aliPay_notify_post.txt", var_export($_POST, true));
		$data = input('post.');
		if($data){
			file_put_contents($WEBPATH."api/aliPay_notify_content.txt", var_export($data, true));
		}
*/
		$alipay_config=[];
		$alipayreturn =( new Alipay );
		$parameter =$alipayreturn->Int_return($alipay_config);
 		$verify_result = $alipayreturn->verifyNotify();

		if ($verify_result) {
			//验证成功
			$trade_no = $_POST['trade_no']; //获取支付宝交易号
			$total_fee = $_POST['total_fee']; //获取总价格
			$out_trade_no = $_POST['out_trade_no'];	//获取订单号
			if ($_POST['trade_status'] == 'TRADE_FINISHED' || $_POST['trade_status'] == 'TRADE_SUCCESS') {
				$money = number_format($total_fee, 2, '.', '');
				exit($this->return_notify('alipay',input('post.')));
			} else {
				exit('trade_status='.$_POST['trade_status']);
			}
		} else {
			echo 'Fail';
 
		}
		
 
	}
	
	
	
	
	/**  微信同步通知  ** /
	public function weixin_call(){
 		//接收微信请求
		$wxpay =( new Wxpay );
		$xml = file_get_contents('php://input');
		
		$nativeCall =$wxpay->saveData($xml);
 
		if($nativeCall->checkSign() == FALSE){
			$nativeCall->setReturnParameter("return_code","FAIL");//返回状态码
			$nativeCall->setReturnParameter("return_msg","签名失败");//返回信息
		}else{
			//【支付成功】
			$sn = $nativeCall->data["out_trade_no"];
			$money = $nativeCall->data["total_fee"];
			$transaction_id = $nativeCall->data["transaction_id"];
			//使用统一支付接口
			$unifiedOrder = new UnifiedOrder_pub();
			$nativeCall->setReturnParameter("return_code","SUCCESS");//返回状态码
			$nativeCall->setReturnParameter("result_code","SUCCESS");//业务结果
			
		}
		//将结果返回微信
		$returnXml = $nativeCall->returnXml();
		echo $returnXml;
		$WEBPATH = Env::get('root_path');
		$this->return_callback('weixin');
	}
 
	
	
	
	/**  微信异步通知  **/
	public function weixin_notify(){
		$WEBPATH = Env::get('root_path');	
 		//接收微信请求
		$wxpay =( new Wxpay );
		$xml = file_get_contents('php://input');
		$post_data =$wxpay->saveData($xml);
		
		if($wxpay->checkSign() == FALSE){
			$wxpay->setReturnParameter("return_code","FAIL");//返回状态码
			$wxpay->setReturnParameter("return_msg","签名失败");//返回信息
		}else{
			//【支付成功】
			$sn = $wxpay->data["out_trade_no"];
			$money = $wxpay->data["total_fee"];
			$transaction_id = $wxpay->data["transaction_id"];
			$re_notify=$this->return_notify('weixin',$post_data);
			if($re_notify=='SUCCESS'){
				//使用统一支付接口
				$wxpay->setReturnParameter("return_code","SUCCESS");//返回状态码
				$wxpay->setReturnParameter("result_code","SUCCESS");//业务结果
			}

		}
		//将结果返回微信
		$returnXml = $wxpay->returnXml();
		echo $returnXml;
 
	}
	
	/*
	**
	*********************************** 
	    同步回调函数
	***********************************
	**
	*/
    public function return_callback($type){
        $param = input('get.');
        $order = Order::where('trade_no',$param['out_trade_no'])->find();
        if(empty($order)){
            $this->error('订单数据不存在');
        }
        if($order['status'] != 1){
            $this->error('订单未支付成功');
        }
        $this->success('VIP开通/续费成功','/user/index','请刷新当前页面，然后重新点击下载');

    }



    public function return_notify($type,$param){
		
		
		#file_put_contents(Env::get('root_path')."return_notify0.txt", var_export($param, true));
		if($type=='alipay'){
			if($param['trade_status'] != 'TRADE_SUCCESS'){
				return'Fail is trade status.';
			}
		}elseif($type=='weixin'){
			$param['trade_no']=$param['transaction_id'];//微信订单号
			if($param['result_code'] != 'SUCCESS'){
				return'Fail is trade status.';
			}	
		} 
        // 查找订单
        $order = Order::where('trade_no',$param['out_trade_no'])->find();
        if(empty($order)){
            return'Fail order is not found.';
        }
        if($order['status']==1){
            return'SUCCESS';//已经支付成功了
        }
        // 查找用户
        $user = Users::where('id',$order['uid'])->find();
        if(empty($user)){
            return'Fail order user is not found.';
        }
        // VIP用户组
        $vip_group = config('vip.vip_group');
        // 开通/续费时长
        $vip_expire = $order['vip_day'] * 86400;
        // 开通/续费VIP
        if($user['group'] == $vip_group){
            // 续费VIP
            $user['group_expire'] = $user['group_expire'] + $vip_expire;
        }else{
            // 开通VIP
            $user['group'] = $vip_group;
            $user['group_expire'] = time() + $vip_expire;
        }
        // 保存数据
        $user->save();
        // 完成订单
        $order['status'] = 1;
        $order['out_trade_no'] = $param['trade_no'];
        $order['pay_time'] = time();
        // 保存订单
        $order->save();
        // 查询分成用户
        $share = Shares::where('id',$order['profit_id'])->find();
        // 参与分成
        if(!empty($share)){
            // 用户分成奖励比例
            $vip_profit = config('vip.vip_profit');
            // 计算用户分成奖励
            $user_profit = ($order['money'] / 100) * $vip_profit;
            // 通用户不奖励
            if($order['uid'] != $share['uid']){
                // 奖励
                Record::addRecord($share['uid'],0,'VIP分成',$user_profit,'用户'.getSafeNickname($user['nickname']).'开通VIP奖励');
                // 记录
                Profit::record($share['uid'],$share['source_id'],'count_order',1);
                Profit::record($share['uid'],$share['source_id'],'count_order_yes',1);
                Profit::record($share['uid'],$share['source_id'],'count_money',$order['money']);
                Profit::record($share['uid'],$share['source_id'],'count_profit',$user_profit);
            }
        }
        // 处理完成
        return'SUCCESS';
    }

 
	
}