<?php
namespace app\index\controller;
use think\facade\Env;
use think\session\driver\Redis;
use app\common\controller\Home;
use app\common\model\Users;
use Qrcode\Qrcode;
use think\Exception;
use think\facade\Cookie;
use think\response\Download;
use app\common\model\Auth;
use think\facade\Session;
use app\common\model\Shares;
use app\common\model\Profit;

class Weixin extends Home {


	/*
	* 微信扫码登录 参数二维码展示
	*/
	public function wx_code() {	
		$time = time() - 600;//清除一天前数据 86400   10分钟 600
		Auth::where('create_time < '.$time)->delete();
		$access_token=$this->dr_get_access_token();
		$uuid=input('get.uuid');
		$share_id=input('get.share_id');
		$post=["expire_seconds"=>604800,"action_name"=>"QR_STR_SCENE","action_info"=>["scene"=>["scene_str"=>$uuid]]];
		$str=drhttp('https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token='.$access_token,$post);
		#$url2='https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket='.$str['ticket'];
		#header('location: '.$url2);exit;
		try {
			(new Auth)->add($uuid,$share_id);
			if(!empty($str['url'])){
				Qrcode::createQrcode($str['url']);
			}
		}catch (Exception $e){
                return json(['code' => 503,'msg' => $e->getMessage()]);
		}
		#echo $str['url'];exit;
	}
	/*
	* 微信扫码登录轮询页面
	*/
	public function wxlogin() {
		$uuid=input('get.uuid');
		$auth = Auth::where('uuid',$uuid)->where('status',1)->field('id,userid,openid,share_id')->find();
		if($auth){
 			
			$user = Users::where('id',$auth['userid'])->where('wx_openid',$auth['openid'])->field('id,username,password,nickname,avatar,status')->find();
			if($user['status']==0){
				return json(['status' =>-1,'msg' => '登录帐号已被管理员封禁，请联系管理员处理！']);
			}
			
			
			// 登录成功
			Session::set('default_uid',$user['id']);
			Session::set('default_lkey',md5($user['username'] . $user['password'] . $user['status']));
			
			return json(['status' => 1,'msg' => $user['nickname'].'登录成功']);
			#echo getRedis($uuid).'<br>';echo request()->ip();
		}else{
			 return json(['status' => 0,'msg' => '未扫码']);
		}
	}
	 public function wxupload(){
        $file = request()->file('file');
        if($file){
            $info = $file->move(ROOT_PATH . 'public' . DS . 'upload');
            if($info){
                echo $info->getExtension();
                echo $info->getSaveName();
            }else{
                echo $file->getError();
            }
        }
    }
// 获取头像
	public function index() {
 		$WEBPATH = Env::get('root_path');
	//	$this->wx = $this->get_cache('weixin');
        // 删除微信传递的token干扰
        unset ( $_REQUEST ['token'] );
 
        $nonce = input('get.nonce');
        $signature = input('get.signature');
        $timestamp = input('get.timestamp');
 
        // 处理参数
        $tmp_arr = array(config('register.wx_token'), $timestamp, $nonce);
        sort($tmp_arr, SORT_STRING);
        $tmp_str = implode($tmp_arr);
        $tmp_str = sha1($tmp_str);
//	 print_r(file_get_contents("php://input"));exit;
//		print_r($this->input->get(NULL, TRUE));exit;
 
        if ($tmp_str == $signature) {
            // 判读是不是只是验证
            $echostr = input('get.echostr');
            if (!empty($echostr)) {
                echo $echostr;exit;
            } else {
 
                // 实际处理用户消息
                $content = file_get_contents("php://input");
				
					#file_put_contents($WEBPATH."t.txt", var_export($content, true));
					#file_put_contents($WEBPATH."t0.txt", var_export(dr_xml2array($content),FILE_APPEND));
				if ($content) {// 解析微信传过来的 XML 内容 转化为数组
                    $content = dr_xml2array($content);
					#file_put_contents($WEBPATH."t1.txt", var_export($content, true));
					$uuid=str_replace('qrscene_', '', $content['EventKey']);
					$update = [];
					$update['openid']=$content['FromUserName'];
 
					$update['userid']=$this->dr_get_user($update['openid']);
					$update['status']=1;
					Auth::where('uuid',$uuid)->update($update);
					
					
					
					
					$users = Users::where('id',$update['userid'])->where('wx_openid',$update['openid'])->field('id,username,password,nickname,avatar,status')->find();
					
				/*统计来源*/	
				$auth = Auth::where('uuid',$uuid)->where('status',1)->field('id,userid,openid,share_id')->find();
				$share_info = Shares::where( 'id', $auth['share_id'])->find();
				// 统计数据
				if ( !empty( $share_info ) ) {
					Profit::record( $share_info[ 'uid' ], $share_info[ 'source_id' ], 'reg', 1 );

				}
					
exit('<xml><ToUserName><![CDATA['.$content['FromUserName'].']]></ToUserName>
<FromUserName><![CDATA['.$content['ToUserName'].']]></FromUserName>
<CreateTime>'.(time()+2).'</CreateTime>
<MsgType><![CDATA[text]]></MsgType>
<Content>['.$users['nickname'].']登录成功</Content>
</xml>
');
					
				}
				
//file_put_contents($WEBPATH."t1.txt", var_export($content, true));
				
 	
				
			}
		}
				
 
 

	}
	public function dr_get_user($openid) {
		$WEBPATH = Env::get('root_path');
		$users = Users::where('wx_openid',$openid)->field('id,nickname')->find();
		if($users){
			$uid=$users->id;
		}else{
			#file_put_contents($WEBPATH."users.txt", var_export($users, true));
			$wx_info=drhttp('https://api.weixin.qq.com/cgi-bin/user/info?access_token='.$this->dr_get_access_token().'&openid='.$openid.'&lang=zh_CN');
			
			#$wx_info=drhttp('https://api.weixin.qq.com/sns/userinfo?access_token='.$this->dr_get_access_token().'&openid='.$openid.'&lang=zh_CN');
			#file_put_contents($WEBPATH."wx_info.txt", var_export($wx_info, true));
			if($wx_info){
				#file_put_contents($WEBPATH."wx_info1.txt", var_export($wx_info, true));
				$default_group = config('register.default_group');
				$uid = (new Users)->wxreg($wx_info['nickname'],'','456789',$default_group,['openid' =>$openid,'avatar' =>$wx_info['headimgurl']]);	
				#file_put_contents($WEBPATH."wx_info2.txt", var_export($uid, true));
			}
		}
		return $uid;
	}
	
	
	public function dr_get_access_token() {
		$WEBPATH = Env::get('root_path');
    	$name = $WEBPATH.'runtime/cache/access_token.cache';
    	$data = @json_decode(dr_catcher_data($name), true);
    	if (isset($data['time']) && $data['time'] > time() && isset($data['access_token']) && $data['access_token']) {
        	return $data['access_token'];
    	}
 
		!config('register.wx_appid') && exit('没有配置账号参数');
		$url = 'https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid='.config('register.wx_appid').'&secret='.config('register.wx_secret');
		$data = json_decode(wx_get_https_json_data($url), true);
		if (!$data) {
			@unlink($name);
			exit('获取access_token失败，请检查服务器是否支持远程链接');
		}
		if (isset($data['errmsg']) && $data['errmsg']) {
			@unlink($name);
			exit('错误代码（'.$data['errcode'].'）：'.$data['errmsg']);
		}
		$data['time'] = time() + $data['expires_in'];
		@file_put_contents($name, json_encode($data));

		return $data['access_token'];
	}

	
 
	
	 
	
}