<?php /*a:1:{s:58:"E:\wwwroot\www_demo\application\admin\view\user\index.html";i:1658883146;}*/ ?>
<!DOCTYPE html>

<html>
<head>
<meta charset="utf-8">
<title>用户管理</title>
<link rel="stylesheet" href="/static/component/pear/css/pear.css" />
</head>

<body class="pear-container">
<div class="layui-card">
    <div class="layui-card-body">
        <form class="layui-form" action="">
            <div class="layui-form-item">
                <div class="layui-form-item layui-inline">
                    <label class="layui-form-label">搜索类型</label>
                    <div class="layui-input-inline">
                        <select name="search_type" lay-verify="required">
                            <option value="username">帐号搜索</option>
                            <option value="email">邮箱搜索</option>
                            <option value="nickname">昵称搜索</option>
                        </select>
                    </div>
                </div>
                <div class="layui-form-item layui-inline">
                    <label class="layui-form-label">用户等级</label>
                    <div class="layui-input-inline">
                        <select name="group">
                           <option value="">全部用户</option>
                            <?php if(is_array($group) || $group instanceof \think\Collection || $group instanceof \think\Paginator): $i = 0; $__LIST__ = $group;if( count($__LIST__)==0 ) : echo "" ;else: foreach($__LIST__ as $key=>$vo): $mod = ($i % 2 );++$i;?>
                            <option value="<?php echo htmlentities($vo['id']); ?>"><?php echo htmlentities($vo['group_name']); ?></option>
                            <?php endforeach; endif; else: echo "" ;endif; ?>
 
                        </select>
                    </div>
                </div>
                <div class="layui-form-item layui-inline">
                    <label class="layui-form-label">搜索内容</label>
                    <div class="layui-input-inline">
                        <input type="text" name="search_value" placeholder="请输入搜索内容" class="layui-input">
                    </div>
                </div>
                <div class="layui-form-item layui-inline">
                    <button class="pear-btn pear-btn-md pear-btn-primary" lay-submit lay-filter="user-query"> <i class="layui-icon layui-icon-search"></i> 搜索结果 </button>
                    <button type="reset" class="pear-btn pear-btn-md"> <i class="layui-icon layui-icon-refresh"></i> 重置搜索 </button>
                </div>
            </div>
        </form>
    </div>
</div>
<div class="layui-card">
    <div class="layui-card-body">
        <table id="user-table" lay-filter="user-table">
        </table>
    </div>
</div>
<script type="text/html" id="user-toolbar">
  <button class="pear-btn pear-btn-primary pear-btn-md" lay-event="add">
    <i class="layui-icon layui-icon-add-1"></i>新增账号
  </button>
  <button class="pear-btn pear-btn-danger pear-btn-md" lay-event="batchRemove">
    <i class="layui-icon layui-icon-delete"></i>
    批量删除
  </button>
</script> 
<script type="text/html" id="user-bar">
  <button class="pear-btn pear-btn-primary pear-btn-sm" lay-event="edit"><i class="layui-icon layui-icon-edit"></i></button>
  <button class="pear-btn pear-btn-danger pear-btn-sm" lay-event="remove"><i class="layui-icon layui-icon-delete"></i></button>
</script> 
<script type="text/html" id="user-enable">
  <input type="checkbox" name="status" value="{{d.id}}" lay-skin="switch" lay-text="启用|禁用" lay-filter="user-enable" {{ d.status == 1 ? 'checked' : '' }}>
</script> 
<script type="text/html" id="user-auth">
  {{#if (d.is_auth == 0) { }}
  <span class="layui-badge layui-bg-orange">未实名</span>
  {{# }else if(d.is_auth == 1){ }}
  <span class="layui-badge layui-bg-blue">已认证</span>
  {{# } }}
</script> 
<script type="text/html" id="user-createTime">
  {{layui.util.toDateString(d.createTime, 'yyyy-MM-dd')}}
</script> 
<script type="text/html" id="user-avatar">
  <img src="{{ d.avatar }}" style="width: 30px;height: 30px;border-radius: 50%">
</script> 
<script src="/static/component/layui/layui.js"></script> 
<script src="/static/component/pear/pear.js"></script> 
<script>
  layui.use(['table', 'form', 'jquery','common'], function() {

    let table = layui.table;

    let form = layui.form;

    let $ = layui.jquery;

    let common = layui.common;



    let cols = [

      [{type: 'checkbox'},

        {title: 'UID', field: 'id', align: 'center'},

        {title: '',field:'avatar',align: 'center',templet: '#user-avatar',width: 45},

        {title: '昵称', field: 'nickname', align: 'left'},

        {title: '用户帐号', field: 'username', align: 'center'},

        {title: '用户等级', field: 'group', align: 'center'},

        {title: '余额', field: 'amount', align: 'center'},

        {title: '安全邮箱', field: 'email', align: 'center'},

        {title: '实名认证', field: 'is_auth', align: 'center', templet: '#user-auth'},

        {title: '账号状态', field: 'status', align: 'center', templet: '#user-enable'},

        {title: '注册时间', field: 'create_time', align: 'center', },/*  templet: '#user-createTime' */

        {title: '操作', toolbar: '#user-bar', align: 'center', width: 130}

      ]

    ]



    table.render({

      elem: '#user-table',

      url: "<?php echo url('user/index'); ?>",

      page: true,

      cols: cols,

      skin: 'line',

      toolbar: '#user-toolbar',

      defaultToolbar: [{

        title: '刷新',

        layEvent: 'refresh',

        icon: 'layui-icon-refresh',

      }, 'filter', 'print', 'exports']

    });



    table.on('tool(user-table)', function(obj) {

      if (obj.event === 'remove') {

        window.remove(obj);

      } else if (obj.event === 'edit') {

        window.edit(obj);

      }

    });



    table.on('toolbar(user-table)', function(obj) {

      if (obj.event === 'add') {

        window.add();

      } else if (obj.event === 'refresh') {

        window.refresh();

      } else if (obj.event === 'batchRemove') {

        window.batchRemove(obj);

      }

    });



    form.on('submit(user-query)', function(data) {

      table.reload('user-table', {

        where: data.field

      })

      return false;

    });



    form.on('switch(user-enable)', function(obj) {

      let status = obj.elem.checked ? 1 : 0;

      $.ajax({

        url:"<?php echo url('user/change_status'); ?>",

        type:'get',

        data:{

          id:this.value,

          status:status

        },

        dataType:'JSON',

        success:function(result){

          layer.tips(result.msg, obj.othis);

        }

      })

    });



    window.add = function() {

      layer.open({

        type: 2,

        title: '新增',

        shade: 0.1,

        area: [common.isModile()?'100%':'600px', common.isModile()?'100%':'400px'],

        content: "<?php echo url('user/add'); ?>"

      });

    }



    window.edit = function(obj) {

      layer.open({

        type: 2,

        title: '修改',

        shade: 0.1,

        area: ['600px', '500px'],

        content: "<?php echo url('user/edit'); ?>?id=" + obj.data['id']

      });

    }



    window.remove = function(obj) {

      layer.confirm('确定要删除该用户吗？<b style="color: red">删除后用户的储存数据会被清空，且不可恢复</b>', {

        icon: 3,

        title: '提示'

      }, function(index) {

        layer.close(index);

        let loading = layer.load();

        $.ajax({

          url: "<?php echo url('user/del'); ?>?ids=" + obj.data['id'],

          dataType: 'json',

          type: 'get',

          success: function(result) {

            layer.close(loading);

            if (result.code == 200) {

              layer.msg(result.msg, {

                icon: 1,

                time: 1000

              }, function() {

                obj.del();

              });

            } else {

              layer.msg(result.msg, {

                icon: 2,

                time: 1000

              });

            }

          }

        })

      });

    }



    window.batchRemove = function(obj) {



      var checkIds = common.checkField(obj,'id');



      if (checkIds === "") {

        layer.msg("未选中数据", {

          icon: 3,

          time: 1000

        });

        return false;

      }



      layer.confirm('确定要删除这些用户[' + checkIds + ']吗，<b style="color: red">删除后数据不可恢复</b>', {

        icon: 3,

        title: '提示'

      }, function(index) {

        layer.close(index);

        let loading = layer.load();

        $.ajax({

          url: "<?php echo url('user/del'); ?>?ids=" + checkIds,

          dataType: 'json',

          type: 'get',

          success: function(result) {

            layer.close(loading);

            if (result.code == 200) {

              layer.msg(result.msg, {

                icon: 1,

                time: 1000

              }, function() {

                table.reload('user-table');

              });

            } else {

              layer.msg(result.msg, {

                icon: 2,

                time: 1000

              });

            }

          }

        })

      });

    }



    window.refresh = function(param) {

      table.reload('user-table');

    }

  })

</script>
</body>
</html>
