<?php /*a:1:{s:65:"/www/wwwroot/127.0.0.1/application/admin/view/file/index.html";i:1658883146;}*/ ?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title></title>
    <link rel="stylesheet" href="/static/component/pear/css/pear.css" />
</head>
<body class="pear-container">
<div class="layui-card">
    <div class="layui-card-body">
        <form class="layui-form" action="">
            <div class="layui-form-item">

                <div id="test6">
                    <div class="layui-form-item layui-inline">
                        <label class="layui-form-label">开始日期</label>
                        <div class="layui-input-inline">
                            <input type="text" autocomplete="off" name="start_time" id="test-startDate-1" class="layui-input" placeholder="开始日期">
                        </div>
                    </div>

                    <div class="layui-form-item layui-inline">
                        <label class="layui-form-label">结束日期</label>
                        <div class="layui-input-inline">
                            <input type="text" autocomplete="off" name="end_time" id="test-endDate-1" class="layui-input" placeholder="结束日期">
                        </div>
                    </div>
                </div>

                <div class="layui-form-item layui-inline">
                    <label class="layui-form-label">排序字段</label>
                    <div class="layui-input-inline">
                        <select name="sort_key" lay-verify="required">
                            <option value="create_time">上传时间排序</option>
                            <option value="update_time">更新时间排序</option>
                            <option value="id">ID排序</option>
                            <option value="size">文件大小排序</option>
                            <option value="count_down">下载量排序</option>
                            <option value="count_open">浏览量排序</option>
                        </select>
                    </div>
                </div>

                <div class="layui-form-item layui-inline">
                    <label class="layui-form-label">排序方式</label>
                    <div class="layui-input-inline">
                        <select name="sort" lay-verify="required">
                            <option value="0">降序</option>
                            <option value="1">升序</option>
                        </select>
                    </div>
                </div>

                <div class="layui-form-item layui-inline">
                    <label class="layui-form-label">存储筛选</label>
                    <div class="layui-input-inline">
                        <select name="policy" lay-verify="required">
                            <?php if(is_array($policy) || $policy instanceof \think\Collection || $policy instanceof \think\Paginator): $i = 0; $__LIST__ = $policy;if( count($__LIST__)==0 ) : echo "" ;else: foreach($__LIST__ as $key=>$vo): $mod = ($i % 2 );++$i;?>
                            <option value="<?php echo htmlentities($vo['id']); ?>"><?php echo htmlentities($vo['name']); ?></option>
                            <?php endforeach; endif; else: echo "" ;endif; ?>
                        </select>
                    </div>
                </div>

                <div class="layui-form-item layui-inline">
                    <label class="layui-form-label">文件后缀</label>
                    <div class="layui-input-inline">
                        <input type="text" name="ext" placeholder="请输入文件后缀 如 png jpg 等" class="layui-input">
                    </div>
                </div>

                <div class="layui-form-item layui-inline">
                    <label class="layui-form-label">用户UID</label>
                    <div class="layui-input-inline">
                        <input type="number" name="uid" placeholder="请输入UID" class="layui-input">
                    </div>
                </div>

                <div class="layui-form-item layui-inline">
                    <label class="layui-form-label">文件名称</label>
                    <div class="layui-input-inline">
                        <input type="text" name="origin_name" placeholder="请输入文件名称" class="layui-input">
                    </div>
                </div>

                <div class="layui-form-item layui-inline">
                    <button class="pear-btn pear-btn-md pear-btn-primary" style="margin-left: 36px;" lay-submit lay-filter="user-query">
                        <i class="layui-icon layui-icon-search"></i>
                        搜索结果
                    </button>
                    <button type="reset" class="pear-btn pear-btn-md">
                        <i class="layui-icon layui-icon-refresh"></i>
                        重置搜索
                    </button>
                </div>

            </div>
        </form>
    </div>
</div>
<div class="layui-card">
    <div class="layui-card-body">
        <table id="user-table" lay-filter="user-table"></table>
    </div>
</div>

<script type="text/html" id="user-toolbar">
    <button class="pear-btn pear-btn-danger pear-btn-md" lay-event="batchRemove">
        <i class="layui-icon layui-icon-delete"></i>
        批量删除
    </button>
</script>

<script type="text/html" id="user-bar">
    <button class="pear-btn pear-btn-primary pear-btn-sm" title="下载文件" lay-event="download"><i class="layui-icon layui-icon-download-circle"></i></button>
    <button class="pear-btn pear-btn-primary pear-btn-sm" title="查看文件" lay-event="info"><i class="layui-icon layui-icon-form"></i></button>
    <button class="pear-btn pear-btn-danger pear-btn-sm" title="删除文件" lay-event="remove"><i class="layui-icon layui-icon-delete"></i></button>
</script>

<script type="text/html" id="file-icon">
    <img src="{{ d.icon }}">
</script>

<script src="/static/component/layui/layui.js"></script>
<script src="/static/component/pear/pear.js"></script>
<script>
    layui.use(['table', 'form', 'jquery','common','laydate'], function() {
        let table = layui.table;
        let form = layui.form;
        let $ = layui.jquery;
        let common = layui.common;
        var laydate = layui.laydate;

        laydate.render({
            elem: '#test6'
            ,range: ['#test-startDate-1', '#test-endDate-1']
        });

        let cols = [
            [{type: 'checkbox'},
                {title: '', field: 'icon', align: 'center',width: 40,templet: '#file-icon'},
                {title: '文件名', field: 'origin_name',width: 300, align: 'left'},
                {title: '大小', field: 'size', align: 'center'},
                {title: '上传用户', field: 'uid', align: 'center'},
                {title: '储存服务器', field: 'policy_id', align: 'center'},
                {title: '文件后缀', field: 'ext', align: 'center'},
                {title: '下载量', field: 'count_down', align: 'center'},
                {title: '浏览量', field: 'count_open', align: 'center'},
                {title: '上传时间', field: 'create_time', align: 'center'},
                {title: '操作', toolbar: '#user-bar', align: 'center', width: 160}
            ]
        ]

        table.render({
            elem: '#user-table',
            url: "<?php echo url('file/index'); ?>",
            page: true,
            cols: cols,
            skin: 'line',
            limit:20,
            toolbar: '#user-toolbar',
            defaultToolbar: [{
                title: '刷新',
                layEvent: 'refresh',
                icon: 'layui-icon-refresh',
            }, 'print', 'exports']
        });

        table.on('tool(user-table)', function(obj) {
            if (obj.event === 'remove') {
                window.remove(obj);
            } else if(obj.event === 'info'){
                window.info(obj);
            } else if (obj.event === 'download') {
                window.download(obj);
            }
        });

        table.on('toolbar(user-table)', function(obj) {
            if (obj.event === 'refresh') {
                window.refresh();
            } else if (obj.event === 'batchRemove') {
                window.batchRemove(obj);
            }
        });

        form.on('submit(user-query)', function(data) {
            table.reload('user-table', {
                where: data.field
            })
            return false;
        });


        window.info = function(obj) {
            layer.open({
                type: 2,
                title: '文件信息',
                shade: 0.1,
                area: ['600px', '600px'],
                content: "<?php echo url('file/info'); ?>?id=" + obj.data['id']
            });
        }

        window.download = function(obj) {
            window.open("<?php echo url('file/download'); ?>?id=" + obj.data['id']);
        }

        window.remove = function(obj) {
            layer.confirm('确定要删除该文件吗？', {
                icon: 3,
                title: '提示'
            }, function(index) {
                layer.close(index);
                let loading = layer.load();
                $.ajax({
                    url: "<?php echo url('file/delete'); ?>?ids=" + obj.data['id'],
                    dataType: 'json',
                    type: 'get',
                    success: function(result) {
                        layer.close(loading);
                        if (result.code == 200) {
                            layer.msg(result.msg, {
                                icon: 1,
                                time: 1000
                            }, function() {
                                obj.del();
                            });
                        } else {
                            layer.msg(result.msg, {
                                icon: 2,
                                time: 1000
                            });
                        }
                    }
                })
            });
        }

        window.batchRemove = function(obj) {

            var checkIds = common.checkField(obj,'id');

            if (checkIds === "") {
                layer.msg("未选中数据", {
                    icon: 3,
                    time: 1000
                });
                return false;
            }

            layer.confirm('确定要删除这些文件[' + checkIds + ']吗?', {
                icon: 3,
                title: '提示'
            }, function(index) {
                layer.close(index);
                let loading = layer.load();
                $.ajax({
                    url: "<?php echo url('file/delete'); ?>?ids=" + checkIds,
                    dataType: 'json',
                    type: 'get',
                    success: function(result) {
                        layer.close(loading);
                        if (result.code == 200) {
                            layer.msg(result.msg, {
                                icon: 1,
                                time: 1000
                            }, function() {
                                table.reload('user-table');
                            });
                        } else {
                            layer.msg(result.msg, {
                                icon: 2,
                                time: 1000
                            });
                        }
                    }
                })
            });
        }

        window.refresh = function(param) {
            table.reload('user-table');
        }
    })
</script>
</body>
</html>
