<?php /*a:1:{s:68:"/www/wwwroot/127.0.0.1/application/admin/view/order/index.html";i:1658883146;}*/ ?>
<!DOCTYPE html>

<html>
<head>
<meta charset="utf-8">
<title></title>
<link rel="stylesheet" href="/static/component/pear/css/pear.css" />
</head>

<body class="pear-container">
<div class="layui-card">
    <div class="layui-card-body">
        <form class="layui-form" action="">
            <div class="layui-form-item">
                <div class="layui-form-item layui-inline">
                    <label class="layui-form-label">搜索类型</label>
                    <div class="layui-input-inline">
                        <select name="search_type" lay-verify="required">
                            <option value="trade_no">订单号</option>
                            <option value="out_trade_no">支付订单号</option>
                        </select>
                    </div>
                </div>
                <div class="layui-form-item layui-inline">
                    <label class="layui-form-label">支付状态</label>
                    <div class="layui-input-inline">
                        <select name="status" lay-verify="required">
                            <option value="0">等待支付</option>
                            <option value="1">支付成功</option>
                            <option value="2">订单关闭</option>
                        </select>
                    </div>
                </div>
                <div class="layui-form-item layui-inline">
                    <label class="layui-form-label">搜索内容</label>
                    <div class="layui-input-inline">
                        <input type="text" name="search_value" placeholder="请输入搜索内容" class="layui-input">
                    </div>
                </div>
                <div class="layui-form-item layui-inline">
                    <button class="pear-btn pear-btn-md pear-btn-primary" lay-submit lay-filter="user-query"> <i class="layui-icon layui-icon-search"></i> 搜索结果 </button>
                    <button type="reset" class="pear-btn pear-btn-md"> <i class="layui-icon layui-icon-refresh"></i> 重置搜索 </button>
                </div>
            </div>
        </form>
    </div>
</div>
<div class="layui-card">
    <div class="layui-card-body">
        <table id="user-table" lay-filter="user-table">
        </table>
    </div>
</div>
<script type="text/html" id="user-toolbar">

    <button class="pear-btn pear-btn-danger pear-btn-md" lay-event="batchRemove">

        <i class="layui-icon layui-icon-delete"></i>

        批量删除

    </button>

</script> 
<script type="text/html" id="user-bar">

    <button class="pear-btn pear-btn-danger pear-btn-sm" lay-event="remove"><i class="layui-icon layui-icon-delete"></i></button>

</script> 
<script type="text/html" id="user-auth">

    {{#if (d.status == 0) { }}

    <span class="layui-badge layui-bg-orange">等待支付</span>

    {{# }else if(d.status == 1){ }}

    <span class="layui-badge layui-bg-blue">支付完成</span>

    {{# }else if(d.status == 2){ }}

    <span class="layui-badge layui-bg-red">订单关闭</span>

    {{# } }}

</script> 
<script src="/static/component/layui/layui.js"></script> 
<script src="/static/component/pear/pear.js"></script> 
<script>

    layui.use(['table', 'form', 'jquery','common'], function() {
        let table = layui.table;
        let form = layui.form;
        let $ = layui.jquery;
        let common = layui.common;

        let cols = [
            [{type: 'checkbox'},
                {title: '订单号', field: 'trade_no', align: 'center', width: 250},
                {title: '开通用户', field: 'uid', align: 'center'},
                {title: '支付方式', field: 'type', align: 'center'},
                {title: '支付金额', field: 'money', align: 'center'},
                {title: '开通时长', field: 'vip_day', align: 'center'},
                {title: '支付订单号', field: 'out_trade_no', align: 'center'},
                {title: '支付状态', field: 'status', align: 'center', templet: '#user-auth'},
                {title: '发起时间', field: 'create_time', align: 'center'},
                {title: '支付时间', field: 'pay_time', align: 'center'},
                {title: '操作', toolbar: '#user-bar', align: 'center', width: 130}
            ]
        ]

        table.render({
            elem: '#user-table',
            url: "<?php echo url('order/index'); ?>",
            page: true,
            limit: 20,
            cols: cols,
            skin: 'line',
            toolbar: '#user-toolbar',
            defaultToolbar: [{
                title: '刷新',
                layEvent: 'refresh',
                icon: 'layui-icon-refresh',
            }, 'filter', 'print', 'exports']
        });


        table.on('tool(user-table)', function(obj) {
            if (obj.event === 'remove') {
                window.remove(obj);
            }
        });

        table.on('toolbar(user-table)', function(obj) {
            if (obj.event === 'refresh') {
                window.refresh();
            } else if (obj.event === 'batchRemove') {
                window.batchRemove(obj);
            }
        });

        form.on('submit(user-query)', function(data) {
            table.reload('user-table', {
                where: data.field
            })
            return false;
        });

        window.remove = function(obj) {
            layer.confirm('确定要删除订单吗？<br><b style="color: red">请勿删除正在等待支付或者支付完成的订单</b>', {
                icon: 3,
                title: '提示'
            }, function(index) {
                layer.close(index);
                let loading = layer.load();
                $.ajax({
                    url: "<?php echo url('order/delete'); ?>?ids=" + obj.data['id'],
                    dataType: 'json',
                    type: 'get',
                    success: function(result) {
                        layer.close(loading);
                        if (result.code == 200) {
                            layer.msg(result.msg, {
                                icon: 1,
                                time: 1000
                            }, function() {
                                obj.del();
                            });
                        } else {
                            layer.msg(result.msg, {
                                icon: 2,
                                time: 1000
                            });
                        }
                    }
                })
            });
        }

       window.batchRemove = function(obj) {
            var checkIds = common.checkField(obj,'id');
            if (checkIds === "") {
                layer.msg("未选中数据", {icon: 3,time: 1000});
                return false;
            }
            layer.confirm('确定要批量删除这些订单吗？<br><b style="color: red">请勿删除正在等待支付或者支付完成的订单</b>', {
                icon: 3,
                title: '提示'
            }, function(index) {
                layer.close(index);
                let loading = layer.load();
                $.ajax({
                    url: "<?php echo url('order/delete'); ?>?ids=" + checkIds,
                    dataType: 'json',
                    type: 'get',
                    success: function(result) {
                        layer.close(loading);
                        if (result.code == 200) {
                            layer.msg(result.msg, {
                                icon: 1,
                                time: 1000
                            }, function() {
                                table.reload('user-table');
                            });
                        } else {
                            layer.msg(result.msg, {
                                icon: 2,
                                time: 1000
                            });
                        }
                    }
                })
            });
        }

        window.refresh = function(param) {
            table.reload('user-table');
        }
    })
</script>
</body>
</html>
