/*
 Navicat Premium Data Transfer

 Source Server         : 127.0.0.1
 Source Server Type    : MySQL
 Source Server Version : 50726
 Source Host           : 127.0.0.1:3306
 Source Schema         : demo

 Target Server Type    : MySQL
 Target Server Version : 50726
 File Encoding         : 65001

 Date: 19/08/2023 10:44:51
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for sk_auth
-- ----------------------------
DROP TABLE IF EXISTS `sk_auth`;
CREATE TABLE `sk_auth`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '临时UUID',
  `share_id` int(11) NOT NULL COMMENT '分享ID',
  `openid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '微信openid',
  `userid` int(11) NOT NULL DEFAULT 0 COMMENT '用户ID',
  `create_time` int(11) NOT NULL DEFAULT 0 COMMENT '时间',
  `status` tinyint(1) NOT NULL DEFAULT 0 COMMENT '状态 0 未扫码 1扫码成功',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 459 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '扫码登录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sk_auth
-- ----------------------------

-- ----------------------------
-- Table structure for sk_certify
-- ----------------------------
DROP TABLE IF EXISTS `sk_certify`;
CREATE TABLE `sk_certify`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT 0 COMMENT '实名用户',
  `name` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '姓名',
  `idcard` varchar(18) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '身份证号码',
  `create_time` int(11) NOT NULL DEFAULT 0 COMMENT '提交时间',
  `status` tinyint(1) NOT NULL DEFAULT 0 COMMENT '实名状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '实名认证表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sk_certify
-- ----------------------------

-- ----------------------------
-- Table structure for sk_folders
-- ----------------------------
DROP TABLE IF EXISTS `sk_folders`;
CREATE TABLE `sk_folders`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT 0 COMMENT '目录所有人',
  `shares_id` int(11) NOT NULL DEFAULT 0 COMMENT '分享id',
  `folder_name` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '目录名称',
  `parent_folder` int(11) NOT NULL DEFAULT 0 COMMENT '上级目录',
  `desc` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '描述',
  `size` int(11) NOT NULL DEFAULT 0,
  `ext` int(11) NOT NULL DEFAULT 755,
  `count_down` int(11) NOT NULL DEFAULT 0 COMMENT '下载统计',
  `count_open` int(11) NOT NULL DEFAULT 0 COMMENT '浏览统计',
  `create_time` int(11) NOT NULL DEFAULT 0 COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT 0 COMMENT '更新时间',
  `delete_time` int(11) NULL DEFAULT NULL COMMENT '软删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 35 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '文件夹' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sk_folders
-- ----------------------------
INSERT INTO `sk_folders` VALUES (1, 2, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1658115118, 0, NULL);
INSERT INTO `sk_folders` VALUES (2, 2, 122, '其他源码', 1, '', 0, 755, 0, 0, 1658281874, 1658281874, NULL);
INSERT INTO `sk_folders` VALUES (3, 2, 123, '小程序源码', 1, '', 0, 755, 0, 3, 1658282367, 1658629440, NULL);
INSERT INTO `sk_folders` VALUES (4, 2, 124, '支付源码', 1, '', 0, 755, 0, 3, 1658284417, 1658284782, NULL);
INSERT INTO `sk_folders` VALUES (5, 2, 125, '影视音乐源码', 1, '', 0, 755, 0, 0, 1658284810, 1658284810, NULL);
INSERT INTO `sk_folders` VALUES (6, 2, 126, '金融理财', 1, '', 0, 755, 0, 0, 1658284822, 1658284822, NULL);
INSERT INTO `sk_folders` VALUES (7, 2, 127, 'HTML源码', 1, '', 0, 755, 0, 0, 1658284833, 1658284833, NULL);
INSERT INTO `sk_folders` VALUES (8, 2, 128, '博客论坛', 1, '', 0, 755, 0, 0, 1658284841, 1658284841, NULL);
INSERT INTO `sk_folders` VALUES (9, 2, 129, '企业源码', 1, '', 0, 755, 0, 0, 1658284847, 1658284847, NULL);
INSERT INTO `sk_folders` VALUES (10, 2, 130, '交友直播源码', 1, '', 0, 755, 0, 0, 1658284855, 1658284855, NULL);
INSERT INTO `sk_folders` VALUES (11, 2, 131, '商城源码', 1, '', 0, 755, 0, 0, 1658284864, 1658284864, NULL);
INSERT INTO `sk_folders` VALUES (12, 2, 132, '图片小说源码', 1, '', 0, 755, 0, 0, 1658284870, 1658284870, NULL);
INSERT INTO `sk_folders` VALUES (13, 2, 133, 'H5源码', 1, '', 0, 755, 0, 2, 1658284876, 1658284876, NULL);
INSERT INTO `sk_folders` VALUES (14, 3, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1658401835, 0, NULL);
INSERT INTO `sk_folders` VALUES (15, 4, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1658422579, 0, NULL);
INSERT INTO `sk_folders` VALUES (16, 5, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1658453083, 0, NULL);
INSERT INTO `sk_folders` VALUES (17, 6, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1658502295, 0, NULL);
INSERT INTO `sk_folders` VALUES (18, 7, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1658552134, 0, NULL);
INSERT INTO `sk_folders` VALUES (19, 8, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1658569411, 0, NULL);
INSERT INTO `sk_folders` VALUES (20, 9, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1658616714, 0, NULL);
INSERT INTO `sk_folders` VALUES (21, 10, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1658854182, 0, NULL);
INSERT INTO `sk_folders` VALUES (22, 11, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1658886916, 0, NULL);
INSERT INTO `sk_folders` VALUES (23, 12, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1658887846, 0, NULL);
INSERT INTO `sk_folders` VALUES (24, 13, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1659572810, 0, NULL);
INSERT INTO `sk_folders` VALUES (25, 14, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1659667385, 0, NULL);
INSERT INTO `sk_folders` VALUES (26, 15, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1659667638, 0, NULL);
INSERT INTO `sk_folders` VALUES (27, 16, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1659667727, 0, NULL);
INSERT INTO `sk_folders` VALUES (28, 17, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1659667868, 0, NULL);
INSERT INTO `sk_folders` VALUES (29, 18, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1675175364, 0, NULL);
INSERT INTO `sk_folders` VALUES (30, 19, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1675207914, 0, NULL);
INSERT INTO `sk_folders` VALUES (31, 20, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1683440821, 0, NULL);
INSERT INTO `sk_folders` VALUES (32, 21, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1683446813, 0, NULL);
INSERT INTO `sk_folders` VALUES (33, 22, 0, '根目录', 0, NULL, 0, 755, 0, 0, 1692411680, 0, NULL);
INSERT INTO `sk_folders` VALUES (34, 22, 258, '1', 33, '', 0, 755, 0, 0, 1692412925, 1692412925, NULL);

-- ----------------------------
-- Table structure for sk_groups
-- ----------------------------
DROP TABLE IF EXISTS `sk_groups`;
CREATE TABLE `sk_groups`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '用户组名称',
  `policy_id` int(11) NOT NULL DEFAULT 0 COMMENT '存储策略ID',
  `max_storage` bigint(20) NOT NULL DEFAULT 0 COMMENT '最大存储',
  `speed` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '下载限速',
  `allow_share` tinyint(1) NOT NULL DEFAULT 0 COMMENT '允许分享',
  `is_sys` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否为系统用户组',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 5 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户组' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sk_groups
-- ----------------------------
INSERT INTO `sk_groups` VALUES (1, '管理员', 1, 1073741824, '', 1, 1);
INSERT INTO `sk_groups` VALUES (2, '游客', 1, 0, '1', 0, 1);
INSERT INTO `sk_groups` VALUES (3, '普通用户', 1, 209715200, '1', 1, 1);
INSERT INTO `sk_groups` VALUES (4, 'VIP用户', 1, 1073741824, '', 1, 0);

-- ----------------------------
-- Table structure for sk_order
-- ----------------------------
DROP TABLE IF EXISTS `sk_order`;
CREATE TABLE `sk_order`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT 0 COMMENT '开通用户',
  `trade_no` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '订单号',
  `out_trade_no` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '易支付订单号',
  `type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '支付方式',
  `profit_id` int(11) NOT NULL DEFAULT 0 COMMENT '收益链接ID',
  `money` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '支付金额',
  `vip_day` int(11) NOT NULL DEFAULT 0 COMMENT 'VIP时长',
  `create_time` int(11) NOT NULL DEFAULT 0 COMMENT '创建时间',
  `pay_time` int(11) NOT NULL DEFAULT 0 COMMENT '支付时间',
  `status` tinyint(3) NOT NULL DEFAULT 0 COMMENT '支付状态 0 等待支付 1支付成功 2订单关闭',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 48 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '订单记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sk_order
-- ----------------------------

-- ----------------------------
-- Table structure for sk_policys
-- ----------------------------
DROP TABLE IF EXISTS `sk_policys`;
CREATE TABLE `sk_policys`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '上传策略名称',
  `type` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '上传策略类型',
  `filetype` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '允许上传的类型',
  `max_size` bigint(20) NOT NULL DEFAULT 0 COMMENT '单文件最大大小',
  `config` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '配置信息',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 7 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '储存策略' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sk_policys
-- ----------------------------
INSERT INTO `sk_policys` VALUES (1, '默认存储', 'local', 'apk,code,excel,exe,fonts.img,ipa,ipa,links,music,ppt,ps,text,unknown,video,word,zip,rar,tar.gz,folder,png', 2097152, '{\"save_dir\":\"\\/uploads\\/\"}');
INSERT INTO `sk_policys` VALUES (3, '远程服务器一', 'remote', '', 1073741824, '{\"save_dir\":\"\\/upload\\/\",\"access_token\":\"SSq2reS4agz0Je7qdQ3tyrjaXiawTtvO6\",\"server_uri\":\"https:\\/\\/vip.yidaotang.vip\\/\"}');
INSERT INTO `sk_policys` VALUES (4, '阿里云(请勿修改)', 'aliyunoss', 'apk,code,excel,exe,fonts.img,ipa,ipa,links,music,ppt,ps,text,unknown,video,word,zip.rar,tar.gz,folder.png', 0, '{\"save_dir\":\"\\/uploads\\/\",\"endpoint\":\"oss-cn-beijing.aliyuncs.com\",\"bucket\":\"gsyp\",\"access_key\":\"LTAI5tQ1ctsoPyLR2wUNnQGs\",\"access_secret\":\"AK0m6wtg0XuoLCwiTUVyE3DpxdUVJD\"}');
INSERT INTO `sk_policys` VALUES (5, '腾讯云', 'txyunoss', 'apk,code,excel,exe,fonts.img,ipa,ipa,links,music,ppt,ps,text,unknown,video,word,zip.rar,tar.gz,folder.png', 0, '{\"save_dir\":\"\\/uploads\\/\",\"secret_id\":\"AKIDnRowoOhkW0D9pDKAj12lEQLyKQFm21j9\",\"secret_key\":\"A4g15rMaXDckcFbgU1HFwMVMwEFzSeaF\",\"bucket\":\"apcms-1307163100\",\"region\":\"ap-nanjing\"}');
INSERT INTO `sk_policys` VALUES (6, '远程服务器二', 'remote', '', 0, '{\"save_dir\":\"chunks\",\"access_token\":\"SSq2reS4agz0Je7qdQ3tyrjaXiawTtvO6\",\"server_uri\":\"https:\\/\\/vip2.yidaotang.vip\\/\"}');

-- ----------------------------
-- Table structure for sk_profit
-- ----------------------------
DROP TABLE IF EXISTS `sk_profit`;
CREATE TABLE `sk_profit`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT 0 COMMENT '用户ID',
  `file_id` int(11) NOT NULL DEFAULT 0 COMMENT '文件ID',
  `count_view` int(11) NOT NULL DEFAULT 0 COMMENT '浏览量',
  `count_down` int(11) NOT NULL DEFAULT 0 COMMENT '下载量',
  `count_reg` int(11) NOT NULL DEFAULT 0 COMMENT '注册量',
  `count_order` int(11) NOT NULL DEFAULT 0 COMMENT '总订单',
  `count_order_yes` int(11) NOT NULL DEFAULT 0 COMMENT '成功订单',
  `count_money` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '金额',
  `count_profit` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '收益',
  `create_time` int(11) NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 67 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '收益记录' ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of sk_profit
-- ----------------------------
INSERT INTO `sk_profit` VALUES (58, 12, 236, 13, 0, 0, 0, 0, 0.00, 0.00, 1659510369);
INSERT INTO `sk_profit` VALUES (60, 13, 237, 3, 0, 0, 0, 0, 0.00, 0.00, 1659633443);
INSERT INTO `sk_profit` VALUES (57, 12, 236, 26, 1, 1, 0, 0, 0.00, 0.00, 1659073013);
INSERT INTO `sk_profit` VALUES (59, 13, 237, 23, 2, 0, 0, 0, 0.00, 0.00, 1659572856);
INSERT INTO `sk_profit` VALUES (61, 18, 238, 3, 0, 0, 0, 0, 0.00, 0.00, 1675176979);
INSERT INTO `sk_profit` VALUES (62, 19, 239, 2, 0, 0, 0, 0, 0.00, 0.00, 1675259925);
INSERT INTO `sk_profit` VALUES (63, 20, 240, 1, 0, 0, 0, 0, 0.00, 0.00, 1683441179);
INSERT INTO `sk_profit` VALUES (64, 21, 242, 2, 0, 0, 0, 0, 0.00, 0.00, 1683446868);
INSERT INTO `sk_profit` VALUES (65, 22, 244, 18, 4, 0, 0, 0, 0.00, 0.00, 1692411823);
INSERT INTO `sk_profit` VALUES (66, 22, 245, 1, 0, 0, 0, 0, 0.00, 0.00, 1692412960);

-- ----------------------------
-- Table structure for sk_record
-- ----------------------------
DROP TABLE IF EXISTS `sk_record`;
CREATE TABLE `sk_record`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT 0,
  `type` tinyint(1) NOT NULL DEFAULT 0 COMMENT '0 增加 1减少',
  `source` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来源',
  `money` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '变更金额',
  `after_money` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '变更前',
  `before_money` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '变更后金额',
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作原因',
  `create_time` int(11) NOT NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '财务记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sk_record
-- ----------------------------

-- ----------------------------
-- Table structure for sk_reports
-- ----------------------------
DROP TABLE IF EXISTS `sk_reports`;
CREATE TABLE `sk_reports`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shares_id` int(11) NOT NULL DEFAULT 0 COMMENT '资源ID',
  `source_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件名',
  `source_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '链接地址',
  `source_uid` int(11) NOT NULL DEFAULT 0 COMMENT '所属用户UID',
  `source_username` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '所属用户帐号',
  `source_type` tinyint(1) NOT NULL DEFAULT 0 COMMENT '0 文件 1目录',
  `type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '举报类型',
  `contact` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '联系方式',
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '详细描述',
  `create_time` int(11) NOT NULL DEFAULT 0 COMMENT '举报时间',
  `real_ip` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '举报IP',
  `status` tinyint(1) NOT NULL DEFAULT 0 COMMENT '举报处理',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '文件举报' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sk_reports
-- ----------------------------

-- ----------------------------
-- Table structure for sk_setting
-- ----------------------------
DROP TABLE IF EXISTS `sk_setting`;
CREATE TABLE `sk_setting`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `set_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '配置名称',
  `set_value` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '配置值',
  `set_type` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '配置类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 84 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '系统配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sk_setting
-- ----------------------------
INSERT INTO `sk_setting` VALUES (1, 'site_name', '分享赚钱，让资源变有价值！', 'basic');
INSERT INTO `sk_setting` VALUES (2, 'site_keywords', '本地网盘 | 新版网盘站测试 | 网络云盘 | 网盘联盟 | 网赚网盘 | 云盘 | 云存储', 'basic');
INSERT INTO `sk_setting` VALUES (3, 'site_desc', '本地网盘测试是一款速度快、不打扰、够安全、易于分享的网络云盘,提供了分享下载分成功能,分享赚钱,让资源变的有收益有价值!', 'basic');
INSERT INTO `sk_setting` VALUES (4, 'site_head', '', 'basic');
INSERT INTO `sk_setting` VALUES (5, 'site_foot', '', 'basic');
INSERT INTO `sk_setting` VALUES (6, 'allow_register', '1', 'register');
INSERT INTO `sk_setting` VALUES (7, 'login_captcha', '1', 'register');
INSERT INTO `sk_setting` VALUES (8, 'default_group', '3', 'register');
INSERT INTO `sk_setting` VALUES (9, 'register_captcha', '1', 'register');
INSERT INTO `sk_setting` VALUES (10, 'forget_captcha', '0', 'register');
INSERT INTO `sk_setting` VALUES (11, 'site_title', '本地网盘', 'basic');
INSERT INTO `sk_setting` VALUES (12, 'site_logo', '/assets/logo/logo.png', 'basic');
INSERT INTO `sk_setting` VALUES (13, 'api_gateway', 'https://127.0.0.1/', 'pay');
INSERT INTO `sk_setting` VALUES (14, 'api_pid', '2016', 'pay');
INSERT INTO `sk_setting` VALUES (15, 'api_type', 'wxpay,alipay', 'pay');
INSERT INTO `sk_setting` VALUES (16, 'api_key', '4OivllybodkQ5htzLiyBzbxzcTmArMXZ', 'pay');
INSERT INTO `sk_setting` VALUES (17, 'vip_group', '4', 'vip');
INSERT INTO `sk_setting` VALUES (18, 'vip_rule', '一天VIP|5|1|天|7.0|立省 10元 原价15元|高速多线程下载文件，无优惠。|1\n月付VIP|15|30|月|6.3|立省175元 仅 1.33元/月|高速多线程下载文件，比周付省11%。|0\n半年VIP|35|180|半年|5.2|立省165元 仅 5.83元/月|高速多线程下载文件，比月付省55%。|1\n一年VIP|50|360|年|4.7|立省420元 原价450元|高速多线程下载文件，比月付省50%。|0\n永久VIP|69|9999|永久|2.7|立省741元 原价800元|高速多线程下载文件，比年付省96%。|1', 'vip');
INSERT INTO `sk_setting` VALUES (19, 'site_email', '190066120@qq.com', 'basic');
INSERT INTO `sk_setting` VALUES (20, 'smtp_host', 'smtp.qq.com', 'email');
INSERT INTO `sk_setting` VALUES (21, 'smtp_port', '465', 'email');
INSERT INTO `sk_setting` VALUES (22, 'nickname', '狗凯之家', 'email');
INSERT INTO `sk_setting` VALUES (23, 'username', '190066120@qq.com', 'email');
INSERT INTO `sk_setting` VALUES (24, 'password', 'homqvzybyddncdif', 'email');
INSERT INTO `sk_setting` VALUES (25, 'template_forget', '<p>&nbsp;</p>\n<table class=\"body-wrap\" style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; width: 100%; background-color: #f6f6f6; margin: 0;\" bgcolor=\"#f6f6f6\">\n<tbody>\n<tr style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;\">\n<td style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; vertical-align: top; margin: 0;\" valign=\"top\">&nbsp;</td>\n<td class=\"container\" style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; vertical-align: top; display: block !important; max-width: 600px !important; clear: both !important; margin: 0 auto;\" valign=\"top\" width=\"600\">\n<div class=\"content\" style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; max-width: 600px; display: block; margin: 0 auto; padding: 20px;\">\n<table class=\"main\" style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; border-radius: 3px; background-color: #fff; margin: 0; border: 1px solid #e9e9e9;\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#fff\">\n<tbody>\n<tr style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;\">\n<td class=\"alert alert-warning\" style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 16px; vertical-align: top; color: #fff; font-weight: 500; text-align: center; border-radius: 3px 3px 0 0; background-color: #2196f3; margin: 0; padding: 20px;\" align=\"center\" valign=\"top\" bgcolor=\"#FF9F00\">找回密码验证 -【{site_title}】</td>\n</tr>\n<tr style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;\">\n<td class=\"content-wrap\" style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; vertical-align: top; margin: 0; padding: 20px;\" valign=\"top\">\n<table style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;\">\n<td class=\"content-block\" style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; vertical-align: top; margin: 0; padding: 0 0 20px;\" valign=\"top\">亲爱的 <strong style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;\"> {username} </strong> ：</td>\n</tr>\n<tr style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;\">\n<td class=\"content-block\" style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; vertical-align: top; margin: 0; padding: 0 0 20px;\" valign=\"top\">请点击下方按钮完成密码重设。十分钟之内有效，如果非你本人操作，请忽略此邮件。</td>\n</tr>\n<tr style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;\">\n<td class=\"content-block\" style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; vertical-align: top; margin: 0; padding: 20px 20px 50px 20px; text-align: center;\" valign=\"top\"><a class=\"btn-primary\" style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; color: #fff; font-weight: bolder; letter-spacing: 2px; text-decoration: none; height: 45px; line-height: 45px; padding: 0 15px; text-align: center; cursor: pointer; display: inline-block; border-radius: 5px; text-transform: capitalize; background-color: #2196f3; margin: 0;\" href=\"{url}\"> 点击设置新密码 </a></td>\n</tr>\n<tr style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;\">\n<td class=\"content-block\" style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; vertical-align: top; margin: 0; padding: 0 0 20px;\" valign=\"top\">感谢您选择<strong>{site_title}</strong>。</td>\n</tr>\n</tbody>\n</table>\n</td>\n</tr>\n</tbody>\n</table>\n<div class=\"footer\" style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; width: 100%; clear: both; color: #999; margin: 0; padding: 20px;\">\n<table style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;\" width=\"100%\">\n<tbody>\n<tr style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; margin: 0;\">\n<td class=\"aligncenter content-block\" style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 12px; vertical-align: top; color: #999; text-align: center; margin: 0; padding: 0 0 20px;\" align=\"center\" valign=\"top\">此邮件由系统自动发送，请不要直接回复。</td>\n</tr>\n</tbody>\n</table>\n<br /><br /></div>\n</div>\n</td>\n<td style=\"font-family: \'Helvetica Neue\',Helvetica,Arial,sans-serif; box-sizing: border-box; font-size: 14px; vertical-align: top; margin: 0;\" valign=\"top\">&nbsp;</td>\n</tr>\n</tbody>\n</table>', 'email');
INSERT INTO `sk_setting` VALUES (26, 'site_kefu', '客服QQ：<span style=\'color:red;font-size:15px\'>190066120</span><br/><br/>客服在线时间：早上9点-晚上22点<br/><br/>如遇到任何问题请联系客服处理<br/>对此给您带来的不便深感抱歉', 'basic');
INSERT INTO `sk_setting` VALUES (27, 'vip_profit', '20', 'vip');
INSERT INTO `sk_setting` VALUES (28, 'index_theme', 'default', 'basic');
INSERT INTO `sk_setting` VALUES (29, 'pay_type', '0', 'pay');
INSERT INTO `sk_setting` VALUES (30, 'login_weixin', '1', 'register');
INSERT INTO `sk_setting` VALUES (31, 'weixin_appid', 'wx18c0c9a48502da05', 'pay');
INSERT INTO `sk_setting` VALUES (32, 'weixin_appsecret', 'e01c54a045341d9363a764477a5cbe9c', 'pay');
INSERT INTO `sk_setting` VALUES (33, 'weixin_mchid', '1608446132', 'pay');
INSERT INTO `sk_setting` VALUES (34, 'weixin_key', '1234567890qwertyuiopASDFGHJKLzxc', 'pay');
INSERT INTO `sk_setting` VALUES (35, 'alipay_email', '17607930447', 'pay');
INSERT INTO `sk_setting` VALUES (36, 'alipay_parterid', '2088422867916643', 'pay');
INSERT INTO `sk_setting` VALUES (37, 'alipay_key', 'cuvlo79v63obw4pl6i9ttq4rd736btpj', 'pay');
INSERT INTO `sk_setting` VALUES (38, 'wx_appid', 'wx76e254237d49badb', 'register');
INSERT INTO `sk_setting` VALUES (39, 'wx_secret', '12bb7e0c7e75e6d7fae9766894179170', 'register');
INSERT INTO `sk_setting` VALUES (40, 'wx_token', 'kjDH1IvDwrBEmsgFODw7rBpbtrpc1Ze6', 'register');
INSERT INTO `sk_setting` VALUES (80, 'site_zydb', '本地网盘', 'basic');
INSERT INTO `sk_setting` VALUES (81, 'site_beian', '京ICP备4545号', 'basic');
INSERT INTO `sk_setting` VALUES (83, 'site_tel', '454545', 'basic');

-- ----------------------------
-- Table structure for sk_shares
-- ----------------------------
DROP TABLE IF EXISTS `sk_shares`;
CREATE TABLE `sk_shares`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT 0 COMMENT '用户ID',
  `source_id` int(11) NOT NULL DEFAULT 0 COMMENT '文件 / 目录ID',
  `type` tinyint(1) NOT NULL DEFAULT 0 COMMENT '0 文件 1目录',
  `speed` tinyint(1) NOT NULL DEFAULT 0 COMMENT '限速开关',
  `code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '短网址代码',
  `pwd` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分享密码',
  `pwd_status` tinyint(1) NOT NULL DEFAULT 0 COMMENT '密码状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 260 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '分享表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sk_shares
-- ----------------------------
INSERT INTO `sk_shares` VALUES (1, 2, 1, 0, 0, 'ZFbyUr9USt', 'Ovfk', 0);
INSERT INTO `sk_shares` VALUES (2, 2, 2, 0, 0, 'bimU7zETkM', 'y2FI', 0);
INSERT INTO `sk_shares` VALUES (3, 2, 3, 0, 0, 'qIjuYvZVkS', 'lUnL', 0);
INSERT INTO `sk_shares` VALUES (4, 2, 4, 0, 0, '2eIryepveA', 'ElGR', 0);
INSERT INTO `sk_shares` VALUES (5, 2, 5, 0, 0, 'mEvqI3XGcf', 'zo6I', 0);
INSERT INTO `sk_shares` VALUES (6, 2, 6, 0, 0, 'EryIFjDG0T', 'xRju', 0);
INSERT INTO `sk_shares` VALUES (7, 2, 7, 0, 0, 'reQJZfEu1v', 'lmdn', 0);
INSERT INTO `sk_shares` VALUES (8, 2, 8, 0, 0, 'BNfIfaOSPB', 'ywJM', 0);
INSERT INTO `sk_shares` VALUES (9, 2, 9, 0, 0, 'fEza2qdKUX', 'vmMQ', 0);
INSERT INTO `sk_shares` VALUES (10, 2, 10, 0, 0, 'biYRFf2rZn', 'v28l', 0);
INSERT INTO `sk_shares` VALUES (11, 2, 11, 0, 0, 'yINbmiJ9yr', 'cgOX', 0);
INSERT INTO `sk_shares` VALUES (12, 2, 12, 0, 0, 'JbeINfrj7s', 'g9s2', 0);
INSERT INTO `sk_shares` VALUES (13, 2, 13, 0, 0, 'uE77VbPZeE', 'ArPV', 0);
INSERT INTO `sk_shares` VALUES (14, 2, 14, 0, 0, 'vaQFfyq5pH', '6khR', 0);
INSERT INTO `sk_shares` VALUES (15, 2, 15, 0, 0, '6ZbEjiaPjc', 'U16z', 0);
INSERT INTO `sk_shares` VALUES (16, 2, 16, 0, 0, 'ERvQNb0EAM', '0uCt', 0);
INSERT INTO `sk_shares` VALUES (17, 2, 17, 0, 0, 'jqYnQbdBWl', '7c9R', 0);
INSERT INTO `sk_shares` VALUES (18, 2, 18, 0, 0, 'M3A7RroSIE', 'lFkS', 0);
INSERT INTO `sk_shares` VALUES (19, 2, 19, 0, 0, 'mm2UBbcANf', 'Ocey', 0);
INSERT INTO `sk_shares` VALUES (20, 2, 20, 0, 0, 'bMVnaa26Lr', '4otS', 0);
INSERT INTO `sk_shares` VALUES (21, 2, 21, 0, 0, 'JfMFvymVoj', 'xDMV', 0);
INSERT INTO `sk_shares` VALUES (22, 2, 22, 0, 0, 'nUZVb2GfU6', 'tZ4B', 0);
INSERT INTO `sk_shares` VALUES (23, 2, 23, 0, 0, '3QB3M3Kva7', 'dIPk', 0);
INSERT INTO `sk_shares` VALUES (24, 2, 24, 0, 0, 'q6jYBjsZWA', 'HPe6', 0);
INSERT INTO `sk_shares` VALUES (25, 2, 25, 0, 0, 'VvyyM3ODRm', 'Sz6Z', 0);
INSERT INTO `sk_shares` VALUES (26, 2, 26, 0, 0, 'AfAFVfweBb', 'aHFs', 0);
INSERT INTO `sk_shares` VALUES (27, 2, 27, 0, 0, 'fQbUFf3Dqn', 'UGRO', 0);
INSERT INTO `sk_shares` VALUES (28, 2, 28, 0, 0, 'BrABfqPZc1', 'JfWp', 0);
INSERT INTO `sk_shares` VALUES (29, 2, 29, 0, 0, 'uuQJ3i0IcU', 'dWDE', 0);
INSERT INTO `sk_shares` VALUES (30, 2, 30, 0, 0, 'z6nmqmTALC', 'PtxP', 0);
INSERT INTO `sk_shares` VALUES (31, 2, 31, 0, 0, 'V7v6J36RBF', 'zz68', 0);
INSERT INTO `sk_shares` VALUES (32, 2, 32, 0, 0, '7b2qqq9UHk', '8UHi', 0);
INSERT INTO `sk_shares` VALUES (33, 2, 33, 0, 0, 'F7J3IrhacH', 'inj6', 0);
INSERT INTO `sk_shares` VALUES (34, 2, 34, 0, 0, 'Y3UVb2EmSv', '18NO', 0);
INSERT INTO `sk_shares` VALUES (35, 2, 35, 0, 0, 'vAvURbpK63', 'ORao', 0);
INSERT INTO `sk_shares` VALUES (36, 2, 36, 0, 0, '3aqaamtXje', 'lxeS', 0);
INSERT INTO `sk_shares` VALUES (37, 2, 37, 0, 0, 'AfQruuZ02x', 'm4VQ', 0);
INSERT INTO `sk_shares` VALUES (38, 2, 38, 0, 0, 'qaQrmehUTE', 'Z2MK', 0);
INSERT INTO `sk_shares` VALUES (39, 2, 39, 0, 0, 'BZ7jqe2Pem', 'nDjK', 0);
INSERT INTO `sk_shares` VALUES (40, 2, 40, 0, 0, 'YnUnimVEa8', 'mEGB', 0);
INSERT INTO `sk_shares` VALUES (41, 2, 41, 0, 0, 'f2aueuufWK', 'RHK5', 0);
INSERT INTO `sk_shares` VALUES (42, 2, 42, 0, 0, 'nQ36J3sYFw', 'ZgUo', 0);
INSERT INTO `sk_shares` VALUES (43, 2, 43, 0, 0, 'jyMZrekP8o', 'dWv1', 0);
INSERT INTO `sk_shares` VALUES (44, 2, 44, 0, 0, '3m6BBrnoak', 'GLw5', 0);
INSERT INTO `sk_shares` VALUES (45, 2, 45, 0, 0, 'aU7r2u3h1K', '9XQ9', 0);
INSERT INTO `sk_shares` VALUES (46, 2, 46, 0, 0, 'vQBr6rLMBu', 'ZIgt', 0);
INSERT INTO `sk_shares` VALUES (47, 2, 47, 0, 0, 'jyQZjm5uXR', 'mAJ4', 0);
INSERT INTO `sk_shares` VALUES (48, 2, 48, 0, 0, 'e6jQB3Yp2X', 'o8dN', 0);
INSERT INTO `sk_shares` VALUES (49, 2, 49, 0, 0, '7vYRjqE7zt', 'PZti', 0);
INSERT INTO `sk_shares` VALUES (50, 2, 50, 0, 0, '7Brmiq8PKB', 'AuiS', 0);
INSERT INTO `sk_shares` VALUES (51, 2, 51, 0, 0, 'ZveABnHdUg', 'Xcew', 0);
INSERT INTO `sk_shares` VALUES (52, 2, 52, 0, 0, 'VzQ36bGdx5', '8Gv2', 0);
INSERT INTO `sk_shares` VALUES (53, 2, 53, 0, 0, 'AJ7j2azuYe', 'E8fG', 0);
INSERT INTO `sk_shares` VALUES (54, 2, 54, 0, 0, 'AviEV3BJ2L', 'tQiM', 0);
INSERT INTO `sk_shares` VALUES (55, 2, 55, 0, 0, '7bANNnGski', 'OYiK', 0);
INSERT INTO `sk_shares` VALUES (56, 2, 56, 0, 0, 'rAF7V33xOh', 'jA1i', 0);
INSERT INTO `sk_shares` VALUES (57, 2, 57, 0, 0, 'MjymimixOH', 'DINo', 0);
INSERT INTO `sk_shares` VALUES (58, 2, 58, 0, 0, 'IbI32yZUiR', 'Xjhk', 0);
INSERT INTO `sk_shares` VALUES (59, 2, 59, 0, 0, 'JNvUNzOZby', 'lTkw', 0);
INSERT INTO `sk_shares` VALUES (60, 2, 60, 0, 0, 'qUrARvDJtS', 'bY9N', 0);
INSERT INTO `sk_shares` VALUES (61, 2, 61, 0, 0, 'miUFVrQd9B', 'k1iZ', 0);
INSERT INTO `sk_shares` VALUES (62, 2, 62, 0, 0, 'QbEN3iabUb', 'EQIf', 0);
INSERT INTO `sk_shares` VALUES (63, 2, 63, 0, 0, 'YJvQRzS0tj', 'LTz0', 0);
INSERT INTO `sk_shares` VALUES (64, 2, 64, 0, 0, '6rIriabMDJ', 'xdkk', 0);
INSERT INTO `sk_shares` VALUES (65, 2, 65, 0, 0, 'FvQFjyCWwS', 'Z88J', 0);
INSERT INTO `sk_shares` VALUES (66, 2, 66, 0, 0, 'ZfUJJjUI0a', 'QdqN', 0);
INSERT INTO `sk_shares` VALUES (67, 2, 67, 0, 0, 'vIvQb2l976', 'aivI', 0);
INSERT INTO `sk_shares` VALUES (68, 2, 68, 0, 0, 'umeIjmXRgk', 'Bryk', 0);
INSERT INTO `sk_shares` VALUES (69, 2, 69, 0, 0, 'Bn6Rne5fBP', 'jHiF', 0);
INSERT INTO `sk_shares` VALUES (70, 2, 70, 0, 0, 'rQN7vyea3V', 'bL6C', 0);
INSERT INTO `sk_shares` VALUES (71, 2, 71, 0, 0, 'EfEVfePKSL', '8T5C', 0);
INSERT INTO `sk_shares` VALUES (72, 2, 72, 0, 0, 'rY3qQrrFEf', 'Unp5', 0);
INSERT INTO `sk_shares` VALUES (73, 2, 73, 0, 0, '6Jvai2DfQf', 'Qv9c', 0);
INSERT INTO `sk_shares` VALUES (74, 2, 74, 0, 0, 'IfmIVvzOFG', '7iSc', 0);
INSERT INTO `sk_shares` VALUES (75, 2, 75, 0, 0, '7z2Mni8eHC', '4AfE', 0);
INSERT INTO `sk_shares` VALUES (76, 2, 76, 0, 0, '7ZzIRfAu1O', 'CVpo', 0);
INSERT INTO `sk_shares` VALUES (77, 2, 77, 0, 0, 'juEVz2uaFj', '0Vl1', 0);
INSERT INTO `sk_shares` VALUES (78, 2, 78, 0, 0, 'nAnQzyhgEa', '9CZa', 0);
INSERT INTO `sk_shares` VALUES (79, 2, 79, 0, 0, '2eAFRnYb1x', '4D50', 0);
INSERT INTO `sk_shares` VALUES (80, 2, 80, 0, 0, 'fIbMfmeOUD', 'SKWi', 0);
INSERT INTO `sk_shares` VALUES (81, 2, 81, 0, 0, 'fIJ3qadUvE', 'FNQq', 0);
INSERT INTO `sk_shares` VALUES (82, 2, 82, 0, 0, 'AJreIbjngR', 'yXjK', 0);
INSERT INTO `sk_shares` VALUES (83, 2, 83, 0, 0, '7FBv6riQXn', 'CcsA', 0);
INSERT INTO `sk_shares` VALUES (84, 2, 84, 0, 0, 'NjmU3eXLIi', 'vySG', 0);
INSERT INTO `sk_shares` VALUES (85, 2, 85, 0, 0, 'NBjqy25dNB', 'vyUZ', 0);
INSERT INTO `sk_shares` VALUES (86, 2, 86, 0, 0, 'VFZfEnZVJ9', 'oFG8', 0);
INSERT INTO `sk_shares` VALUES (87, 2, 87, 0, 0, 'VNvA73F9Kg', 'gnmn', 0);
INSERT INTO `sk_shares` VALUES (88, 2, 88, 0, 0, 'qUnIR3YdUW', 'kCJ0', 0);
INSERT INTO `sk_shares` VALUES (89, 2, 89, 0, 0, 'RzqUFzK7av', 'DSpQ', 0);
INSERT INTO `sk_shares` VALUES (90, 2, 90, 0, 0, 'ARZNjqb24X', 'NfCn', 0);
INSERT INTO `sk_shares` VALUES (91, 2, 91, 0, 0, 'NVnaEfShP4', 'VkdM', 0);
INSERT INTO `sk_shares` VALUES (92, 2, 92, 0, 0, 'ZFZZZnDoQR', 'gkq8', 0);
INSERT INTO `sk_shares` VALUES (93, 2, 93, 0, 0, 'JVVNve9pCM', 'mrZ5', 0);
INSERT INTO `sk_shares` VALUES (94, 2, 94, 0, 0, 'BBnUVnvnLj', 'qphE', 0);
INSERT INTO `sk_shares` VALUES (95, 2, 95, 0, 0, 'qauEVjYRlU', '9Q22', 0);
INSERT INTO `sk_shares` VALUES (96, 2, 96, 0, 0, 'aUjYNjWMld', 'DWop', 0);
INSERT INTO `sk_shares` VALUES (97, 2, 97, 0, 0, 'ae2YFryxQ5', 'FJto', 0);
INSERT INTO `sk_shares` VALUES (98, 2, 98, 0, 0, 'mYrq6bPURN', 'RAbK', 0);
INSERT INTO `sk_shares` VALUES (99, 2, 99, 0, 0, 'qYzaiiDFWh', '9MoU', 0);
INSERT INTO `sk_shares` VALUES (100, 2, 100, 0, 0, 'Q3yeIraIxm', 'Y4tb', 0);
INSERT INTO `sk_shares` VALUES (101, 2, 101, 0, 0, '3IjeYz0hXW', 'qhCY', 0);
INSERT INTO `sk_shares` VALUES (102, 2, 102, 0, 0, 'nMFBfuKAUg', 'RT6a', 0);
INSERT INTO `sk_shares` VALUES (103, 2, 103, 0, 0, 'ze6NZbylvV', 'SiXD', 0);
INSERT INTO `sk_shares` VALUES (104, 2, 104, 0, 0, '6BVfeyLjDp', '9azp', 0);
INSERT INTO `sk_shares` VALUES (105, 2, 105, 0, 0, 'EFfq63sgjH', 'cUS3', 0);
INSERT INTO `sk_shares` VALUES (106, 2, 106, 0, 0, 'aya2Mn3D6G', 'fJgx', 0);
INSERT INTO `sk_shares` VALUES (107, 2, 107, 0, 0, 'JrAnqaVddt', 'x8dS', 0);
INSERT INTO `sk_shares` VALUES (108, 2, 108, 0, 0, 'Qbi6FjyNvN', '9cjN', 0);
INSERT INTO `sk_shares` VALUES (109, 2, 109, 0, 0, 'q2y2q2MAi1', 'GVkb', 0);
INSERT INTO `sk_shares` VALUES (110, 2, 110, 0, 0, 'bMvu2ynJGj', 'zJv1', 0);
INSERT INTO `sk_shares` VALUES (111, 2, 111, 0, 0, '73mQnqAzUv', 'xT70', 0);
INSERT INTO `sk_shares` VALUES (112, 2, 112, 0, 0, 'fEZZBbqqsw', '5oQz', 0);
INSERT INTO `sk_shares` VALUES (113, 2, 113, 0, 0, 'Yv6NZnJSv9', 'NXLX', 0);
INSERT INTO `sk_shares` VALUES (114, 2, 114, 0, 0, 'umEvYjyTeC', 'vdIo', 0);
INSERT INTO `sk_shares` VALUES (115, 2, 115, 0, 0, 'ayqQ7fbxYQ', 'luSE', 0);
INSERT INTO `sk_shares` VALUES (116, 2, 116, 0, 0, 'nuuqA3pAoP', 'iY5V', 0);
INSERT INTO `sk_shares` VALUES (117, 2, 117, 0, 0, 'mUbUz2v1RE', 'K647', 0);
INSERT INTO `sk_shares` VALUES (118, 2, 118, 0, 0, 'vMJnm27H7w', 'wevj', 0);
INSERT INTO `sk_shares` VALUES (119, 2, 119, 0, 0, 'YbYfiaIReF', 'Joui', 0);
INSERT INTO `sk_shares` VALUES (120, 2, 120, 0, 0, 'Z36nQb86V0', 'iv5u', 0);
INSERT INTO `sk_shares` VALUES (121, 2, 121, 0, 0, 'fMrE3inVb8', '0COW', 0);
INSERT INTO `sk_shares` VALUES (122, 2, 2, 1, 0, 'eeAbyiw1Yd', 'SA31', 0);
INSERT INTO `sk_shares` VALUES (123, 2, 3, 1, 0, 'aIVNnmnJxp', 'wkLw', 0);
INSERT INTO `sk_shares` VALUES (124, 2, 4, 1, 0, 'rqQNRbhU2A', 'Qkfm', 0);
INSERT INTO `sk_shares` VALUES (125, 2, 5, 1, 0, 'jq22yijjlK', 'yaQT', 0);
INSERT INTO `sk_shares` VALUES (126, 2, 6, 1, 0, 'Zfa6VjAhQC', 'H1Pf', 0);
INSERT INTO `sk_shares` VALUES (127, 2, 7, 1, 0, 'uu6r6j7SW2', 'fhR5', 0);
INSERT INTO `sk_shares` VALUES (128, 2, 8, 1, 0, '67rAB3AXjY', '9Vwb', 0);
INSERT INTO `sk_shares` VALUES (129, 2, 9, 1, 0, 'feIrInFE7g', 'OpPL', 0);
INSERT INTO `sk_shares` VALUES (130, 2, 10, 1, 0, 'JNNjuqtsKv', 'hSqL', 0);
INSERT INTO `sk_shares` VALUES (131, 2, 11, 1, 0, 'aQbqqaqpNq', 'PvP6', 0);
INSERT INTO `sk_shares` VALUES (132, 2, 12, 1, 0, '2MrQbm3FjY', 'DCAe', 0);
INSERT INTO `sk_shares` VALUES (133, 2, 13, 1, 0, 'yQfQB3g2gT', 'mWCc', 0);
INSERT INTO `sk_shares` VALUES (134, 5, 122, 0, 0, 'zquiEjbmun', 'pBz6', 0);
INSERT INTO `sk_shares` VALUES (135, 2, 123, 0, 0, 'FfQz6vBp4T', 'KJrD', 0);
INSERT INTO `sk_shares` VALUES (136, 2, 124, 0, 0, 'IJ3eQzvsHt', 'VNsd', 0);
INSERT INTO `sk_shares` VALUES (137, 2, 125, 0, 0, 'i2uyQbVcIv', 'G6B7', 0);
INSERT INTO `sk_shares` VALUES (138, 2, 126, 0, 0, 'Y3yQ7bjmKY', 'GxgR', 0);
INSERT INTO `sk_shares` VALUES (139, 2, 127, 0, 0, '7BZbYvjirJ', 'ltcB', 0);
INSERT INTO `sk_shares` VALUES (140, 2, 128, 0, 0, 'vyIVBzFfWs', '2p3M', 0);
INSERT INTO `sk_shares` VALUES (141, 2, 129, 0, 0, 'uamENjc4Uo', 'C4br', 0);
INSERT INTO `sk_shares` VALUES (142, 2, 130, 0, 0, '2EFVZjppN8', '3YsB', 0);
INSERT INTO `sk_shares` VALUES (143, 2, 131, 0, 0, 'Er6NJjRZxo', 'MJMs', 0);
INSERT INTO `sk_shares` VALUES (144, 2, 132, 0, 0, 'V3e2Ibqaye', 'vxjO', 0);
INSERT INTO `sk_shares` VALUES (145, 2, 133, 0, 0, 'MryMz2s8tb', 'GRlI', 0);
INSERT INTO `sk_shares` VALUES (146, 2, 134, 0, 0, 'NFF73u7GAB', 'lQqY', 0);
INSERT INTO `sk_shares` VALUES (147, 2, 135, 0, 0, 'bA3qYnDSOw', 'dbsA', 0);
INSERT INTO `sk_shares` VALUES (148, 2, 136, 0, 0, 'amEFvqoTty', 'u067', 0);
INSERT INTO `sk_shares` VALUES (149, 2, 137, 0, 0, 'A3Q36zv030', 'G4Nf', 0);
INSERT INTO `sk_shares` VALUES (150, 2, 138, 0, 0, 'EBBFBnqwMN', 'EpOC', 0);
INSERT INTO `sk_shares` VALUES (151, 2, 139, 0, 0, '7vAVNnL3Cc', 'Ry1x', 0);
INSERT INTO `sk_shares` VALUES (152, 2, 140, 0, 0, '7veABvZcL3', 'WEZX', 0);
INSERT INTO `sk_shares` VALUES (153, 2, 141, 0, 0, 'I3iiua7OVw', 'clhS', 0);
INSERT INTO `sk_shares` VALUES (154, 2, 142, 0, 0, '7RvQJv4y2m', 'WQbX', 0);
INSERT INTO `sk_shares` VALUES (155, 2, 143, 0, 0, 'NBNrymGF80', 'X3TQ', 0);
INSERT INTO `sk_shares` VALUES (156, 2, 144, 0, 0, 'ryaei2LwKm', 'xdiK', 0);
INSERT INTO `sk_shares` VALUES (157, 2, 145, 0, 0, 'jieeUj5E1B', 'PBFn', 0);
INSERT INTO `sk_shares` VALUES (158, 2, 146, 0, 0, 'Y36biqEmRh', 'pH46', 0);
INSERT INTO `sk_shares` VALUES (159, 2, 147, 0, 0, 'zIbmierZHq', 'Aht0', 0);
INSERT INTO `sk_shares` VALUES (160, 2, 148, 0, 0, 'qYjEBjVuAG', 'BI9n', 0);
INSERT INTO `sk_shares` VALUES (161, 2, 149, 0, 0, '6VJJ3uMhK3', '0CvX', 0);
INSERT INTO `sk_shares` VALUES (162, 2, 150, 0, 0, 'nUJ3IrCpUT', 'xS6X', 0);
INSERT INTO `sk_shares` VALUES (163, 2, 151, 0, 0, 'v6fqmiyyGs', 'xM6n', 0);
INSERT INTO `sk_shares` VALUES (164, 2, 152, 0, 0, '7JnayaPDkx', 'zQcu', 0);
INSERT INTO `sk_shares` VALUES (165, 2, 153, 0, 0, 'ZFzQbydVWk', 'KGtr', 0);
INSERT INTO `sk_shares` VALUES (166, 2, 154, 0, 0, 'Bb6rYfkdit', 'U3iF', 0);
INSERT INTO `sk_shares` VALUES (167, 2, 155, 0, 0, 'jaMJju38Jr', 'CX2w', 0);
INSERT INTO `sk_shares` VALUES (168, 2, 156, 0, 0, 'Yfqi6zYAUA', 'O0x2', 0);
INSERT INTO `sk_shares` VALUES (169, 2, 157, 0, 0, 'mENri2PnKm', 'YFcE', 0);
INSERT INTO `sk_shares` VALUES (170, 2, 158, 0, 0, '6ZJJrmJIAz', 'lmAG', 0);
INSERT INTO `sk_shares` VALUES (171, 2, 159, 0, 0, 'eUzIVnPUsD', 'cTGG', 0);
INSERT INTO `sk_shares` VALUES (172, 2, 160, 0, 0, 'fyeaIbeKAC', 'a8Av', 0);
INSERT INTO `sk_shares` VALUES (173, 2, 161, 0, 0, 'mM7R7vgMWs', '34yn', 0);
INSERT INTO `sk_shares` VALUES (174, 2, 162, 0, 0, 'viaiyyzyQB', 'o54w', 0);
INSERT INTO `sk_shares` VALUES (175, 2, 163, 0, 0, 'um22ErlInm', 'N9yd', 0);
INSERT INTO `sk_shares` VALUES (176, 2, 164, 0, 0, 'EZF7JjjnpB', 'JzhN', 0);
INSERT INTO `sk_shares` VALUES (177, 2, 165, 0, 0, 'V3muy2A7su', 'lKCN', 0);
INSERT INTO `sk_shares` VALUES (178, 2, 166, 0, 0, 'NfeEVrHnCl', 'anLj', 0);
INSERT INTO `sk_shares` VALUES (179, 2, 167, 0, 0, 'MneUvypl8o', 'VUtX', 0);
INSERT INTO `sk_shares` VALUES (180, 2, 168, 0, 0, 'mYnUVnms50', 'ImiF', 0);
INSERT INTO `sk_shares` VALUES (181, 2, 169, 0, 0, 'uiQry2ciEJ', 'SBpD', 0);
INSERT INTO `sk_shares` VALUES (182, 2, 170, 0, 0, 'aEFze2z0Pn', 'ahhZ', 0);
INSERT INTO `sk_shares` VALUES (183, 2, 171, 0, 0, 'iaIRJ34aFv', 'dRBi', 0);
INSERT INTO `sk_shares` VALUES (184, 2, 172, 0, 0, 'JjamqaaP1o', 'ZRY1', 0);
INSERT INTO `sk_shares` VALUES (185, 2, 173, 0, 0, '363ueapagm', 'TuFA', 0);
INSERT INTO `sk_shares` VALUES (186, 2, 174, 0, 0, 'JVrmiei4MG', 'YzwP', 0);
INSERT INTO `sk_shares` VALUES (187, 2, 175, 0, 0, 'buqI3iN9uJ', 'LbGb', 0);
INSERT INTO `sk_shares` VALUES (188, 2, 176, 0, 0, 'qM7zmyBXuk', 'q9ZC', 0);
INSERT INTO `sk_shares` VALUES (189, 2, 177, 0, 0, 'VrYfQfcNDo', 'hM2Y', 0);
INSERT INTO `sk_shares` VALUES (190, 2, 178, 0, 0, 'nInIZbm9Xw', 'AzE7', 0);
INSERT INTO `sk_shares` VALUES (191, 2, 179, 0, 0, 'aaMrAnZqYa', '6Fkg', 0);
INSERT INTO `sk_shares` VALUES (192, 2, 180, 0, 0, 'nQRrEf2CC1', 'xSgx', 0);
INSERT INTO `sk_shares` VALUES (193, 2, 181, 0, 0, 'meuY3atkg3', 'Voec', 0);
INSERT INTO `sk_shares` VALUES (194, 2, 182, 0, 0, 'I3yYj2PcPa', '77Tl', 0);
INSERT INTO `sk_shares` VALUES (195, 2, 183, 0, 0, 'bUVJby7Cpf', 'MCAa', 0);
INSERT INTO `sk_shares` VALUES (196, 2, 184, 0, 0, 'EVvAZrQGXh', '5R0Q', 0);
INSERT INTO `sk_shares` VALUES (197, 2, 185, 0, 0, 'aa2myijRVA', 'atFQ', 0);
INSERT INTO `sk_shares` VALUES (198, 2, 186, 0, 0, 'feuEFrA7FD', 'uiud', 0);
INSERT INTO `sk_shares` VALUES (199, 2, 187, 0, 0, 'fUfINfuTSc', '6DN3', 0);
INSERT INTO `sk_shares` VALUES (200, 2, 188, 0, 0, 'aeimU33wIg', '4GKm', 0);
INSERT INTO `sk_shares` VALUES (201, 2, 189, 0, 0, 'e63Q7b47AE', '7jsw', 0);
INSERT INTO `sk_shares` VALUES (202, 2, 190, 0, 0, 'mYZFjaVWtm', '9bga', 0);
INSERT INTO `sk_shares` VALUES (203, 2, 191, 0, 0, 'UrYVNjxlrD', 'nIKi', 0);
INSERT INTO `sk_shares` VALUES (204, 2, 192, 0, 0, 'fI3YJnXA9Q', 'JKDR', 0);
INSERT INTO `sk_shares` VALUES (205, 2, 193, 0, 0, 'NjmiIr4VSa', 'JYiC', 0);
INSERT INTO `sk_shares` VALUES (206, 2, 194, 0, 0, 'BraiQfVTQN', 'nrlu', 0);
INSERT INTO `sk_shares` VALUES (207, 2, 195, 0, 0, 'VVZfMj3XPi', 'UYmQ', 0);
INSERT INTO `sk_shares` VALUES (208, 2, 196, 0, 0, 'fuqumuoURC', 'fgn7', 0);
INSERT INTO `sk_shares` VALUES (209, 2, 197, 0, 0, 'IF7RrmTr3V', 'kGL7', 0);
INSERT INTO `sk_shares` VALUES (210, 2, 198, 0, 0, 'bu6FNrPdnD', 'YNtu', 0);
INSERT INTO `sk_shares` VALUES (211, 2, 199, 0, 0, 'Z7ZBNrFW0Q', '5vre', 0);
INSERT INTO `sk_shares` VALUES (212, 2, 200, 0, 0, 'AbIrIjlSpg', 'D1XU', 0);
INSERT INTO `sk_shares` VALUES (213, 2, 201, 0, 0, 'z6RnQ35k5v', '8HwV', 0);
INSERT INTO `sk_shares` VALUES (214, 2, 202, 0, 0, 'YvmeIf6X9b', 'CaT9', 0);
INSERT INTO `sk_shares` VALUES (215, 2, 203, 0, 0, 'mQZJB3AVZy', 'z15t', 0);
INSERT INTO `sk_shares` VALUES (216, 2, 204, 0, 0, 'uaiQBfIfy8', '6Mj1', 0);
INSERT INTO `sk_shares` VALUES (217, 2, 205, 0, 0, 'ZfmIr24JqL', 'Dv58', 0);
INSERT INTO `sk_shares` VALUES (218, 2, 206, 0, 0, '6zqUry2tpN', 'KcxV', 0);
INSERT INTO `sk_shares` VALUES (219, 2, 207, 0, 0, 'AZBJfuLZQM', '4o5l', 0);
INSERT INTO `sk_shares` VALUES (220, 2, 208, 0, 0, 'YRRrye8rR4', 'HF9u', 0);
INSERT INTO `sk_shares` VALUES (221, 2, 209, 0, 0, 'fQjyMvgy2y', 'pAZq', 0);
INSERT INTO `sk_shares` VALUES (222, 2, 210, 0, 0, '7baiMjgA0e', 'YRbX', 0);
INSERT INTO `sk_shares` VALUES (223, 2, 211, 0, 0, 'F3mUzm9phw', 'Vl29', 0);
INSERT INTO `sk_shares` VALUES (224, 2, 212, 0, 0, 'myARV3nOW6', 'Rmfz', 0);
INSERT INTO `sk_shares` VALUES (225, 2, 213, 0, 0, 'FbeemuEqtg', 'wS5i', 0);
INSERT INTO `sk_shares` VALUES (226, 2, 214, 0, 0, 'eIRz2eYOnd', '4Fe8', 0);
INSERT INTO `sk_shares` VALUES (227, 2, 215, 0, 0, 'AFbQFnl4tT', 'GyC7', 0);
INSERT INTO `sk_shares` VALUES (228, 2, 216, 0, 0, 'nYf67rXgNz', 'geK3', 0);
INSERT INTO `sk_shares` VALUES (229, 2, 217, 0, 0, '3QBfMfU61a', 'Vnsw', 0);
INSERT INTO `sk_shares` VALUES (230, 2, 218, 0, 0, 'EZbUV3JpNw', '88u1', 0);
INSERT INTO `sk_shares` VALUES (231, 2, 219, 0, 0, 'byMZRnW3t1', 'Ia4e', 0);
INSERT INTO `sk_shares` VALUES (232, 2, 220, 0, 0, 'UbQJZzEFqL', 'xCGb', 0);
INSERT INTO `sk_shares` VALUES (233, 2, 221, 0, 0, 'BfqIFvhkTQ', 'mHny', 0);
INSERT INTO `sk_shares` VALUES (234, 2, 222, 0, 0, 'bIZRridpKo', 'At2M', 0);
INSERT INTO `sk_shares` VALUES (235, 2, 223, 0, 0, 'NBzemyY1I3', 'OJUZ', 0);
INSERT INTO `sk_shares` VALUES (236, 2, 224, 0, 0, 'u2uqautLTd', 'LVA5', 0);
INSERT INTO `sk_shares` VALUES (237, 2, 225, 0, 0, 'INRFZziBoq', 'AXOP', 0);
INSERT INTO `sk_shares` VALUES (238, 2, 226, 0, 0, 'fI3YfaOKOG', 'BrWq', 0);
INSERT INTO `sk_shares` VALUES (239, 2, 227, 0, 0, 'AzquiyOpEL', 'Fg00', 0);
INSERT INTO `sk_shares` VALUES (240, 2, 228, 0, 0, 'uMvaUfGloh', 'cu1e', 0);
INSERT INTO `sk_shares` VALUES (241, 2, 229, 0, 0, 'jqyQzqtzst', 'lhBp', 0);
INSERT INTO `sk_shares` VALUES (242, 2, 230, 0, 0, 'jqqERfB0pG', '4sjb', 0);
INSERT INTO `sk_shares` VALUES (243, 2, 231, 0, 0, 'eqQJzad3V1', 'NA0I', 0);
INSERT INTO `sk_shares` VALUES (244, 2, 232, 0, 0, 'MJRBVrV5sn', 'R0ou', 0);
INSERT INTO `sk_shares` VALUES (245, 2, 233, 0, 0, 'MjaAVzdSZv', '4R7y', 0);
INSERT INTO `sk_shares` VALUES (246, 2, 234, 0, 0, '7raYB3NmRW', '8Upx', 0);
INSERT INTO `sk_shares` VALUES (247, 11, 235, 0, 0, 'N77rAnYSNG', 'hSvS', 0);
INSERT INTO `sk_shares` VALUES (248, 12, 236, 0, 0, '7buU3muzL0', '5ph7', 0);
INSERT INTO `sk_shares` VALUES (249, 13, 237, 0, 0, 'Qf63iyk0XX', 'Ozwy', 0);
INSERT INTO `sk_shares` VALUES (250, 18, 238, 0, 0, 'j6BNbmyGV8', 'mrOU', 0);
INSERT INTO `sk_shares` VALUES (251, 19, 239, 0, 0, 'ErimIzKQSP', '1EUT', 0);
INSERT INTO `sk_shares` VALUES (252, 20, 240, 0, 0, 'BNFv6nmWCq', 'SiD3', 0);
INSERT INTO `sk_shares` VALUES (253, 20, 241, 0, 0, 'q673YvsfnH', 'vW7m', 0);
INSERT INTO `sk_shares` VALUES (254, 21, 242, 0, 0, '6jaUjqy3TQ', 'Lw7g', 0);
INSERT INTO `sk_shares` VALUES (255, 21, 243, 0, 0, 'raUJbexrv2', 'YaXn', 0);
INSERT INTO `sk_shares` VALUES (256, 22, 244, 0, 0, 'q6vaiy3wxU', 'JczH', 0);
INSERT INTO `sk_shares` VALUES (257, 22, 245, 0, 0, 'm22maukO8T', 'P5aw', 0);
INSERT INTO `sk_shares` VALUES (258, 22, 34, 1, 0, 'vqY36bJ4wd', '2Kah', 0);
INSERT INTO `sk_shares` VALUES (259, 22, 246, 0, 0, 'UV3iyeNAJM', 'zmvk', 0);

-- ----------------------------
-- Table structure for sk_stores
-- ----------------------------
DROP TABLE IF EXISTS `sk_stores`;
CREATE TABLE `sk_stores`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NULL DEFAULT 0 COMMENT '所属用户',
  `shares_id` int(11) NULL DEFAULT 0 COMMENT '分享id',
  `origin_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '源文件名',
  `file_name` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '存储文件名',
  `size` bigint(20) NULL DEFAULT 0 COMMENT '文件大小',
  `meta` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '文件元属性',
  `mime_type` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '文件类型',
  `ext` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '文件后缀',
  `parent_folder` int(11) NULL DEFAULT 0 COMMENT '所属目录',
  `policy_id` int(11) NULL DEFAULT 0 COMMENT '存储策略',
  `count_down` int(11) NULL DEFAULT 0 COMMENT '下载量',
  `count_open` int(11) NULL DEFAULT 0 COMMENT '浏览量',
  `dir` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '文件目录',
  `desc` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '文件描述',
  `create_time` int(11) NULL DEFAULT 0 COMMENT '创建时间',
  `update_time` int(11) NULL DEFAULT 0 COMMENT '更新时间',
  `delete_time` int(11) NULL DEFAULT NULL COMMENT '软删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 247 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '储存文件' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sk_stores
-- ----------------------------
INSERT INTO `sk_stores` VALUES (236, 12, 248, '850.png', '/uploads/20220729/12/file_62e371efeaeb11659073007.png', 82885, '', '', 'png', 23, 1, 1, 27, '', NULL, 1659073007, 1675175789, 1675175789);
INSERT INTO `sk_stores` VALUES (237, 13, 249, '850.png', '/uploads/20220804/13/file_62eb126bab5511659572843.png', 82885, '', '', 'png', 24, 1, 2, 24, '', NULL, 1659572843, 1675175786, 1675175786);
INSERT INTO `sk_stores` VALUES (238, 18, 250, 'uugai.com-1629566763288.png', '/uploads/20230131/18/file_63d92c09cc50e1675176969.png', 15452, '', '', 'png', 29, 1, 0, 3, '', NULL, 1675176969, 1683438065, 1683438065);
INSERT INTO `sk_stores` VALUES (239, 19, 251, 'uugai.com-1629566763288.png', '/uploads/20230201/19/file_63da700a0cb451675259914.png', 15452, '', '', 'png', 30, 1, 0, 2, '', NULL, 1675259914, 1675259914, NULL);
INSERT INTO `sk_stores` VALUES (240, 20, 252, '_.._logo_font20230401_uugai.com-5318689-16803346005945 (1) - 副本.png', '/uploads/20230507/20/file_64574616c5a7c1683441174.png', 4711, '', '', 'png', 31, 1, 0, 1, '', NULL, 1683441174, 1683441174, NULL);
INSERT INTO `sk_stores` VALUES (241, 20, 253, 'logo2 (1).png', '/uploads/20230507/20/file_64575c08de9561683446792.png', 16561, '', '', 'png', 31, 1, 0, 0, '', NULL, 1683446792, 1683446792, NULL);
INSERT INTO `sk_stores` VALUES (242, 21, 254, 'logo2 (1).png', '/uploads/20230507/21/file_64575c29ab3e21683446825.png', 16561, '', '', 'png', 32, 1, 0, 2, '', NULL, 1683446825, 1683446825, NULL);
INSERT INTO `sk_stores` VALUES (243, 21, 255, 'logo5.png', '/uploads/20230507/21/file_64575c46b8d681683446854.png', 15993, '', '', 'png', 32, 1, 0, 0, '', NULL, 1683446854, 1683446854, NULL);
INSERT INTO `sk_stores` VALUES (244, 22, 256, '10011.png', '/uploads/20230819/22/file_64e027a6d50781692411814.png', 14812, NULL, '', 'png', 33, 1, 4, 18, NULL, NULL, 1692411814, 1692411814, NULL);
INSERT INTO `sk_stores` VALUES (245, 22, 257, '10011.png', '/uploads/20230819/22/file_64e027a6d50781692411814.png', 14812, NULL, '', 'png', 33, 1, 0, 1, NULL, NULL, 1692412921, 1692412921, NULL);
INSERT INTO `sk_stores` VALUES (246, 22, 259, '10011.png', '/uploads/20230819/22/file_64e027a6d50781692411814.png', 14812, NULL, '', 'png', 34, 1, 0, 0, NULL, NULL, 1692412926, 1692412926, NULL);

-- ----------------------------
-- Table structure for sk_users
-- ----------------------------
DROP TABLE IF EXISTS `sk_users`;
CREATE TABLE `sk_users`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '用户名',
  `nickname` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户昵称',
  `email` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '邮箱账号',
  `password` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '密码',
  `avatar` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '用户头像',
  `desc` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '个性签名',
  `amount` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '用户余额',
  `group` int(11) NOT NULL DEFAULT 0 COMMENT '用户组',
  `group_expire` int(11) NOT NULL DEFAULT 0 COMMENT '用户组过期时间',
  `is_auth` tinyint(3) NOT NULL DEFAULT 0 COMMENT '是否实名认证',
  `wx_openid` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '微信开放平台ID',
  `create_time` int(11) NOT NULL DEFAULT 0 COMMENT '注册时间',
  `login_time` int(11) NOT NULL DEFAULT 0 COMMENT '最近登录时间',
  `login_real_ip` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `status` tinyint(2) NOT NULL DEFAULT 1 COMMENT '用户状态 1 正常 0封禁',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 23 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sk_users
-- ----------------------------
INSERT INTO `sk_users` VALUES (1, 'admin', '管理员', '190066120@qq.com', 'f890f825c0d6aae83005c731fc2c4892', NULL, NULL, 10.00, 1, 1658332800, 0, NULL, 1631009197, 1692412065, '127.0.0.1', 1);
INSERT INTO `sk_users` VALUES (22, 'demo123', '本地测试', '190066120@qq.com', 'f890f825c0d6aae83005c731fc2c4892', NULL, NULL, 0.00, 4, 1755570830, 0, NULL, 1692411680, 1692412430, '127.0.0.1', 1);

-- ----------------------------
-- Table structure for sk_withdraw
-- ----------------------------
DROP TABLE IF EXISTS `sk_withdraw`;
CREATE TABLE `sk_withdraw`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT 0 COMMENT '提现用户',
  `money` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '提现金额',
  `alipay_account` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '支付宝帐号',
  `alipay_name` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '支付宝姓名',
  `create_time` int(11) NOT NULL DEFAULT 0 COMMENT '提现时间',
  `status` tinyint(1) NOT NULL DEFAULT 0 COMMENT '提现状态 0 等待处理 1提现成功',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户提现记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sk_withdraw
-- ----------------------------

SET FOREIGN_KEY_CHECKS = 1;
