<?php
defined('PP_PATH') or exit;
class book_control extends admin_control {
	public function __construct(){
		parent::__construct();
	}

	public function index(){
		$cfg = $this->kv->xget('cfg');
		$cid = intval(R('cid','R'));

	
		// 初始模型表名
		$this->cms_content_book->table = 'cms_book';

		// 初始分页
		$pagenum = 10;
		$where = array();
		
		$urlstr = '';

		$total = $this->cms_content_book->count();

		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pp_pages($page, $maxpage, 'index.php?u=book-index'.$urlstr.'-page-{page}');
		

		$this->assign('total', $total);
		$this->assign('pages', $pages);
	
		$cms_arr = $this->cms_content_book->list_arr($where, 'id', -1, ($page-1)*$pagenum, $pagenum, $total);
		foreach($cms_arr as &$v) {
			$this->cms_content_book->formatbook($v,$dateformat = 'm月d日');
			$v['user'] = $this->user->get($v['uid']);
		}

		$this->assign('cfg', $cfg);
		$this->assign('list', $cms_arr);
	
		$this->display();
	}
	public function get_pro(){
		$pid = intval(R('pid','R'));
	
		// 初始模型表名
		$this->cms_content_book->table = 'cms_book';

		// 初始分页
		$pagenum = 10;
		$where = array();
		$where['pid'] 		= $pid;
		$total = $this->cms_content_book->find_count($where);


		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));

		$this->assign('total', $total);
	
		$cms_arr = $this->cms_content_book->list_arr($where, 'id', -1, ($page-1)*$pagenum, $pagenum, $total);
		foreach($cms_arr as &$v) {
			$this->cms_content_book->formatbook($v,$dateformat = 'm月d日');
			$v['user'] = $this->user->get($v['uid']);
		}
		$this->assign('pid', $pid);
		$this->assign('page', $page);
		$this->assign('maxpage', $maxpage);
		$this->assign('list', $cms_arr);
		$this->display();
	}
	public function get_user(){
		$uid = intval(R('uid','R'));
	
		// 初始模型表名
		$this->cms_content_book->table = 'cms_book';

		// 初始分页
		$pagenum = 10;
		$where = array();
		$where['uid'] 		= $uid;
		$total = $this->cms_content_book->find_count($where);


		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));

		$this->assign('total', $total);
		$this->assign('pages', $pages);
	
		$cms_arr = $this->cms_content_book->list_arr($where, 'id', -1, ($page-1)*$pagenum, $pagenum, $total);
		foreach($cms_arr as &$v) {
			$this->cms_content_book->formatbook($v,$dateformat = 'm月d日');
		}
		$this->assign('uid', $uid);
		$this->assign('page', $page);
		$this->assign('maxpage', $maxpage);
		$this->assign('list', $cms_arr);
		$this->display();
	}
	public function update_sms() {
		$pid = intval(R('pid','P'));
		$this->cms_content_book->table = 'cms_book';
		$arrlist 	= $this->cms_content_book->find_fetch(array('pid'=>$pid), array(), 0, 1000);
		if(empty($arrlist)){
			E(1, '无可发送名单！');
		}else{
			$sms_cfg 	= $this->kv->xget('sms_cfg');
			$mail_cfg 	= $this->kv->xget('mail_cfg');
			$cfg 		= $this->kv->xget('cfg');
			
			$this->cms_content->table = 'cms_products';
			$pro = $this->cms_content->get($pid);
			
			$uid_arr = array();
			foreach($arrlist as &$v) {
				$uid_arr[] = $v['uid'];
			}
			$user_arr 	= $this->user->mget($uid_arr);
			
			$key_pre 	= 'user-uid-';
			if($sms_cfg['update_off']){	//发送短信
				$pagenum	= 80 ;	//短信平台批量发送限制　大多为100以下
				$maxpage 	= max(2, ceil(count($user_arr)/$pagenum)); //最小为2 当为1时会分为若干个
				$user_arr	= array_chunk($user_arr,$maxpage,true);

				foreach($user_arr as $k=>&$t){
					$phone_arr 	= array();
					if($t['mobile_staus']){
						array_push($phone_arr, $t['mobile']);
					}
					$phone_arr 	= implode(',',$phone_arr);
					try{
						other::send_sms($sms_cfg,$phone_arr,str_replace("{name}",$pro['title'],$sms_cfg['update']));
					}catch(Exception $e){}
				}
			}
			if(!empty($mail_cfg['moban']['email_update_off'])){	//群发邮件
				$email_content = $mail_cfg['moban']['email_update'];
				$email_content = str_replace('{name}', $pro['title'], $email_content);

				$subject = $cfg['webname'].' ：'.$pro['title'].'更新了！';
				
				foreach($user_arr as $k=>&$t){
					//$mailto 	= array(); //需数组
					$message = "
						<html>
						<head>
						<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
						</head>
						<body>
						".$t['username']."：您好！<br />
						$email_content
						</body>
						</html>
					";
					if($t['email_staus']){
						try{
							$this->mmisc->sendmail($t['username'],$t['email'],$subject,$message);
						}catch(Exception $e){}
					}
				}
			}
			E(0, '发送成功！');
		}
	}
	public function del(){ //删除 作废
		$order_id 	= htmlspecialchars(trim(R('oid', 'P')));

		$where['order_id'] 	= $order_id;
		
		$this->cms_content_book->table = $this->_table;
		$book 	= $this->cms_content_book->get_by_oid($order_id);
		
		empty($book) && E(1, '找不到此订单');

		$status = $this->cms_content_book->find_delete($where);
		if($status){
			E(0, '删除成功');
		}else{
			E(1, '删除失败！');
		}
	}
	//处理3天后默认好评
	public function auto_comment(){
		$list	= $this->cms_content_book->find_fetch(array('is_comments'=>0), array('id'=>'1'), 0, 1000);
		foreach($list as &$v){
			if(empty($v['is_comments'])){
				$threetime = $v['dateline']  + 86400 * 3 ;
				if($threetime < time()){
					$this->cms_content_book->auto_comments($v);
				}
			}
		}
		E(0, 'OK');
	}
}