<?php
class user_group_control extends admin_control {

	public $whitelist_arr = array(
		'home'	=>	array(
			'name' => '首页' ,
			'list' => array(
				'my-index'				=>'后台首页',
				'my-password'			=>'修改密码',
				'blockmanage-index'		=> array(
					'name'	=> '碎片管理',
					'list'	=> array(
						'blockmanage-set' 	=> '编辑',
						'blockmanage-del' 	=> '删除',
					),
				),
				'links-index'		=> array(
					'name'	=> '友情链接',
					'list'	=> array(
						'links-set' 	=> '编辑',
						'links-del' 	=> '删除',
					),
				),
			),
		),
		'audit'	=>	array(
			'name' => '订单' ,
			'list' => array(
				'book-index'		=> array(
					'name'	=> '订单管理',
					'list'	=> array(
						'book-auto_comment' => '一键好评',
					),
				),
				'record-index'		=> array(
					'name'	=> '充值消费',
					'list'	=> array(
						'record-confirm' 	=> '充值确认',
						'record-del' 		=> '充值删除',
					),
				),
				'withdraw-index'		=> array(
					'name'	=> '提现管理',
					'list'	=> array(
						'withdraw-index-status-1' 	=> '提现列表',
						'withdraw-confirm' 	=> '提现确认',
						'withdraw-del' 		=> '提现删除',
					),
				),
			),
		),
		'setting'	=>	array(
			'name' => '设置' ,
			'list' => array(
				'setting-index'		=>'基本设置',
				'setting-sms'		=>'短信邮箱',
				'setting-seo'		=>'SEO设置',
				'setting-link'		=>'链接设置',
				'setting-attach'	=>'上传设置',
				'setting-image'		=>'图片设置',
			),
		),
		'category'	=>	array(
			'name' => '分类' ,
			'list' => array(
				'category-index'		=> array(
					'name'	=> '分类管理',
					'list'	=> array(
						'category-set' 			=> '分类编辑',
						'category-del' 			=> '分类删除',
						'category-edit_orderby' => '分类排序',
					),
				),
				'navigate-index'		=> array(
					'name'	=> '导航管理',
					'list'	=> array(
						'navigate-add_cate' => '添加导航',
						'navigate-add_link' => '添加外链',
						'navigate-nav_save' => '修改导航',
						'navigate-del' 		=> '删除导航',
					),
				),
				'models-index'			=>'模型管理',
			),
		),
		'content'	=>	array(
			'name' => '内容' ,
			'list' => array(
				'products-index'		=> array(
					'name'	=> '资源管理',
					'list'	=> array(
						'products-add' 				=> '添加资源',
						'products-edit' 			=> '编辑资源',
						'products-del' 				=> '删除资源',
						'products-ajaxsetflags' 	=> '属性设置',
						'products-faq' 				=> 'FAQ管理',
						'products-faq_add' 			=> 'FAQ添加',
						'products-faq_edit' 		=> 'FAQ编辑',
						'products-faq_del' 			=> 'FAQ删除',
						'products-update_sms' 		=> '更新通知',
					),
				),
				'comment-index'		=> array(
					'name'	=> '评论管理',
					'list'	=> array(
						'comment-get_json' 	=> '编辑评论',
						'comment-edit' 		=> '评论编辑',
						'comment-status' 	=> '评论审核',
						'comment-del' 		=> '评论删除',
						'comment-batch_del' => '批量删除',
					),
				),
				'article-index'		=> array(
					'name'	=> '文章管理',
					'list'	=> array(
						'article-add' 	=> '添加文章',
						'article-edit' 	=> '编辑文章',
						'article-del' 	=> '删除文章',
						'article-batch_del' 	=> '批量删除',
						'article-ajaxsetflags' 	=> '属性设置',
					),
				),
				'tag-index'		=> array(
					'name'	=> '标签管理',
					'list'	=> array(
						'article-add' 		=> '添加标签',
						'article-get_json' 	=> '编辑标签',
						'article-edit' 		=> '编辑标签',
						'article-del' 		=> '删除标签',
						'article-batch_del' => '批量删除',
					),
				),
			),
		),
		'user'	=>	array(
			'name' => '用户' ,
			'list' => array(
				'user-index'		=> array(
					'name'	=> '用户管理',
					'list'	=> array(
						'user-add' 			=> '添加用户',
						'user-edit' 		=> '编辑用户',
						'user-change_money' => '资金调整',
						'user-del' 			=> '删除用户',
						'user-set_status' 	=> '用户冻结',
					),
				),
				'user_group-index'		=> array(
					'name'	=> '用户组管理',
					'list'	=> array(
						'user_group-add' 		=> '添加用户组',
						'user_group-edit' 		=> '编辑用户组',
						'user_group-del' 		=> '删除用户组',
					),
				),
			),
		),
		'tool'	=>	array(
			'name' => '工具' ,
			'list' => array(
				'database-index'		=> array(
					'name'	=> '数据库管理',
					'list'	=> array(
						'database-docommand'	=>'数据库优化',
						'database-backup'		=>'备份数据库',
						'database-recove'		=>'还原数据库',
						
						'database-down'			=>'备份下载',
						'database-del'			=>'备份删除',
					),
				),
				'tool-rebuild'			=>'重新统计',
			),
		)
	);
	
	// 用户组管理
	public function index() {
		$user_group = &$this->user_group;

		$user_group_arr = $user_group->get_groups();
		
		foreach($user_group_arr as &$v) {
			$user_group->format($v);
		}

		$this->assign('list', $user_group_arr);
		$this->display();
	}
	// 权限编辑
	public function edit() {
		if(empty($_POST)) {
			$id 	= intval(R('id'));
			
			$this->_pkey = 'user_group';
			$this->_ukey = 'user_group-edit-id-'.$id;
			$this->_title = '编辑权限';
			$this->_place = '用户组 &#187; 编辑权限';
			
			$user_group = &$this->user_group;
			$data		= $user_group->get_group_one($id);
			
			//purviews
			$purviews_arr	= empty($data['purviews']) ? array() : json_decode($data['purviews'], true);
			$other			= empty($purviews_arr['other']) ? array() : $purviews_arr['other'];
			$purviews		= empty($purviews_arr['whitelist']) ? array() : $purviews_arr['whitelist'];
			$navs			= empty($purviews_arr['navs']) ? array() : $purviews_arr['navs'];
			$this->assign('data', $data);
			$this->assign('navs', $navs);
			$this->assign('purviews', $purviews);
			$this->assign('other', $other);
			$this->assign('whitelist', $this->whitelist_arr);
			
			//print_r($data);
			
			$this->display();

		}else{
			$groupid 		= intval(R('groupid', 'P'));
			$ishidden 		= intval(R('ishidden', 'P'));
			$groupname 		= R('groupname', 'P');
			
			$navs = $whitelist = $other = array();
			
			if($groupid && $groupid<4){
				$navs 			= R('navs', 'P');
				$whitelist1 		= R('whitelist', 'P');
				$whitelist2 		=	array(
					'attach-index' 			=> 1,
					'products-ajaxset' 			=> 1,
					'products-get_pro_json' 	=> 1,
					'products-batch_del' 		=> 1,
					'products-tuan_edit' 		=> 1,
					'products-tuan_over' 		=> 1,
					'products-baidu' 			=> 1,
					'products-auto_pic' 		=> 1,
					'products-save_images' 		=> 1,
					'products-save_downs' 		=> 1,
					'products-del_attach' 		=> 1,
					'products-auto_save' 		=> 1,
					'tool-get_tags' 			=> 1,
					'tool-get_pinyin' 			=> 1,
					'article-baidu' 			=> 1,
					'links-sort' 				=> 1,
					'tool-index' 				=> 1,
					'book-get_pro' 				=> 1,
					'book-get_user' 				=> 1,
					'category-get_category_upid' 		=> 1,
					'category-get_category_json' 		=> 1,
					'category-get_category_content' 	=> 1,
					'category-get_pinyin' 				=> 1,
					'comment-content' 		=> 1,
					'database-import'		=> 1,
					'pay-lifealipay'		=> 1,
					'setting-testemail'		=> 1,
				);
				$whitelist 		= array_merge($whitelist1, $whitelist2);
			}
			
			$other 		= R('other', 'P');

			$user_group = &$this->user_group;
			if($groupid){
				$data		= $user_group->get_group_one($groupid);
			}
			
			$data['groupid']	= $groupid;
			$data['groupname']	= $groupname;
			$data['ishidden']	= $ishidden;
			$data['purviews']	= json_encode(array('navs'=>$navs,'whitelist'=>$whitelist,'other'=>$other));
			if($groupid){
				if(!$this->user_group->update($data)) {
					E(1, '更新出错');
				}
			}else{
				if(!$this->user_group->create($data)) {
					E(1, '添加出错');
				}
			}
			E(0, '编辑完成');
		}
	}

	//删除用户
	public function del(){
		$groupid = intval( R('groupid','P') );
		$user_group = &$this->user_group;
		$status = $user_group->delete($groupid);
		if( $status ){
			E(0, '删除成功！');
		}else{
			E(1, '删除失败');
		}
	}
}
