<?php
defined('PP_PATH') or exit;
class article_control extends user_control{
	public $_navgroup = 'art';
	private $_table = 'cms_audit_article';	//待审核文章模型表名
	private $_mid = 3;	//模型ID
	private $_audit_mid = 255;	//模型ID (审核专用)
	
	//待审核文章列表
	public function index(){
		$this->assign_value('navkey', 'article-index');
		$cid = intval(R('cid','R'));
		
		// 获取分类下拉框
		$cidhtml = $this->category->get_cidhtml_by_mid($this->_mid, $cid, '所有文章');
		$this->assign('cidhtml', $cidhtml);
		
		// 初始模型表名
		$this->cms_content->table = $this->_table;
		
		// 初始分页
		$where['uid'] = $this->_uid;
		$pagenum = 10;
		if($cid) {
			$where['cid'] = $cid;			
			$urlstr = '-cid-'.$cid;
		}else{
			$urlstr = '';
		}
		$total = $this->cms_content->find_count($where);
		
		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pages($page, $maxpage, 'index.php?u=article-index'.$urlstr.'-page-{page}');
		$this->assign('total', $total);
		$this->assign('pages', $pages);
		
		$cms_arr = $this->cms_content->list_arr($where, 'id', -1, ($page-1)*$pagenum, $pagenum, $total);
		foreach($cms_arr as &$v) {
			$this->cms_content->format($v, $this->_mid);
		}
		$this->assign('lists', $cms_arr);
		
		$this->display('article_audit.htm');
	}
	
	public function all() {
		$this->assign_value('navkey', 'article-all');
		$cid = intval(R('cid','R'));
		// 获取分类下拉框
		$cidhtml = $this->category->get_cidhtml_by_mid($this->_mid, $cid, '所有文章');
		$this->assign('cidhtml', $cidhtml);
		
		// 初始模型表名
		$this->cms_content->table = 'cms_article';
		
		// 初始分页
		$where['uid'] 	= $this->_uid;
		$pagenum 		= 10;
		if($cid){
			$where 		= array('cid' => $cid);
			$categorys 	= $this->category->read($cid);
			$total 		= isset($categorys['count']) ? $categorys['count'] : 0;
			$urlstr 	= '-cid-'.$cid;
		}else{
			$total = $this->cms_content->find_count($where);
			$urlstr = '';
		}
		
		$maxpage 	= max(1, ceil($total/$pagenum));
		$page 		= min($maxpage, max(1, intval(R('page'))));
		$pages 		= pages($page, $maxpage, 'index.php?u=article-all'.$urlstr.'-page-{page}');
		$this->assign('total', $total);
		$this->assign('pages', $pages);
		
		$cms_arr = $this->cms_content->list_arr($where, 'id', -1, ($page-1)*$pagenum, $pagenum, $total);
		foreach($cms_arr as &$v) {
			$this->cms_content->format($v, $this->_mid);
		}
		$this->assign('lists', $cms_arr);
		
		$this->display('article.htm');
	}
	
	//添加
	public function add(){
		$this->assign_value('navkey', 'article-add');
		$uid = $this->_uid;
		$this->assign('_cfg', $this->_cfg);
		
		if(empty($_POST)) {
				
			//上次发布的分类CID
			$habits = (array)$this->kv->get('user_habits_uid_'.$uid);
			$cid = isset($habits['last_add_cid']) ? (int)$habits['last_add_cid'] : 0;
				
			//自动保存的数据
			$data = $this->kv->get('auto_save_article_uid_'.$uid);
		
			if($data) {
				!empty($data['cid']) && $cid = $data['cid'];
				$data['pic_src'] = empty($data['pic']) ? '../static/img/nopic.gif' : '../'.$data['pic'];
				empty($data['author']) && $data['author'] = $this->_user['author'];
				$data['iscomment'] = isset($data['iscomment']) ? intval($data['iscomment']):0;
			}else{
				//初始值
				$data['pic_src'] = '../static/img/nopic.gif';
				$data['author'] = $this->_user['author'];
				$data['iscomment'] = 0;
			}
				
			$this->assign('data', $data);
		
			$cidhtml = $this->category->get_cidhtml_by_mid($this->_mid, $cid);
			$this->assign('cidhtml', $cidhtml);
				
			//用于编辑器定位到模型ID
			$edit_cid_id = '&mid='.$this->_audit_mid;
			$this->assign('edit_cid_id', $edit_cid_id);
		
			$this->display('article_set.htm');
		}else{
			$cid = intval( R('cid','P') );
			empty($cid) && $this->message(0, '请选择分类！');
			
			$code = R('code','P');
			empty($code) && $this->message(0, '请输入验证码！');
			if( md5($code) != session::get('postcode') ){
				$this->message(0, '验证码不正确！');
			}
				
			//主表数据
			$info = R('info','P');
			$info['cid'] = $cid;
			$info['uid'] = $this->_uid;
			$info['title'] = trim(strip_tags($info['title']));
			
			empty($info['title']) && $this->message(0, '标题不能为空！');
			
			$categorys = $this->category->read($info['cid']);
			if(empty($categorys)) $this->message(0, '分类ID不存在！');
				
			$contentstr = trim( $info['content'] );
			
			$table = 'audit_article';
			$mid = $this->_audit_mid;
				
			// 如果摘要为空，自动生成摘要
			$info['intro'] = $this->auto_intro($info['intro'], $contentstr);
			
			$info['lasttime'] = $_ENV['_time'];
			$info['dateline'] = $_ENV['_time'];

			$this->cms_content->table = 'cms_'.$table;
			$id = $this->cms_content->create($info);
			if(!$id) {
				$this->message(0, '写入内容表出错');
			}

			//删除自动保存的数据
			$this->kv->delete('auto_save_article_uid_'.$uid);
				
			//记住最后一次发布的分类CID，感觉这样人性化一些吧。
			$habits = (array) $this->kv->get('user_habits_uid_'.$uid);
			$habits['last_add_cid'] = $cid;
			$habits = $this->kv->set('user_habits_uid_'.$uid, $habits);

			$this->message(1, '发布完成，请等待审核！','index.php?u=article-index');
		}
	}
	
	// 编辑文章
	public function edit() {
		$this->assign_value('navkey', 'my-index');
		$this->assign('_cfg', $this->_cfg);
		if(empty($_POST)) {
			$id = intval(R('id'));
			$cid = intval(R('cid'));
	
			$cidhtml = $this->category->get_cidhtml_by_mid($this->_mid, $cid);
			$this->assign('cidhtml', $cidhtml);
			
			// 读取内容
			$this->cms_content->table = $this->_table;
				
			$data = $this->cms_content->get($id);
			if(empty($data)) $this->message(0, '内容不存在！');	
				
			$data['content'] = htmlspecialchars($data['content']);
			$data['intro'] = str_replace('<br />', "\n", strip_tags($data['intro'], '<br>'));
			$data['pic_src'] = empty($data['pic']) ? '../static/img/nopic.gif' : '../'.$data['pic'];
			$this->assign('data', $data);
				
			//用于编辑器定位到模型ID
			$edit_cid_id = '&mid='.$this->_audit_mid.'&cid='.$data['cid'].'&id='.$data['id'];
			$this->assign('edit_cid_id', $edit_cid_id);
	
			$this->display('article_set.htm');
		}else{
				
			$cid = intval( R('cid','P') );
			empty($cid) && $this->message(0, '请选择分类！');
				
			$uid = $this->_user['uid'];
				
			//主表数据
			$info = R('info','P');
			$info['cid'] = $cid;
			$id = intval( $info['id'] );
			$info['title'] = trim(strip_tags($info['title']));
				
			empty($info['title']) && $this->message(0, '标题不能为空！');
	
			$categorys = $this->category->read($info['cid']);
			if(empty($categorys)) $this->message(0, '分类ID不存在！');
			
			$code = R('code','P');
			empty($code) && $this->message(0, '请输入验证码！');
			if( md5($code) != session::get('postcode') ){
				$this->message(0, '验证码不正确！');
			}
			
				
			$contentstr = trim($info['content']);
			
			$table = 'audit_article';
			$mid = $this->_audit_mid;

			// 如果摘要为空，自动生成摘要
			$info['intro'] = $this->auto_intro($info['intro'], $contentstr);
			
			// 写入内容表
			$info['lasttime'] = $_ENV['_time'];
			
			$info['status'] = 0;	//待审核状态

			$this->cms_content->table = 'cms_'.$table;
			if(!$this->cms_content->update($info)) {
				$this->message(0, '更新内容表出错');
			}
			$this->message(1, '编辑完成','index.php?u=article-index');
		}
	}
	
	//删除
	public function del(){
		$id = (int) R('id', 'P');
		$cid = (int) R('cid', 'P');

		empty($id) && $this->message(0,'内容ID不能为空！');
		empty($cid) && $this->message(0,'分类ID不能为空！');
		
		$this->cms_content->table = 'cms_article';
		
		//是否属于该用户
		$data = $this->cms_content->get($id);
		if( empty($data) || $data['cid'] != $cid || $data['uid'] != $this->_uid ){
			$this->message(0,'无效请求！');
		}

		// hook user_article_control_del_after.php

		$err = $this->cms_content->xdelete('article', $id, $cid);
		if($err) {
			$this->message(0,$err);
		}else{
			$this->message(1,'删除文章成功！','index.php?u=my-index');
		}
	}
	
	//删除待审核内容
	public function delaudit(){
		$id = (int) R('id', 'P');
		empty($id) && $this->message(0,'内容ID不能为空！');
		
		$this->cms_content->table = 'cms_audit_article';
		
		//是否属于该用户
		$data = $this->cms_content->get($id);
		if( empty($data) || $data['uid'] != $this->_uid ){
			$this->message(0,'无效请求！');
		}
		$this->cms_content->delete($id);
		$this->message(1,'删除成功!','index.php?u=article-index');
	}
	
	// 自动保存
	public function auto_save() {
		$this->kv->set('auto_save_article_uid_'.$this->_user['uid'], $_POST) ? E(0, '自动保存成功！') : E(1, '自动保存失败！');
	}
	
	// 自动生成摘要
	private function auto_intro($intro, &$content) {
		if(empty($intro)) {
			$intro = preg_replace('/\s{2,}/', ' ', strip_tags($content));
			return trim(utf8::cutstr_cn($intro, 255, ''));
		}else{
			return str_replace(array("\r\n", "\r", "\n"), '<br />', strip_tags($intro));
		}
	}
}
