<?php
defined('PP_PATH') or exit;
class user_control extends control{
	public $_user = array();	// 用户
	public $_uid = 0;	//UID
	public $_group = array();	// 当前组
	public $_cfg = array();	// 全站参数
	public $_navs = array();	// 导航
	public $_navgroup = '';
	
	function __construct() {
		$this->assign_value('core', F_APP_NAME);
		$this->assign('navgroup', $this->_navgroup);
		
		$this->_cfg 			= $this->runtime->xget('cfg');
		$this->_cfg['titles'] 	= $this->_cfg['webname'];
		$this->_cfg['FORM_HASH'] = form_hash();
		$this->assign('pp', $this->_cfg);
		
		if( empty($this->_cfg['user']['open_user_model']) ){	//关闭用户模块
			$this->message(0, '用户中心暂时关闭！',$this->_cfg['weburl']);
			//E(1, '用户中心暂时关闭！');
		}

		$this->_uid = session::get('_uid');
		
		$err = 1;
		$_ENV['_hometheme'] 		= $this->_cfg['theme'];

		if($this->_uid){
			$err = 0;
			$user 			= 	&$this->user;
			$user_group 	= &$this->user_group;
			$this->_user 	= $user->get($this->_uid);	//当前用户信息
			
			$user->format($this->_user);

			if($this->_user['status'] == 2 ){
				session::delete('_uid');
				session::destory();
				$this->message(0, '该账号已被冻结！',$this->_cfg['weburl']);
			}

			$group = $user_group->get($this->_user['groupid']);
			$user_group->format($group);
			$this->_group = $group;
			
			
			$this->init_navigation();

			$this->assign('user', $this->_user);
			$this->assign('group', $this->_group);
			//未开启推广时　去掉推广菜单
			if(empty($this->_cfg['user']['open_sem'])){
				unset($this->_navs[1]['book'][3]);
			}
			$this->assign('_navs', $this->_navs);
			
		}
		if($err) {
			if(R('ajax')) {
				$this->message(0, '非法访问，请登陆后再试！', 'index.php?u=public-login');
			}
			exit('<html><body><script>top.location="index.php?u=public-login"</script></body></html>');
		}
	}
	protected function init_navigation() {
		$this->_navs = array(
			array(
				'book'=>'订单管理',				
				'other'=>'其他管理',
			),
			array(
				'book'=>array(
					array('name'=>'已购买的资源', 'url'=>'index.php?u=book-index', 'key'=>'book-index', 'class'=>'icon-list'),
					array('name'=>'资金流水', 'url'=>'index.php?u=record-index', 'key'=>'record-index', 'class'=>'icon-credit-card'),
					array('name'=>'在线充值', 'url'=>'index.php?u=record-order', 'key'=>'record-order', 'class'=>'icon-coin-yen'),
					array('name'=>'我的推广', 'url'=>'index.php?u=promotion-index', 'key'=>'promotion-index', 'class'=>'icon-gift'),
					array('name'=>'快速提现', 'url'=>'index.php?u=withdraw-index', 'key'=>'withdraw-index', 'class'=>'icon-pig'),

				),
				'other'=>array(
					array('name'=>'修改资料', 'url'=>'index.php?u=index-profile', 'key'=>'index-profile', 'class'=>'icon-pencil'),
					array('name'=>'修改密码', 'url'=>'index.php?u=index-password', 'key'=>'index-password', 'class'=>'icon-key'),
					//array('name'=>'留言反馈', 'url'=>'index.php?u=guestbook-index', 'key'=>'guestbook-index', 'class'=>'icon-book'),
					array('name'=>'我的评价', 'url'=>'index.php?u=comment-index', 'key'=>'comment-index', 'class'=>'icon-bubble'),
				)
			),
		);
	}
	
	//重写父类的信息提示方法
	public function message($status, $message, $jumpurl = '', $delay = 2) {
		if(R('ajax')) {
			$status = $status == 1 ? 0:1;	//AJAX返回0表示成功，1表示失败
			echo json_encode(array('err'=>$status, 'msg'=>$message, 'jumpurl'=>$jumpurl, 'delay'=>$delay));
		}else{
			if(empty($jumpurl)) {
				$jumpurl = empty($_SERVER['HTTP_REFERER']) ? '' : $_SERVER['HTTP_REFERER'];
			}
			include FINE_PATH.'tpl/sys_message.php';
		}
		exit;
	}
}