<?php
defined('FINE_PATH') || exit;

/**
 * 内容页模块
 * @param string dateformat 时间格式
 * @param int show_prev_next 显示上下翻页
 * @return array
 */
function kp_block_global_show($conf) {
	global $run, $_show;

	$dateformat = empty($conf['dateformat']) ? 'Y-m-d H:i:s' : $conf['dateformat'];
	$show_prev_next = isset($conf['show_prev_next']) && (int)$conf['show_prev_next'] ? true : false;

	// 排除单页模型
	$mid = &$run->_var['mid'];
	if($mid == 1) return FALSE;

	// 初始模型表名
	$run->cms_content_data->table = 'cms_'.$run->_var['table'].'_data';

	// 格式化
	$run->cms_content->format($_show, $mid, $dateformat,0,0,1);

	// 合并大数据字段
	$id = &$_show['id'];
	$title = &$_show['title'];
	$_show['comment_url'] = $run->cms_content->comment_url($run->_var['cid'], $id);
	$_show['views_url'] = $run->_cfg['webdir'].'index.php?u=views--cid-'.$run->_var['cid'].'-id-'.$id;

	$data = $run->cms_content_data->read($id);
	if($data) $_show += $data;

	if(isset($_show['images'])){
		$_show['images'] = (array)_json_decode($_show['images']);
		foreach($_show['images'] as &$v) {
			$v['big'] = $run->_cfg['webdir'].$v['big'];
			$v['thumb'] = $run->_cfg['webdir'].$v['thumb'];
		}
	}
	if(isset($_show['downs'])){
		$_show['downs'] = (array)_json_decode($_show['downs']);
	}
	if($_show['pic']){
		$_show['bigpic'] = str_replace('_thumb','',$_show['pic']);
	}
	$_show['cate_arr'] = $run->category->get_place($_show['cid']);
	
	//VIP价格 限资源模型
	if($mid == 2){
		$_user = &$run->_user;
		$_group = &$run->_group;

		if(!empty($_user['uid']) && !empty($_group['percent'])){
			$_show['vipprice'] 		= number_format($_show['vipprice'] * $_group['percent'] / 10, 2, ".", "") ;
		}
		if(!empty($_group['issuper'])){
			$_show['vipprice'] 		= 0 ; //超级VIP，全站免费
		}
		$is_yes = 0 ;	//无下载权限
		$err 	= ''; 	//错误提示
		if($_show['price']==0){	//免费
			$is_yes = 1 ;
			if(empty($_user['uid'])){
				$is_yes = 0 ;
				$err 	.= '<li>请登陆后下载！<a href=\"'.$run->_cfg['webdir'].'member\" class="btn btn-link btn-xs"><i class=\"icon-link\"></i> 立即登陆！</a></li>';
			}
		}else{
			if(!empty($_group['issuper']) && empty($_show['vipprice'])){
				$is_yes = 1 ;	//超级用户全站免费下载
			}else{
				if($_show['isBuyed']){
					$is_yes = 1 ;
				}else{
					$err 	.= '<li>请购买后下载！</li>';
				}
			}
		}
		$_groupid	= !empty($_user['groupid']) ? $_user['groupid'] : 0 ;
		$group_arr 	= $run->user_group->get_groups();
		$_show['need_groupname']	= !empty($_show['need_groupid']) ? $group_arr["user_group-groupid-".$_show['need_groupid']]['groupname'] : '' ;
		
		if($_show['need_groupid'] > $_groupid && empty($_group['issuper']) && empty($_show['isBuyed'])){	//指定下载用户组，超级用户不受此限制；已购买过的不受此限制
			$is_yes 	= 0 ;

			$webdir 	= str_replace("/","\/",$run->_cfg['webdir']);
			$err 		.= '<li>需至少升级到“<b>'.$group_arr["user_group-groupid-".$_show['need_groupid']]['groupname'].'</b>”方可下载！<a href=\"'.$run->_cfg['webdir'].'member\" class="btn btn-link btn-xs"><i class=\"icon-link\"></i> 立即升级！</a></li>';
		}
		$_show['is_yes'] 		= $is_yes ;
		$_show['down_err'] 		= !empty($err) ? '<ul class=\"pull-left text-left\">'.$err.'</ul>' : '' ;
	}

	// 显示上下翻页 (大数据站点建议关闭)
	if($show_prev_next) {
		// 上一页
		$_show['prev'] = $run->cms_content->find_fetch(array('cid' => $run->_var['cid'], 'id'=>array('<'=> $id)), array('id'=>-1), 0 , 1);
		$_show['prev'] = current($_show['prev']);
		$run->cms_content->format($_show['prev'], $mid, $dateformat);

		// 下一页
		$_show['next'] = $run->cms_content->find_fetch(array('cid' => $run->_var['cid'], 'id'=>array('>'=> $id)), array('id'=>1), 0 , 1);
		$_show['next'] = current($_show['next']);
		$run->cms_content->format($_show['next'], $mid, $dateformat);
	}

	return $_show;
}
