<?php
defined('FINE_PATH') || exit;
/**
 * 调用最新订单 
 * @param int limit	调用数量
 * @param int titlenum 标题长度
 * @param string dateformat 时间格式
 * @param int humandate 人性化时间显示 默认开启 (开启: 1 关闭: 0)
 * @param int orderway 降序(-1),升序(1)
 * @return array
 */
function kp_block_order($conf) {
	global $run, $_show;

	$limit = empty($conf['limit']) ? 20 : max(1, (int)$conf['limit']);
	$titlenum = _int($conf, 'titlenum');
	$dateformat = empty($conf['dateformat']) ? 'Y-m-d H:i:s' : $conf['dateformat'];
	$humandate = isset($conf['humandate']) ? ($conf['humandate'] == 1 ? 1 : 0) : 1;
	$orderway = isset($conf['orderway']) && $conf['orderway'] == 1 ? 1 : -1;

	$list_arr = $run->cms_content_book->find_fetch(array(), array('id' => $orderway), 0, $limit);
	foreach($list_arr as &$v) {
		$run->cms_content_book->formatbook($v, false, $humandate ,$titlenum);
		$user = $run->user->get($v['uid']);
		$v['user'] 	= other::hidecard(2,$user['username']);
	}
	return array('list' => $list_arr);
}
