<?php
defined('PP_PATH') or exit;
class cms_comment extends model {
	function __construct() {
		$this->table = 'cms_comment';
		$this->pri = array('commentid');	// 主键
		$this->maxid = 'commentid';		// 自增字段
	}
	public function format(&$v, $dateformat = 'Y-m-d', $humandate = TRUE) {
		if(empty($v)) return FALSE;
	
		$v['date'] 		= $humandate ? human_date($v['dateline'], $dateformat) : date($dateformat, $v['dateline']);
		$v['ip'] 		= long2ip($v['ip']);
		$v['ip'] 		= other::hidecard(3,$v['ip']);
		$v['author_full'] 		= $v['author'];
		$v['author'] 	= other::hidecard(2,$v['author']);

		// if($v['uid']){
			// $user = $this->user->read($v['uid']);
		// }
	}
	public function list_arr($where, $orderway, $start, $limit, $total) {
		if($start > 1000 && $total > 2000 && $start > $total/2) {
			$orderway = -$orderway;
			$newstart = $total-$start-$limit;
			if($newstart < 0) {
				$limit += $newstart;
				$newstart = 0;
			}
			$list_arr = $this->find_fetch($where, array('commentid' => $orderway), $newstart, $limit);
			return array_reverse($list_arr, TRUE);
		}else{
			return $this->find_fetch($where, array('commentid' => $orderway), $start, $limit);
		}
	}
	public function xdelete($table, $id, $commentid,$status,$uid) {
		$this->cms_content->table = 'cms_'.$table;
		if($status < 1){//已审核的减少数量
			$data = $this->cms_content->read($id);
			if(empty($data)) return '读取内容表出错！';
			if($data['comments'] > 0) {
				$data['comments']--;
				if(!$this->cms_content->update($data)) return '更新内容评论数量出错！';
			}
		}
		if($uid > 0 ){
			$userdata = $this->user->read($uid);
			if( $userdata['comments'] ){
				$userdata['comments']--;
				if(!$this->user->update($userdata)) return '更新用户评论数量出错！';
			}
		}
		return $this->delete($commentid) ? '' : '删除失败！';
	}
}
