<?php
defined('PP_PATH') or exit;
class cms_content_book extends model {
	function __construct() {
		$this->table = 'cms_book';	
		$this->pri = array('id');	// 主键
		$this->maxid = 'id';			// 自增字段
	}
	function __get($var) {
		if($var == 'cfg') {
			return $this->cfg = $this->runtime->xget();
		}else{
			return parent::__get($var);
		}
	}

	public function list_arr($where, $orderby, $orderway, $start, $limit, $total) {
		if($start > 1000 && $total > 2000 && $start > $total/2) {
			$orderway = -$orderway;
			$newstart = $total-$start-$limit;
			if($newstart < 0) {
				$limit += $newstart;
				$newstart = 0;
			}
			$list_arr = $this->find_fetch($where, array($orderby => $orderway), $newstart, $limit);
			return array_reverse($list_arr, TRUE);
		}else{
			return $this->find_fetch($where, array($orderby => $orderway), $start, $limit);
		}
	}
	public function formatbook(&$v, $dateformat = 'Y年m月d日',$humandate = TRUE, $titlenum = 0) {
		if(empty($v)) return FALSE;
		$v['data'] 		= $this->get_book_pro($v['cid'],$v['pid'],$titlenum);
		$v['goldarr'] 	= $this->get_golds($v['cid'],$v['pid']);
		$v['date'] 		= $humandate ? human_date($v['dateline'], $dateformat) : date($dateformat, $v['dateline']);
	}
	//自动评价 - 仅下载模型　3天内未做出评价的自动处理
	public function auto_comments(&$v) {
		if(empty($v)) return FALSE;
		$bookdata = $this->get($v['id']);
		//更新订单已评论状态
		$bookdata['is_comments'] = 1 ;
		$this->update($bookdata);
		//更新评分
		$mgolds = &$this->models->cms_content_golds;
		$mgolds->table = 'cms_products_golds';
		$data = $mgolds->get($v['pid']);
		if(!empty($data)){
			$data['gold'] 	= number_format(($data['gold'] * $data['golder'] + 5)/($data['golder'] + 1),1);
			$data['golder'] ++;
			$mgolds->update($data);
		}else{
			$this->cms_content_golds->table = 'cms_'.$table.'_golds';
			$mgolds->set($v['pid'], array('cid' => $v['cid'], 'gold' => 5, 'golder' => 1)) ;
		}
		//用户评论数+1
		$user = $this->user->read($v['uid']);
		$user['comments'] += 1;
		$this->user->update($user);
		//添加评论内容
		$maxid = $this->cms_comment->create(array(
			'id' 		=> $v['pid'],
			'mid' 		=> 2,
			'uid' 		=> $v['uid'],
			'author' 	=> $user['username'],
			'content' 	=> '未评价，系统默认好评！',
			'ip' 		=> ip2long(ip()),
			'dateline' 	=> $v['dateline'], //$_ENV['_time']
			'status' 	=> 0,
		));
		//内容的评论数量+1
		$this->cms_content->table = 'cms_products';
		$prodata = $this->cms_content->get($v['pid']);
		$prodata['comments']++;
		$this->cms_content->update($prodata);

	}
	public function get_golds(&$cid, &$id) {
		$mgolds = &$this->models->cms_content_golds;
		$mgolds->table = 'cms_products_golds';
		$data = $mgolds->get($id);
		if(!$data) $data = array('id'=>$id, 'cid'=>$cid, 'gold'=>0, 'golder'=>0);
		return array('gold'=>$data['gold'],'golder'=>$data['golder']);
	}
	public function get_book_pro(&$cid, &$id,&$titlenum) {
		$_var = $this->category->get_cache($cid);
		$pros = &$this->models->cms_content;
		$prodata = &$this->models->cms_content_data;
		$pros->table = 'cms_'.$_var['table'];
		$prodata->table = 'cms_'.$_var['table'].'_data';
		try{
			$data = $pros->read($id);
			if(!empty($data)){
				$_data = $prodata->read($id);
				if($_data) $data['downs'] = (array)_json_decode($_data['downs']);
				$data['url'] = $this->content_url($data['cid'], $data['id'], $data['alias'], $data['dateline']);
				$data['subject'] = $titlenum ? utf8::cutstr_cn($data['title'], $titlenum) : $data['title'];
				return $data;
			}
		}catch(Exception $e) {}
		$data['url'] = "javascript:;";
		$data['subject'] = "此资源已删除";
		return $data;
	}
	//是否已购买
	function isBuyed($pid){
		$data = $this->find_fetch(array('pid'=>$pid,'uid'=>session::get('_uid'),'totalprice'=>array('>'=>0)), array(), 0, 1);
		return $data ? true : false;
	}
	// 根据订单号获取数据
	public function get_by_oid($order_id) {
		$data = $this->find_fetch(array('order_id'=>$order_id), array(), 0, 1);
		return $data ? array_pop($data) : array();
	}
	public function content_url(&$cid, &$id, &$alias, &$dateline) {
		if(empty($_ENV['_config']['nzcms_parseurl'])) {
			return $this->cfg['webdir'].'index.php?show--cid-'.$cid.'-id-'.$id.$_ENV['_config']['url_suffix'];
		}else{
			switch($this->cfg['link_show_type']) {
				case 1:
					return $this->cfg['webdir'].$cid.'/'.$id.$this->cfg['link_show_end'];
				case 2:
					return $this->cfg['webdir'].$this->cfg['cate_arr'][$cid].'/'.$id.$this->cfg['link_show_end'];
				case 3:
					return $this->cfg['webdir'].($alias ? $alias : $cid.'_'.$id).$this->cfg['link_show_end'];
				default:
					return $this->cfg['webdir'].strtr($this->cfg['link_show'], array(
						'{cid}' => $cid,
						'{id}' => $id,
						'{alias}' => $alias ? $alias : $cid.'_'.$id,
						'{cate_alias}' => $this->cfg['cate_arr'][$cid],
						'{y}' => date('Y', $dateline),
						'{m}' => date('m', $dateline),
						'{d}' => date('d', $dateline)
					));
			}
		}
	}
}