<?php function runtime() { return number_format(microtime(1) - $_ENV['_start_time'], 4); } function runmem() { return MEMORY_LIMIT_ON ? get_byte(memory_get_usage() - $_ENV['_start_memory']) : 'unknown'; } function ip() { if(isset($_SERVER['HTTP_X_FORWARDED_FOR'])) { preg_match('#[\d\.]{7,15}#', $_SERVER['HTTP_X_FORWARDED_FOR'], $mat); $ip = $mat[0]; }elseif(isset($_SERVER['HTTP_CLIENT_IP'])) { $ip = $_SERVER['HTTP_CLIENT_IP']; }elseif(isset($_SERVER['REMOTE_ADDR'])) { $ip = $_SERVER['REMOTE_ADDR']; } return long2ip(ip2long($ip)); } function E($err, $msg, $name = '') { exit('{"err":'.$err.', "msg":"'.$msg.'", "name":"'.$name.'"}'); } function ME($err, $msg) { exit(json_encode(array('err'=>$err,'msg'=>$msg))); } function R($k, $var = 'G') { switch($var) { case 'G': $var = &$_GET; break; case 'P': $var = &$_POST; break; case 'C': $var = &$_COOKIE; break; case 'R': $var = isset($_GET[$k]) ? $_GET : (isset($_POST[$k]) ? $_POST : $_COOKIE); break; case 'S': $var = &$_SERVER; break; } return isset($var[$k]) ? $var[$k] : null; } function C($key, $val = null) { if(is_null($val)) return isset($_ENV['_config'][$key]) ? $_ENV['_config'][$key] : $val; return $_ENV['_config'][$key] = $val; } function FW($filename, $data) { $dir = dirname($filename); is_dir($dir) || mkdir($dir, 0755, true); return file_put_contents($filename, $data); } function _setcookie($name, $value='', $expire=0, $path='', $domain='', $secure=false, $httponly=false) { $name = $_ENV['_config']['cookie_pre'].$name; if(!$path) $path = $_ENV['_config']['cookie_path']; if(!$domain) $domain = $_ENV['_config']['cookie_domain']; $_COOKIE[$name] = $value; return setcookie($name, $value, $expire, $path, $domain, $secure, $httponly); } function _addslashes(&$var) { if(is_array($var)) { foreach($var as $k=>&$v) _addslashes($v); }else{ $var = addslashes($var); } } function _stripslashes(&$var) { if(is_array($var)) { foreach($var as $k=>&$v) _stripslashes($v); }else{ $var = stripslashes($var); } } function _htmls(&$var) { if(is_array($var)) { foreach($var as $k=>&$v) _htmls($v); }else{ $var = htmlspecialchars($var); } } function _trim(&$var) { if(is_array($var)) { foreach($var as $k=>&$v) _trim($v); }else{ $var = trim($var); } } function _urlencode($s) { return str_replace('-', '%2D', urlencode($s)); } function _json_decode($s) { return $s === FALSE ? FALSE : json_decode($s, true); } function _json_encode($arr) { if(!is_array($arr) && empty($arr)) return ''; $s = '{'; foreach($arr as $k=>$v) { $s .= '"'.$k.'":"'.strtr($v, array('\\'=>'\\\\', '"'=>'\"')).'",'; } return rtrim($s, ',').'}'; } function _array_multisort(&$data, $c_1, $c_2 = true, $a_1 = 1, $a_2 = 1) { if(!is_array($data)) return $data; $col_1 = $col_2 = array(); foreach($data as $key => $row) { $col_1[$key] = $row[$c_1]; $col_2[$key] = $c_2===true ? $key : $row[$c_2]; } $asc_1 = $a_1 ? SORT_DESC : SORT_ASC; $asc_2 = $a_2 ? SORT_DESC : SORT_ASC; array_multisort($col_1, $asc_1, $col_2, $asc_2, $data); return $data; } function _int(&$c, $k, $v = 0) { if(isset($c[$k])) { $i = intval($c[$k]); return $i ? $i : $v; }else{ return $v; } } function _scandir($dir) { if(function_exists('scandir')) return scandir($dir); $dh = opendir($dir); $arr = array(); while($file = readdir($dh)) { if($file == '.' || $file == '..') continue; $arr[] = $file; } closedir($dh); return $arr; } function _rmdir($dir, $keepdir = 0) { if(!is_dir($dir) || $dir == '/' || $dir == '../') return FALSE; $files = _scandir($dir); foreach($files as $file) { if($file == '.' || $file == '..') continue; $filepath = $dir.'/'.$file; if(!is_dir($filepath)) { try{unlink($filepath);}catch(Exception $e){} }else{ _rmdir($filepath); } } if(!$keepdir) try{rmdir($dir);}catch(Exception $e){} return TRUE; } function _is_writable($file) { try{ if(is_dir($file)) { $tmpfile = $file.'/_test.tmp'; $n = @file_put_contents($tmpfile, 'test'); if($n > 0) { unlink($tmpfile); return TRUE; }else{ return FALSE; } }elseif(is_file($file)) { if(strpos(strtoupper(PHP_OS), 'WIN') !== FALSE) { $fp = @fopen($file, 'a'); @fclose($fp); return (bool)$fp; }else{ return is_writable($file); } } }catch(Exception $e) {} return FALSE; } function _strip_whitespace($content) { $tokens = token_get_all($content); $last = FALSE; $s = ''; for($i = 0, $j = count($tokens); $i < $j; $i++) { if(is_string($tokens[$i])) { $last = FALSE; $s .= $tokens[$i]; }else{ switch($tokens[$i][0]) { case T_COMMENT: case T_DOC_COMMENT: break; case T_WHITESPACE: if(!$last) { $s .= ' '; $last = TRUE; } break; case T_START_HEREDOC: $s .= "<<<FINE\n"; break; case T_END_HEREDOC: $s .= "FINE;\n"; for($k = $i+1; $k < $j; $k++) { if(is_string($tokens[$k]) && $tokens[$k] == ';') { $i = $k; break; }elseif($tokens[$k][0] == T_CLOSE_TAG) { break; } } break; default: $last = FALSE; $s .= $tokens[$i][1]; } } } return $s; } function random($length, $type = 1, $chars = '0123456789abcdefghijklmnopqrstuvwxyz') { if($type == 1) { $hash = sprintf('%0'.$length.'d', mt_rand(0, pow(10, $length) - 1)); } else { $hash = ''; if($type == 3) $chars .= 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'; $max = strlen($chars) - 1; for($i = 0; $i < $length; $i++) $hash .= $chars[mt_rand(0, $max)]; } return $hash; } function get_byte($byte) { if($byte < 1024) { return $byte.' Byte'; }elseif($byte < 1048576) { return round($byte/1024, 2).' KB'; }elseif($byte < 1073741824) { return round($byte/1048576, 2).' MB'; }elseif($byte < 1099511627776) { return round($byte/1073741824, 2).' GB'; }else{ return round($byte/1099511627776, 2).' TB'; } } function human_date($dateline, $dateformat = 'Y-m-d H:i:s') { $second = $_ENV['_time'] - $dateline; if($second > 31536000) { return date($dateformat, $dateline); }elseif($second > 2592000) { return floor($second / 2592000).'月前'; }elseif($second > 86400) { return floor($second / 86400).'天前'; }elseif($second > 3600) { return floor($second / 3600).'小时前'; }elseif($second > 60) { return floor($second / 60).'分钟前'; }else{ return $second.'秒前'; } } function safe_str($s, $ext = '') { $ext = preg_quote($ext); $s = preg_replace('#[^\040\w\x{4E00}-\x{9FA5}\x{30A0}-\x{30FF}\x{3040}-\x{309F}\x{1100}-\x{11FF}\x{3130}-\x{318F}\x{AC00}-\x{D7AF}'.$ext.']+#u', '', $s); $s = trim($s); return $s; } function get_dirs($path, $fullpath = false) { $arr = array(); $dh = opendir($path); while($dir = readdir($dh)) { if(preg_match('#\W#', $dir) || !is_dir($path.$dir)) continue; $arr[] = $fullpath ? $path.$dir.'/' : $dir; } sort($arr); return $arr; } function str_replace_once($search, $replace, $content) { $pos = strpos($content, $search); if($pos === false) return $content; return substr_replace($content, $replace, $pos, strlen($search)); } function str_auth($string, $operation = 'DECODE', $key = '', $expiry = 0) { $ckey_length = 4; $key = md5($key != '' ? $key : C('auth_key')); $keya = md5(substr($key, 0, 16)); $keyb = md5(substr($key, 16, 16)); $keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : ''; $cryptkey = $keya.md5($keya.$keyc); $key_length = strlen($cryptkey); $string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0).substr(md5($string.$keyb), 0, 16).$string; $string_length = strlen($string); $result = ''; $box = range(0, 255); $rndkey = array(); for($i = 0; $i <= 255; $i++) { $rndkey[$i] = ord($cryptkey[$i % $key_length]); } for($j = $i = 0; $i < 256; $i++) { $j = ($j + $box[$i] + $rndkey[$i]) % 256; $tmp = $box[$i]; $box[$i] = $box[$j]; $box[$j] = $tmp; } for($a = $j = $i = 0; $i < $string_length; $i++) { $a = ($a + 1) % 256; $j = ($j + $box[$a]) % 256; $tmp = $box[$a]; $box[$a] = $box[$j]; $box[$j] = $tmp; $result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256])); } if($operation == 'DECODE') { if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) { return substr($result, 26); }else{ return ''; } }else{ return $keyc.str_replace('=', '', base64_encode($result)); } } function form_hash() { return substr(md5(substr($_ENV['_time'], 0, -5).$_ENV['_config']['auth_key']), 16); } function form_submit() { return R('FORM_HASH', 'P') == form_hash(); } function fetch_url($url, $timeout = 30) { $opts = array ('http'=>array('method'=>'GET', 'timeout'=>$timeout)); $context = stream_context_create($opts); $html = file_get_contents($url, false, $context); return $html; } function pp_pages($page, $maxpage, $url, $offset = 5, $lang = array('&#171;', '&#187;')) { if($maxpage < 2) return ''; $pnum = $offset*2; $ismore = $maxpage > $pnum; $s = ''; $ua = explode('{page}', $url); if($page > 1) $s .= '<li><a href="'.$ua[0].($page-1).$ua[1].'">'.$lang[0].'</a></li>'; if($ismore) { $i_end = min($maxpage, max($pnum, $page+$offset)) - 1; $i = max(2, $i_end-$pnum+2); }else{ $i_end = min($maxpage, $pnum)-1; $i = 2; } $s .= $page == 1 ? '<li class="active"><a href="javascript:;">1</a></li>' : '<li><a href="'.$ua[0].'1'.$ua[1].'">1'.($ismore && $i > 2 ? ' ...' : '').'</a></li>'; for($i; $i<=$i_end; $i++){ $s .= $page == $i ? '<li class="active"><a href="javascript:;">'.$i.'</a></li>' : '<li><a href="'.$ua[0].$i.$ua[1].'">'.$i.'</a></li>'; } $s .= $page == $maxpage ? '<li class="active"><a href="javascript:;">'.$maxpage.'</a></li>' : '<li><a href="'.$ua[0].$maxpage.$ua[1].'">'.($ismore && $i_end < $maxpage-1 ? '... ' : '').$maxpage.'</a></li>'; if($page < $maxpage) $s .= '<li><a href="'.$ua[0].($page+1).$ua[1].'">'.$lang[1].'</a></li>'; return $s; } function user_pages($page, $maxpage, $url, $offset = 5, $lang = array('&#171;', '&#187;')) { if($maxpage < 2) return ''; $pnum = $offset*2; $ismore = $maxpage > $pnum; $s = ''; $ua = explode('{page}', $url); if($page > 1) $s .= '<li><a href="'.$ua[0].($page-1).$ua[1].'">'.$lang[0].'</a></li>'; if($ismore) { $i_end = min($maxpage, max($pnum, $page+$offset)) - 1; $i = max(2, $i_end-$pnum+2); }else{ $i_end = min($maxpage, $pnum)-1; $i = 2; } $s .= $page == 1 ? '<li class="active"><a href="javascript:;">1</a></li>' : '<li><a href="'.$ua[0].'1'.$ua[1].'">1'.($ismore && $i > 2 ? ' ...' : '').'</a></li>'; for($i; $i<=$i_end; $i++){ $s .= $page == $i ? '<li class="active"><a href="javascript:;">'.$i.'</a></li>' : '<li><a href="'.$ua[0].$i.$ua[1].'">'.$i.'</a></li>'; } $s .= $page == $maxpage ? '<li class="active"><a href="javascript:;">'.$maxpage.'</a></li>' : '<li><a href="'.$ua[0].$maxpage.$ua[1].'">'.($ismore && $i_end < $maxpage-1 ? '... ' : '').$maxpage.'</a></li>'; if($page < $maxpage) $s .= '<li><a href="'.$ua[0].($page+1).$ua[1].'">'.$lang[1].'</a></li>'; return $s; } function pages($page, $maxpage, $url, $offset = 5, $lang = array('&#171;', '&#187;')) { if($maxpage < 2) return ''; $pnum = $offset*2; $ismore = $maxpage > $pnum; $s = ''; $ua = explode('{page}', $url); if($page > 1) $s .= '<a href="'.$ua[0].($page-1).$ua[1].'">'.$lang[0].'</a>'; if($ismore) { $i_end = min($maxpage, max($pnum, $page+$offset)) - 1; $i = max(2, $i_end-$pnum+2); }else{ $i_end = min($maxpage, $pnum)-1; $i = 2; } $s .= $page == 1 ? '<b>1</b>' : '<a href="'.$ua[0].'1'.$ua[1].'">1'.($ismore && $i > 2 ? ' ...' : '').'</a>'; for($i; $i<=$i_end; $i++){ $s .= $page == $i ? '<b>'.$i.'</b>' : '<a href="'.$ua[0].$i.$ua[1].'">'.$i.'</a>'; } $s .= $page == $maxpage ? '<b>'.$maxpage.'</b>' : '<a href="'.$ua[0].$maxpage.$ua[1].'">'.($ismore && $i_end < $maxpage-1 ? '... ' : '').$maxpage.'</a>'; if($page < $maxpage) $s .= '<a href="'.$ua[0].($page+1).$ua[1].'">'.$lang[1].'</a>'; return $s; } function get_password($password='',$salt=''){ return md5(md5($password).$salt); } function is_mobile() { $is_mobile = R($_ENV['_config']['cookie_pre'].'is_mobile', 'R'); if(isset($is_mobile)) return $is_mobile ? 1 : 0; $mobile_agents = array( 'iphone','ipod','android','samsung','sony','meizu','ericsson','mot','htc','sgh','lg','sharp','sie-', 'philips','panasonic','alcatel','lenovo','blackberry','netfront','symbian','ucweb','windowsce', 'palm','operamini','operamobi','openwave','nexusone','cldc','midp','wap','mobile' ); $is_mobile = 0; $browser = $_SERVER['HTTP_USER_AGENT']; foreach($mobile_agents as $agent) { if(stripos($browser, $agent) !== 0) { $is_mobile = 1; break; } } _setcookie('is_mobile', $is_mobile); return $is_mobile; } function order_number(){ static $ORDERSN=array(); $ors=date('ymd').substr(time(),-5).substr(microtime(),2,5); if (isset($ORDERSN[$ors])) { $ORDERSN[$ors]++; }else{ $ORDERSN[$ors]=1; } return $ors.str_pad($ORDERSN[$ors],2,'0',STR_PAD_LEFT); } function humandate($timestamp,$dateformat) { $time = isset($_SERVER['REQUEST_TIME']) ? $_SERVER['REQUEST_TIME'] : time(); $seconds = $time - $timestamp; if($seconds > 7776000) { return date($dateformat, $timestamp); } elseif($seconds > 2592000) { return floor($seconds / 2592000).'月前'; } elseif($seconds > 86400) { return floor($seconds / 86400).'天前'; } elseif($seconds > 3600) { return floor($seconds / 3600).'小时前'; } elseif($seconds > 60) { return floor($seconds / 60).'分钟前'; } else { return $seconds.'秒前'; } } function t2js($str){ $tmp = str_replace(array("\r", "\n"), array('', '\n'), addslashes($str)); return "document.write(\"$tmp\");"; }class core{ public static function start() { devmode::init(); self::ob_start(); self::init_set(); self::init_get(); self::init_control(); } public static function ob_start() { ob_start(array('core', 'ob_gzip')); } public static function ob_gzip($s) { $gzip = $_ENV['_config']['gzip']; $isfirst = empty($_ENV['_isgzip']); if($gzip) { if(function_exists('ini_get') && ini_get('zlib.output_compression')) { $isfirst && header("Content-Encoding: gzip"); }elseif(function_exists('gzencode') && strpos($_SERVER["HTTP_ACCEPT_ENCODING"], 'gzip') !== FALSE) { $s = gzencode($s, 5); if($isfirst) { header("Content-Encoding: gzip"); } } }elseif($isfirst) { header("Content-Encoding: none"); } $isfirst && $_ENV['_isgzip'] = 1; return $s; } public static function ob_clean() { !empty($_ENV['_isgzip']) && ob_clean(); } public static function ob_end_clean() { !empty($_ENV['_isgzip']) && ob_end_clean(); } public static function init_set() { date_default_timezone_set($_ENV['_config']['zone']); spl_autoload_register(array('core', 'autoload_handler')); if(get_magic_quotes_gpc()) { _stripslashes($_GET); _stripslashes($_POST); _stripslashes($_COOKIE); } $_ENV['_include'] = array(); $_ENV['_time'] = isset($_SERVER['REQUEST_TIME']) ? $_SERVER['REQUEST_TIME'] : time(); $_ENV['_ip'] = ip(); $_ENV['_sqlnum'] = 0; if(!isset($_SERVER['REQUEST_URI'])) { if(isset($_SERVER['HTTP_X_REWRITE_URL'])) { $_SERVER['REQUEST_URI'] = &$_SERVER['HTTP_X_REWRITE_URL']; }else{ $_SERVER['REQUEST_URI'] = ''; $_SERVER['REQUEST_URI'] .= $_SERVER['REQUEST_URI']; $_SERVER['REQUEST_URI'] .= isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : ''; $_SERVER['REQUEST_URI'] .= empty($_SERVER['QUERY_STRING']) ? '' : '?'.$_SERVER['QUERY_STRING']; } } header("Expires: 0"); header("Cache-Control: private, post-check=0, pre-check=0, max-age=0"); header("Pragma: no-cache"); header('Content-Type: text/html; charset=UTF-8'); } public static function autoload_handler($classname) { if(substr($classname, 0, 3) == 'db_') { include FINE_PATH.'db/'.$classname.'.class.php'; }elseif(substr($classname, 0, 6) == 'cache_') { include FINE_PATH.'cache/'.$classname.'.class.php'; }elseif(is_file(FINE_PATH.'ext/'.$classname.'.class.php')) { include FINE_PATH.'ext/'.$classname.'.class.php'; }else{ throw new Exception("类 $classname 不存在"); } return class_exists($classname, false); } public static function init_get() { if(!empty($_ENV['_config'][APP_NAME.'_parseurl'])) { self::parseurl_control(); }else{ if(isset($_GET['u'])) { $u = $_GET['u']; unset($_GET['u']); }elseif(!empty($_SERVER['PATH_INFO'])) { $u = $_SERVER['PATH_INFO']; }else{ $_GET = array(); $u = $_SERVER["QUERY_STRING"]; } $url_suffix = C('url_suffix'); if($url_suffix) { $suf_len = strlen($url_suffix); if(substr($u, -($suf_len)) == $url_suffix) $u = substr($u, 0, -($suf_len)); } $uarr = explode('-', $u); if(isset($uarr[0])) { $_GET['control'] = $uarr[0]; array_shift($uarr); } if(isset($uarr[0])) { $_GET['action'] = $uarr[0]; array_shift($uarr); } $num = count($uarr); for($i=0; $i<$num; $i+=2){ isset($uarr[$i+1]) && $_GET[$uarr[$i]] = $uarr[$i+1]; } } $_GET['control'] = isset($_GET['control']) && preg_match('/^\w+$/', $_GET['control']) ? $_GET['control'] : 'index'; $_GET['action'] = isset($_GET['action']) && preg_match('/^\w+$/', $_GET['action']) ? $_GET['action'] : 'index'; if(in_array($_GET['control'], array('parseurl', 'error404'))) { $_GET['control'] = 'error404'; $_GET['action'] = 'index'; } } public static function parseurl_control() { $controlname = 'parseurl_control.class.php'; $objfile = RUNTIME_CONTROL.$controlname; if(!is_file($objfile)) { $controlfile = self::get_original_file($controlname, CONTROL_PATH); if(!$controlfile) { $_GET['control'] = 'parseurl'; throw new Exception("访问的 URL 不正确，$controlname 文件不存在"); } self::parse_all($controlfile, $objfile, "写入 control 编译文件 $controlname 失败"); } include $objfile; $obj = new parseurl_control(); $obj->index(); } public static function init_control() { $control = &$_GET['control']; $action = &$_GET['action']; $controlname = "{$control}_control.class.php"; $objfile = RUNTIME_CONTROL.$controlname; if(DEVMODE || !is_file($objfile)) { $controlfile = self::get_original_file($controlname, CONTROL_PATH); if($controlfile) { self::parse_all($controlfile, $objfile, "写入 control 编译文件 $controlname 失败"); }else{ self::error404(); } } include $objfile; $class_name = $control.'_control'; $obj = new $class_name(); $obj->$action(); } public static function error404() { log::write('404', 'php_error404.php'); $errorname = 'error404_control.class.php'; $objfile = RUNTIME_CONTROL.$errorname; if(DEVMODE || !is_file($objfile)) { $errorfile = self::get_original_file($errorname, CONTROL_PATH); if(!$errorfile) { throw new Exception("控制器加载失败，$errorname 文件不存在"); } self::parse_all($errorfile, $objfile, "写入 control 编译文件 $errorname 失败"); } include $objfile; $obj = new error404_control(); $obj->index(); exit(); } public static function parse_all($readfile, $writefile, $errorstr){ $s = file_get_contents($readfile); $s = self::parse_extends($s); if(!FW($writefile, $s)) { throw new Exception($errorstr); } } public static function parse_extends($s) { if(preg_match('#class\s+\w+\s+extends\s+(\w+)\s*\{#', $s, $m)) { if($m[1] != 'control') { $controlname = $m[1].'.class.php'; $realfile = CONTROL_PATH.$controlname; if(is_file($realfile)) { $objfile = RUNTIME_CONTROL.$controlname; self::parse_all($realfile, $objfile, "写入继承的类的编译文件 $controlname 失败"); $s = str_replace_once($m[0], 'include RUNTIME_CONTROL.\''.$controlname."'; ".$m[0], $s); }else{ throw new Exception("您继承的类文件 $controlname 不存在"); } } } return $s; } public static function model($model) { $modelname = $model.'_model.class.php'; if(isset($_ENV['_models'][$modelname])) { return $_ENV['_models'][$modelname]; } $objfile = RUNTIME_MODEL.$modelname; if(DEVMODE || !is_file($objfile)) { $modelfile = core::get_original_file($modelname, MODEL_PATH); if(!$modelfile) { throw new Exception("模型 $modelname 文件不存在"); } $s = file_get_contents($modelfile); if(!FW($objfile, $s)) { throw new Exception("写入 model 编译文件 $modelname 失败"); } } include $objfile; $mod = new $model(); $_ENV['_models'][$modelname] = $mod; return $mod; } public static function get_original_file($filename, $path) { if(is_file($path.$filename)) { return $path.$filename; } return FALSE; } public static function clear_code($s) { $s = trim($s); if(substr($s, 0, 5) == '<?php') $s = substr($s, 5); $s = ltrim($s); if(substr($s, 0, 29) == 'defined(\'FINE_PATH\') || exit;') $s = substr($s, 29); if(substr($s, -2, 2) == '?>') $s = substr($s, 0, -2); return $s; } } class devmode{ public static function init() { if(DEVMODE) { error_reporting(E_ALL | E_STRICT); }else{ error_reporting(0); } } } class log { public static function write($s, $file = 'php_error.php') { $time = date('Y-m-d H:i:s', $_ENV['_time']); $ip = $_ENV['_ip']; $url = self::to_str($_SERVER['REQUEST_URI']); $s = self::to_str($s); self::write_log('<?php exit;?>'."	$time	$ip	$url	$s	\r\n", $file); return TRUE; } public static function write_mini($s, $file = 'logs.php') { $time = date('Y-m-d H:i:s', $_ENV['_time']); $s = self::to_str($s); self::write_log('<?php exit;?>'."	$time	$s	\r\n", $file); return TRUE; } public static function to_str($s) { return str_replace(array("\r\n", "\r", "\n", "\t"), ' ', $s); } public static function write_log($s, $file) { $logfile = LOG_PATH.$file; try{ $fp = fopen($logfile, 'ab+'); if(!$fp) { throw new Exception("写入日志失败，文件 $file 不可写或空间已满。"); } fwrite($fp, $s); fclose($fp); }catch(Exception $e) {} return TRUE; } } class model{ public $table; public $pri = array(); public $maxid; static $dbs = array(); static $caches = array(); private $unique = array(); function __get($var) { switch ($var) { case 'db': return $this->db = $this->load_db(); case 'cache': return $this->cache = $this->load_cache(); case 'db_conf': return $this->db_conf = &$_ENV['_config']['db']; case 'cache_conf': return $this->cache_conf = &$_ENV['_config']['cache']; default: return $this->$var = core::model($var); } } function __call($method, $args) { throw new Exception("方法 $method 不存在"); } public function load_db() { $type = $this->db_conf['type']; if(isset($this->db_conf['master'])) { $m = $this->db_conf['master']; $id = $type.'-'.$m['host'].'-'.$m['user'].'-'.$m['password'].'-'.$m['name'].'-'.$m['tablepre']; }else{ $id = $type; } if(isset(self::$dbs[$id])) { return self::$dbs[$id]; }else{ $db = 'db_'.$type; self::$dbs[$id] = new $db($this->db_conf); return self::$dbs[$id]; } } public function load_cache() { $type = $this->cache_conf['type']; if(isset($this->cache_conf[$type])) { $c = $this->cache_conf[$type]; $id = $type.'-'.$c['host'].'-'.$c['port']; }else{ $id = $type; } if(isset(self::$caches[$id])) { return self::$caches[$id]; }else{ $cache = 'cache_'.$type; self::$caches[$id] = new $cache($this->cache_conf); return self::$caches[$id]; } } public function create($data) { if(empty($this->maxid)) { $key = $this->pri2key($data); return $this->cache_db_set($key, $data); }else{ $data[$this->maxid] = $this->maxid('+1'); $key = $this->pri2key($data); $this->count('+1'); if($this->cache_db_set($key, $data)) { return $data[$this->maxid]; }else{ $this->maxid('-1'); $this->count('-1'); return FALSE; } } } public function set($key, $data, $life = 0) { $key = $this->arr2key($key); $this->unique[$key] = $data; return $this->cache_db_set($key, $data, $life); } public function read($arg1, $arg2 = FALSE, $arg3 = FALSE, $arg4 = FALSE) { $arr = ($arg2 !== FALSE) ? $this->arg2arr($arg1, $arg2, $arg3, $arg4) : (array)$arg1; return $this->get($arr); } public function get($arr) { $key = $this->arr2key($arr); if(!isset($this->unique[$key])) { $this->unique[$key] = $this->cache_db_get($key); } return $this->unique[$key]; } public function mget($arr) { $data = array(); foreach($arr as $k=>&$key) { $key = $this->arr2key($key); if(isset($this->unique[$key])) { $data[$key] = $this->unique[$key]; unset($arr[$k]); }else{ $this->unique[$key] = $data[$key] = NULL; } } $data2 = $this->cache_db_multi_get($arr); return array_merge($data, $data2); } public function update($data, $life = 0) { $key = $this->pri2key($data); $this->unique[$key] = $data; return $this->cache_db_update($key, $data, $life); } public function delete($arg1, $arg2 = FALSE, $arg3 = FALSE, $arg4 = FALSE) { $arr = ($arg2 !== FALSE) ? $this->arg2arr($arg1, $arg2, $arg3, $arg4) : (array)$arg1; return $this->del($arr); } public function del($arr) { $key = $this->arr2key($arr); $ret = $this->cache_db_delete($key); if($ret) { unset($this->unique[$key]); $this->count('-1'); } return $ret; } public function truncate() { return $this->cache_db_truncate(); } public function maxid($val = FALSE) { return $this->cache_db_maxid($val); } public function count($val = FALSE) { return $this->cache_db_count($val); } public function find_fetch($where = array(), $order = array(), $start = 0, $limit = 0, $life = 0) { return $this->cache_db_find_fetch($this->table, $this->pri, $where, $order, $start, $limit, $life); } public function find_fetch_key($where = array(), $order = array(), $start = 0, $limit = 0, $life = 0) { return $this->cache_db_find_fetch_key($this->table, $this->pri, $where, $order, $start, $limit, $life); } public function find_update($where, $data, $lowprority = FALSE) { $this->unique = array(); if($this->cache_conf['enable']) { $n = $this->find_count($where); if($n > 2000) { $this->cache->truncate($this->table); }else{ $keys = $this->find_fetch_key($where); foreach($keys as $key) { $this->cache->delete($key); } } } return $this->db->find_update($this->table, $where, $data, $lowprority); } public function find_delete($where, $lowprority = FALSE) { $this->unique = array(); if($this->cache_conf['enable']) { $n = $this->find_count($where); if($n > 2000) { $this->cache->truncate($this->table); }else{ $keys = $this->find_fetch_key($where); foreach($keys as $key) { $this->cache_db_delete($key); } } } $num = $this->db->find_delete($this->table, $where, $lowprority); if(!empty($this->maxid) && $num > 0) { $this->count('-'.$num); } return $num; } public function find_maxid() { return isset($this->maxid) ? $this->db->find_maxid($this->table.'-'.$this->maxid) : 0; } public function find_count($where = array()) { return $this->db->find_count($this->table, $where); } public function find_count_col($key,$where = array()) { return $this->db->find_count_col($key, $where); } public function index_create($index) { return $this->db->index_create($this->table, $index); } public function index_drop($index) { return $this->db->index_drop($this->table, $index); } public function pri2key($arr) { $s = $this->table; foreach($this->pri as $v) { $s .= "-$v-".$arr[$v]; } return $s; } public function arr2key($arr) { $arr = (array)$arr; $s = $this->table; foreach($this->pri as $k=>$v) { if(!isset($arr[$k])) { $err = array(); foreach($this->pri as $pk=>$pv) { $var = isset($arr[$pk]) ? $arr[$pk] : 'null'; $err[] = "'$pv => $var"; } throw new Exception('非法键名数组: array('.implode(', ', $err).');'); } $s .= "-$v-".$arr[$k]; } return $s; } public function arg2arr($arg1, $arg2, $arg3 = FALSE, $arg4 = FALSE) { $arr = (array)$arg1; array_push($arr, $arg2); $arg3 !== FALSE && array_push($arr, $arg3); $arg4 !== FALSE && array_push($arr, $arg4); return $arr; } public function cache_db_get($key) { if($this->cache_conf['enable']) { $data = $this->cache->get($key); if(empty($data)) { $data = $this->db->get($key); $this->cache->set($key, $data); } return $data; }else{ return $this->db->get($key); } } public function cache_db_multi_get($keys) { if($this->cache_conf['enable']) { $data = $this->cache->multi_get($keys); if(empty($data)) { $data = $this->db->multi_get($keys); foreach((array)$data as $k=>$v) { $this->cache->set($k, $v); } }else{ foreach($data as $k=>&$v) { if($v === FALSE) { $v = $this->db->get($k); $this->cache->set($k, $v); } } } return $data; }else{ return $this->db->multi_get($keys); } } public function cache_db_set($key, $data, $life = 0) { $this->cache_conf['enable'] && $this->cache->set($key, $data, $life); return $this->db->set($key, $data); } public function cache_db_update($key, $data, $life = 0) { $this->cache_conf['enable'] && $this->cache->update($key, $data, $life); return $this->db->update($key, $data); } public function cache_db_delete($key) { $this->cache_conf['enable'] && $this->cache->delete($key); return $this->db->delete($key); } public function cache_db_truncate() { $this->cache_conf['enable'] && $this->cache->truncate($this->table); return $this->db->truncate($this->table); } public function cache_db_maxid($val = FALSE) { $key = $this->table.'-'.$this->maxid; if($this->cache_conf['enable']) { if($val === FALSE) { $maxid = $this->cache->maxid($key, $val); if(empty($maxid)) { $maxid = $this->db->maxid($key, $val); $this->cache->maxid($key, $maxid); } return $maxid; }else{ $maxid = $this->db->maxid($key, $val); return $this->cache->maxid($key, $maxid); } }else{ return $this->db->maxid($key, $val); } } public function cache_db_count($val = FALSE) { $key = $this->table; if($this->cache_conf['enable']) { if($val === FALSE) { $rows = $this->cache->count($key, $val); if(empty($rows)) { $rows = $this->db->count($key, $val); $this->cache->count($key, $rows); } return $rows; }else{ $rows = $this->db->count($key, $val); return $this->cache->count($key, $rows); } }else{ return $this->db->count($key, $val); } } public function cache_db_find_fetch($table, $pri, $where = array(), $order = array(), $start = 0, $limit = 0, $life = 0) { if($this->db_conf['type'] == 'mongodb') { return $this->db->find_fetch($table, $pri, $where, $order, $start, $limit); }else{ $keys = $this->cache_db_find_fetch_key($table, $pri, $where, $order, $start, $limit, $life); return $this->cache_db_multi_get($keys); } } public function cache_db_find_fetch_key($table, $pri, $where = array(), $order = array(), $start = 0, $limit = 0, $life = 0) { if($this->cache_conf['enable'] && $this->cache_conf['l2_cache'] === 1) { $key = $table.'_'.md5(serialize(array($pri, $where, $order, $start, $limit))); $keys = $this->cache->l2_cache_get($key); if(empty($keys)) { $keys = $this->db->find_fetch_key($table, $pri, $where, $order, $start, $limit); $this->cache->l2_cache_set($key, $keys, $life); } }else{ $keys = $this->db->find_fetch_key($table, $pri, $where, $order, $start, $limit); } return $keys; } } class view{ private $vars = array(); private $head_arr = array(); public function __construct() { $_ENV['_theme'] = 'default'; $_ENV['_view_diy'] = FALSE; } public function assign($k, &$v) { $this->vars[$k] = &$v; } public function assign_value($k, $v) { $this->vars[$k] = $v; } public function display($filename = null) { $_ENV['_tplname'] = is_null($filename) ? $_GET['control'].'_'.$_GET['action'].'.htm' : $filename; extract($this->vars, EXTR_SKIP); include $this->get_tplfile($_ENV['_tplname']); } private function get_tplfile($filename) { if(APP_NAME == 'nzcms_member'){ $_ENV['_theme'] = 'default'; } $view_dir = APP_NAME.($_ENV['_view_diy'] ? '_view_diy' : '_view').'/'; $php_file = RUNTIME_PATH.$view_dir.$_ENV['_theme'].','.$filename.'.php'; if(!is_file($php_file) || DEVMODE) { $tpl_file = core::get_original_file($filename, VIEW_PATH.$_ENV['_theme'].'/'); if(!$tpl_file) { throw new Exception('模板文件 '.$_ENV['_theme'].'/'.$filename.' 不存在'); } if(FW($php_file, $this->tpl_parse($tpl_file)) === false) { throw new Exception("写入模板编译文件 $filename 失败"); } } return $php_file; } private function tpl_parse($tpl_file) { $reg_arr = '[a-zA-Z_]\w*(?:\[\w+\]|\[\'\w+\'\]|\[\"\w+\"\]|\[\$[a-zA-Z_]\w*\])*'; $s = file_get_contents($tpl_file); $s = preg_replace_callback('#\{inc\:home\:([\w\.]+)\}#', array($this, 'parse_home_inc'), $s); $s = preg_replace_callback('#\{inc\:([\w\.]+)\}#', array($this, 'parse_inc'), $s); $s = preg_replace('#(?:\<\?.*?\?\>|\<\?.*)#s', '', $s); $s = preg_replace('#\{php\}(.*?)\{\/php\}#s', '<?php \\1 ?>', $s); $s = preg_replace_callback('#\{block\:([a-zA-Z_]\w*)\040?([^\n\}]*?)\}(.*?){\/block}#s', array($this, 'parse_block'), $s); while(preg_match('#\{loop\:\$'.$reg_arr.'(?:\040\$[a-zA-Z_]\w*){1,2}\}.*?\{\/loop\}#s', $s)) $s = preg_replace_callback('#\{loop\:(\$'.$reg_arr.'(?:\040\$[a-zA-Z_]\w*){1,2})\}(.*?)\{\/loop\}#s', array($this, 'parse_loop'), $s); while(preg_match('#\{if\:[^\n\}]+\}.*?\{\/if\}#s', $s)) $s = preg_replace_callback('#\{if\:([^\n\}]+)\}(.*?)\{\/if\}#s', array($this, 'parse_if'), $s); $s = preg_replace('#\{\@([^\}]+)\}#', '<?php echo(\\1); ?>', $s); $s = preg_replace_callback('#\{(\$'.$reg_arr.')\}#', array($this, 'parse_vars'), $s); $head_str = empty($this->head_arr) ? '' : implode("\r\n", $this->head_arr); $s = "<?php defined('APP_NAME') || exit('Access Denied'); $head_str\r\n?>$s"; $s = str_replace('?><?php ', '', $s); return $s; } private function parse_inc($matches) { if(APP_NAME == 'nzcms_member'){ $_ENV['_theme'] = 'default'; } $filename = 'inc-'.$matches[1]; $tpl_file = core::get_original_file($filename, VIEW_PATH.$_ENV['_theme'].'/'); if(!$tpl_file) { throw new Exception('模板文件 '.$_ENV['_theme'].'/'.$filename.' 不存在'); } return file_get_contents($tpl_file); } private function parse_home_inc($matches) { $_ENV['_theme'] = $_ENV['_hometheme']; $filename = 'inc-'.$matches[1]; $tpl_file = core::get_original_file($filename, APP_PATH.'view/'.$_ENV['_theme'].'/'); if(!$tpl_file) { throw new Exception('模板文件 '.$_ENV['_theme'].'/'.$filename.' 不存在'); } return file_get_contents($tpl_file); } private function parse_block($matches) { $func = $matches[1]; $config = $matches[2]; $s = $matches[3]; $lib_file = core::get_original_file('kp_block_'.$func.'.lib.php', BLOCK_PATH); if(!is_file($lib_file)) return ''; $lib_str = file_get_contents($lib_file); if(!DEVMODE) $lib_str = _strip_whitespace($lib_str); $lib_str = core::clear_code($lib_str); $this->head_arr['kp_block_'.$func] = $lib_str; $s = $this->rep_double($s); $config = $this->rep_double($config); $config_arr = array(); preg_match_all('#([a-zA-Z_]\w*)="(.*?)" #', $config.' ', $m); foreach($m[2] as $k=>$v) { if(isset($v)) $config_arr[strtolower($m[1][$k])] = addslashes($v); } unset($m); $func_str = 'kp_block_'.$func.'('.var_export($config_arr, 1).');'; $before = $after = ''; if(substr($func, 0, 7) == 'global_') { $this->head_arr[$func] = '$gdata = '.$func_str; }else{ $before .= '<?php $data = '.$func_str.' ?>'; $after .= '<?php unset($data); ?>'; } if($_ENV['_view_diy']) { $this->kp_block_id++; $before .= '<span kp_block_diy="before" kp_block_id="'.$this->kp_block_id.'"></span>'; $after .= '<span kp_block_diy="after" kp_block_id="'.$this->kp_block_id.'"></span>'; } return $before.$s.$after; } private function parse_loop($matches) { $args = explode(' ', $this->rep_double($matches[1])); $s = $this->rep_double($matches[2]); $arr = $this->rep_vars($args[0]); $v = empty($args[1]) ? '$v' : $args[1]; $k = empty($args[2]) ? '' : $args[2].'=>'; return "<?php if(isset($arr) && is_array($arr)) { foreach($arr as $k&$v) { ?>$s<?php }} ?>"; } private function parse_if($matches) { $expr = $this->rep_double($matches[1]); $expr = $this->rep_vars($expr); $s = preg_replace_callback('#\{elseif\:([^\n\}]+)\}#', array($this, 'rep_elseif'), $this->rep_double($matches[2])); $s = str_replace('{else}', '<?php }else{ ?>', $s); return "<?php if ($expr) { ?>$s<?php } ?>"; } private function rep_elseif($matches) { $expr = $this->rep_double($matches[1]); $expr = $this->rep_vars($expr); return "<?php }elseif($expr) { ?>"; } private function parse_vars($matches) { $vars = $this->rep_double($matches[1]); $vars = $this->rep_vars($vars); return "<?php echo(isset($vars) ? $vars : ''); ?>"; } private function rep_double($s) { return str_replace('\"', '"', $s); } private function rep_vars($s) { $s = preg_replace('#\[(\w+)\]#', "['\\1']", $s); $s = preg_replace('#\[\"(\w+)\"\]#', "['\\1']", $s); $s = preg_replace('#\[\'(\d+)\'\]#', '[\\1]', $s); return $s; } } class control{ public function __get($var) { if($var == 'view') { return $this->view = new view(); }elseif($var == 'db') { $db = 'db_'.$_ENV['_config']['db']['type']; return $this->db = new $db($_ENV['_config']['db']); }else{ return $this->$var = core::model($var); } } public function assign($k, &$v) { $this->view->assign($k, $v); } public function assign_value($k, $v) { $this->view->assign_value($k, $v); } public function display($filename = null) { $this->view->display($filename); } public function message($status, $message, $jumpurl = '', $delay = 2) { if(R('ajax')) { echo json_encode(array('fine_status'=>$status, 'message'=>$message, 'jumpurl'=>$jumpurl, 'delay'=>$delay)); }else{ if(empty($jumpurl)) { $jumpurl = empty($_SERVER['HTTP_REFERER']) ? '' : $_SERVER['HTTP_REFERER']; } include FINE_PATH.'tpl/sys_message.php'; } exit; } public function __call($method, $args) { core::error404(); } } interface db_interface { public function get($key); public function multi_get($keys); public function set($key, $data); public function update($key, $data); public function delete($key); public function maxid($key, $val = FALSE); public function count($key, $val = FALSE); public function truncate($table); public function version(); public function find_fetch($table, $pri, $where = array(), $order = array(), $start = 0, $limit = 0); public function find_fetch_key($table, $pri, $where = array(), $order = array(), $start = 0, $limit = 0); public function find_update($table, $where, $data, $lowprority = FALSE); public function find_delete($table, $where, $lowprority = FALSE); public function find_maxid($key); public function find_count($table, $where = array()); public function find_count_col($key,$where = array()); public function index_create($table, $index); public function index_drop($table, $index); }  class db_mysql implements db_interface { private $conf; public $tablepre; public function __construct(&$conf) { $this->conf = &$conf; $this->tablepre = $conf['master']['tablepre']; } public function __get($var) { if($var == 'wlink') { $cfg = $this->conf['master']; empty($cfg['engine']) && $cfg['engine'] = ''; $this->wlink = $this->connect($cfg['host'].':'.$cfg['port'], $cfg['user'], $cfg['password'], $cfg['name'], $cfg['charset'], $cfg['engine']); return $this->wlink; }elseif($var == 'rlink') { if(empty($this->conf['slaves'])) { $this->rlink = $this->wlink; return $this->rlink; } $n = rand(0, count($this->conf['slaves']) - 1); $cfg = $this->conf['slaves'][$n]; empty($cfg['engine']) && $cfg['engine'] = ''; $this->rlink = $this->connect($cfg['host'].':'.$cfg['port'], $cfg['user'], $cfg['password'], $cfg['name'], $cfg['charset'], $cfg['engine']); return $this->rlink; }elseif($var == 'xlink') { if(empty($this->conf['arbiter'])) { $this->xlink = $this->wlink; return $this->xlink; } $cfg = $this->conf['arbiter']; empty($cfg['engine']) && $cfg['engine'] = ''; $this->xlink = $this->connect($cfg['host'].':'.$cfg['port'], $cfg['user'], $cfg['password'], $cfg['name'], $cfg['charset'], $cfg['engine']); return $this->xlink; } } public function get($key) { list($table, $keyarr, $keystr) = $this->key2arr($key); $query = $this->query("SELECT * FROM {$this->tablepre}$table WHERE $keystr LIMIT 1", $this->rlink); return mysql_fetch_assoc($query); } public function multi_get($keys) { $sql = ''; $ret = array(); foreach($keys as $k) { $ret[$k] = array(); list($table, $keyarr, $keystr) = $this->key2arr($k); $sql .= "$keystr OR "; } $sql = substr($sql, 0, -4); if($sql) { $query = $this->query("SELECT * FROM {$this->tablepre}$table WHERE $sql", $this->rlink); while($row = mysql_fetch_assoc($query)) { $keyname = $table; foreach($keyarr as $k=>$v) { $keyname .= "-$k-".$row[$k]; } $ret[$keyname] = $row; } } return $ret; } public function set($key, $data) { if(!is_array($data)) return FALSE; list($table, $keyarr) = $this->key2arr($key); $data += $keyarr; $s = $this->arr2sql($data); $exists = $this->get($key); if(empty($exists)) { return $this->query("INSERT INTO {$this->tablepre}$table SET $s", $this->wlink); } else { return $this->update($key, $data); } } public function update($key, $data) { list($table, $keyarr, $keystr) = $this->key2arr($key); $s = $this->arr2sql($data); return $this->query("UPDATE {$this->tablepre}$table SET $s WHERE $keystr LIMIT 1", $this->wlink); } public function delete($key) { list($table, $keyarr, $keystr) = $this->key2arr($key); return $this->query("DELETE FROM {$this->tablepre}$table WHERE $keystr LIMIT 1", $this->wlink); } public function maxid($key, $val = FALSE) { list($table, $col) = explode('-', $key); $maxid = $this->table_maxid($key); if($val === FALSE) { return $maxid; }elseif(is_string($val)) { $val = max(0, $maxid + intval($val)); } $this->query("UPDATE {$this->tablepre}framework_maxid SET maxid='$val' WHERE name='$table' LIMIT 1", $this->xlink); return $val; } public function table_maxid($key) { list($table, $col) = explode('-', $key); $maxid = FALSE; $query = $this->query("SELECT maxid FROM {$this->tablepre}framework_maxid WHERE name='$table' LIMIT 1", $this->xlink, FALSE); if($query) { $maxid = $this->result($query, 0); }elseif(mysql_errno($this->xlink) == 1146) { $sql = "CREATE TABLE `{$this->tablepre}framework_maxid` ("; $sql .= "`name` char(32) NOT NULL default '',"; $sql .= "`maxid` int(10) unsigned NOT NULL default '0',"; $sql .= "PRIMARY KEY (`name`)"; $sql .= ") ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci"; $this->query($sql, $this->xlink); }else{ throw new Exception('framework_maxid error, mysql_error:'.mysql_error()); } if($maxid === FALSE) { $query = $this->query("SELECT MAX($col) FROM {$this->tablepre}$table", $this->wlink); $maxid = $this->result($query, 0); $this->query("INSERT INTO {$this->tablepre}framework_maxid SET name='$table', maxid='$maxid'", $this->xlink); } return $maxid; } public function count($table, $val = FALSE) { $count = $this->table_count($table); if($val === FALSE) { return $count; }elseif(is_string($val)) { if($val[0] == '+') { $val = $count + intval($val); }elseif($val[0] == '-') { $val = max(0, $count + intval($val)); } } $this->query("UPDATE {$this->tablepre}framework_count SET count='$val' WHERE name='$table' LIMIT 1", $this->xlink); return $val; } public function table_count($table) { $count = FALSE; $query = $this->query("SELECT count FROM {$this->tablepre}framework_count WHERE name='$table' LIMIT 1", $this->xlink, FALSE); if($query) { $count = $this->result($query, 0); }elseif(mysql_errno($this->xlink) == 1146) { $sql = "CREATE TABLE {$this->tablepre}framework_count ("; $sql .= "`name` char(32) NOT NULL default '',"; $sql .= "`count` int(10) unsigned NOT NULL default '0',"; $sql .= "PRIMARY KEY (`name`)"; $sql .= ") ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci"; $this->query($sql, $this->xlink); }else{ throw new Exception('framework_cout error, mysql_error:'.mysql_error()); } if($count === FALSE) { $query = $this->query("SELECT COUNT(*) FROM {$this->tablepre}$table", $this->wlink); $count = $this->result($query, 0); $this->query("INSERT INTO {$this->tablepre}framework_count SET name='$table', count='$count'", $this->xlink); } return $count; } public function truncate($table) { try { $this->query("TRUNCATE {$this->tablepre}$table"); return TRUE; } catch(Exception $e) { return FALSE; } } public function find_fetch($table, $pri, $where = array(), $order = array(), $start = 0, $limit = 0) { $key_arr = $this->find_fetch_key($table, $pri, $where, $order, $start, $limit); if(empty($key_arr)) return array(); return $this->multi_get($key_arr); } public function find_fetch_key($table, $pri, $where = array(), $order = array(), $start = 0, $limit = 0) { $pris = implode(',', $pri); $s = "SELECT $pris FROM {$this->tablepre}$table"; $s .= $this->arr2where($where); if(!empty($order)) { $s .= ' ORDER BY '; $comma = ''; foreach($order as $k=>$v) { $s .= $comma."$k ".($v == 1 ? ' ASC ' : ' DESC '); $comma = ','; } } $s .= ($limit ? " LIMIT $start,$limit" : ''); $ret = array(); $query = $this->query($s, $this->rlink); while($row = mysql_fetch_assoc($query)) { $keystr = ''; foreach($pri as $k) { $keystr .= "-$k-".$row[$k]; } $ret[] = $table.$keystr; } return $ret; } public function find_update($table, $where, $data, $lowprority = FALSE) { $where = $this->arr2where($where); $data = $this->arr2sql($data); $lpy = $lowprority ? 'LOW_PRIORITY' : ''; $this->query("UPDATE $lpy {$this->tablepre}$table SET $data $where", $this->wlink); return mysql_affected_rows($this->wlink); } public function find_delete($table, $where, $lowprority = FALSE) { $where = $this->arr2where($where); $lpy = $lowprority ? 'LOW_PRIORITY' : ''; $this->query("DELETE $lpy FROM {$this->tablepre}$table $where", $this->wlink); return mysql_affected_rows($this->wlink); } public function find_maxid($key) { list($table, $maxid) = explode('-', $key); $arr = $this->fetch_first("SELECT MAX($maxid) AS num FROM {$this->tablepre}$table"); return isset($arr['num']) ? intval($arr['num']) : 0; } public function find_count($table, $where = array()){ $where = $this->arr2where($where); $arr = $this->fetch_first("SELECT COUNT(*) AS num FROM {$this->tablepre}$table $where"); return isset($arr['num']) ? intval($arr['num']) : 0; } public function find_count_col($key,$where = array()) { $where = $this->arr2where($where); list($table, $filed) = explode('-', $key); $res = 0; $query = $this->fetch_all("SELECT sum($filed) AS money FROM {$this->tablepre}$table $where"); if($query) { $res = $query[0]['money']; } return $res; } public function index_create($table, $index) { $keys = implode(',', array_keys($index)); $keyname = implode('_', array_keys($index)); return $this->query("ALTER TABLE {$this->tablepre}$table ADD INDEX $keyname($keys)", $this->wlink); } public function index_drop($table, $index) { $keys = implode(',', array_keys($index)); $keyname = implode('_', array_keys($index)); return $this->query("ALTER TABLE {$this->tablepre}$table DROP INDEX $keyname", $this->wlink); } public function connect($host, $user, $pass, $name, $charset = 'utf8', $engine = '') { $link = mysql_connect($host, $user, $pass); if(!$link) { throw new Exception(mysql_error()); } $result = mysql_select_db($name, $link); if(!$result) { throw new Exception(mysql_error()); } if(!empty($engine) && $engine == 'InnoDB') { $this->query("SET innodb_flush_log_at_trx_commit=no", $link); } $this->query("SET character_set_connection=$charset, character_set_results=$charset, character_set_client=binary, sql_mode=''", $link); return $link; } public function query($sql, $link = NULL, $isthrow = TRUE) { empty($link) && $link = $this->wlink; $result = mysql_query($sql, $link); if(!$result && $isthrow) { $s = 'MySQL Query Error: <b>'.$sql.'</b>. '.mysql_error(); $s = str_replace($this->tablepre, '***', $s); throw new Exception($s); } $_ENV['_sqlnum']++; return $result; } public function fetch_first($sql, $link = NULL) { empty($link) && $link = $this->rlink; $query = $this->query($sql, $link); return mysql_fetch_assoc($query); } public function fetch_all($sql, $link = NULL) { empty($link) && $link = $this->rlink; $query = $this->query($sql, $link); $ret = array(); while($row = mysql_fetch_assoc($query)) { $ret[] = $row; } return $ret; } function fetch_array($query, $result_type = MYSQL_ASSOC) { return mysql_fetch_array($query, $result_type); } function fetch_object($query) { return mysql_fetch_object($query); } function fetch_row($query) { return mysql_fetch_row($query); } function fetch_fields($query) { return mysql_fetch_field($query); } function num_rows($query) { return mysql_num_rows($query); } function num_fields($query) { return mysql_num_fields($query); } function S($str, $quot="'") { return is_numeric($str) ? $str : $quot.mysql_real_escape_string($str).$quot; } public function result($query, $row) { return mysql_num_rows($query) ? intval(mysql_result($query, $row)) : FALSE; } public function version() { return mysql_get_server_info($this->rlink); } public function __destruct() { if(is_resource($this->wlink)) { mysql_close($this->wlink); } if(is_resource($this->rlink) && is_resource($this->wlink) && $this->rlink != $this->wlink) { mysql_close($this->rlink); } } private function arr2where($arr) { $s = ''; if(!empty($arr)) { foreach($arr as $key=>$val) { if(is_array($val)) { foreach($val as $k=>$v) { if(is_array($v)) { if($k === 'IN' && $v) { $s .= "("; foreach($v as $i) { $i = addslashes($i); $s .= "$key='$i' OR "; } $s = substr($s, 0, -4).') AND '; } }else{ $v = addslashes($v); if($k === 'LIKE') { $s .= "$key LIKE '%$v%' AND "; }else{ $s .= "$key$k'$v' AND "; } } } }else{ $val = addslashes($val); $s .= "$key='$val' AND "; } } $s && $s = ' WHERE '.substr($s, 0, -5); } return $s; } private function arr2sql($arr) { $s = ''; foreach($arr as $k=>$v) { $v = addslashes($v); $s .= "$k='$v',"; } return rtrim($s, ','); } private function key2arr($key) { $arr = explode('-', $key); if(empty($arr[0])) { throw new Exception('table name is empty.'); } $table = $arr[0]; $keyarr = array(); $keystr = ''; $len = count($arr); for($i = 1; $i < $len; $i = $i + 2) { if(isset($arr[$i + 1])) { $v = $arr[$i + 1]; $keyarr[$arr[$i]] = is_numeric($v) ? intval($v) : $v; $keystr .= ($keystr ? ' AND ' : '').$arr[$i]."='".addslashes($v)."'"; } else { $keyarr[$arr[$i]] = NULL; } } if(empty($keystr)) { throw new Exception('keystr name is empty.'); } return array($table, $keyarr, $keystr); } } interface cache_interface { public function get($key); public function multi_get($keys); public function set($key, $data, $life = 0); public function update($key, $data, $life = 0); public function delete($key); public function maxid($table, $val = FALSE); public function count($table, $val = FALSE); public function truncate($pre = ''); public function l2_cache_get($l2_key); public function l2_cache_set($l2_key, $keys, $life = 0); }  class cache_memcache implements cache_interface{ private $conf; private $is_getmulti = FALSE; public $pre; public function __construct(&$conf) { $this->conf = &$conf; $this->pre = $conf['pre']; } public function __get($var) { $c = $this->conf['memcache']; if($var == 'memcache') { if(extension_loaded('Memcached')) { $this->memcache = new Memcached; }elseif(extension_loaded('Memcache')) { $this->memcache = new Memcache; }else{ throw new Exception('Memcache Extension not loaded.'); } if(!$this->memcache) { throw new Exception('PHP.ini Error: Memcache extension not loaded.'); } if($this->memcache->connect($c['host'], $c['port'])) { if(!empty($c['multi'])) { $this->is_getmulti = method_exists($this->memcache, 'getMulti'); } return $this->memcache; }else{ throw new Exception('Can not connect to Memcached host.'); } } } public function get($key) { return $this->memcache->get($this->pre.$key); } public function multi_get($keys) { $data = array(); if($this->is_getmulti) { $m_keys = array(); foreach ($keys as $i=>$k) { $m_keys[$i] = $this->pre.$k; } $m_data = $this->memcache->getMulti($m_keys); foreach($keys as $k) { if(empty($m_data[$this->pre.$k])) { $data[$k] = FALSE; }else{ $data[$k] = $m_data[$this->pre.$k]; } } }else{ foreach($keys as $k) { $arr = $this->memcache->get($this->pre.$k); if(empty($arr)) { $data[$k] = FALSE; }else{ $data[$k] = $arr; } } } return $data; } public function set($key, $data, $life = 0) { if($this->conf['l2_cache'] === 1) { $this->memcache->delete($this->pre.'_l2_cache_time'); } return $this->memcache->set($this->pre.$key, $data, 0, $life); } public function update($key, $data, $life = 0) { $key = $this->pre.$key; $arr = $this->get($key); if($arr !== FALSE) { is_array($arr) && is_array($data) && $arr = array_merge($arr, $data); return $this->set($key, $arr, $life); } return FALSE; } public function delete($key) { if($this->conf['l2_cache'] === 1) { $this->memcache->delete($this->pre.'_l2_cache_time'); } return $this->memcache->delete($this->pre.$key); } public function maxid($table, $val = FALSE) { $key = $table.'-Auto_increment'; if($val === FALSE) { return intval($this->get($key)); }else{ $this->set($key, $val); return $val; } } public function count($table, $val = FALSE) { $key = $table.'-Rows'; if($val === FALSE) { return intval($this->get($key)); }else{ $this->set($key, $val); return $val; } } public function truncate($pre = '') { return $this->memcache->flush(); } public function l2_cache_get($l2_key) { $l2_cache_time = $this->get('_l2_cache_time'); $l2_key_time = $this->get($l2_key.'_time'); if($l2_cache_time && $l2_cache_time === $l2_key_time) { return $this->get($l2_key); } return FALSE; } public function l2_cache_set($l2_key, $keys, $life = 0) { $l2_cache_time = $this->get('_l2_cache_time'); if(empty($l2_cache_time)) { $l2_cache_time = microtime(1); $this->memcache->set($this->pre.'_l2_cache_time', $l2_cache_time, 0, 0); } $this->memcache->set($this->pre.$l2_key.'_time', $l2_cache_time, 0, $life); return $this->memcache->set($this->pre.$l2_key, $keys, 0, $life); } } 