<?php
defined('PP_PATH') or exit;
include RUNTIME_CONTROL.'user_control.class.php'; class index_control extends user_control{
	public $_navgroup = 'home';	
	public function index() {
		$this->assign_value('navkey', 'index-index');
		$this->_cfg['titles'] = '个人中心_'.$this->_cfg['webname'];
		$smscfg 	= $this->kv->xget('sms_cfg');
		
		$user_group = &$this->user_group;
		$user_group_arr = $user_group->get_groups();
		foreach($user_group_arr as $k=>&$v) {
			if($v['groupid'] < 4 || $v['ishidden']){
				unset($user_group_arr[$k]);
			}
			$user_group->format($v);
		}

		if(empty($_ENV['_config']['nzcms_parseurl'])) {
			$promotion_url = $this->_cfg['weburl'].'index.php?index-t-c-'.$this->_uid.$_ENV['_config']['url_suffix'];
		}else{
			$promotion_url = $this->_cfg['weburl'].'t_'.$this->_uid;
		}

		
		$this->assign('promotion_url', $promotion_url);
		$this->assign('group_list', $user_group_arr);
		$this->assign('pp', $this->_cfg);
		$this->assign('smscfg', $smscfg);
		$this->display();
	}
	
	//修改资料
	public function profile(){
		$this->assign_value('navkey', 'index-profile');
		if( empty($_POST) ){
			$this->display('user_profile.htm');
		}else{
			$info = R('info','P');
			
			$email 	= $info['email'] ;
			$mobile = $info['mobile'] ;
			$qq 	= $info['qq'] ;

			if($email && !check::is_email($email) ){
				E(1, '邮箱格式不正确！');
			}elseif($qq && !check::is_qq($qq)){
				E(1, 'QQ格式不正确！');
			}elseif($mobile && !check::is_mobile($mobile) ){
				E(1, '手机号格式不正确！');
			}else{

				$this->_user['email'] 	= $email;
				$this->_user['mobile'] = $mobile;
				$this->_user['qq'] 	= $qq;

				if($this->user->update($this->_user) ){
					E(0, '修改资料成功！');
				}else{
					E(1, '修改资料失败！');
				}
			}
		}
	}
	
	//修改密码
	public function password(){
		$this->assign_value('navkey', 'index-password');
		if( empty($_POST) ){
			$this->display('user_password.htm');
		}else{
			$user = &$this->user;
			
			$oldpassword = R('oldpassword','P');
			$password = R('password','P');
			$repassword = R('repassword','P');
			
			if ( empty($oldpassword) ){
				E(1, '旧密码不能为空！');
			}elseif ( empty($password) ){
				E(1, '新密码不能为空！');
			}elseif ( $password != $repassword ){
				E(1, '两次输入的新密码不一致！');
			}elseif ( !$user->verify_password($oldpassword,$this->_user['salt'],$this->_user['password']) ){
				E(1, '旧密码不正确！');
			}else{
				//检测密码规则
				$errmsg = $user->check_password($password);
				if( $errmsg )	$this->message(0, $errmsg);

				//新密码
				$data['password'] = get_password($password,$this->_user['salt']);
				$data['uid'] = $this->_user['uid'];

				if( $user->update($data) ){
					E(0, '修改密码成功！');
				}else{
					E(1, '修改密码失败！');
				}
			}
		}
	}
	public function up_group(){
		if(!empty($_POST)){
			$groupid 	= intval(R('groupid','P'));
			$price 		= intval(R('price','P'));
			
			$user = &$this->user;
			$info['uid'] = $this->_user['uid'];
			if($price > $this->_user['money']){
				E(1, '你的余额不足！请先充值');
			}
			
			if($groupid == $this->_user['groupid']){
				E(1, '您已经是“'.$this->_group['groupname'].'”，请选择其他用户组！');
			}
			
			$user_group 	= &$this->user_group;
			$group 			= $user_group->get($groupid); //要升级的用户组
			$user_group->format($group);
			
			if($price != $group['price']){	//再次检测提交金额是否异常
				E(1, '升级用户组异常！');
			}

			$info['groupid'] 	= $groupid;
			$info['money'] 		= $this->_user['money'] - $price;

			if($user->update($info) ){
				//写入交易记录
				$orderid 	= order_number();
				$record 	= &$this->record;
				$recordata 	= array(
					'uid'		=> $this->_uid,
					'username'	=> $this->_user['username'],
					'money'		=> $price,
					'gold'		=> 0,
					'type'		=> 2,
					'order_id'	=> $orderid,
					'created'	=> $_ENV['_time'],
					'status'	=> 1,
					'comment'	=> '成功升级用户组：'.$group['groupname'],
				);
				$record->create($recordata);
				E(0, '用户组升级成功！');
			}else{
				E(0, '用户组升级失败！');
			}
		}
	}
}