/*
 Navicat Premium Data Transfer

 Source Server         : 127.0.0.1
 Source Server Type    : MySQL
 Source Server Version : 50726
 Source Host           : 127.0.0.1:3306
 Source Schema         : demo

 Target Server Type    : MySQL
 Target Server Version : 50726
 File Encoding         : 65001

 Date: 19/08/2023 11:48:11
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for pp_category
-- ----------------------------
DROP TABLE IF EXISTS `pp_category`;
CREATE TABLE `pp_category`  (
  `cid` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `mid` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `type` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `upid` int(10) NOT NULL DEFAULT 0,
  `name` char(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `alias` char(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `intro` char(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `cate_tpl` char(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `show_tpl` char(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `count` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `count_0` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `count_1` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `orderby` smallint(5) NOT NULL DEFAULT 0,
  `seo_title` char(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `seo_keywords` char(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `seo_description` char(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`cid`) USING BTREE,
  UNIQUE INDEX `alias`(`alias`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 18 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of pp_category
-- ----------------------------
INSERT INTO `pp_category` VALUES (1, 2, 0, 10, '公司企业', 'company', '', 'products_list.htm', 'products_show.htm', 3, 0, 0, 0, '', '', '');
INSERT INTO `pp_category` VALUES (2, 2, 0, 10, '淘客推广', 'taoke', '', 'products_list.htm', 'products_show.htm', 2, 0, 0, 0, '', '', '');
INSERT INTO `pp_category` VALUES (5, 2, 0, 10, '酒店宾馆', 'hotel', '', 'products_list.htm', 'products_show.htm', 0, 0, 0, 0, '', '', '');
INSERT INTO `pp_category` VALUES (10, 2, 1, 0, '资源', 'downs', '', 'products_index.htm', 'products_show.htm', 0, 0, 0, 0, '', '', '');
INSERT INTO `pp_category` VALUES (11, 3, 0, 0, '站内公告', 'notice', '', 'article_list.htm', 'article_show.htm', 1, 0, 0, 0, '', '', '');
INSERT INTO `pp_category` VALUES (12, 1, 0, 0, '关于', 'about', '', 'page.htm', '', 0, 0, 0, 0, '', '', '');
INSERT INTO `pp_category` VALUES (13, 1, 0, 0, '作品', 'codes', '', 'search_index.htm', '', 0, 0, 0, 0, '', '', '');
INSERT INTO `pp_category` VALUES (14, 3, 0, 0, '技术文章', 'art', '', 'article_list.htm', 'article_show.htm', 6, 0, 0, 0, '', '', '');
INSERT INTO `pp_category` VALUES (15, 2, 0, 10, '电子商城', 'shop', '', 'products_list.htm', 'products_show.htm', 1, 0, 0, 0, '', '', '');
INSERT INTO `pp_category` VALUES (16, 2, 0, 10, '影音游戏', 'mov', '', 'products_list.htm', 'products_show.htm', 2, 1, 0, 0, '', '', '');
INSERT INTO `pp_category` VALUES (17, 3, 0, 0, '常见问题与解答', 'faq', '', 'article_list.htm', 'article_show.htm', 9, 0, 0, 0, '', '', '');

-- ----------------------------
-- Table structure for pp_cms_article
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_article`;
CREATE TABLE `pp_cms_article`  (
  `cid` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` char(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `color` char(6) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `alias` char(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `tags` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `intro` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `pic` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `uid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `author` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `source` varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `dateline` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `lasttime` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `ip` int(10) NOT NULL DEFAULT 0,
  `iscomment` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `comments` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `views` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `imagenum` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `filenum` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `flags` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `seo_title` varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `seo_keywords` varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `seo_description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `baidu` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cid_id`(`cid`, `id`) USING BTREE,
  INDEX `cid_dateline`(`cid`, `dateline`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_cms_article
-- ----------------------------

-- ----------------------------
-- Table structure for pp_cms_article_data
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_article_data`;
CREATE TABLE `pp_cms_article_data`  (
  `id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `images` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `content` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_cms_article_data
-- ----------------------------

-- ----------------------------
-- Table structure for pp_cms_article_flag
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_article_flag`;
CREATE TABLE `pp_cms_article_flag`  (
  `flag` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `cid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`flag`, `id`) USING BTREE,
  INDEX `flag_cid`(`flag`, `cid`, `id`) USING BTREE,
  INDEX `id`(`id`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of pp_cms_article_flag
-- ----------------------------

-- ----------------------------
-- Table structure for pp_cms_article_tag
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_article_tag`;
CREATE TABLE `pp_cms_article_tag`  (
  `tagid` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` char(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `count` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`tagid`) USING BTREE,
  UNIQUE INDEX `name`(`name`) USING BTREE,
  INDEX `count`(`count`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_cms_article_tag
-- ----------------------------

-- ----------------------------
-- Table structure for pp_cms_article_tag_data
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_article_tag_data`;
CREATE TABLE `pp_cms_article_tag_data`  (
  `tagid` int(10) UNSIGNED NOT NULL,
  `id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`tagid`, `id`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of pp_cms_article_tag_data
-- ----------------------------

-- ----------------------------
-- Table structure for pp_cms_attach
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_attach`;
CREATE TABLE `pp_cms_attach`  (
  `aid` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cid` smallint(5) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分类ID',
  `uid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '用户ID',
  `id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '内容ID',
  `mid` tinyint(1) UNSIGNED NOT NULL DEFAULT 2 COMMENT '模型ID(默认文章模型)',
  `filename` char(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '文件原名',
  `filetype` char(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '后缀',
  `filesize` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '大小',
  `filepath` char(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '路径',
  `dateline` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '上传时间',
  `downloads` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '下载次数',
  `isimage` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否是图片 (1为图片，0为文件)',
  PRIMARY KEY (`aid`) USING BTREE,
  INDEX `id`(`id`, `aid`, `mid`) USING BTREE,
  INDEX `uid`(`uid`, `aid`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 6 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of pp_cms_attach
-- ----------------------------
INSERT INTO `pp_cms_attach` VALUES (1, 16, 1, 1, 2, '10002.png', 'png', 20934, '202308/19/11375564e0391384193P95yjz.png', 1692416275, 0, 1);
INSERT INTO `pp_cms_attach` VALUES (2, 16, 1, 1, 2, '10231.png', 'png', 12163, '202308/19/11375964e039172acb6WfwOY8.png', 1692416279, 0, 1);
INSERT INTO `pp_cms_attach` VALUES (3, 16, 1, 1, 2, '10201.png', 'png', 11426, '202308/19/11380364e0391b1564eEQAock.png', 1692416283, 0, 1);
INSERT INTO `pp_cms_attach` VALUES (4, 16, 1, 1, 2, '10006.png', 'png', 17287, '202308/19/11380764e0391f2f9efO8pR5X.png', 1692416287, 0, 1);
INSERT INTO `pp_cms_attach` VALUES (5, 16, 1, 1, 2, '20000.png', 'png', 25146, '202308/19/11382264e0392e511bd9XjTLz.png', 1692416302, 0, 1);

-- ----------------------------
-- Table structure for pp_cms_block
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_block`;
CREATE TABLE `pp_cms_block`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pos` char(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `isjs` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `title` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `dateline` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `pos`(`pos`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 4 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_cms_block
-- ----------------------------
INSERT INTO `pp_cms_block` VALUES (1, 'home_center', 1, '首页中间', '<a href=\"\"><img src=\"https://img10.360buyimg.com/da/jfs/t3235/326/3911409958/101118/5831a815/57f9a91fN51369fb5.jpg\" class=\"img-responsive\" /></a>', 1435285291);
INSERT INTO `pp_cms_block` VALUES (2, 'home_top', 1, '首页顶部', '<a href=\"\"><img src=\"https://img11.360buyimg.com/cms/jfs/t3091/221/3128129977/91346/fbc76a21/57ee2821N4e40d129.jpg\" class=\"img-responsive\" /></a>', 1476003157);
INSERT INTO `pp_cms_block` VALUES (3, 'list_zanzhu', 1, '列表页赞助', '<li class=\"list-group-item\"><a href=\"\"><img class=\"img-responsive\" src=\"static/default/img/a1.jpg\" /></a></li><li class=\"list-group-item\"><a href=\"\"><img class=\"img-responsive\" src=\"static/default/img/a2.jpg\" /></a></li>', 1476003374);

-- ----------------------------
-- Table structure for pp_cms_book
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_book`;
CREATE TABLE `pp_cms_book`  (
  `cid` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `order_id` char(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `pid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `uid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `price` decimal(11, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `totalprice` decimal(11, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `ordernum` smallint(3) UNSIGNED NOT NULL DEFAULT 0,
  `dateline` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `edittime` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `is_tuan` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `is_comments` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `staus` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cid_id`(`cid`, `id`) USING BTREE,
  INDEX `cid_dateline`(`cid`, `dateline`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of pp_cms_book
-- ----------------------------
INSERT INTO `pp_cms_book` VALUES (16, 1, '230819164441834301', 1, 3, 1.00, 1.00, 1, 1692416444, 0, 0, 0, 0);

-- ----------------------------
-- Table structure for pp_cms_comment
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_comment`;
CREATE TABLE `pp_cms_comment`  (
  `id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '内容ID',
  `mid` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '模型ID(默认文章模型)',
  `commentid` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '用户ID',
  `author` char(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '称呼',
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '评论内容',
  `ip` int(10) NOT NULL DEFAULT 0 COMMENT 'IP',
  `dateline` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '发表时间',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`commentid`) USING BTREE,
  INDEX `id`(`id`, `commentid`, `mid`) USING BTREE,
  INDEX `ip`(`ip`, `commentid`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_cms_comment
-- ----------------------------

-- ----------------------------
-- Table structure for pp_cms_faq
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_faq`;
CREATE TABLE `pp_cms_faq`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `title` char(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `uid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `dateline` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `lasttime` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cid_id`(`id`) USING BTREE,
  INDEX `cid_dateline`(`dateline`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of pp_cms_faq
-- ----------------------------

-- ----------------------------
-- Table structure for pp_cms_faq_data
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_faq_data`;
CREATE TABLE `pp_cms_faq_data`  (
  `id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `pid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `content` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_cms_faq_data
-- ----------------------------

-- ----------------------------
-- Table structure for pp_cms_page
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_page`;
CREATE TABLE `pp_cms_page`  (
  `cid` smallint(5) UNSIGNED NOT NULL,
  `content` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`cid`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_cms_page
-- ----------------------------
INSERT INTO `pp_cms_page` VALUES (12, '<p>NewZhan.com<br/></p>');
INSERT INTO `pp_cms_page` VALUES (13, '<p>仅用于内容引导<br/></p>');

-- ----------------------------
-- Table structure for pp_cms_products
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_products`;
CREATE TABLE `pp_cms_products`  (
  `cid` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `author` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `title` char(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `color` char(6) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `pic` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `pid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `down_pan` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `pan_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `demo_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `alias` char(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `tags` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `intro` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `price` decimal(11, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `sells` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `zk_price` decimal(11, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `zk_start` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `zk_end` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `lan` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `sqls` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `license` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `dateline` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `lasttime` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `iscomment` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `comments` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `faqs` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `views` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `seo_title` varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `seo_keywords` varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `seo_description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `imagenum` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `filenum` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `flags` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `baidu` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `need_groupid` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cid_id`(`cid`, `id`) USING BTREE,
  INDEX `cid_dateline`(`cid`, `dateline`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_cms_products
-- ----------------------------
INSERT INTO `pp_cms_products` VALUES (16, 1, 1, 'admin', '资源名称是在等你购买', '', 'upload/products/202308/19/11382264e0392e511bd9XjTLz_thumb.png', 5, 'http://127.0.0.1/admin/', '', 'http://127.0.0.1/admin/', 'ziyuanmingchengshizaidengnigoumai', '{}', '摘要摘要摘要摘要摘要摘要摘要摘要摘要摘要摘要摘要摘要摘要摘要摘要摘要', 1.00, 1, 0.00, 0, 0, 0, 0, 0, 1692416308, 1692374400, 0, 0, 0, 5, '', '', '', 0, 5, 0, '', 0, 0);

-- ----------------------------
-- Table structure for pp_cms_products_data
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_products_data`;
CREATE TABLE `pp_cms_products_data`  (
  `id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `images` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `downs` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `content` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_cms_products_data
-- ----------------------------
INSERT INTO `pp_cms_products_data` VALUES (1, '{\"1\":{\"big\":\"upload\\/products\\/202308\\/19\\/11375564e0391384193P95yjz.png\",\"thumb\":\"upload\\/products\\/202308\\/19\\/11375564e0391384193P95yjz_thumb.png\",\"aid\":\"1\",\"content\":\"\"},\"2\":{\"big\":\"upload\\/products\\/202308\\/19\\/11375964e039172acb6WfwOY8.png\",\"thumb\":\"upload\\/products\\/202308\\/19\\/11375964e039172acb6WfwOY8_thumb.png\",\"aid\":\"2\",\"content\":\"\"},\"3\":{\"big\":\"upload\\/products\\/202308\\/19\\/11380364e0391b1564eEQAock.png\",\"thumb\":\"upload\\/products\\/202308\\/19\\/11380364e0391b1564eEQAock_thumb.png\",\"aid\":\"3\",\"content\":\"\"},\"4\":{\"big\":\"upload\\/products\\/202308\\/19\\/11380764e0391f2f9efO8pR5X.png\",\"thumb\":\"upload\\/products\\/202308\\/19\\/11380764e0391f2f9efO8pR5X_thumb.png\",\"aid\":\"4\",\"content\":\"\"}}', '[]', '<p><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"background-color: rgb(255, 255, 255); color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right;\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span><span style=\"color: rgb(255, 0, 0); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, &quot;Hiragino Sans GB&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; text-align: right; background-color: rgb(255, 255, 255);\">内容</span></p>');

-- ----------------------------
-- Table structure for pp_cms_products_flag
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_products_flag`;
CREATE TABLE `pp_cms_products_flag`  (
  `flag` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `cid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`flag`, `id`) USING BTREE,
  INDEX `flag_cid`(`flag`, `cid`, `id`) USING BTREE,
  INDEX `id`(`id`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of pp_cms_products_flag
-- ----------------------------
INSERT INTO `pp_cms_products_flag` VALUES (0, 16, 1);

-- ----------------------------
-- Table structure for pp_cms_products_golds
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_products_golds`;
CREATE TABLE `pp_cms_products_golds`  (
  `id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `cid` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `gold` decimal(3, 1) UNSIGNED NOT NULL DEFAULT 0.0,
  `golder` smallint(6) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cid`(`cid`, `gold`) USING BTREE,
  INDEX `gold`(`gold`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of pp_cms_products_golds
-- ----------------------------
INSERT INTO `pp_cms_products_golds` VALUES (1, 16, 0.0, 0);

-- ----------------------------
-- Table structure for pp_cms_products_tag
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_products_tag`;
CREATE TABLE `pp_cms_products_tag`  (
  `tagid` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `count` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`tagid`) USING BTREE,
  UNIQUE INDEX `name`(`name`) USING BTREE,
  INDEX `count`(`count`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_cms_products_tag
-- ----------------------------

-- ----------------------------
-- Table structure for pp_cms_products_tag_data
-- ----------------------------
DROP TABLE IF EXISTS `pp_cms_products_tag_data`;
CREATE TABLE `pp_cms_products_tag_data`  (
  `tagid` int(10) UNSIGNED NOT NULL,
  `id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`tagid`, `id`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of pp_cms_products_tag_data
-- ----------------------------

-- ----------------------------
-- Table structure for pp_framework_count
-- ----------------------------
DROP TABLE IF EXISTS `pp_framework_count`;
CREATE TABLE `pp_framework_count`  (
  `name` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `count` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`name`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of pp_framework_count
-- ----------------------------
INSERT INTO `pp_framework_count` VALUES ('runtime', 0);
INSERT INTO `pp_framework_count` VALUES ('cms_products', 1);
INSERT INTO `pp_framework_count` VALUES ('cms_article', 0);
INSERT INTO `pp_framework_count` VALUES ('user', 3);
INSERT INTO `pp_framework_count` VALUES ('cms_book', 1);
INSERT INTO `pp_framework_count` VALUES ('cms_block', 3);
INSERT INTO `pp_framework_count` VALUES ('cms_attach', 5);
INSERT INTO `pp_framework_count` VALUES ('kv', 6);
INSERT INTO `pp_framework_count` VALUES ('record', 2);

-- ----------------------------
-- Table structure for pp_framework_maxid
-- ----------------------------
DROP TABLE IF EXISTS `pp_framework_maxid`;
CREATE TABLE `pp_framework_maxid`  (
  `name` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `maxid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`name`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of pp_framework_maxid
-- ----------------------------
INSERT INTO `pp_framework_maxid` VALUES ('user', 3);
INSERT INTO `pp_framework_maxid` VALUES ('cms_attach', 5);
INSERT INTO `pp_framework_maxid` VALUES ('cms_products', 1);
INSERT INTO `pp_framework_maxid` VALUES ('record', 2);
INSERT INTO `pp_framework_maxid` VALUES ('cms_book', 1);

-- ----------------------------
-- Table structure for pp_kv
-- ----------------------------
DROP TABLE IF EXISTS `pp_kv`;
CREATE TABLE `pp_kv`  (
  `k` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `v` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `expiry` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`k`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_kv
-- ----------------------------
INSERT INTO `pp_kv` VALUES ('link_keywords', '[\"tag\",\"tag_top\",\"comment\",\"index\",\"sitemap\",\"admin\",\"user\",\"space\"]', 0);
INSERT INTO `pp_kv` VALUES ('navigate', '{\"1\":{\"cid\":10,\"alias\":\"downs\",\"name\":\"\\u8d44\\u6e90\",\"url\":10,\"target\":\"_self\"}}', 0);
INSERT INTO `pp_kv` VALUES ('pp_links', '[{\"name\":\"baidu\",\"url\":\"http:\\/\\/www.baidu.com\"}]', 0);
INSERT INTO `pp_kv` VALUES ('mail_cfg', '{\"sendtype\":1,\"smtplist\":{\"email\":\"test@126.com\",\"host\":\"smtp.126.com\",\"port\":\"25\",\"user\":\"test@126.com\",\"pass\":\"\"},\"moban\":{\"email_active_content\":\"\\u6b22\\u8fce\\u60a8\\u6ce8\\u518c\\u6210\\u4e3aNZ\\u5de5\\u4f5c\\u5ba4\\u7528\\u6237\\uff0c\\u70b9\\u51fb\\u4e0b\\u9762\\u94fe\\u63a5\\u8fdb\\u884c\\u90ae\\u7bb1\\u7ed1\\u5b9a\\uff1a{click}\\r\\n\\u6216\\u8005\\u5c06\\u7f51\\u5740\\u590d\\u5236\\u5230\\u6d4f\\u89c8\\u5668\\uff1a{url}\",\"email_active_off\":\"1\",\"email_pwd_content\":\"NZ\\u5de5\\u4f5c\\u5ba4\\u5bc6\\u7801\\u627e\\u56de\\uff0c\\u65b0\\u7684\\u767b\\u5f55\\u5bc6\\u7801\\u4e3a\\uff1a{password}\",\"email_pwd_off\":\"1\"}}', 0);
INSERT INTO `pp_kv` VALUES ('sms_cfg', '{\"sms_off\":0,\"sms_user\":\"\",\"sms_password\":\"\",\"payok\":\"\\u3010NZcms\\u3011{username}\\uff0c\\u60a8\\u5728\\u7ebf\\u5145\\u503c{money}\\u5143\\u5df2\\u5230\\u5e10\",\"payok_off\":0,\"phonecode\":\"\\u3010NZcms\\u3011{username}\\uff0c\\u60a8\\u7684\\u624b\\u673a\\u9a8c\\u8bc1\\u7801\\u4e3a{code}\",\"phonecode_off\":1,\"type\":1,\"admin_mobile\":\"13854395382\",\"sms_pwd_content\":\"\\u3010NZcms\\u3011\\u4f60\\u597d\\uff0c\\u5bc6\\u7801\\u627e\\u56de\\uff0c\\u65b0\\u7684\\u767b\\u5f55\\u5bc6\\u7801\\u4e3a\\uff1a{password}\",\"sms_pwd_off\":1,\"tuan_ok\":\"\\u3010NZcms\\u3011\\u4f60\\u597d\\uff0c\\u4f60\\u8ba2\\u8d2d\\u7684\\u201c{name}\\u201d\\u56e2\\u8d2d\\u6210\\u529f\\uff0c\\u8bf7\\u767b\\u9646\\u4f1a\\u5458\\u4e2d\\u5fc3\\u67e5\\u770b\\u4e0b\\u8f7d\",\"tuanok_off\":0,\"tuan_no\":\"\\u3010NZcms\\u3011\\u4f60\\u597d\\uff0c\\u4f60\\u8ba2\\u8d2d\\u7684\\u201c{name}\\u201d\\u7ec4\\u56e2\\u5931\\u8d25\\uff0c{money}\\u5143\\u5df2\\u9000\\u56de\\u5230\\u4f60\\u7684\\u5e10\\u6237\",\"tuanno_off\":0}', 0);
INSERT INTO `pp_kv` VALUES ('cfg', '{\"webname\":\"\\u6e90\\u7801\\u4ea4\\u6613\\u7ba1\\u7406\\u7cfb\\u7edf\",\"webdomain\":\"127.0.0.1\",\"webdir\":\"\\/\",\"webmail\":\"admin@qq.com\",\"tongji\":\"\",\"beian\":\"127.0.0.1\",\"seo_title\":\"NZ\\u6570\\u5b57\\u5316\\u4ea4\\u6613\\u7ba1\\u7406\\u7cfb\\u7edf\",\"seo_keywords\":\"\\u865a\\u62df\\u4ea4\\u6613\\u7cfb\\u7edf,\\u4ed8\\u8d39\\u4e0b\\u8f7d\\u7cfb\\u7edf,\",\"seo_description\":\"\\u6570\\u5b57\\u5316\\u5185\\u5bb9\\u4ea4\\u6613\\u7cfb\\u7edf\\u3001\\u6e90\\u7801\\/\\u7d20\\u6750\\/\\u6a21\\u677f\\u4ea4\\u6613\\u7cfb\\u7edf\\u3001\\u4ed8\\u8d39\\u4e0b\\u8f7d\\u7cfb\\u7edf\",\"link_show\":\"{alias}.html\",\"link_show_type\":3,\"link_show_end\":\".html\",\"link_cate_page_pre\":\"\\/page_\",\"link_cate_page_end\":\".html\",\"link_cate_end\":\"\\/\",\"link_tag_pre\":\"tag\\/\",\"link_tag_end\":\".html\",\"link_comment_pre\":\"comment\\/\",\"link_comment_end\":\".html\",\"link_index_end\":\".html\",\"up_img_ext\":\"jpg,jpeg,gif,png\",\"up_img_max_size\":\"1024\",\"up_file_ext\":\"zip\",\"up_file_max_size\":\"20480\",\"thumb_article_w\":163,\"thumb_article_h\":124,\"thumb_products_w\":250,\"thumb_products_h\":250,\"thumb_photo_w\":250,\"thumb_photo_h\":250,\"thumb_type\":2,\"thumb_quality\":90,\"watermark_pos\":0,\"watermark_pct\":90,\"theme\":\"default\",\"gzip\":1,\"dis_comment\":0,\"user_comment\":1,\"comment_status\":1,\"comment_filter\":\"\",\"lifealipay\":{\"off\":\"1\",\"id\":\"\",\"notice\":\"\\u8f6c\\u5e10\\u6210\\u529f\\u540e\\u8bf7\\u8054\\u7cfb\\u7ad9\\u957f\\uff0c\\u4ee5\\u4fbf\\u53ca\\u65f6\\u786e\\u8ba4\\uff01\"},\"alipay\":{\"id\":\"\",\"partner\":\"\",\"key\":\"\",\"sign_type\":\"MD5\",\"input_charset\":\"utf-8\",\"cacert\":\"..\\/cacert.pem\",\"transport\":\"http\"},\"weixin\":{\"APPID\":\"\",\"MCHID\":\"\",\"KEY\":\"\",\"APPSECRET\":\"\"},\"teegon\":{\"off\":0,\"TEE_CLIENT_ID\":\"\",\"TEE_CLIENT_SECRET\":\"\",\"alipay_off\":0,\"wxpay_off\":0},\"offbank\":{\"1\":{\"bank\":\"\\u4e2d\\u56fd\\u94f6\\u884c\",\"name\":\"\\u5f20\\u4e09\",\"card\":\"1234531371324\",\"addr\":\"\\u4e2d\\u56fd\\u94f6\\u884c\\u5317\\u4eac\\u5e02\\u652f\\u884c\"}},\"user\":{\"open_user_model\":\"1\",\"open_user_reg\":\"1\",\"gift\":\"0\",\"charge\":\"1\",\"mintx\":\"100\",\"gift_mobi_off\":0,\"gift_email_off\":0,\"open_sem\":0},\"qq\":\"190066120\",\"bdts\":\"\",\"passpay\":{\"user_seller\":\"\",\"partner\":\"\",\"key\":\"\"},\"cft\":null,\"mingyi\":{\"id\":\"\",\"key\":\"\"},\"qq_login\":{\"appid\":\"\",\"appkey\":\"\"}}', 0);
INSERT INTO `pp_kv` VALUES ('vip', '{\"key\":\"ded8439ee82b7d88da8504a78edb1853\",\"_key\":\"ded8439ee82b7d88da8504a78edb1853\",\"api_url\":\"http:\\/\\/www.mx800.com\\/app\\/index.php\",\"version\":\"2.2.5\",\"release\":\"20170504\",\"backup_theme\":0}', 0);
INSERT INTO `pp_kv` VALUES ('user_habits_uid_1', '{\"last_add_cid\":16}', 0);

-- ----------------------------
-- Table structure for pp_models
-- ----------------------------
DROP TABLE IF EXISTS `pp_models`;
CREATE TABLE `pp_models`  (
  `mid` tinyint(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` char(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `tablename` char(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `index_tpl` char(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `cate_tpl` char(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `show_tpl` char(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `system` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`mid`) USING BTREE,
  UNIQUE INDEX `tablename`(`tablename`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 4 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of pp_models
-- ----------------------------
INSERT INTO `pp_models` VALUES (1, '单页', 'page', '', 'page_show.htm', '', 1);
INSERT INTO `pp_models` VALUES (2, '资源', 'products', 'products_index.htm', 'products_list.htm', 'products_show.htm', 1);
INSERT INTO `pp_models` VALUES (3, '文章', 'article', 'article_index.htm', 'article_list.htm', 'article_show.htm', 1);

-- ----------------------------
-- Table structure for pp_only_alias
-- ----------------------------
DROP TABLE IF EXISTS `pp_only_alias`;
CREATE TABLE `pp_only_alias`  (
  `alias` char(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `mid` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `cid` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`alias`) USING BTREE,
  INDEX `mid_id`(`mid`, `id`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of pp_only_alias
-- ----------------------------
INSERT INTO `pp_only_alias` VALUES ('ziyuanmingchengshizaidengnigoumai', 2, 16, 1);

-- ----------------------------
-- Table structure for pp_record
-- ----------------------------
DROP TABLE IF EXISTS `pp_record`;
CREATE TABLE `pp_record`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `username` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `type` smallint(3) UNSIGNED NOT NULL DEFAULT 0,
  `type1` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `paybank` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `money` decimal(11, 2) NOT NULL DEFAULT 0.00,
  `charge` decimal(13, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `gold` int(10) NOT NULL DEFAULT 0,
  `comment` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `order_id` char(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `created` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `uid`(`uid`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 3 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_record
-- ----------------------------
INSERT INTO `pp_record` VALUES (1, 3, 'demo', 0, 0, '', 10000.00, 0.00, 0, '系统', '', 1692416437, 0);
INSERT INTO `pp_record` VALUES (2, 3, 'demo', 2, 0, '', 1.00, 0.00, 0, '下单成功', '230819164441834301', 1692416444, 0);

-- ----------------------------
-- Table structure for pp_runtime
-- ----------------------------
DROP TABLE IF EXISTS `pp_runtime`;
CREATE TABLE `pp_runtime`  (
  `k` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `v` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `expiry` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`k`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_runtime
-- ----------------------------
INSERT INTO `pp_runtime` VALUES ('block', '{\"list_zanzhu\":{\"isjs\":\"1\",\"content\":\"<li class=\\\"list-group-item\\\"><a href=\\\"\\\"><img class=\\\"img-responsive\\\" src=\\\"static\\/default\\/img\\/a1.jpg\\\" \\/><\\/a><\\/li><li class=\\\"list-group-item\\\"><a href=\\\"\\\"><img class=\\\"img-responsive\\\" src=\\\"static\\/default\\/img\\/a2.jpg\\\" \\/><\\/a><\\/li>\"},\"home_top\":{\"isjs\":\"1\",\"content\":\"<a href=\\\"\\\"><img src=\\\"https:\\/\\/img11.360buyimg.com\\/cms\\/jfs\\/t3091\\/221\\/3128129977\\/91346\\/fbc76a21\\/57ee2821N4e40d129.jpg\\\" class=\\\"img-responsive\\\" \\/><\\/a>\"},\"home_center\":{\"isjs\":\"1\",\"content\":\"<a href=\\\"\\\"><img src=\\\"https:\\/\\/img10.360buyimg.com\\/da\\/jfs\\/t3235\\/326\\/3911409958\\/101118\\/5831a815\\/57f9a91fN51369fb5.jpg\\\" class=\\\"img-responsive\\\" \\/><\\/a>\"}}', 0);
INSERT INTO `pp_runtime` VALUES ('cfg', '{\"webname\":\"\\u6e90\\u7801\\u4ea4\\u6613\\u7ba1\\u7406\\u7cfb\\u7edf\",\"webdomain\":\"127.0.0.1\",\"webdir\":\"\\/\",\"webmail\":\"admin@qq.com\",\"tongji\":\"\",\"beian\":\"127.0.0.1\",\"seo_title\":\"NZ\\u6570\\u5b57\\u5316\\u4ea4\\u6613\\u7ba1\\u7406\\u7cfb\\u7edf\",\"seo_keywords\":\"\\u865a\\u62df\\u4ea4\\u6613\\u7cfb\\u7edf,\\u4ed8\\u8d39\\u4e0b\\u8f7d\\u7cfb\\u7edf,\",\"seo_description\":\"\\u6570\\u5b57\\u5316\\u5185\\u5bb9\\u4ea4\\u6613\\u7cfb\\u7edf\\u3001\\u6e90\\u7801\\/\\u7d20\\u6750\\/\\u6a21\\u677f\\u4ea4\\u6613\\u7cfb\\u7edf\\u3001\\u4ed8\\u8d39\\u4e0b\\u8f7d\\u7cfb\\u7edf\",\"link_show\":\"{alias}.html\",\"link_show_type\":3,\"link_show_end\":\".html\",\"link_cate_page_pre\":\"\\/page_\",\"link_cate_page_end\":\".html\",\"link_cate_end\":\"\\/\",\"link_tag_pre\":\"tag\\/\",\"link_tag_end\":\".html\",\"link_comment_pre\":\"comment\\/\",\"link_comment_end\":\".html\",\"link_index_end\":\".html\",\"up_img_ext\":\"jpg,jpeg,gif,png\",\"up_img_max_size\":\"1024\",\"up_file_ext\":\"zip\",\"up_file_max_size\":\"20480\",\"thumb_article_w\":163,\"thumb_article_h\":124,\"thumb_products_w\":250,\"thumb_products_h\":250,\"thumb_photo_w\":250,\"thumb_photo_h\":250,\"thumb_type\":2,\"thumb_quality\":90,\"watermark_pos\":0,\"watermark_pct\":90,\"theme\":\"default\",\"gzip\":1,\"dis_comment\":0,\"user_comment\":1,\"comment_status\":1,\"comment_filter\":\"\",\"lifealipay\":{\"off\":\"1\",\"id\":\"\",\"notice\":\"\\u8f6c\\u5e10\\u6210\\u529f\\u540e\\u8bf7\\u8054\\u7cfb\\u7ad9\\u957f\\uff0c\\u4ee5\\u4fbf\\u53ca\\u65f6\\u786e\\u8ba4\\uff01\"},\"alipay\":{\"id\":\"\",\"partner\":\"\",\"key\":\"\",\"sign_type\":\"MD5\",\"input_charset\":\"utf-8\",\"cacert\":\"..\\/cacert.pem\",\"transport\":\"http\"},\"weixin\":{\"APPID\":\"\",\"MCHID\":\"\",\"KEY\":\"\",\"APPSECRET\":\"\"},\"teegon\":{\"off\":0,\"TEE_CLIENT_ID\":\"\",\"TEE_CLIENT_SECRET\":\"\",\"alipay_off\":0,\"wxpay_off\":0},\"offbank\":{\"1\":{\"bank\":\"\\u4e2d\\u56fd\\u94f6\\u884c\",\"name\":\"\\u5f20\\u4e09\",\"card\":\"1234531371324\",\"addr\":\"\\u4e2d\\u56fd\\u94f6\\u884c\\u5317\\u4eac\\u5e02\\u652f\\u884c\"}},\"user\":{\"open_user_model\":\"1\",\"open_user_reg\":\"1\",\"gift\":\"0\",\"charge\":\"1\",\"mintx\":\"100\",\"gift_mobi_off\":0,\"gift_email_off\":0,\"open_sem\":0},\"qq\":\"190066120\",\"bdts\":\"\",\"passpay\":{\"user_seller\":\"\",\"partner\":\"\",\"key\":\"\"},\"cft\":null,\"mingyi\":{\"id\":\"\",\"key\":\"\"},\"qq_login\":{\"appid\":\"\",\"appkey\":\"\"},\"tpl\":\"\\/nzcms\\/view\\/default\\/\",\"webroot\":\"http:\\/\\/127.0.0.1\",\"weburl\":\"http:\\/\\/127.0.0.1\\/\",\"table_arr\":{\"1\":\"page\",\"2\":\"products\",\"3\":\"article\"},\"mod_name\":{\"2\":\"\\u8d44\\u6e90\",\"3\":\"\\u6587\\u7ae0\"},\"cate_arr\":{\"17\":\"faq\",\"16\":\"mov\",\"15\":\"shop\",\"14\":\"art\",\"13\":\"codes\",\"12\":\"about\",\"11\":\"notice\",\"10\":\"downs\",\"5\":\"hotel\",\"2\":\"taoke\",\"1\":\"company\"}}', 0);
INSERT INTO `pp_runtime` VALUES ('cate_16', '{\"cid\":\"16\",\"mid\":\"2\",\"type\":\"0\",\"upid\":\"10\",\"name\":\"\\u5f71\\u97f3\\u6e38\\u620f\",\"alias\":\"mov\",\"intro\":\"\",\"cate_tpl\":\"products_list.htm\",\"show_tpl\":\"products_show.htm\",\"count\":\"2\",\"count_0\":\"1\",\"count_1\":\"0\",\"orderby\":\"0\",\"seo_title\":\"\",\"seo_keywords\":\"\",\"seo_description\":\"\",\"place\":[{\"cid\":\"10\",\"name\":\"\\u8d44\\u6e90\",\"url\":\"\\/index.php?cate--cid-10.html\"},{\"cid\":\"16\",\"name\":\"\\u5f71\\u97f3\\u6e38\\u620f\",\"url\":\"\\/index.php?cate--cid-16.html\"}],\"topcid\":\"10\",\"table\":\"products\"}', 0);
INSERT INTO `pp_runtime` VALUES ('cate_11', '{\"cid\":\"11\",\"mid\":\"3\",\"type\":\"0\",\"upid\":\"0\",\"name\":\"\\u7ad9\\u5185\\u516c\\u544a\",\"alias\":\"notice\",\"intro\":\"\",\"cate_tpl\":\"article_list.htm\",\"show_tpl\":\"article_show.htm\",\"count\":\"1\",\"count_0\":\"0\",\"count_1\":\"0\",\"orderby\":\"0\",\"seo_title\":\"\",\"seo_keywords\":\"\",\"seo_description\":\"\",\"place\":[{\"cid\":\"11\",\"name\":\"\\u7ad9\\u5185\\u516c\\u544a\",\"url\":\"\\/index.php?cate--cid-11.html\"}],\"topcid\":\"11\",\"table\":\"article\"}', 0);
INSERT INTO `pp_runtime` VALUES ('cate_10', '{\"cid\":\"10\",\"mid\":\"2\",\"type\":\"1\",\"upid\":\"0\",\"name\":\"\\u8d44\\u6e90\",\"alias\":\"downs\",\"intro\":\"\",\"cate_tpl\":\"products_index.htm\",\"show_tpl\":\"products_show.htm\",\"count\":\"0\",\"count_0\":\"0\",\"count_1\":\"0\",\"orderby\":\"0\",\"seo_title\":\"\",\"seo_keywords\":\"\",\"seo_description\":\"\",\"place\":[{\"cid\":\"10\",\"name\":\"\\u8d44\\u6e90\",\"url\":\"\\/index.php?cate--cid-10.html\"}],\"topcid\":\"10\",\"table\":\"products\",\"son_list\":{\"16\":1,\"15\":1,\"5\":1,\"2\":1,\"1\":1},\"son_cids\":[16,15,5,2,1]}', 0);
INSERT INTO `pp_runtime` VALUES ('cate_15', '{\"cid\":\"15\",\"mid\":\"2\",\"type\":\"0\",\"upid\":\"10\",\"name\":\"\\u7535\\u5b50\\u5546\\u57ce\",\"alias\":\"shop\",\"intro\":\"\",\"cate_tpl\":\"products_list.htm\",\"show_tpl\":\"products_show.htm\",\"count\":\"1\",\"count_0\":\"0\",\"count_1\":\"0\",\"orderby\":\"0\",\"seo_title\":\"\",\"seo_keywords\":\"\",\"seo_description\":\"\",\"place\":[{\"cid\":\"10\",\"name\":\"\\u8d44\\u6e90\",\"url\":\"\\/index.php?cate--cid-10.html\"},{\"cid\":\"15\",\"name\":\"\\u7535\\u5b50\\u5546\\u57ce\",\"url\":\"\\/index.php?cate--cid-15.html\"}],\"topcid\":\"10\",\"table\":\"products\"}', 0);
INSERT INTO `pp_runtime` VALUES ('cate_5', '{\"cid\":\"5\",\"mid\":\"2\",\"type\":\"0\",\"upid\":\"10\",\"name\":\"\\u9152\\u5e97\\u5bbe\\u9986\",\"alias\":\"hotel\",\"intro\":\"\",\"cate_tpl\":\"products_list.htm\",\"show_tpl\":\"products_show.htm\",\"count\":\"0\",\"count_0\":\"0\",\"count_1\":\"0\",\"orderby\":\"0\",\"seo_title\":\"\",\"seo_keywords\":\"\",\"seo_description\":\"\",\"place\":[{\"cid\":\"10\",\"name\":\"\\u8d44\\u6e90\",\"url\":\"\\/index.php?cate--cid-10.html\"},{\"cid\":\"5\",\"name\":\"\\u9152\\u5e97\\u5bbe\\u9986\",\"url\":\"\\/index.php?cate--cid-5.html\"}],\"topcid\":\"10\",\"table\":\"products\"}', 0);
INSERT INTO `pp_runtime` VALUES ('cate_2', '{\"cid\":\"2\",\"mid\":\"2\",\"type\":\"0\",\"upid\":\"10\",\"name\":\"\\u6dd8\\u5ba2\\u63a8\\u5e7f\",\"alias\":\"taoke\",\"intro\":\"\",\"cate_tpl\":\"products_list.htm\",\"show_tpl\":\"products_show.htm\",\"count\":\"2\",\"count_0\":\"0\",\"count_1\":\"0\",\"orderby\":\"0\",\"seo_title\":\"\",\"seo_keywords\":\"\",\"seo_description\":\"\",\"place\":[{\"cid\":\"10\",\"name\":\"\\u8d44\\u6e90\",\"url\":\"\\/index.php?cate--cid-10.html\"},{\"cid\":\"2\",\"name\":\"\\u6dd8\\u5ba2\\u63a8\\u5e7f\",\"url\":\"\\/index.php?cate--cid-2.html\"}],\"topcid\":\"10\",\"table\":\"products\"}', 0);
INSERT INTO `pp_runtime` VALUES ('cate_1', '{\"cid\":\"1\",\"mid\":\"2\",\"type\":\"0\",\"upid\":\"10\",\"name\":\"\\u516c\\u53f8\\u4f01\\u4e1a\",\"alias\":\"company\",\"intro\":\"\",\"cate_tpl\":\"products_list.htm\",\"show_tpl\":\"products_show.htm\",\"count\":\"3\",\"count_0\":\"0\",\"count_1\":\"0\",\"orderby\":\"0\",\"seo_title\":\"\",\"seo_keywords\":\"\",\"seo_description\":\"\",\"place\":[{\"cid\":\"10\",\"name\":\"\\u8d44\\u6e90\",\"url\":\"\\/index.php?cate--cid-10.html\"},{\"cid\":\"1\",\"name\":\"\\u516c\\u53f8\\u4f01\\u4e1a\",\"url\":\"\\/index.php?cate--cid-1.html\"}],\"topcid\":\"10\",\"table\":\"products\"}', 0);
INSERT INTO `pp_runtime` VALUES ('cate_17', '{\"cid\":\"17\",\"mid\":\"3\",\"type\":\"0\",\"upid\":\"0\",\"name\":\"\\u5e38\\u89c1\\u95ee\\u9898\\u4e0e\\u89e3\\u7b54\",\"alias\":\"faq\",\"intro\":\"\",\"cate_tpl\":\"article_list.htm\",\"show_tpl\":\"article_show.htm\",\"count\":\"9\",\"count_0\":\"0\",\"count_1\":\"0\",\"orderby\":\"0\",\"seo_title\":\"\",\"seo_keywords\":\"\",\"seo_description\":\"\",\"place\":[{\"cid\":\"17\",\"name\":\"\\u5e38\\u89c1\\u95ee\\u9898\\u4e0e\\u89e3\\u7b54\",\"url\":\"\\/index.php?cate--cid-17.html\"}],\"topcid\":\"17\",\"table\":\"article\"}', 0);
INSERT INTO `pp_runtime` VALUES ('cate_14', '{\"cid\":\"14\",\"mid\":\"3\",\"type\":\"0\",\"upid\":\"0\",\"name\":\"\\u6280\\u672f\\u6587\\u7ae0\",\"alias\":\"art\",\"intro\":\"\",\"cate_tpl\":\"article_list.htm\",\"show_tpl\":\"article_show.htm\",\"count\":\"6\",\"count_0\":\"0\",\"count_1\":\"0\",\"orderby\":\"0\",\"seo_title\":\"\",\"seo_keywords\":\"\",\"seo_description\":\"\",\"place\":[{\"cid\":\"14\",\"name\":\"\\u6280\\u672f\\u6587\\u7ae0\",\"url\":\"\\/index.php?cate--cid-14.html\"}],\"topcid\":\"14\",\"table\":\"article\"}', 0);

-- ----------------------------
-- Table structure for pp_user
-- ----------------------------
DROP TABLE IF EXISTS `pp_user`;
CREATE TABLE `pp_user`  (
  `uid` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `upid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `username` char(16) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `password` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `salt` char(16) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `groupid` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `email` char(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `mobile` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `regip` int(10) NOT NULL DEFAULT 0,
  `regdate` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `loginip` int(10) NOT NULL DEFAULT 0,
  `logindate` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `lastip` int(10) NOT NULL DEFAULT 0,
  `lastdate` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `contents` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `comments` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `logins` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `author` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `isadmin` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `avatar` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `recordtime` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `recordays` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `setoptime` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `money` decimal(13, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `dmoney` decimal(13, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `gold` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `alipay` char(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `alipay_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `qq` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `email_staus` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `mobile_staus` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`uid`) USING BTREE,
  UNIQUE INDEX `username`(`username`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 4 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_user
-- ----------------------------
INSERT INTO `pp_user` VALUES (1, 0, 'admin', '0dcd0f61cbf422ff7642d328b922ab4a', '1t&2_LBP#CP<0h_)', 1, '190066120@qq.com', '13800138666', 2130706433, 1494299078, 2130706433, 1692416125, 2130706433, 1692415995, 1, 0, 85, 'admin', 1, 1, '', 0, 0, 0, 0.00, 0.00, 0, '', '', '190066120', 0, 0);
INSERT INTO `pp_user` VALUES (3, 0, 'demo', '18f773b45ab8363ef78d2cc849c61a79', '82Mw>!2^I@Q,b,v^', 4, '', '', 2130706433, 1692416163, 2130706433, 1692416163, 0, 0, 0, 0, 1, 'demo', 1, 0, '', 0, 0, 0, 9999.00, 0.00, 0, '', '', '', 0, 0);

-- ----------------------------
-- Table structure for pp_user_group
-- ----------------------------
DROP TABLE IF EXISTS `pp_user_group`;
CREATE TABLE `pp_user_group`  (
  `groupid` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `groupname` char(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `system` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `isadmin` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `purviews` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ishidden` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`groupid`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 8 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_user_group
-- ----------------------------
INSERT INTO `pp_user_group` VALUES (1, '超级管理员', 1, 1, '{\"navs\":null,\"whitelist\":{\"home\":\"\\u9996\\u9875\",\"my-index\":\"1\",\"my-password\":\"1\",\"blockmanage-index\":\"1\",\"blockmanage-set\":\"1\",\"blockmanage-del\":\"1\",\"links-index\":\"1\",\"links-set\":\"1\",\"links-del\":\"1\",\"audit\":\"\\u8ba2\\u5355\",\"book-index\":\"1\",\"book-auto_comment\":\"1\",\"record-index\":\"1\",\"record-confirm\":\"1\",\"record-del\":\"1\",\"withdraw-index\":\"1\",\"withdraw-index-status-1\":\"1\",\"withdraw-confirm\":\"1\",\"withdraw-del\":\"1\",\"setting\":\"\\u8bbe\\u7f6e\",\"setting-index\":\"1\",\"setting-sms\":\"1\",\"setting-seo\":\"1\",\"setting-link\":\"1\",\"setting-attach\":\"1\",\"setting-image\":\"1\",\"category\":\"\\u5206\\u7c7b\",\"category-index\":\"1\",\"category-set\":\"1\",\"category-del\":\"1\",\"category-edit_orderby\":\"1\",\"navigate-index\":\"1\",\"navigate-add_cate\":\"1\",\"navigate-add_link\":\"1\",\"navigate-nav_save\":\"1\",\"navigate-del\":\"1\",\"models-index\":\"1\",\"content\":\"\\u5185\\u5bb9\",\"products-index\":\"1\",\"products-add\":\"1\",\"products-edit\":\"1\",\"products-del\":\"1\",\"products-ajaxsetflags\":\"1\",\"products-faq\":\"1\",\"products-faq_add\":\"1\",\"products-faq_edit\":\"1\",\"products-faq_del\":\"1\",\"products-update_sms\":\"1\",\"comment-index\":\"1\",\"comment-get_json\":\"1\",\"comment-edit\":\"1\",\"comment-status\":\"1\",\"comment-del\":\"1\",\"comment-batch_del\":\"1\",\"article-index\":\"1\",\"article-add\":\"1\",\"article-edit\":\"1\",\"article-del\":\"1\",\"article-batch_del\":\"1\",\"article-ajaxsetflags\":\"1\",\"tag-index\":\"1\",\"article-get_json\":\"1\",\"user\":\"\\u7528\\u6237\",\"user-index\":\"1\",\"user-add\":\"1\",\"user-edit\":\"1\",\"user-change_money\":\"1\",\"user-del\":\"1\",\"user-set_status\":\"1\",\"user_group-index\":\"1\",\"user_group-add\":\"1\",\"user_group-edit\":\"1\",\"user_group-del\":\"1\",\"tool\":\"\\u5de5\\u5177\",\"database-index\":\"1\",\"database-docommand\":\"1\",\"database-backup\":\"1\",\"database-recove\":\"1\",\"database-down\":\"1\",\"database-del\":\"1\",\"tool-rebuild\":\"1\",\"products-ajaxset\":1,\"products-get_pro_json\":1,\"products-batch_del\":1,\"products-tuan_edit\":1,\"products-tuan_over\":1,\"products-baidu\":1,\"products-auto_pic\":1,\"products-save_images\":1,\"products-save_downs\":1,\"products-del_attach\":1,\"products-auto_save\":1,\"tool-get_tags\":1,\"tool-get_pinyin\":1,\"article-baidu\":1,\"links-sort\":1,\"tool-index\":1,\"book-get_pro\":1,\"book-get_user\":1,\"category-get_category_upid\":1,\"category-get_category_json\":1,\"category-get_category_content\":1,\"category-get_pinyin\":1,\"comment-content\":1,\"database-import\":1,\"pay-lifealipay\":1,\"setting-testemail\":1},\"other\":null}', 0);
INSERT INTO `pp_user_group` VALUES (2, '普通管理员', 1, 1, '{\"navs\":null,\"whitelist\":{\"home\":\"\\u9996\\u9875\",\"my-index\":\"1\",\"my-password\":\"1\",\"blockmanage-index\":\"1\",\"blockmanage-set\":\"1\",\"blockmanage-del\":\"1\",\"links-index\":\"1\",\"links-set\":\"1\",\"links-del\":\"1\",\"audit\":\"\\u8ba2\\u5355\",\"book-index\":\"1\",\"book-auto_comment\":\"1\",\"withdraw-del\":\"1\",\"category\":\"\\u5206\\u7c7b\",\"category-index\":\"1\",\"category-set\":\"1\",\"category-del\":\"1\",\"category-edit_orderby\":\"1\",\"navigate-index\":\"1\",\"navigate-add_cate\":\"1\",\"navigate-add_link\":\"1\",\"navigate-nav_save\":\"1\",\"models-index\":\"1\",\"content\":\"\\u5185\\u5bb9\",\"products-index\":\"1\",\"products-add\":\"1\",\"products-edit\":\"1\",\"products-ajaxsetflags\":\"1\",\"products-faq\":\"1\",\"products-faq_add\":\"1\",\"products-faq_edit\":\"1\",\"products-update_sms\":\"1\",\"comment-index\":\"1\",\"comment-get_json\":\"1\",\"comment-edit\":\"1\",\"comment-status\":\"1\",\"comment-del\":\"1\",\"comment-batch_del\":\"1\",\"article-index\":\"1\",\"article-add\":\"1\",\"article-edit\":\"1\",\"article-del\":\"1\",\"article-batch_del\":\"1\",\"tag-index\":\"1\",\"article-get_json\":\"1\",\"user\":\"\\u7528\\u6237\",\"user-set_status\":\"1\",\"tool\":\"\\u5de5\\u5177\",\"database-index\":\"1\",\"database-docommand\":\"1\",\"database-backup\":\"1\",\"tool-rebuild\":\"1\",\"products-ajaxset\":1,\"products-get_pro_json\":1,\"products-batch_del\":1,\"products-tuan_edit\":1,\"products-tuan_over\":1,\"products-baidu\":1,\"products-auto_pic\":1,\"products-save_images\":1,\"products-save_downs\":1,\"products-del_attach\":1,\"products-auto_save\":1,\"tool-get_tags\":1,\"tool-get_pinyin\":1,\"article-baidu\":1,\"links-sort\":1,\"tool-index\":1,\"book-get_pro\":1,\"book-get_user\":1,\"category-get_category_upid\":1,\"category-get_category_json\":1,\"category-get_category_content\":1,\"category-get_pinyin\":1,\"comment-content\":1,\"database-import\":1,\"pay-lifealipay\":1,\"setting-testemail\":1},\"other\":null}', 0);
INSERT INTO `pp_user_group` VALUES (3, '网站编辑', 1, 1, '{\"navs\":null,\"whitelist\":{\"home\":\"\\u9996\\u9875\",\"my-index\":\"1\",\"my-password\":\"1\",\"content\":\"\\u5185\\u5bb9\",\"products-index\":\"1\",\"products-add\":\"1\",\"products-edit\":\"1\",\"products-del\":\"1\",\"products-ajaxsetflags\":\"1\",\"products-faq\":\"1\",\"products-faq_add\":\"1\",\"products-faq_edit\":\"1\",\"products-faq_del\":\"1\",\"products-update_sms\":\"1\",\"comment-index\":\"1\",\"comment-get_json\":\"1\",\"comment-edit\":\"1\",\"comment-status\":\"1\",\"comment-del\":\"1\",\"comment-batch_del\":\"1\",\"article-index\":\"1\",\"article-add\":\"1\",\"article-edit\":\"1\",\"article-del\":\"1\",\"article-batch_del\":\"1\",\"article-ajaxsetflags\":\"1\",\"tag-index\":\"1\",\"article-get_json\":\"1\",\"products-ajaxset\":1,\"products-get_pro_json\":1,\"products-batch_del\":1,\"products-tuan_edit\":1,\"products-tuan_over\":1,\"products-baidu\":1,\"products-auto_pic\":1,\"products-save_images\":1,\"products-save_downs\":1,\"products-del_attach\":1,\"products-auto_save\":1,\"tool-get_tags\":1,\"tool-get_pinyin\":1,\"article-baidu\":1,\"links-sort\":1,\"tool-index\":1,\"book-get_pro\":1,\"book-get_user\":1,\"category-get_category_upid\":1,\"category-get_category_json\":1,\"category-get_category_content\":1,\"category-get_pinyin\":1,\"comment-content\":1,\"database-import\":1,\"pay-lifealipay\":1,\"setting-testemail\":1},\"other\":null}', 0);
INSERT INTO `pp_user_group` VALUES (4, '普通用户', 1, 0, '{\"navs\":[],\"whitelist\":[],\"other\":{\"utype\":\"1\",\"price\":\"\",\"percent\":\"\",\"sem\":\"5\"}}', 0);
INSERT INTO `pp_user_group` VALUES (5, '银卡会员', 1, 0, '{\"navs\":[],\"whitelist\":[],\"other\":{\"utype\":\"2\",\"price\":\"66\",\"percent\":\"9\",\"sem\":\"10\"}}', 0);
INSERT INTO `pp_user_group` VALUES (6, '金卡会员', 1, 0, '{\"navs\":[],\"whitelist\":[],\"other\":{\"utype\":\"2\",\"price\":\"288\",\"percent\":\"8\",\"sem\":\"20\"}}', 0);
INSERT INTO `pp_user_group` VALUES (7, '钻石会员', 1, 0, '{\"navs\":[],\"whitelist\":[],\"other\":{\"utype\":\"2\",\"price\":\"680\",\"percent\":\"5\",\"sem\":\"30\"}}', 0);

-- ----------------------------
-- Table structure for pp_user_qqlogin
-- ----------------------------
DROP TABLE IF EXISTS `pp_user_qqlogin`;
CREATE TABLE `pp_user_qqlogin`  (
  `uid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `openid` char(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`) USING BTREE,
  UNIQUE INDEX `openid`(`openid`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of pp_user_qqlogin
-- ----------------------------

-- ----------------------------
-- Table structure for pp_withdraw
-- ----------------------------
DROP TABLE IF EXISTS `pp_withdraw`;
CREATE TABLE `pp_withdraw`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `username` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `paybank` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `money` decimal(11, 2) NOT NULL DEFAULT 0.00,
  `comment` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `order_id` char(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `created` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `uid`(`uid`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pp_withdraw
-- ----------------------------

SET FOREIGN_KEY_CHECKS = 1;
