$(function () {
	// 支付信息
	var payDetail = {
		paytype: 'weixin',
		amount: 0,
		payCode: '',
		out_trade_no: ''
	};
	// 金额按钮
	var $payAmountItem = $('.pay-amount-item a');
	// 收款金额输入框
	var $amountInput = $('.pay-amount-input');
	// 付款码输入框
	var $payCodeInput = $('.pay-code-input');
	// 付款方式
	var $radio = $('.am-radio input');
	// 支付链接
	// var $jsapipayurl = $('.payurl-input');
	// 确认按钮
	var $barcode = $('.pay-barcode');
	var $qrcode = $('.pay-qrcode');
	var $qrcode2 = $('.pay-qrcode2');
	// 扫码弹出框
	var $barcodepop = $('.pay-barcode-pop');
	// 二维码支付弹出框
	var $qrcodepop = $('.pay-qrcode-pop');
	var $qrcodeimg = document.getElementById('paycodeurl');
	var $pay_explain = $('.pay_explain');
	var $orderquery = $('.orderquery-btn');
	// 支付成功弹出框
	var $paySuccessPop = $('.pay-success-pop');
	// 支付中弹出框
	var $payingPop = $('.paying-pop');
	var $payDetailAmount = $('.pay-detail-amount');
	var $out_trade_no = $('.pay-out-trade-no');
	// 关闭弹出框按钮
	var $closePopBtn = $('.close-pop-btn');
	// 报错信息
	var $errMsg = $('.error-msg');
	// 温馨提示弹出框
	var $submitPayingPop = $('.submit-paying-pop');
	// 温馨提示确认按钮
	var $submitPayingBtn = $('.submit-paying-pop .submit-paying');
	// 温馨提示取消按钮
	var $cancelPayingBtn = $('.submit-paying-pop .cancel-paying');
	// 点击金额，选中效果
	$payAmountItem.on('click', function () {
		// 选中效果
		$(this)
			.parent()
			.addClass('active')
			.siblings()
			.removeClass('active');
		// 金额赋值
		$amountInput.val($(this).html());
		// changerul();
	});

	$amountInput.on('change', function (e) {
		// changerul();
	})

	// 支付方式
	$radio.on('click', function (e) {
		payDetail.paytype = e.target.id;
		// changerul();
	})

	// 弹出付款码框
	$barcode.on('click', function () {
		// 付款金额
		payDetail.amount = Number($amountInput.val());
		// 校验收款金额
		if (payDetail.amount <= 0) {
			getErrMsg('请输入收款金额');
			return;
		}
		$payCodeInput.val('');
		$barcodepop.removeClass('hidden');
		$payCodeInput.focus();
	});

	$payCodeInput.on('keydown', function (e) {
		code = e.keyCode;
		if (code == 13) {
			payDetail.payCode = $payCodeInput.val();
			// 调用支付接口接口
			res = barcode(payDetail.paytype, payDetail.amount, payDetail.payCode, '', '');
			// console.log(res);
			if (res.data.return_code == 'SUCCESS') {
				// 支付单据号
				payDetail.out_trade_no = res.outTradeNo;
				// {"return_code":"SUCCESS","return_msg":"OK","result_code":"SUCCESS","mch_id":"1600100258","appid":"wxd76110199f2b2a85","device_info":"001","nonce_str":"tzvV3ZNEBSP692pW","sign":"826198826B4B6D3D1DD3551A9D67EBF1","openid":"o8xdmuK60a7HUVzms-mGQWzgu_l8","is_subscribe":"N","trade_type":"MICROPAY","bank_type":"OTHERS","fee_type":"CNY","total_fee":"1","cash_fee_type":"CNY","cash_fee":"1","transaction_id":"4200059220202208193571179678","out_trade_no":"62ff49f961a3a","attach":"pay","time_end":"20220819162946"}
				// {"return_code":"SUCCESS","return_msg":"OK","result_code":"FAIL","err_code_des":"需要用户输入支付密码","err_code":"USERPAYING","mch_id":"1600100258","appid":"wxd76110199f2b2a85","device_info":"001","nonce_str":"4LsgljkhcGgQGoI0","sign":"DF97F7012619ECDFA8949A33B8D69299"}
				if (res.data.result_code == 'SUCCESS') {
					// 支付成功
					paySuccess(res.data.cash_fee / 100, res.outTradeNo);
				} else if (res.data.err_code == 'USERPAYING') {
					// 支付中
					$payingPop.removeClass('hidden');
					checkPaying(payDetail.out_trade_no);
				} else {
					// 温馨提示弹出框弹出
					$submitPayingPop.removeClass('hidden');
				}
			} else {
				getErrMsg(res.data.err_code_des);
			}
		}
	});

	// 弹出二维码框
	$qrcode.on('click', function () {
		// 付款金额
		payDetail.amount = Number($amountInput.val());
		// 校验收款金额
		if (payDetail.amount <= 0) {
			getErrMsg('请输入收款金额');
			return;
		}

		// 获取二维码
		var res = getqrcode(payDetail.paytype, payDetail.amount, '', '');
		console.log(res);
		payDetail.out_trade_no = res.outTradeNo;
		$qrcodeimg.src = res.data;
		$pay_explain.text('支付金额:' + payDetail.amount + '元');
		$qrcodepop.removeClass('hidden');
	});

	// 弹出二维码框
	$qrcode2.on('click', function () {
		// 付款金额
		payDetail.amount = Number($amountInput.val());
		// 校验收款金额
		if (payDetail.amount <= 0) {
			getErrMsg('请输入收款金额');
			return;
		}

		// 获取支付链接
		var res = getpayurl(payDetail.paytype, payDetail.amount, '', '');
		console.log(res);
		payDetail.out_trade_no = res.outTradeNo;
		copyToClipboard(res.data);
		alert('已复制链接');
		// $qrcodeimg.src = res.data;
		// $pay_explain.text('支付金额:' + payDetail.amount + '元');
		// $qrcodepop.removeClass('hidden');
	});

	// 查询支付结果
	$orderquery.on('click', function () {
		res = orderquery(payDetail.paytype, payDetail.out_trade_no);
		// {"data":{"return_code":"SUCCESS","return_msg":"OK","result_code":"SUCCESS","mch_id":"1600100258","appid":"wxd76110199f2b2a85","device_info":{},"trade_state":"NOTPAY","total_fee":"100000","out_trade_no":"63042eb3da5ac","trade_state_desc":"订单未支付","nonce_str":"j3nvmi31v1YtYGc0","sign":"F7460DAA9FE9E27DB83D07BF01D0CCB9"}}
		// {"data":{"return_code":"SUCCESS","return_msg":"OK","result_code":"SUCCESS","mch_id":"1600100258","appid":"wxd76110199f2b2a85","openid":"o8xdmuHVM4zzz5AYMZ_7MTNMbDNg","is_subscribe":"Y","trade_type":"NATIVE","trade_state":"SUCCESS","bank_type":"OTHERS","total_fee":"1","fee_type":"CNY","cash_fee":"1","cash_fee_type":"CNY","transaction_id":"4200001561202208239878984669","out_trade_no":"630430d2ed2d0","attach":"pay","time_end":"20220823094427","trade_state_desc":"支付成功","nonce_str":"vbrQexrHUIZZXfYI","sign":"75FFF05B0D69719F516AAD578AD5B97E"}}
		if (res.data.return_code == 'SUCCESS') {
			if (res.data.trade_state == 'SUCCESS') {
				// 支付成功
				paySuccess(res.data.cash_fee / 100, payDetail.out_trade_no);
			} else if (res.data.trade_state == 'USERPAYING') {
				// 支付中
				$payingPop.removeClass('hidden');
				checkPaying(payDetail.out_trade_no);
			} else {
				alert(res.data.trade_state_desc);
			}
		}
	});

	// 点击关闭弹出框
	$closePopBtn.on('click', function () {
		// 关闭弹出框
		$paySuccessPop.addClass('hidden');
		$barcodepop.addClass('hidden');
		$qrcodepop.addClass('hidden');
		// 清空数据
		payDetail.payCode = '';
		payDetail.out_trade_no = '';
	});

	// 温馨提示弹出框确认
	$submitPayingBtn.on('click', function () {
		res = orderquery(payDetail.paytype, payDetail.out_trade_no);
		if (res.data.return_code == 'SUCCESS') {
			if (res.data.trade_state == 'SUCCESS') {
				// 支付成功
				paySuccess(res.data.cash_fee / 100, payDetail.out_trade_no);
			} else {
				alert(res.data.trade_state_desc);
				// 支付超时
				payError();
			}
		}
	});

	// 温馨提示弹出框取消
	$cancelPayingBtn.on('click', function () {
		// 支付超时
		payError();
	});

	// 支付中，调用查询接口，3秒查询一次，监控60s
	// 如果返回支付成功，调用成功函数，否则，支付失败
	function checkPaying(out_trade_no) {
		var startTimeStamp = new Date().getTime();
		var timer = window.setInterval(function () {
			// 超时
			if (new Date().getTime() - startTimeStamp > 60000) {
				// 支付中弹出框关闭
				$payingPop.addClass('hidden');
				// 温馨提示弹出框弹出
				$submitPayingPop.removeClass('hidden');
				clearInterval(timer);
			}

			res = orderquery(payDetail.paytype, out_trade_no);
			if (res.data.return_code == 'SUCCESS') {
				if (res.data.trade_state == 'SUCCESS') {
					// 支付成功
					payDetail.out_trade_no = out_trade_no;
					paySuccess(res.data.cash_fee / 100, out_trade_no);
					clearInterval(timer);
					return;
				} else if (res.data.trade_state == "PAYERROR") {
					// 支付中弹出框关闭
					$payingPop.addClass('hidden');
					// 温馨提示弹出框弹出
					$submitPayingPop.removeClass('hidden');
					clearInterval(timer);
					return;
				}
			}
		}, 3000);
	}

	// 支付成功
	function paySuccess(amount, out_trade_no) {
		// 弹出框赋值
		$payDetailAmount.html(amount);
		$out_trade_no.html(out_trade_no);
		// 关闭扫码框
		$barcodepop.addClass('hidden');
		// 关闭支付中弹出框
		$payingPop.addClass('hidden');
		// 关闭温馨提示弹窗
		$submitPayingPop.addClass('hidden');
		// 打开支付成功弹出框
		$paySuccessPop.removeClass('hidden');

		// 按钮禁用
		// $payBtn.removeAttr('disabled');
		// $payBtn.attr('disabled', 'disabled');

		// 清空错误信息
		$errMsg.html('');
	}

	// 支付超时
	function payError() {
		// 清空数据
		payDetail.payCode = '';
		payDetail.out_trade_no = '';
		// 关闭支付中弹出框
		$payingPop.addClass('hidden');
		// 关闭温馨提示弹窗
		$submitPayingPop.addClass('hidden');
		getErrMsg('支付超时');
	}

	// 添加错误信息
	function getErrMsg(msg) {
		$errMsg.html(msg);
	}

	// jsapi支付链接
	// function changerul() {
	// 	$jsapipayurl.val(window.location.origin + '/' + payDetail.paytype + '/jsapi.php' + '?amout=' + $amountInput.val());
	// }

	function copyToClipboard(text) {
		var textarea = document.createElement('textarea');
		textarea.style.position = 'fixed';
		textarea.style.opacity = 0;
		textarea.value = text;
		document.body.appendChild(textarea);
		textarea.select();
		document.execCommand('copy');
		document.body.removeChild(textarea);
	}

});

// 自动跳转手机版
// if (/Android|webOS|iPhone|iPod|BlackBerry/i.test(navigator.userAgent)) {
// 	window.location.href = "./mobile.html";
// } 