<?php

/**
 * 原生支付（扫码支付）及公众号支付的异步回调通知
 * 说明：需要在native.php或者jsapi.php中的填写回调地址。例如：http://www.xxx.com/wx/notify.php
 * 付款成功后，微信服务器会将付款结果通知到该页面
 */
header('Content-type:text/html; Charset=utf-8');
require '../mysql.class.php';
require '../config.php';

$mchid = $config['mchid'];          //微信支付商户号 PartnerID 通过微信支付商户资料审核后邮件发送
$appid = $config['appid'];  //公众号APPID 通过微信支付商户资料审核后邮件发送
$apiKey = $config['key'];   //https://pay.weixin.qq.com 帐户设置-安全设置-API安全-API密钥-设置API密钥
$wxPay = new WxpayService($mchid, $appid, $apiKey);
$result = $wxPay->notify();
if ($result) {
    //完成你的逻辑
    //例如连接数据库，获取付款金额$result['cash_fee']，获取订单号$result['out_trade_no']，修改数据库中的订单状态等;
    writeLogFile(json_encode($result, JSON_UNESCAPED_UNICODE));

    $outTradeNo = $result['out_trade_no'];
    $transaction_id = $result['transaction_id'];
    $pay_amount = $result['cash_fee'];

    $sql = "select status from payorders where orderno = '$outTradeNo'";
    $data = $db->find($sql);
    $status = $data['status'];
    if ($status != '支付成功') {
        $sql = "update payorders set transactionid='$transaction_id',status = '支付成功',paytime = now(),result = '" . json_encode($result) . "' where orderno = '$outTradeNo'";
        $db->query($sql);

        $sql = "select username,tel from payorders where orderno = '$outTradeNo'";
        $data = $db->find($sql);
        $tel = $data['tel'];
        if ($tel != '') {
            $username = $data['username'];
            $Message = $smsconfig['default'];
            // 替换模板参数
            $Message = str_replace('{username}', $username, $Message);
            // 加签名
            $Message = $smsconfig['sign'] . $Message;
            $data = array(
                'Id' =>  $smsconfig['id'],
                'Name' => $smsconfig['user'],
                'Psw' => $smsconfig['pwd'],
                'Message' => $Message,
                'Phone' => $tel,
                'Timestamp' => '0'
            );
            curlPost($smsconfig['url'], $data);
        }
    }
} else {
    echo 'pay error';
}

function writeLogFile($message)
{
    // 获取当前时间
    $dateTime = date('Y-m-d H:i:s');

    $filename = './paylog.txt';

    // 拼接日志内容
    $logEntry = $dateTime . ' - ' . $message . PHP_EOL;

    // 写入日志文件
    file_put_contents($filename, $logEntry, FILE_APPEND);
}

function curlPost($url = '', $postData = '', $options = array())
{
    if (is_array($postData)) {
        $postData = http_build_query($postData);
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30); //设置cURL允许执行的最长秒数
    if (!empty($options)) {
        curl_setopt_array($ch, $options);
    }
    //https请求 不验证证书和host
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}

class WxpayService
{
    protected $mchid;
    protected $appid;
    protected $apiKey;
    public function __construct($mchid, $appid, $key)
    {
        $this->mchid = $mchid;
        $this->appid = $appid;
        $this->apiKey = $key;
    }

    public function notify()
    {
        $postStr = file_get_contents('php://input');
        //禁止引用外部xml实体
        libxml_disable_entity_loader(true);
        $postObj = simplexml_load_string($postStr, 'SimpleXMLElement', LIBXML_NOCDATA);
        if ($postObj === false) {
            die('parse xml error');
        }
        if ($postObj->return_code != 'SUCCESS') {
            die($postObj->return_msg);
        }
        if ($postObj->result_code != 'SUCCESS') {
            die($postObj->err_code);
        }
        $arr = (array)$postObj;
        unset($arr['sign']);
        if (self::getSign($arr, $this->apiKey) == $postObj->sign) {
            echo '<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>';
            return $arr;
        }
    }

    /**
     * 获取签名
     */
    public static function getSign($params, $key)
    {
        ksort($params, SORT_STRING);
        $unSignParaString = self::formatQueryParaMap($params, false);
        $signStr = strtoupper(md5($unSignParaString . "&key=" . $key));
        return $signStr;
    }
    protected static function formatQueryParaMap($paraMap, $urlEncode = false)
    {
        $buff = "";
        ksort($paraMap);
        foreach ($paraMap as $k => $v) {
            if (null != $v && "null" != $v) {
                if ($urlEncode) {
                    $v = urlencode($v);
                }
                $buff .= $k . "=" . $v . "&";
            }
        }
        $reqPar = '';
        if (strlen($buff) > 0) {
            $reqPar = substr($buff, 0, strlen($buff) - 1);
        }
        return $reqPar;
    }
}
