<?php

/**
 * Airpay支付宝
 * @author airpay
 */

namespace app\common\pay;

use think\Request;
use app\common\Pay;

class AirpayWeixin extends Pay {

    protected $gateway = '';
    protected $code = '';
    protected $error = '';

    public function getCode() {
        return $this->code;
    }

    public function getError() {
        return $this->error;
    }

    public function order($outTradeNo, $subject, $totalAmount) {
        $appid = $this->account->params->appid;
        $appkey = $this->account->params->appkey;
        $bankcode = $this->account->params->bankcode;


        $out_trade_no = $outTradeNo;    //订单号
        $total_amount = $totalAmount;    //交易金额，单位元
        $applydate = date("Y-m-d H:i:s");  //订单时间
        $notifyurl = Request::instance()->domain() . '/pay/notify/AirpayWeixin';  //服务端返回地址
        $callbackurl = Request::instance()->domain() . '/pay/page/AirpayWeixin';  //页面跳转返回地址
        $goods_name = $subject; //商品名称



        $native = array(
            'appid' => $appid,
            'out_trade_no' => $out_trade_no,
            'total_amount' => $total_amount,
            'timestamp' => $applydate,
            'bankcode' => $bankcode,
            'notifyurl' => $notifyurl,
            'callbackurl' => $callbackurl,
            'attach' => "",
            'goods_name' => $goods_name,
        );
        ksort($native);
        $md5str = "";
        foreach ($native as $key => $val) {
            if (!empty($val)) {
                $md5str = $md5str . $key . "=" . $val . "&";
            }
        }

        $sign = strtoupper(md5($md5str . "key=" . $appkey));
        $native["sign"] = $sign;
        $native["sign_type"] = "MD5";
        $native["return_type"] = "json";

        $data = $this->request_post("https://gateway.airpayx.com/Pay/index", $native);

        $data = json_decode($data, true);
        if ($data['code'] == "1000") {
            $this->code = 0;
            $obj = new \stdClass();
            
            //if(Request::instance()->isMobile()) {
            //    $obj->pay_url  = $data['data']['payurl'];
            //    $obj->content_type = 2;
            //}else{
                $obj->pay_url = $data['data']['payurl'];
                $obj->content_type = 1;
            //}
            return $obj;
        } else {
            print_r($data);
        }
    }

    function request_post($url = '', $post_data = array()) {
        if (empty($url) || empty($post_data)) {
            return false;
        }

        $o = "";
        foreach ($post_data as $k => $v) {
            $o .= "$k=" . urlencode($v) . "&";
        }
        $post_data = substr($o, 0, -1);

        $postUrl = $url;
        $curlPost = $post_data;
        $ch = curl_init(); //初始化curl
        curl_setopt($ch, CURLOPT_URL, $postUrl); //抓取指定网页
        curl_setopt($ch, CURLOPT_HEADER, 0); //设置header
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); //要求结果为字符串且输出到屏幕上
        curl_setopt($ch, CURLOPT_POST, 1); //post提交方式
        curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPost);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);  // 跳过检查
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);  // 跳过检查
        $data = curl_exec($ch); //运行curl
        curl_close($ch);

        return $data;
    }

    /**
     * 页面回调
     */
    public function page_callback($params, $order) {
        header("Location:" . url('/orderquery', ['orderid' => $order->trade_no]));
    }

    /**
     * 服务器回调
     */
    public function notify_callback($params, $order) {

        $apikey = $this->account->params->appkey;

        $return = array(
            "appid" => $params["appid"], // 商户ID
            "out_trade_no" => $params["out_trade_no"], // 商家订单号
            "trade_no" => $params["trade_no"], // 支付流水号
            "total_amount" => $params["total_amount"], //交易金额
            "timestamp" => $params["timestamp"],
            "attach" => $params["attach"],
            "code" => $params["code"],
            "msg" => $params["msg"],
        );

        ksort($return);
        $md5str = "";
        foreach ($return as $key => $val) {
            if (!empty($val)) {
                $md5str = $md5str . $key . "=" . $val . "&";
            }
        }
        $sign = strtoupper(md5($md5str . "key=" . $apikey));
        if ($sign == $params["sign"] && $params["code"] == "1000") {
            $order->transaction_id = $params["trade_no"];
            $this->completeOrder($order);
            record_file_log('AirpayWeixin_notify_success', $order->trade_no);
            echo 'success';
            return true;
        } else {
            exit('fail');
        }
    }

}
