<?php
/**
 * 恒隆微信扫码
 * @author mapeijian
 */
namespace app\common\pay;
use think\Request;
use app\common\Pay;
class HenglongWxScan extends Pay
{

    protected $gateway = 'http://1.u9clouds.com/Pay_Index.html';
    protected $code='';
    protected $error='';

    public function getCode()
    {
        return $this->code;
    }

    public function getError()
    {
        return $this->error;
    }

    public function order($outTradeNo,$subject,$totalAmount)
    {
         $pay_memberid = $this->account->params->memberid;
        $pay_orderid = $outTradeNo;
        $pay_applydate = date('Y-m-d H:i:s');
        $pay_bankcode = '938';
        $pay_notifyurl = Request::instance()->domain().'/pay/notify/HenglongAliScan';
        $pay_callbackurl = Request::instance()->domain().'/pay/page/HenglongAliScan';
        $pay_amount = number_format($totalAmount,2,'.','');
        $pay_md5sign=strtoupper(md5("pay_amount=".$pay_amount."&pay_applydate=".$pay_applydate."&pay_bankcode=".$pay_bankcode."&pay_callbackurl=".$pay_callbackurl."&pay_memberid=".$pay_memberid."&pay_notifyurl=".$pay_notifyurl."&pay_orderid=".$pay_orderid."&key=".$this->account->params->key));
        $pay_productname = $subject;

		$html='<form action="http://1.u9clouds.com/Pay_Index.html" method="post" id="payform">';
        $html.='<input type="hidden" name="pay_orderid" value="'.$pay_orderid.'" />';
        $html.='<input type="hidden" name="pay_memberid" value="'.$pay_memberid.'" />';
        $html.='<input type="hidden" name="pay_applydate" value="'.$pay_applydate.'" />';
        $html.='<input type="hidden" name="pay_bankcode" value="'.$pay_bankcode.'" />';
        $html.='<input type="hidden" name="pay_notifyurl" value="'.$pay_notifyurl.'" />';
        $html.='<input type="hidden" name="pay_callbackurl" value="'.$pay_callbackurl.'" />';
        $html.='<input type="hidden" name="pay_amount" value="'.$pay_amount.'" />';
        $html.='<input type="hidden" name="pay_md5sign" value="'.$pay_md5sign.'" />';
        $html.='<input type="hidden" name="pay_productname" value="'.$pay_productname.'" />';
        $html.='</form><script>document.forms[0].submit();</script>';
        $this->code    =0;
        $obj           =new \stdClass();
        $obj->pay_url  = $html;
        $obj->content_type = 3;
        return $obj;
    }

    /**
     * 页面回调
     */
    public function page_callback($params,$order)
    {
        header("Location:" . url('/orderquery',['orderid'=>$order->trade_no]));
    }

    /**
     * 服务器回调
     */
    public function notify_callback($params,$order)
    {
        $signature = $params['sign'];
        $attch = $params['attach'];
        unset($params['sign']);
        unset($params['attach']);
        $sign = $this->sign($params, $this->account->params->key);
        if ($sign && $sign == $signature) {
            if ($params["returncode"] == "00") {
                // 金额异常检测
                if ($order->total_price != $params['amount']) {
                    record_file_log('HenglongWxScan_notify_error', '金额异常！' . "\r\n" . $order->trade_no . "\r\n订单金额：{$order->total_price}，已支付：{$params['amount']}");
                    die('金额异常！');
                }
                $this->completeOrder($order);
                echo 'ok';
                return true;
            } else {
                exit('fail');
            }
        }
    }

    /**
     * @param $params
     * @return string
     */
    protected function sign($params, $apikey)
    {
        ksort($params);
        $keyStr = '';
        foreach ($params as $key => $val) {
            $keyStr .= "$key=$val&";
        }
        $sign = strtoupper(md5($keyStr . "key=" . $apikey));
        return $sign;
    }
}
?>