<?php

class Payment
{
    /**
     * 配置项
     * @var array
     */
    private $config = [
        "app_id" => '',
        "secret" => '',
    ];

    /**
     * 支付网关
     * @var string
     */
    private $gateway_url = 'https://api.ttpays.cn/api/v1/create';

    public function __construct($app_id, $secret)
    {
        $this->config['app_id'] = $app_id;
        $this->config['secret'] = $secret;
    }


    /**
     * 发起支付请求
     * @param array $data
     * @return mixed|null
     */
    public function commit(array $data)
    {
        $data['app_id'] = $this->config['app_id'];
        $data['sign'] = Utils::sign($this->config['secret'], $data);
        $result = Utils::sendPostRequest($this->gateway_url, $data);
        return $result;
    }


}