$(function(){
  //   给input框扩大点击范围
  $('.click_input').click(function () {
    $(this).find('input').focus();
  });
});
(function(doc, win) {
  /*设置缩放视口与设置理想视口有什么不同
  问题：viewport设为理想视口(scale=1)，基本已经满足适配，为什么要动态设置viewport缩放?
  原因：iPhone6为例，dpr为2，缩放设为0.5，则DOM宽度为750，缩放后显示刚好为屏幕宽度375，而总的CSS像素其实是750，与设备像素一致，这样1px的CSS像素，占用的物理像素也是1；而viewport设置缩放为1的理想视口情况下，DOM宽度为375，显示也刚好是屏幕宽度，然而1px的CSS像素，占用的物理像素是2。这样说来，这样设置可以实现1px的线条在二倍屏的显示。因为： CSS像素与设备像素的关系依赖于屏幕缩放。 
  验证：设备：iPhone6, 
  在scale=0.5时，1px边框显示效果;
  在scale=1.0时，1px边框显示效果;
  在scale=0.5时，2px边框显示效果;
  通过对比后发现，在scale=0.5时，1px的线比scale=1.0要细，这也就解决了1px线条的显示问题。*/
  var docEl = win.document.documentElement;
  var resizeEvt = 'orientationchange' in window ? 'orientationchange' : 'resize';
  var metaEl = doc.querySelector('meta[name="viewport"]');
  var dpr = 0;
  var scale = 0;

  // 对iOS设备进行dpr的判断，对于Android系列，始终认为其dpr为1
  if (!dpr && !scale) {
    var isAndroid = win.navigator.appVersion.match(/android/gi);
    var isIPhone = win.navigator.appVersion.match(/[iphone|ipad]/gi);
    var devicePixelRatio = win.devicePixelRatio;
    if (isIPhone) {
      dpr = devicePixelRatio;
    } else {
      drp = 1;
    }
    scale = 1 / dpr;
  }
  /**
    * ================================================
    *   设置data-dpr和viewport
    × ================================================
    */

  docEl.setAttribute('data-dpr', dpr);
  // 动态改写meta:viewport标签
  // if (!metaEl) {
  //   metaEl = doc.createElement('meta');
  //   metaEl.setAttribute('name', 'viewport');
  //   metaEl.setAttribute('content', 'width=device-width, initial-scale=' + scale + ', maximum-scale=' + scale + ', minimum-scale=' + scale + ', user-scalable=no');
  //   document.documentElement.firstElementChild.appendChild(metaEl);
  // } else {
  //   metaEl.setAttribute('content', 'width=device-width, initial-scale=' + scale + ', maximum-scale=' + scale + ', minimum-scale=' + scale + ', user-scalable=no');
  // }

})(document, window);

(function(doc, win) {
  /**
   * 以下这段代码是用于根据移动端设备的屏幕分辨率计算出合适的根元素的大小
   * 当设备宽度为375(iPhone6)时，根元素font-size=16px; 依次增大；
   * 限制当为设备宽度大于768(iPad)之后，font-size不再继续增大
   * scale 为meta viewport中的缩放大小
   */
  var docEl = win.document.documentElement;
  var resizeEvt = 'orientationchange' in window ? 'orientationchange' : 'resize';
  /**
    * ================================================
    *   设置根元素font-size
    * 当设备宽度为375(iPhone6)时，根元素font-size=16px; 
    × ================================================
    */
  var refreshRem = function() {
    var clientWidth = win.innerWidth ||
      doc.documentElement.clientWidth ||
      doc.body.clientWidth;

    if (!clientWidth) return;
    var fz;
    var width = clientWidth;
    if (width <= 1242) {
      fz = width / 10;
      docEl.style.fontSize = fz + 'px';
    } else {
      docEl.style.fontSize = '124.2px';
    }
  };

  if (!doc.addEventListener) return;
  win.addEventListener(resizeEvt, refreshRem, false);
  doc.addEventListener('DOMContentLoaded', refreshRem, false);
  refreshRem();

})(document, window);

/*倒计时countDown
  id: 容器ID，
  type: 倒计时主要类型
  t: 自定义时候起作用表示分钟
 */
function countDown(objs) {
  var obj = {};
      obj.id = objs.id;
      obj.type = objs.type;
      obj.t = objs.m;
      obj.callback = objs.callback || function(){};
  var timer = null; //这里设置time为null，用于下面来清除计时器
  var parentEle = document.getElementById(obj.id) //获取到放置时间数据的span的id
  console.log(objs);
  var ele = parentEle.getElementsByTagName("t") //获取布局中的em标签用于存取数据
  var a = getDate(obj.type,obj.t);
  countDownChildFun(a,ele,timer,obj.t,obj.callback);
  timer = setInterval(function() { //设置定时器，来更新时间
    countDownChildFun(a,ele,timer,obj.t,obj.callback);
  }, 1000)
}

function countDownChildFun(a,ee,timer,t,callback){
    var b = new Date().getTime();
    var s = 0,
        h = 0,
        m = 0,
        leftTime = a - b;
        //定义变量
        h = Math.floor(leftTime / 1000 / 60 / 60 % 24); //获取剩余小时
        m = Math.floor(leftTime / 1000 / 60 % 60); //获取剩余分钟
        s = Math.ceil(leftTime / 1000 % 60); //获取剩余秒数，因为不精确，所以要向上获取整数
        fzs = Math.ceil(leftTime / 1000);//获取秒数
        if (h < 10) {
          h = "0" + h
        } else if (h < 0) {
          h = 0
        }
        if (m < 10) {
          m = "0" + m;
        } else if (m < 0) {
          m = 0;
        }
        if (s < 10) {
          s = "0" + s;
        } else if (s < 0) {
          s = 0;
        }
        //1分钟倒计时只显示秒;
        if(t == 1){
          ee[0].innerHTML = fzs;
        }else{
          ee[0].innerHTML = h;
          ee[1].innerHTML = m;
          ee[2].innerHTML = s;
        }
      if (a <= b) { //当我们的时间到期的时候，清除计时器，然后把当前标签的内容设置为0；
        clearInterval(timer);
        console.log('定时器执行结束');
        if(t == 1){
          ee[0].innerHTML = '0';
        }else{
          ee[0].innerHTML = '00';
          ee[1].innerHTML = '00';
          ee[2].innerHTML = '00';
        }
        callback();
      }
}
function getDate(str,m){
  var curDate = new Date();
  var date = 0;
  if(str == "next"){
    date = new Date(curDate.getTime() + 24*60*60*1000).getTime()-1000; //后一天
  }
  if(str == "fz"){
    date = new Date().getTime() + (m * 60 * 1000);
  }
  return date;
}


//获得file按钮选取文件的路径
function getObjectURL(file) {
    var url = null;
    if (window.createObjectURL != undefined) { // basic
        url = window.createObjectURL(file);
    } else if (window.URL != undefined) { // mozilla(firefox)
        url = window.URL.createObjectURL(file);
    } else if (window.webkitURL != undefined) { // webkit or chrome
        url = window.webkitURL.createObjectURL(file);
    }
    return url;
}

/**
 * [根据传进来的对象,验证图片是否合格，合格后返回该图片的本地路径]
 * @return {url} [本地路径]
 */
function getImgUrl(obj){
    var file = obj,
    s = file.value,
    start = s.indexOf('.')+1,
    name = s.substring(start,s.length).toLowerCase();
    if (name != "jpg" && name != "png" && name != "jpeg") {
      tyMsgOne({str:'图片格式必须为jpg、png、gif中的一种'})
      return 0;
    }
    if (file.files[0].size > 2*1024*1024) {
        tyMsgOne({str:'图片不能超过2M'})
        return 0;
    }
    return getObjectURL(file.files[0]) ? getObjectURL(file.files[0]) : 0;
}

/**
 * [newSelect 下拉选择列表的插件生成函数]
 *  {[type]} [参数接受元素的选择器和标题以及数据]
 */
function newSelect(obj){
  var _this_initCallback = obj.initCallback|| function(){},
      _this_checked = obj.checked || '默认',
      _this_index = 0,
      _this_cancelCallback = obj.cancelCallback|| function(){};
   return new MobileSelect({
        trigger: obj.obj,
        title: obj.title, 
        wheels: [
                    {data:obj.arr}
                ],
        triggerDisplayData: false,
        checked: _this_checked,
        cancelCallback: function(){
          _this_cancelCallback();
        },
        callback: function(indexArr,data){
          /*选中筛选的内容后*/
          var _this = $(this.trigger);
              _this.find('.select_ty_val').text(data[0].value);
              _this.attr('data-id',data[0].id);
              obj.callback(indexArr,data,_this);
        },
        initCallback:function(obj,arr,checked){
          /*初始化的筛选框操作*/
          var _this = $(obj),
              _data = arr[0].data;
          /*checked指定选中，如果为默认表示无指定选中，默认选中第一个
          否则按指定的id值来选中,假如没有找到指定的id那么久默认选中第一个*/
          if(checked == '默认'){
            _this.attr('data-id',_data[0].id);
            _this.find('.select_ty_val').text(_data[0].value);
          }else{
            /*循环判断指定id值得对象*/
            for(var i = 0; i< _data.length; i++){
              if(_data[i].id == checked){
                _this_index = i;
                _this.attr('data-id',_data[i].id);
                _this.find('.select_ty_val').text(_data[i].value);
                break; 
              }else{
                _this.attr('data-id',_data[0].id);
                _this.find('.select_ty_val').text(_data[0].value);
              }
            }
          }
          _this_initCallback($(obj),_data,checked,_this_index);
        }
    }).locatePosition(0,_this_index);
}

//显示隐藏验证窗口模态窗
function showModal(){
      $('.modals_box').fadeIn(400);
      $('.yzm_val').trigger("click").focus();
}
function hideModal(){
  $('.modals_box').fadeOut(300);
}
//时间插件
function setDate(obj){
    var objs = {};
        objs.trigger = obj.obj;
        objs.ele = obj.ele;
        objs.type = obj.type || 'date';
        objs.callBack = obj.callBack || function(){};
        objs.minDate = obj.minDate || (new Date().getFullYear()-5) + '-' + 1 + '-' + 1;
        objs.maxDate = obj.maxDate || (new Date().getFullYear()+5) + '-' + 1 + '-' + 1;
    
    new LCalendar().init({
      'trigger': objs.trigger, //标签id
      'type': objs.type, //date 调出日期选择 datetime 调出日期时间选择 time 调出时间选择 ym 调出年月选择,
      'minDate': objs.minDate, //最小日期
      'maxDate': objs.maxDate, //最大日期
      callback:function(selectDate){
        var timeC = new Date(selectDate).getTime();
        objs.callBack(selectDate,timeC,objs.trigger,objs.ele);
      }
    });
}
//用于时间插件实例化减少函数代码
function dateFun(obj){
      if(obj.endDiv.hasClass('date_select')){
        console.log(1,obj);
      if(obj.endDateC < obj.startDateC){
        tyMsgOne({str:'开始时间不能大于结束时间'});
        return;
      }
    }else{
      $('.date_end').addClass('date_select');
    }
    var child = $(obj.parent).find(obj.child);
    if(!child.hasClass('selected')){
      child.addClass('selected');
    }
    child.text(obj.text).addClass('selected');
}


//复制函数实例化
function copyText(obj) {
  console.log(obj);
  console.log($(obj.btn).closest(obj.div).find(obj.text).text());
  var clipboards = new ClipboardJS(obj.btn, {
    text: function() {
      return $(obj.btn).closest(obj.div).find(obj.text).text();
    }
  });
  clipboards.on('success', function(e) {
    console.log('进入成功');
    tyMsgOne({
      str: obj.str
    });
    e.clearSelection();
  });
  clipboards.on('error', function(e) {
    console.log('进入失败');
    tyMsgOne({
      str: '设备不支持该功能,请手动复制'
    });
    e.clearSelection();
  });
}


//模态窗实例化
function newModals(object1){
    var object = {
        type: '',
        title: '',
        contentClass: '',
        btnShow: '',
        btnHide: '.modals_btn_back',
        btnSave: '.modals_btn_save',
        divID: '',
        str: '',
        maxL: '150',
        beizhu: '',
        initCallback:function(){}
    };

    var obj = $.extend(object,object1),
        id = object.divID + '_modals',
        data = '',
        kami_c = false,
        text_c = false;

    if($('#'+id).length == 0){
        var str ='';
        str += `<div id="${id}" class="modals_box ${obj.contentClass}"><div class="modals_main"><div class="modals_div">
                <div class="modals_title"><a href="javascript:;" class="modals_btn_back"><i class="iconfont icon-arrow-back"></i></a>
                <span>${obj.title}</span>`;
        if(object.type == 'importText' || object.type == 'importKami'){
          str += `<a href="javascript:;" class="modals_btn_save">保存</a>`;
        }
        str += `</div><div class="modals_content">`;
        if(object.type == 'importText'){
          str += `<div class="text_div">
                      <textarea name="" class="text_content textWenzi" placeholder="请输入文字"></textarea>
                      <p class="text_title">您可以输入${obj.maxL}个字，现在剩余<span class="word">${obj.maxL}</span>个</p>
                    </div>`;
        }else if(object.type == 'importKami'){
            str += `<div class="text_div">
                      <textarea name="" class="text_content textKami" placeholder="请输入卡密"></textarea>
                      <p class="text_title">您可以输入${obj.maxL}个卡密，现在剩余<span class="word">${obj.maxL}</span>个</p>
                    </div>`;
        }
        str += `</div></div></div><div class="modals_shade"></div></div>`;

        //动态生成一个元素
        $('body').append(str);
        var objModals = $('#'+id);

        //生成模态窗执行函数
        obj.initCallback();

        //绑定点击和隐藏方法
        $(obj.btnShow).tap(function(){
          console.log('走到点击');
          showModal(250);
          if(object.type == 'importText'){
            var text = $('.' + obj.divID).find('.section_div_text').text();
            // 判断如果值是备注值就不做处理，否则填入
            if (text == obj.beizhu){
              objModals.find('.textWenzi').val('');
              objModals.find('.word').text(obj.maxL);
            }else{
              objModals.find('.textWenzi').val(text);
            }
          }
          if(object.type == 'importKami'){
             objModals.find('.textKami').val('');
             objModals.find('.word').text(obj.maxL);
          }
        });
        objModals.find(obj.btnHide).tap(function(){
          hideModal();
        });

        //点击保存按钮
        objModals.find(obj.btnSave).tap(function(){
          //判断是否是输入文本框
          if(object.type == 'importKami'){
            enterStr('.textKami','enter');
          }
          fuzhi();
          obj.saveCallback(data);
          hideModal();
        });
      }

      fuzhi();

      //用于给文本域赋值
      function fuzhi(){
        console.log('走到赋值');
         if(object.type == 'importText'){
            var text = objModals.find('.textWenzi').val();
            if(text.length == 0){
              data = obj.beizhu;
            }else{
              data = text;
            }
          }
          if(object.type == 'importKami'){
            var text = objModals.find('.textKami').val();
            if(text.length == 0){
              data = obj.beizhu;
            }else{
              data = text;
            }
          }
          obj.saveCallback(data);
      }

      function hideModal(time){
        objModals.fadeOut(time||300);
        toggleBody(0);
      }

      function showModal(time){
        objModals.fadeIn(time||400);
        toggleBody(1);
      }

      $(objModals).find(".textWenzi").keyup(function(){
          var len = $(this).val().length;
          if(len > obj.maxL){
            $(this).val($(this).val().substring(0,obj.maxL));
          }else{
            var num = obj.maxL - len;
            $(this).closest('.text_div').find(".word").text(num);
          }
      });

      $(objModals).find(".textKami").keyup(function(event){
          var str = '',
              arr = '',
              len = 0,
              strs ='';
          if(event.keyCode == '13'){
            enterStr(this,'enter');
          }
          if(event.keyCode == '8'){
            enterStr(this,'back');
          }
      });
  
      function enterStr(ele,type){
        var val = $(ele).val(),
            arr = [],
            len = 0,
            strs = val.split('\n');
            str = '',
            maxStr = '';
        //strs保存文本框里面的值根据换行符分割
        //然后清楚文本框的值，把之前分隔好的字符输入到文本框中去
        if(type == 'enter'){
          $(ele).val('');
        }
        for(var i = 0; i < strs.length; i++){
          if(removeAllSpace(strs[i]) != ''){
              arr.push(strs[i]);
              str += strs[i] + '\n';
          }
        }
        len = arr.length;
        if(len > obj.maxL){
          event.preventDefault();
          for(var i = 0; i < arr.length; i++){
               if(i < obj.maxL ){
                maxStr += arr[i] + '\n';
               }
          }
          $(ele).val(maxStr);
          tyMsgOne({
            str: `卡密的行数不能大于${obj.maxL}行`,
            type: 'jd_tips'
          });

        }else{
          var num = obj.maxL - len;
          $(ele).closest('.text_div').find(".word").text(num);
          if(type == 'enter'){
            $(ele).val(str);
          }
        }
      }
}
//滚动到底部事件
$.fn.scrollBottom = function(callback) {
    var can = true;
    $(this).scroll(function() {
        var a = document.documentElement.scrollTop || document.body.scrollTop; //滑动块距离顶部的高度 (前面是兼容火狐)
        var b = document.body.scrollHeight; //可滑动区域的总体高度
        var c = document.documentElement.clientHeight; //可视区域的高度 这个是固定的 手机屏幕的高度
        if (a + c >= b - 1 && can) {
            can = false;
            if ($.isFunction(callback)) {
                callback();
            }
            setTimeout(function() {
                can = true;
            }, 1500);
        }
    });
};


//禁止屏幕滚动 n=1禁止 n=0取消禁止滚动
function toggleBody(isPin){
    if(isPin){
        document.body.style.height = '100vh'

        document.body.style['overflow-y'] = 'hidden'
    }
    else{

        document.body.style.height = 'unset'

        document.body.style['overflow-y'] = 'auto'

    }
}
//替换空格
function removeAllSpace(str) {
   return str.replace(/\s+/g, "");
}
/**
 * [tyMsgOne 简单的提示框]
 * @param  obj [一个用来配置提示框的对象]
 */
function tyMsgOne(obj){
    var btnText =  obj.btnText || '我知道了',
        callback = obj.callback || function(){};
        if(obj.type == 'jd_tips'){
          layer.open({
            content: obj.str,
            skin: 'msg',
            time: 2
          });
        }else{
          layer.open({
            content: obj.str
            ,btn: btnText,
            shadeClose: false,
            yes: function(index){
              layer.close(index);
              callback(index);
            }
          });
        }
}

//验证
// function yznumber(obj, type) {
//   if (typeof obj != 'object') {
//     alert('这不是对象');
//     return false;
//   }
//   if (type == 0) {
//     //验证百分比类型的输入文本，大于99.99清空 小数点后最多带2位小数
//     return obj.value = obj.value.replace(/^(0\d)|[^\d.]+|\.\d{3}|\d{6}|^[1-9]{1}\d{2,}$/, '');
//   } else if (type == 1) {
//     //验证常用数字 小数点后最多带2位小数 数字不能大于8位及以上的数字
//     return obj.value = obj.value.replace(/^(0\d)|[^\d.]+|\.\d{3}|\d{8,}|\.\d+\.|\.\./, '');
//   } else if (type == 2) {
//     //验证常用数字 小数点后最多带2位小数 数字不能大于8位及以上的数字,可以为负数
//     return obj.value = obj.value.replace(/^(0\d)|\d+-|[^\d.-]+|\.\d{3}|\d{8,}/, '');
//   } else if (type == 3) {
//     //验证常用整数  数字不能大于8位及以上的数字
//     return obj.value = obj.value.replace(/^(0\d)|\d+-|[^\d-]+|\d{8,}/,'');
//   } else {
//     tyMsgOne({str:'没有这个验证，请重新输入'});
//   }
//  }


//待模仿 评价图片的自适应 取中间显示  点击大图预览
// $.fn.autoImg = function() {
//     $(this).each(function() {
//         var _h = $(this).height();
//         var _w = $(this).width();
//         if (_w > _h) {
//             $(this).css({
//                 "height": "50px",
//                 "left": -(50 * (_w / _h) - 50) / 2,
//                 "z-index": "1"
//             });
//         } else {
//             $(this).css({
//                 "width": "50px",
//                 "top": -(50 * (_h / _w) - 50) / 2,
//                 "z-index": "1"
//             });
//         }
//     });
//     // 大图预览
//     $('.pj_img>span>img').click(function() {
//         var _this = $(this).parent().parent().find("img");
//         var _index = $(this).parent().index();
//         var img_length = _this.length;
//         $('.zhezhao_img').css({
//             'display': 'block'
//         });
//         var _div_con = $('<div class="img_index"></div>');
//         var _div_imgbox = $('<div class="imgbox1"></div>');
//         var _div_ol = $('<ol class="imgbox_ol1"></ol>');
//         var _div_ul = $('<ul></ul>');
//         for (var i = 0; i < img_length; i++) {
//             var _src = $(_this[i]).attr('src');
//             var _img = $('<img src="' + _src + '">');
//             var _li = $('<li></li>');
//             $(_li).append(_img);
//             $(_div_ul).append(_li);
//         }
//         for (var i = 0; i < img_length; i++) {
//             _li = $('<li></li>');
//             $(_div_ol).append(_li);
//         }
//         $(_div_con).append(_div_ol);
//         $(_div_imgbox).append(_div_ul);
//         $(_div_con).append(_div_imgbox);
//         $('.main').append(_div_con);
//         //  //让图片宽度和高度都为屏幕的宽度
//         var pwidth = $("body").width();
//         var body_h = document.documentElement.clientHeight * 0.92;
//         var body_w = document.documentElement.clientWidth;
//         $('.img_index').css('top', "4%");
//         $(".imgbox1 ul li").css({
//             "width": pwidth,
//             "height": body_h
//         });
//         $(".imgbox1 ul li img").each(function() {
//             var _w = $(this).width();
//             var _h = $(this).height();
//             if (_w / _h > body_w / body_h) {
//                 $(this).css({
//                     "width": body_w,
//                     "margin-top": (body_h - body_w * (_h / _w)) / 2
//                 });
//             } else {
//                 $(this).css({
//                     "height": body_h,
//                     "margin-left": (body_w - body_h * (_w / _h)) / 2
//                 });
//             }
//         });
//         $(".imgbox_ol1 li").eq(_index).addClass('img_ol_ac1');
//         var scrollImg1 = $.mggScrollImg('.imgbox1 ul', {
//             callback: function(ind) {
//                 $(".imgbox_ol1 li").removeClass("img_ol_ac1").eq(ind).addClass("img_ol_ac1");
//             }
//         });
//         scrollImg1.go(_index);
//         $(".imgbox_ol1").css({
//             "width": pwidth - 10,
//             "bottom": -20
//         });
//         $(".imgbox1 ul li img").click(function() {
//             $('.zhezhao_img').css({
//                 'display': 'none'
//             });
//             $('.main .img_index').remove();
//         });
//         $(".imgbox_ol li").each(function(i) {
//             var _i = i;
//             $(this).click(function() {
//                 scrollImg.go(_i);
//             });
//         });
//     });
//     // 退出图片浏览
//     $('.zhezhao_img').click(function() {
//         $(this).css({
//             'display': 'none'
//         });
//         $('.main .img_index').remove();
//     });
// };
// 