<?php
    $title = '源码管理';
    require_once 'header.php';
    $files = getFileList(BACKUP_PATH . 'source/', 'zip');
    $countSource = count($files);
    $pageSize = !empty($_GET['size']) ? $_GET['size'] : 10;
    $nowPage = !empty($_GET['page']) ? $_GET['page'] : 1;
    $startNum = ($nowPage - 1) * $pageSize;
?>

  <div class="oz-container">
    <div class="oz-panel">
      <div class="oz-panel-head"><strong>源码列表</strong></div>
      <div class="oz-panel-body">
        <div class="oz-quote wrap-option">
          <div>
            共 <strong><?php echo $countSource; ?></strong> 份源码
            <button type="button" class="oz-btn oz-btn-sm oz-bg-orange" onclick="backup('source')">备份源码</button>
            备份源码目录：<strong><?php echo OZDAO_ROOT; ?></strong>
          </div>
          <div style="margin-left: 15px;">
            <button type="button" class="oz-btn oz-btn-sm oz-bg-purple" onclick="packDownload('source')">打包下载</button>
            <button type="button" class="oz-btn oz-btn-sm oz-bg-red" onclick="batchDelete('source')">删除</button>
          </div>
        </div>
        <form id="batch" method="post" onsubmit="return false">
          <div class="oz-table-fluid">
            <table class="oz-table">
              <thead>
              <tr>
                <th style="width: 5%;">
                  <label>
                    <input type="checkbox" onclick="selectAll(this);">
                  </label>
                </th>
                <th style="width: 5%;">#</th>
                <th style="width: 40%;">文件</th>
                <th style="width: 20%;">时间</th>
                <th style="width: 10%;">大小</th>
                <th style="width: 20%;">操作</th>
              </tr>
              </thead>
              <tbody>
              <?php
                  if($countSource < $pageSize) {
                      $total = $countSource;
                  } else {
                      $total = $pageSize + $startNum;
                      if($total > $countSource) {
                          $total = $countSource;
                      }
                  }
                  for($i = $startNum; $i < $total; $i++) {
                      ?>
                    <tr>
                      <td>
                        <label>
                          <input type="checkbox" name="id[]" value="<?php echo $files[$i]; ?>">
                        </label>
                      </td>
                      <td><?php echo $i + 1; ?></td>
                      <td>
                        <a href="<?php echo BACKUP_URL . 'source/' . basename($files[$i]); ?>" class="oz-tooltip oz-tooltip-up" oz-title="点击下载"><?php echo basename($files[$i]); ?></a>
                      </td>
                      <td><?php echo getFileTime($files[$i]); ?></td>
                      <td><?php echo getFileSize($files[$i]); ?></td>
                      <td>
                        <button type="button" class="oz-btn oz-btn-xs oz-bg-blue" onclick="recover('source', '<?php echo $files[$i]; ?>')">恢复</button>
                        <button type="button" class="oz-btn oz-btn-xs oz-bg-red" onclick="deleteOne('source', '<?php echo $files[$i]; ?>')">删除</button>
                      </td>
                    </tr>
                  <?php } ?>
              </tbody>
            </table>
          </div>
        </form>
          <?php echo paging($countSource, $nowPage, $pageSize); ?>
      </div>
    </div>
  </div>

<?php
    require_once 'footer.php';
?>