<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
spl_autoload_register(function($class) 
{
	$filename = OZDAO_ROOT . 'include/lib/' . $class . '.php';
	if(file_exists($filename)) 
	{
		require_once $filename;
	}
	else 
	{
		die($class . '类未定义');
	}
}
);
function checkConstants($constants) 
{
	if(!is_array($constants)) 
	{
		return defined($constants) && !empty($constants);
	}
	foreach($constants as $constant) 
	{
		if(!defined($constant) || empty($constants)) 
		{
			return false;
		}
	}
	return true;
}
function gotoInstall() 
{
	die('<script>alert("还未安装，请先安装OUZERO网站导航！");location.href="' . OZDAO_URL . 'install/";</script>');
}
function return404() 
{
	header('HTTP/1.1 404 Not Found');
	header('Status: 404 Not Found');
	if(file_exists(TEMPLATE_PATH . '404.php')) 
	{
		include TEMPLATE_PATH . '404.php';
	}
	elseif(file_exists(OZDAO_ROOT . '404.php')) 
	{
		include OZDAO_ROOT . '404.php';
	}
	else 
	{
		echo '抱歉，请求的页面不存在！<a href="javascript:history.back();">点击返回</a>';
	}
	die();
}
function jsonEncode($code, $msg, $data = null) 
{
	$result = ['code' => $code, 'msg' => $msg];
	$data != null && $result['data'] = $data;
	return json_encode($result, 320);
}
function returnJson($code, $msg, $data = null) 
{
	die(jsonEncode($code, $msg, $data));
}
function pushUrls($api, $urls) 
{
	$ch = curl_init();
	$options = [ CURLOPT_URL => $api, CURLOPT_POST => true, CURLOPT_RETURNTRANSFER => true, CURLOPT_POSTFIELDS => implode("\n", $urls), CURLOPT_HTTPHEADER => ['Content-Type: text/plain'], ];
	curl_setopt_array($ch, $options);
	$result = curl_exec($ch);
	curl_close($ch);
	return json_decode($result, 320);
}
function isOtherReferer() 
{
	$referer = $_SERVER['HTTP_REFERER'];
	if(!isset($referer)) 
	{
		return true;
	}
	$refererHost = parse_url($referer)['host'];
	$thisHost = parse_url(OZDAO_URL)['host'];
	return $refererHost != $thisHost;
}
function checkExternalLink($url) 
{
	$text = httpGet($url);
	return stripos($text, $_SERVER['HTTP_HOST']);
}
function getDomain($url) 
{
	preg_match("/^(?:http:\/\/|https:\/\/)?([^\/]+)/i", $url, $matches);
	return $matches[1];
}
function addProtocol($url, $protocol = null) 
{
	if(!empty($url)) 
	{
		$protocol = $protocol ? $protocol : 'http://';
		if(!preg_match("/^(http:\/\/|https:\/\/)/i", $url)) 
		{
			return $protocol . $url;
		}
	}
	return $url;
}
function httpGet($url) 
{
	$curl = curl_init();
	curl_setopt($curl, CURLOPT_URL, $url);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($curl, CURLOPT_TIMEOUT, 500);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
	$result = curl_exec($curl);
	curl_close($curl);
	return $result;
}
function getSiteInfo($url) 
{
	$api = 'https://o.ouzero.com:811/info/?url=';
	return json_decode(httpGet($api . $url), 320);
}
function saveIco($url, $ico = null) 
{
	$ico = $ico ? $ico : 'https://o.ouzero.com:811/ico/?url=' . $url;
	$dir = IMAGES_PATH . 'ico/';
	!is_dir($dir) && mkdir($dir, 0777, true);
	$path = $dir . getDomain($url) . '.ico';
	$file = file_get_contents($ico);
	file_put_contents($path, $file);
}
function sendEmail($config, $sender, $receiver, $email) 
{
	require_once OZDAO_ROOT . 'include/PHPMailer/Exception.php';
	require_once OZDAO_ROOT . 'include/PHPMailer/PHPMailer.php';
	require_once OZDAO_ROOT . 'include/PHPMailer/SMTP.php';
	$mailer = new PHPMailer(true);
	try 
	{
		$mailer->CharSet = 'UTF-8';
		$mailer->SMTPDebug = 0;
		$mailer->isSMTP();
		$mailer->Host = $config['host'];
		$mailer->SMTPAuth = true;
		$mailer->Username = $config['username'];
		$mailer->Password = $config['password'];
		$mailer->SMTPSecure = $mailer::ENCRYPTION_SMTPS;
		$mailer->Port = $config['port'];
		$mailer->setFrom($sender['email'], $sender['name']);
		$mailer->addAddress($receiver['email'], $receiver['name']);
		$mailer->addReplyTo($sender['email'], $sender['name']);
		$mailer->isHTML(true);
		$mailer->Subject = $email['subject'];
		$mailer->Body = $email['body'];
		$mailer->AltBody = getTextFromHtml($email['body']);
		$mailer->send();
		return true;
	}
	catch(Exception $e) 
	{
		return $mailer->ErrorInfo;
	}
}
function getTextFromHtml($str) 
{
	$str = html_entity_decode($str);
	$str = trim($str);
	$str = strip_tags($str, '');
	$str = preg_replace("/\b/", '', $str);
	$str = preg_replace("/&nbsp;/", '', $str);
	return trim($str);
}
function getSubstr($string, $length, $suffix = '...') 
{
	if(mb_strlen($string) > $length) 
	{
		return mb_substr($string, 0, $length) . $suffix;
	}
	return $string;
}
function myAddSlashes($string, $strip = false) 
{
	if(is_array($string)) 
	{
		foreach($string as $key => $val) 
		{
			$string[$key] = myAddSlashes($val, $strip);
		}
	}
	else 
	{
		$string = addslashes($strip ? stripslashes($string) : $string);
	}
	return $string;
}
function removeXSS($val) 
{
	if(!is_string($val)) 
	{
		return $val;
	}
	$val = htmlspecialchars($val, ENT_QUOTES);
	$val = preg_replace('/([ -,-,-])/', '', $val);
	$search = 'abcdefghijklmnopqrstuvwxyz';
	$search .= 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
	$search .= '1234567890!@#$%^&*()';
	$search .= '~`";:?+/={}[]-_|\'\\';
	for($i = 0; $i < strlen($search);
	$i++) 
	{
		$val = preg_replace('/(&#[xX]0{0,8}' . dechex(ord($search[$i])) . ';?)/i', $search[$i], $val);
		$val = preg_replace('/(&#0{0,8}' . ord($search[$i]) . ';?)/', $search[$i], $val);
	}
	$ra1 = ['javascript', 'vbscript', 'expression', 'applet', 'meta', 'xml', 'blink', 'link', 'style', 'script', 'embed', 'object', 'iframe', 'frame', 'frameset', 'ilayer', 'layer', 'bgsound', 'title', 'base'];
	$ra2 = ['onabort', 'onactivate', 'onafterprint', 'onafterupdate', 'onbeforeactivate', 'onbeforecopy', 'onbeforecut', 'onbeforedeactivate', 'onbeforeeditfocus', 'onbeforepaste', 'onbeforeprint', 'onbeforeunload', 'onbeforeupdate', 'onblur', 'onbounce', 'oncellchange', 'onchange', 'onclick', 'oncontextmenu', 'oncontrolselect', 'oncopy', 'oncut', 'ondataavailable', 'ondatasetchanged', 'ondatasetcomplete', 'ondblclick', 'ondeactivate', 'ondrag', 'ondragend', 'ondragenter', 'ondragleave', 'ondragover', 'ondragstart', 'ondrop', 'onerror', 'onerrorupdate', 'onfilterchange', 'onfinish', 'onfocus', 'onfocusin', 'onfocusout', 'onhelp', 'onkeydown', 'onkeypress', 'onkeyup', 'onlayoutcomplete', 'onload', 'onlosecapture', 'onmousedown', 'onmouseenter', 'onmouseleave', 'onmousemove', 'onmouseout', 'onmouseover', 'onmouseup', 'onmousewheel', 'onmove', 'onmoveend', 'onmovestart', 'onpaste', 'onpropertychange', 'onreadystatechange', 'onreset', 'onresize', 'onresizeend', 'onresizestart', 'onrowenter', 'onrowexit', 'onrowsdelete', 'onrowsinserted', 'onscroll', 'onselect', 'onselectionchange', 'onselectstart', 'onstart', 'onstop', 'onsubmit', 'onunload'];
	$ra = array_merge($ra1, $ra2);
	$found = true;
	while($found == true) 
	{
		$val_before = $val;
		for($i = 0; $i < sizeof($ra);
		$i++) 
		{
			$pattern = '/';
			for($j = 0; $j < strlen($ra[$i]);
			$j++) 
			{
				if($j > 0) 
				{
					$pattern .= '(';
					$pattern .= '(&#[xX]0{0,8}([9ab]);)';
					$pattern .= '|';
					$pattern .= '|(&#0{0,8}([9|10|13]);)';
					$pattern .= ')*';
				}
				$pattern .= $ra[$i][$j];
			}
			$pattern .= '/i';
			$replacement = substr($ra[$i], 0, 2) . '<x>' . substr($ra[$i], 2);
			$val = preg_replace($pattern, $replacement, $val);
			if($val_before == $val) 
			{
				$found = false;
			}
		}
	}
	return $val;
}
function authCode($string, $decode = false, $key = '', $expiry = 0) 
{
	$cKey_length = 4;
	$key = md5($key ? $key : OZDAO_KEY);
	$keyA = md5(substr($key, 0, 16));
	$keyB = md5(substr($key, 16, 16));
	$keyC = $cKey_length ? ($decode ? substr($string, 0, $cKey_length) : substr(md5(microtime()), -$cKey_length)) : '';
	$cryptKey = $keyA . md5($keyA . $keyC);
	$key_length = strlen($cryptKey);
	$string = $decode ? base64_decode(substr($string, $cKey_length)) : sprintf('0d', $expiry ? $expiry + time() : 0) . substr(md5($string . $keyB), 0, 16) . $string;
	$string_length = strlen($string);
	$result = '';
	$box = range(0, 255);
	$rndKey = [];
	for($i = 0; $i <= 255; $i++) 
	{
		$rndKey[$i] = ord($cryptKey[$i % $key_length]);
	}
	for($j = $i = 0; $i < 256; $i++) 
	{
		$j = ($j + $box[$i] + $rndKey[$i]) % 256;
		$tmp = $box[$i];
		$box[$i] = $box[$j];
		$box[$j] = $tmp;
	}
	for($a = $j = $i = 0; $i < $string_length; $i++) 
	{
		$a = ($a + 1) % 256;
		$j = ($j + $box[$a]) % 256;
		$tmp = $box[$a];
		$box[$a] = $box[$j];
		$box[$j] = $tmp;
		$result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
	}
	if($decode) 
	{
		if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26) . $keyB), 0, 16)) 
		{
			return substr($result, 26);
		}
		else 
		{
			return '';
		}
	}
	else 
	{
		return $keyC . str_replace('=', '', base64_encode($result));
	}
}

if(!isset($_SESSION['authToken'])) 
{
	$ip = $_SERVER['HTTP_VIA'] ? $_SERVER['HTTP_X_FORWARDED_FOR'] : $_SERVER['REMOTE_ADDR'];
	if($auth = json_decode(httpGet('https://o.ouzero.com:811/auth/?act=get_check&domain=' . $_SERVER['HTTP_HOST'] . '&ip=' . $ip), 320)) 
	{
		if($auth['code'] == 1) 
		{
			$_SESSION['authToken'] = $auth['token'];
		}
		else 
		{
			exit($auth['msg']);
		}
	}
	else 
	{
		exit($auth['msg']);
	}
}
function getRealUrl() 
{
	static $realUrl = NULL;
	if($realUrl !== NULL) 
	{
		return $realUrl;
	}
	$path = trim(OZDAO_ROOT, '/') . DIRECTORY_SEPARATOR;
	$scriptPath = pathinfo($_SERVER['SCRIPT_NAME'], PATHINFO_DIRNAME);
	$scriptPath = str_replace('\\', '/', $scriptPath);
	$pathElement = explode('/', $scriptPath);
	$thisMatch = '';
	$bestMatch = '';
	$currentDeep = 0;
	$maxDeep = count($pathElement);
	while($currentDeep < $maxDeep) 
	{
		$thisMatch = $thisMatch . $pathElement[$currentDeep] . DIRECTORY_SEPARATOR;
		if(substr($path, strlen($thisMatch) * (-1)) === $thisMatch) 
		{
			$bestMatch = $thisMatch;
		}
		$currentDeep++;
	}
	$bestMatch = str_replace(DIRECTORY_SEPARATOR, '/', $bestMatch);
	$realUrl = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://';
	$realUrl .= $_SERVER['HTTP_HOST'];
	$realUrl .= $bestMatch;
	return $realUrl;
}
?>