<?php
    $domain = getDomain($site['url']);
?>
  <div class="container">
    <div class="card board">
      <span class="icon"><i class="fa fa-map-signs fa-fw"></i></span>
        <?php echoBoard($site['name'], $sort['id']); ?>
    </div>
    <div class="card">
      <div class="card-body">
        <div class="site-main">
          <span class="title"><?php echo $site['name']; ?></span>
          <span class="oz-xs-12 oz-sm-6 oz-lg-4">站点域名：<?php echo $domain; ?></span>
          <span class="oz-xs-12 oz-sm-6 oz-lg-4">站点星级：<img class="lazy-load" src="<?php echo TEMPLATE_URL; ?>images/star/<?php echo getStarNum($site['totalView']); ?>.png" alt=""></span>
          <span class="oz-xs-12 oz-sm-6 oz-lg-4">收录日期：<?php echo date('Y-m-d', $site['time']); ?></span>
          <span class="oz-xs-12 oz-sm-6 oz-lg-4">备案信息：<a title="<?php echo $site['icp']; ?>" href="http://icp.chinaz.com/info?q=<?php echo $domain; ?>" target="_blank"><?php echo $site['icp']; ?></a></span>
          <span class="oz-xs-6 oz-sm-6 oz-lg-4">站长ＱＱ：<?php if(!empty($site['qq'])) { ?>
              <a title="<?php echo $site['qq']; ?>" href="http://wpa.qq.com/msgrd?v=3&uin=<?php echo $site['qq']; ?>&site=qq&menu=yes" target="_blank"><?php echo $site['qq']; ?></a>
              <?php } else {
                  echo '暂无';
              } ?></span>
          <span class="oz-xs-6 oz-sm-6 oz-lg-4">所属分类：<a href="<?php echo $sort['url']; ?>"><?php echo $sort['name']; ?></a></span>
          <span class="oz-xs-6 oz-sm-6 oz-lg-4">日浏览数：<?php echo convertNum($site['dayView']); ?>次</span>
          <span class="oz-xs-6 oz-sm-6 oz-lg-4">月浏览数：<?php echo convertNum($site['monthView']); ?>次</span>
          <span class="oz-xs-6 oz-sm-6 oz-lg-4">总浏览数：<?php echo convertNum($site['totalView']); ?>次</span>
          <span class="oz-xs-6 oz-sm-6 oz-lg-4">百度权重：<img class="lazy-load" src="https://o.ouzero.com:811/rank/?url=<?php echo $domain; ?>&type=baidu" alt=""></span>
          <span class="oz-xs-6 oz-sm-6 oz-lg-4">搜狗权重：<img class="lazy-load" src="https://o.ouzero.com:811/rank/?url=<?php echo $domain; ?>&type=sogou" alt=""></span>
          <span class="oz-xs-6 oz-sm-6 oz-lg-4">谷歌权重：<img class="lazy-load" src="https://o.ouzero.com:811/rank/?url=<?php echo $domain; ?>&type=google" alt=""></span>
        </div>
        <div class="site-side">
          <div class="snapshot">
            <img class="lazy-load" src="<?php echo IMAGES_URL; ?>loading.gif" data-src="<?php echo $CONFIG['snapshot'] . $site['url']; ?>" alt="">
          </div>
          <a title="<?php echo $site['url']; ?>" href="<?php echo $site['goto']; ?>" target="_blank" class="oz-btn oz-btn-lg oz-btn-block oz-bg-orange">
            <i class="fa fa-telegram fa-fw" aria-hidden="true"></i> 网站直达
          </a>
          <button class="oz-btn oz-btn-lg oz-btn-block oz-bg-blue" onclick="addLove(this, <?php echo $site['id']; ?>)">
            <i class="fa fa-thumbs-o-up fa-fw" aria-hidden="true"></i> 点赞 [<?php echo $site['love']; ?>]
          </button>
        </div>
      </div>
    </div>
    <div class="card">
      <div class="card-head">
        <i class="fa fa-feed fa-fw" aria-hidden="true"></i> 站点信息
      </div>
      <div class="card-body content">
        <p><b>标题：</b><?php echo $site['title']; ?></p>
        <p><b>关键词：</b><?php echo $site['keywords']; ?></p>
        <p><b>描述：</b><?php echo $site['description']; ?></p>
      </div>
    </div>
      <?php echoAd($ads[0]); ?>
    <div class="card">
      <div class="card-head">
        <i class="fa fa-magnet fa-fw" aria-hidden="true"></i> 相关站点
      </div>
      <div class="card-body">
          <?php echoSites($DATA->getRelatedSites($sort['id'], $site['id'], 12)); ?>
      </div>
    </div>
  </div>

<?php
    include View::getView('footer');
?>