<?php
    $title = '网站设置';
    require_once 'header.php';
?>

  <div class="oz-container">
    <form id="config-edit" method="post" onsubmit="return false">
      <div class="oz-panel">
        <div class="oz-panel-head"><strong>基本设置</strong></div>
        <div class="oz-panel-body">
          <div class="oz-form-group">
            <span class="oz-form-label">网站名称</span>
            <label class="oz-form-field">
              <input type="text" placeholder="请输入网站名称" value="<?php echo $CONFIG['name']; ?>" name="name">
            </label>
          </div>
          <div class="oz-form-group">
            <span class="oz-form-label">建站时间</span>
            <label class="oz-form-field">
              <input type="date" placeholder="请输入建站时间" value="<?php echo date('Y-m-d', $CONFIG['time']); ?>" id="time">
            </label>
          </div>
          <div class="oz-form-group">
            <span class="oz-form-label">首页各分类显示站点数量</span>
            <label class="oz-form-field">
              <input type="number" placeholder="不限制请留空" value="<?php echo $CONFIG['number']; ?>" name="number" id="number">
            </label>
          </div>
          <div class="oz-form-group">
            <span class="oz-form-label">分类页每页显示站点数量</span>
            <label class="oz-form-field">
              <input type="number" placeholder="不限制请留空" value="<?php echo $CONFIG['sitePaging']; ?>" name="sitePaging" id="sitePaging">
            </label>
          </div>
          <div class="oz-form-group">
            <span class="oz-form-label">分类页每页显示文章数量</span>
            <label class="oz-form-field">
              <input type="number" placeholder="不限制请留空" value="<?php echo $CONFIG['postPaging']; ?>" name="postPaging" id="postPaging">
            </label>
          </div>
          <div class="oz-form-group">
            <span class="oz-form-label">每次刷新或点击增加浏览数</span>
            <label class="oz-form-field">
              <input type="number" placeholder="请输入每次刷新或点击增加浏览数" value="<?php echo $CONFIG['viewNum']; ?>" name="viewNum" id="viewNum">
            </label>
          </div>
          <div class="oz-form-group">
            <span class="oz-form-label">站点缩略图接口</span>
            <label class="oz-form-field">
              <input type="text" placeholder="请输入站点缩略图接口" value="<?php echo $CONFIG['snapshot']; ?>" name="snapshot" id="snapshot">
            </label>
          </div>
          <div style="margin-bottom: 15px;">
            申请收录：
            <label>
              <input type="radio" name="apply" value="0" <?php echo $CONFIG['apply'] == '0' ? 'checked' : ''; ?>> 关闭
            </label>
            <label>
              <input type="radio" name="apply" value="1" <?php echo $CONFIG['apply'] == '1' ? 'checked' : ''; ?>> 开启
            </label>
          </div>
          <div style="margin-bottom: 15px;">
            链接跳转页：
            <label>
              <input type="radio" name="goto" value="0" <?php echo $CONFIG['goto'] == '0' ? 'checked' : ''; ?>> 关闭
            </label>
            <label>
              <input type="radio" name="goto" value="1" <?php echo $CONFIG['goto'] == '1' ? 'checked' : ''; ?>> 开启
            </label>
          </div>
          <div style="margin-bottom: 15px;">
            站点详情页：
            <label>
              <input type="radio" name="detail" value="0" <?php echo $CONFIG['detail'] == '0' ? 'checked' : ''; ?>> 关闭
            </label>
            <label>
              <input type="radio" name="detail" value="1" <?php echo $CONFIG['detail'] == '1' ? 'checked' : ''; ?>> 开启
            </label>
          </div>
          <div style="margin-bottom: 15px;">
            站点排序方式：
            <label>
              <input type="radio" name="order" value="id DESC" <?php echo $CONFIG['order'] == 'id DESC' ? 'checked' : ''; ?>> 按添加先后
            </label>
            <label>
              <input type="radio" name="order" value="dayViews DESC" <?php echo $CONFIG['order'] == 'dayViews DESC' ? 'checked' : ''; ?>> 按日浏览数
            </label>
            <label>
              <input type="radio" name="order" value="monthViews DESC" <?php echo $CONFIG['order'] == 'monthViews DESC' ? 'checked' : ''; ?>> 按月浏览数
            </label>
            <label>
              <input type="radio" name="order" value="totalViews DESC" <?php echo $CONFIG['order'] == 'totalViews DESC' ? 'checked' : ''; ?>> 按总浏览数
            </label>
            <label>
              <input type="radio" name="order" value="love DESC" <?php echo $CONFIG['order'] == 'love DESC' ? 'checked' : ''; ?>> 按点赞数量
            </label>
            <label>
              <input type="radio" name="order" value="rand()" <?php echo $CONFIG['order'] == 'rand()' ? 'checked' : ''; ?>> 按随机显示
            </label>
            <label>
              <input type="radio" name="order" value="serial ASC" <?php echo $CONFIG['order'] == 'serial ASC' ? 'checked' : ''; ?>> 按序号正序
            </label>
            <label>
              <input type="radio" name="order" value="serial DESC" <?php echo $CONFIG['order'] == 'serial DESC' ? 'checked' : ''; ?>> 按序号倒序
            </label>
          </div>
          <div style="margin-bottom: 15px;">
            自动检测外链审核：
            <label>
              <input type="radio" name="autoPass" value="0" <?php echo $CONFIG['autoPass'] == '0' ? 'checked' : ''; ?>> 关闭
            </label>
            <label>
              <input type="radio" name="autoPass" value="1" <?php echo $CONFIG['autoPass'] == '1' ? 'checked' : ''; ?>> 开启
            </label>
          </div>
          <div style="margin-bottom: 15px;">
            站点ICO图标本地化：
            <label>
              <input type="radio" name="saveIco" value="0" <?php echo $CONFIG['saveIco'] == '0' ? 'checked' : ''; ?>> 关闭
            </label>
            <label>
              <input type="radio" name="saveIco" value="1" <?php echo $CONFIG['saveIco'] == '1' ? 'checked' : ''; ?>> 开启
            </label>
          </div>
        </div>
      </div>
      <div class="oz-panel">
        <div class="oz-panel-head"><strong>SEO设置</strong></div>
        <div class="oz-panel-body">
          <div class="oz-form-group">
            <span class="oz-form-label">标题</span>
            <label class="oz-form-field">
              <input value="<?php echo $CONFIG['title']; ?>" type="text" placeholder="请输入网站标题" name="title">
            </label>
          </div>
          <div class="oz-form-group oz-form-textarea">
            <span class="oz-form-label">关键词</span>
            <label class="oz-form-field">
              <textarea rows="3" placeholder="请输入网站关键词" name="keywords"><?php echo $CONFIG['keywords']; ?></textarea>
            </label>
          </div>
          <div class="oz-form-group oz-form-textarea">
            <span class="oz-form-label">描述</span>
            <label class="oz-form-field">
              <textarea rows="4" placeholder="请输入网站描述" name="description"><?php echo $CONFIG['description']; ?></textarea>
            </label>
          </div>
        </div>
      </div>
      <div class="oz-panel">
        <div class="oz-panel-head"><strong>底部设置</strong></div>
        <div class="oz-panel-body">
          <div class="oz-form-group">
            <span class="oz-form-label">ICP备案号</span>
            <label class="oz-form-field">
              <input value="<?php echo $CONFIG['icp']; ?>" type="text" placeholder="请输入ICP备案号" name="icp">
            </label>
          </div>
          <div class="oz-form-group oz-form-textarea">
            <span class="oz-form-label">底部信息</span>
            <label class="oz-form-field">
              <textarea rows="6" placeholder="请输入底部信息[支持HTMl代码]" name="info"><?php echo $CONFIG['info']; ?></textarea>
            </label>
          </div>
        </div>
      </div>
      <div class="oz-center">
        <button type="submit" class="oz-btn oz-bg-blue" style="width: 50%;" onclick="editConfig()">保存</button>
      </div>
    </form>
  </div>

<?php
    require_once 'footer.php';
?>