<?php
    $title = '邮箱配置';
    require_once 'header.php';
?>

  <div class="oz-container">
    <div class="oz-xs-12 oz-sm-6">
      <div class="oz-panel">
        <div class="oz-panel-head"><strong>邮箱设置</strong></div>
        <div class="oz-panel-body">
          <div class="oz-quote">
            温馨提示：如果开启邮件通知，收到站点申请时会发送邮件给发信邮箱。
          </div>
          <form id="config-edit" method="post" onsubmit="return false">
            <div style="margin-bottom: 15px;">
              站点申请邮件通知：
              <label>
                <input type="radio" name="emailNotice" value="0" <?php echo $CONFIG['emailNotice'] == '0' ? 'checked' : ''; ?>> 关闭
              </label>
              <label>
                <input type="radio" name="emailNotice" value="1" <?php echo $CONFIG['emailNotice'] == '1' ? 'checked' : ''; ?>> 开启
              </label>
            </div>
            <div class="oz-form-group">
              <span class="oz-form-label">SMTP服务</span>
              <label class="oz-form-field">
                <input value="<?php echo $CONFIG['smtpHost']; ?>" type="text" placeholder="请输入SMTP服务" name="smtpHost">
              </label>
            </div>
            <div class="oz-form-group">
              <span class="oz-form-label">SMTP端口</span>
              <label class="oz-form-field">
                <input value="<?php echo $CONFIG['smtpPort']; ?>" type="text" placeholder="请输入SMTP端口" name="smtpPort">
              </label>
            </div>
            <div class="oz-form-group">
              <span class="oz-form-label">SMTP发信邮箱</span>
              <label class="oz-form-field">
                <input value="<?php echo $CONFIG['smtpUsername']; ?>" type="text" placeholder="请输入SMTP发信邮箱" name="smtpUsername">
              </label>
            </div>
            <div class="oz-form-group">
              <span class="oz-form-label">SMTP密码/授权码</span>
              <label class="oz-form-field">
                <input value="<?php echo $CONFIG['smtpPassword']; ?>" type="password" placeholder="请输入SMTP密码/授权码" name="smtpPassword">
              </label>
            </div>
            <div class="oz-center">
              <button type="submit" class="oz-btn oz-bg-blue" style="width: 50%;" onclick="editConfig()">保存</button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <div class="oz-xs-12 oz-sm-6">
      <div class="oz-panel">
        <div class="oz-panel-head"><strong>发送邮件</strong></div>
        <div class="oz-panel-body">
          <form id="email-send" method="post" onsubmit="return false">
            <div class="oz-form-group">
              <span class="oz-form-label">收信邮箱</span>
              <label class="oz-form-field">
                <input type="text" placeholder="请输入收信邮箱" name="email" id="email" value="<?php echo $CONFIG['smtpUsername']; ?>">
              </label>
            </div>
            <div class="oz-form-group">
              <span class="oz-form-label">邮件主题</span>
              <label class="oz-form-field">
                <input type="text" placeholder="请输入邮件主题" name="subject" id="subject" value="测试邮件 - <?php echo $CONFIG['name']; ?>">
              </label>
            </div>
            <div class="oz-form-group oz-form-textarea">
              <span class="oz-form-label">邮件内容</span>
              <label class="oz-form-field">
                <textarea rows="5" placeholder="请输入邮件内容[支持HTMl代码]" name="body" id="body">这是一封来自【<a href="<?php echo OZDAO_URL; ?>" target="_blank"><strong><?php echo $CONFIG['name']; ?></strong></a>】的测试邮件！</textarea>
              </label>
            </div>
            <div class="oz-center" style="margin-top: 15px">
              <button type="submit" class="oz-btn oz-bg-blue" style="width: 50%;" onclick="sendEmail()">发送</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>

<?php
    require_once 'footer.php';
?>